/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

public class DNSRequester
implements Runnable {
    final Node node;
    private long lastLogTime;
    private final Set<Double> recentNodeIdentitySet = new HashSet<Double>();
    private final Deque<Double> recentNodeIdentityQueue = new ArrayDeque<Double>();
    static boolean DISABLE = false;
    private static volatile boolean logMINOR;

    DNSRequester(Node node) {
        this.node = node;
    }

    void start() {
        Logger.normal(this, "Starting DNSRequester");
        System.out.println("Starting DNSRequester");
        this.node.getExecutor().execute(this, "DNSRequester thread for " + this.node.getDarknetPortNumber());
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.realRun();
                }
            }
            catch (Throwable t) {
                Logger.error(this, "Caught in DNSRequester: " + t, t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        int unconnectedNodesLength;
        PeerNode[] nodesToCheck = (PeerNode[])Arrays.stream(this.node.getPeers().myPeers()).filter(peerNode -> !peerNode.isConnected()).filter(peerNode -> !this.recentNodeIdentitySet.contains(peerNode.getLocation())).toArray(PeerNode[]::new);
        if (logMINOR) {
            long now = System.currentTimeMillis();
            if (now - this.lastLogTime > 100L) {
                Logger.minor(this, "Processing DNS Requests (log rate-limited)");
            }
            this.lastLogTime = now;
        }
        if ((unconnectedNodesLength = nodesToCheck.length) == 0) {
            return;
        }
        PeerNode pn = nodesToCheck[this.node.getFastWeakRandom().nextInt(unconnectedNodesLength)];
        if (unconnectedNodesLength < 5) {
            this.recentNodeIdentitySet.clear();
            this.recentNodeIdentityQueue.clear();
        } else {
            this.recentNodeIdentitySet.add(pn.getLocation());
            this.recentNodeIdentityQueue.offerFirst(pn.getLocation());
            while ((double)this.recentNodeIdentityQueue.size() > 0.81 * (double)unconnectedNodesLength) {
                this.recentNodeIdentitySet.remove(this.recentNodeIdentityQueue.removeLast());
            }
        }
        pn.maybeUpdateHandshakeIPs(false);
        int nextMaxWaitTime = 1000 + this.node.getFastWeakRandom().nextInt(60000);
        try {
            DNSRequester dNSRequester = this;
            synchronized (dNSRequester) {
                this.wait(nextMaxWaitTime);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRun() {
        DNSRequester dNSRequester = this;
        synchronized (dNSRequester) {
            this.notifyAll();
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

