/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.keys.Key;
import freenet.node.DarknetPeerNode;
import freenet.node.DarknetPeerNodeStatus;
import freenet.node.FNPPacketMangler;
import freenet.node.FSParseException;
import freenet.node.FailureTable;
import freenet.node.Location;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNode;
import freenet.node.OpennetPeerNodeStatus;
import freenet.node.OutgoingPacketMangler;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.node.PeerStatusTracker;
import freenet.node.PeerTooOldException;
import freenet.node.PrioRunnable;
import freenet.node.RecentlyFailedReturn;
import freenet.node.SeedClientPeerNode;
import freenet.node.SeedServerPeerNode;
import freenet.node.SemiOrderedShutdownHook;
import freenet.node.TimedOutNodesList;
import freenet.node.Version;
import freenet.node.useralerts.DroppedOldPeersUserAlert;
import freenet.node.useralerts.PeerManagerUserAlert;
import freenet.support.ByteArrayWrapper;
import freenet.support.Logger;
import freenet.support.ShortBuffer;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class PeerManager {
    private static volatile boolean logMINOR;
    final Node node;
    private PeerNode[] myPeers;
    private PeerNode[] connectedPeers;
    private String darkFilename;
    private String openFilename;
    private String oldOpennetPeersFilename;
    private String darknetPeersStringCache = null;
    private String opennetPeersStringCache = null;
    private String oldOpennetPeersStringCache = null;
    private PeerManagerUserAlert ua;
    private long oldestNeverConnectedDarknetPeerAge;
    private long nextOldestNeverConnectedDarknetPeerAgeUpdateTime = -1L;
    private static final long oldestNeverConnectedPeerAgeUpdateInterval = 5000L;
    private long nextPeerNodeStatusLogTime = -1L;
    private static final long peerNodeStatusLogInterval = 5000L;
    private final PeerStatusTracker<Integer> allPeersStatuses;
    private final PeerStatusTracker<Integer> darknetPeersStatuses;
    private final PeerStatusTracker<String> peerNodeRoutingBackoffReasonsRT;
    private final PeerStatusTracker<String> peerNodeRoutingBackoffReasonsBulk;
    private long nextRoutableConnectionStatsUpdateTime = -1L;
    private static final long routableConnectionStatsUpdateInterval;
    private volatile boolean shouldWritePeersDarknet = false;
    private volatile boolean shouldWritePeersOpennet = false;
    private static final long MIN_WRITEPEERS_DELAY;
    private final Runnable writePeersRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                PeerManager.this.writePeersNow(false);
            }
            finally {
                PeerManager.this.node.getTicker().queueTimedJob(PeerManager.this.writePeersRunnable, MIN_WRITEPEERS_DELAY);
            }
        }
    };
    public static final int PEER_NODE_STATUS_CONNECTED = 1;
    public static final int PEER_NODE_STATUS_ROUTING_BACKED_OFF = 2;
    public static final int PEER_NODE_STATUS_TOO_NEW = 3;
    public static final int PEER_NODE_STATUS_TOO_OLD = 4;
    public static final int PEER_NODE_STATUS_DISCONNECTED = 5;
    public static final int PEER_NODE_STATUS_NEVER_CONNECTED = 6;
    public static final int PEER_NODE_STATUS_DISABLED = 7;
    public static final int PEER_NODE_STATUS_BURSTING = 8;
    public static final int PEER_NODE_STATUS_LISTENING = 9;
    public static final int PEER_NODE_STATUS_LISTEN_ONLY = 10;
    public static final int PEER_NODE_STATUS_CLOCK_PROBLEM = 11;
    public static final int PEER_NODE_STATUS_CONN_ERROR = 12;
    public static final int PEER_NODE_STATUS_DISCONNECTING = 13;
    public static final int PEER_NODE_STATUS_ROUTING_DISABLED = 14;
    public static final int PEER_NODE_STATUS_NO_LOAD_STATS = 15;
    private List<PeerStatusChangeListener> listeners = new CopyOnWriteArrayList<PeerStatusChangeListener>();
    long timeFirstAnyConnections = 0L;
    final ByteCounter ctrDisconn = new ByteCounter(){

        @Override
        public void receivedBytes(int x) {
            PeerManager.this.node.getNodeStats().disconnBytesReceived(x);
        }

        @Override
        public void sentBytes(int x) {
            PeerManager.this.node.getNodeStats().disconnBytesSent(x);
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    static final int MIN_DELTA = 2000;
    private final Object writePeersSync = new Object();
    private final Object writePeerFileSync = new Object();
    private static final int BACKUPS_OPENNET = 1;
    private static final int BACKUPS_DARKNET = 10;
    public static final int OUTDATED_MIN_TOO_NEW_TOTAL = 5;
    public static final int OUTDATED_MIN_TOO_NEW_DARKNET = 1;
    public static final int OUTDATED_MAX_CONNS = 5;

    protected void writePeersNow(boolean rotateBackups) {
        this.writePeersDarknetNow(rotateBackups);
        this.writePeersOpennetNow(rotateBackups);
    }

    private void writePeersDarknetNow(boolean rotateBackups) {
        if (this.shouldWritePeersDarknet) {
            this.shouldWritePeersDarknet = false;
            this.writePeersInnerDarknet(rotateBackups);
        }
    }

    private void writePeersOpennetNow(boolean rotateBackups) {
        if (this.shouldWritePeersOpennet) {
            this.shouldWritePeersOpennet = false;
            this.writePeersInnerOpennet(rotateBackups);
        }
    }

    public PeerManager(Node node, SemiOrderedShutdownHook shutdownHook) {
        Logger.normal(this, "Creating PeerManager");
        this.peerNodeRoutingBackoffReasonsRT = new PeerStatusTracker();
        this.peerNodeRoutingBackoffReasonsBulk = new PeerStatusTracker();
        this.allPeersStatuses = new PeerStatusTracker();
        this.darknetPeersStatuses = new PeerStatusTracker();
        System.out.println("Creating PeerManager");
        this.myPeers = new PeerNode[0];
        this.connectedPeers = new PeerNode[0];
        this.node = node;
        shutdownHook.addEarlyJob(new Thread(){

            @Override
            public void run() {
                PeerManager.this.writePeersDarknet();
                PeerManager.this.writePeersOpennet();
                PeerManager.this.writePeersNow(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryReadPeers(String filename, NodeCrypto crypto, OpennetManager opennet, boolean isOpennet, boolean oldOpennetPeers) {
        Object object = this.writePeersSync;
        synchronized (object) {
            if (!oldOpennetPeers) {
                if (isOpennet) {
                    this.openFilename = filename;
                } else {
                    this.darkFilename = filename;
                }
            }
        }
        int maxBackups = isOpennet ? 1 : 10;
        for (int i = 0; i <= maxBackups; ++i) {
            File peersFile = this.getBackupFilename(filename, i);
            if (!peersFile.exists() || !this.readPeers(peersFile, crypto, opennet, oldOpennetPeers)) continue;
            String msg = oldOpennetPeers ? "Read " + opennet.countOldOpennetPeers() + " old-opennet-peers from " + peersFile : (isOpennet ? "Read " + this.getOpennetPeers().length + " opennet peers from " + peersFile : "Read " + this.getDarknetPeers().length + " darknet peers from " + peersFile);
            Logger.normal(this, msg);
            System.out.println(msg);
            return;
        }
        if (!isOpennet) {
            System.out.println("No darknet peers file found.");
        }
    }

    private boolean readPeers(File peersFile, NodeCrypto crypto, OpennetManager opennet, boolean oldOpennetPeers) {
        FileInputStream fis;
        boolean someBroken = false;
        try {
            fis = new FileInputStream(peersFile);
        }
        catch (FileNotFoundException e4) {
            Logger.normal(this, "Peers file not found: " + peersFile);
            return false;
        }
        InputStreamReader ris = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
        BufferedReader br = new BufferedReader(ris);
        File brokenPeersFile = new File(peersFile.getPath() + ".broken");
        DroppedOldPeersUserAlert droppedOldPeers = new DroppedOldPeersUserAlert(brokenPeersFile);
        block17: while (true) {
            try {
                while (true) {
                    SimpleFieldSet fs = new SimpleFieldSet(br, false, true);
                    try {
                        PeerNode pn = PeerNode.create(fs, this.node, crypto, opennet, this);
                        if (oldOpennetPeers) {
                            if (!(pn instanceof OpennetPeerNode)) {
                                Logger.error(this, "Darknet node in old opennet peers?!: " + pn);
                                continue block17;
                            }
                            opennet.addOldOpennetNode((OpennetPeerNode)pn);
                            continue block17;
                        }
                        this.addPeer(pn, true, false);
                        continue block17;
                    }
                    catch (FSParseException e2) {
                        Logger.error(this, "Could not parse peer: " + e2 + '\n' + fs.toString(), (Throwable)e2);
                        System.err.println("Cannot parse a friend from the peers file: " + e2);
                        someBroken = true;
                        continue;
                    }
                    catch (PeerParseException e2) {
                        Logger.error(this, "Could not parse peer: " + e2 + '\n' + fs.toString(), (Throwable)e2);
                        System.err.println("Cannot parse a friend from the peers file: " + e2);
                        someBroken = true;
                        continue;
                    }
                    catch (ReferenceSignatureVerificationException e2) {
                        Logger.error(this, "Could not parse peer: " + e2 + '\n' + fs.toString(), (Throwable)e2);
                        System.err.println("Cannot parse a friend from the peers file: " + e2);
                        someBroken = true;
                        continue;
                    }
                    catch (RuntimeException e2) {
                        Logger.error(this, "Could not parse peer: " + e2 + '\n' + fs.toString(), (Throwable)e2);
                        System.err.println("Cannot parse a friend from the peers file: " + e2);
                        someBroken = true;
                        continue;
                    }
                    catch (PeerTooOldException e) {
                        if (crypto.isOpennet()) {
                            Logger.error(this, "Dropping too-old opennet peer");
                        } else {
                            droppedOldPeers.add(e, fs.get("myName"));
                        }
                        someBroken = true;
                        continue;
                    }
                    break;
                }
            }
            catch (EOFException fs) {
                break;
            }
            catch (IOException e1) {
                Logger.error(this, "Could not read peers file: " + e1, (Throwable)e1);
                break;
            }
        }
        try {
            br.close();
        }
        catch (IOException e3) {
            Logger.error(this, "Ignoring " + e3 + " caught reading " + peersFile, (Throwable)e3);
        }
        if (someBroken) {
            try {
                brokenPeersFile.delete();
                FileOutputStream fos = new FileOutputStream(brokenPeersFile);
                fis = new FileInputStream(peersFile);
                FileUtil.copy(fis, fos, -1L);
                fos.close();
                fis.close();
                System.err.println("Broken peers file copied to " + brokenPeersFile);
            }
            catch (IOException e) {
                System.err.println("Unable to copy broken peers file.");
            }
        }
        if (!droppedOldPeers.isEmpty()) {
            try {
                this.node.getClientCore().getAlerts().register(droppedOldPeers);
                Logger.error(this, droppedOldPeers.getText());
            }
            catch (Throwable t) {
                Logger.error(this, "Caught error telling user about dropped peers", t);
            }
        }
        return !someBroken;
    }

    public boolean addPeer(PeerNode pn) {
        return this.addPeer(pn, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addPeer(PeerNode pn, boolean ignoreOpennet, boolean reactivate) {
        assert (pn != null);
        if (reactivate) {
            pn.forceCancelDisconnecting();
        }
        PeerManager peerManager = this;
        synchronized (peerManager) {
            for (PeerNode myPeer : this.myPeers) {
                if (!myPeer.equals(pn)) continue;
                if (logMINOR) {
                    Logger.minor(this, "Can't add peer " + pn + " because already have " + myPeer, (Throwable)new Exception("debug"));
                }
                return false;
            }
            this.myPeers = Arrays.copyOf(this.myPeers, this.myPeers.length + 1);
            this.myPeers[this.myPeers.length - 1] = pn;
            Logger.normal(this, "Added " + pn);
        }
        if (pn.recordStatus()) {
            this.addPeerNodeStatus(pn.getPeerNodeStatus(), pn, false);
        }
        pn.setPeerNodeStatus(System.currentTimeMillis());
        if (!ignoreOpennet && pn instanceof OpennetPeerNode) {
            OpennetManager opennet = this.node.getOpennet();
            if (opennet != null) {
                opennet.forceAddPeer((OpennetPeerNode)pn, true);
            } else {
                Logger.error(this, "Adding opennet peer when no opennet enabled!!!: " + pn + " - removing...");
                this.removePeer(pn);
                return false;
            }
        }
        this.notifyPeerStatusChangeListeners();
        if (!pn.isSeed()) {
            this.node.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PeerManager.this.updatePMUserAlert();
                }
            });
        }
        return true;
    }

    synchronized boolean havePeer(PeerNode pn) {
        for (PeerNode myPeer : this.myPeers) {
            if (myPeer != pn) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePeer(PeerNode pn) {
        if (logMINOR) {
            Logger.minor(this, "Removing " + pn);
        }
        boolean isInPeers = false;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            for (PeerNode peerNode : this.myPeers) {
                if (peerNode != pn) continue;
                isInPeers = true;
                break;
            }
            if (pn instanceof DarknetPeerNode) {
                ((DarknetPeerNode)pn).removeExtraPeerDataDir();
            }
            if (isInPeers) {
                String peerNodePreviousRoutingBackoffReason;
                int peerNodeStatus = pn.getPeerNodeStatus();
                if (pn.recordStatus()) {
                    this.removePeerNodeStatus(peerNodeStatus, pn, !isInPeers);
                }
                if ((peerNodePreviousRoutingBackoffReason = pn.getPreviousBackoffReason(true)) != null) {
                    this.removePeerNodeRoutingBackoffReason(peerNodePreviousRoutingBackoffReason, pn, true);
                }
                if ((peerNodePreviousRoutingBackoffReason = pn.getPreviousBackoffReason(false)) != null) {
                    this.removePeerNodeRoutingBackoffReason(peerNodePreviousRoutingBackoffReason, pn, false);
                }
                ArrayList<PeerNode> a = new ArrayList<PeerNode>();
                for (PeerNode mp : this.myPeers) {
                    if (mp == pn || !mp.isConnected() || !mp.isRealConnection()) continue;
                    a.add(mp);
                }
                PeerNode[] peerNodeArray2 = new PeerNode[a.size()];
                peerNodeArray2 = a.toArray(peerNodeArray2);
                this.connectedPeers = peerNodeArray2;
                PeerNode[] newMyPeers = new PeerNode[this.myPeers.length - 1];
                int positionInNewArray = 0;
                for (PeerNode mp : this.myPeers) {
                    if (mp == pn) continue;
                    newMyPeers[positionInNewArray] = mp;
                    ++positionInNewArray;
                }
                this.myPeers = newMyPeers;
                Logger.normal(this, "Removed " + pn);
            }
        }
        pn.onRemove();
        if (isInPeers && !pn.isSeed()) {
            this.updatePMUserAlert();
        }
        this.notifyPeerStatusChangeListeners();
        this.updatePMUserAlert();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllPeers() {
        Logger.normal(this, "removeAllPeers!");
        PeerNode[] peerNodeArray = this;
        synchronized (this) {
            PeerNode[] oldPeers = this.myPeers;
            this.myPeers = new PeerNode[0];
            this.connectedPeers = new PeerNode[0];
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (PeerNode oldPeer : oldPeers) {
                oldPeer.onRemove();
            }
            super.notifyPeerStatusChangeListeners();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnected(PeerNode pn) {
        PeerManager peerManager = this;
        synchronized (peerManager) {
            boolean isInPeers = false;
            for (PeerNode connectedPeer : this.connectedPeers) {
                if (connectedPeer != pn) continue;
                isInPeers = true;
                break;
            }
            if (!isInPeers) {
                return false;
            }
            ArrayList<PeerNode> a = new ArrayList<PeerNode>();
            for (PeerNode mp : this.myPeers) {
                if (mp == pn || !mp.isRoutable()) continue;
                a.add(mp);
            }
            PeerNode[] newConnectedPeers = new PeerNode[a.size()];
            newConnectedPeers = a.toArray(newConnectedPeers);
            this.connectedPeers = newConnectedPeers;
        }
        if (!pn.isSeed()) {
            this.updatePMUserAlert();
        }
        this.node.getLocationManager().announceLocChange();
        return true;
    }

    public long getTimeFirstAnyConnections() {
        return this.timeFirstAnyConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectedPeer(PeerNode pn) {
        if (!pn.isRealConnection()) {
            if (logMINOR) {
                Logger.minor(this, "Not a real connection: " + pn);
            }
            return;
        }
        if (!pn.isConnected()) {
            if (logMINOR) {
                Logger.minor(this, "Not connected: " + pn);
            }
            return;
        }
        long now = System.currentTimeMillis();
        PeerManager peerManager = this;
        synchronized (peerManager) {
            if (this.timeFirstAnyConnections == 0L) {
                this.timeFirstAnyConnections = now;
            }
            for (PeerNode connectedPeer : this.connectedPeers) {
                if (connectedPeer != pn) continue;
                if (logMINOR) {
                    Logger.minor(this, "Already connected: " + pn);
                }
                return;
            }
            boolean inMyPeers = false;
            for (PeerNode mp : this.myPeers) {
                if (mp != pn) continue;
                inMyPeers = true;
                break;
            }
            if (!inMyPeers) {
                Logger.error(this, "Connecting to " + pn + " but not in peers!");
                this.addPeer(pn);
            }
            if (logMINOR) {
                Logger.minor(this, "Connecting: " + pn);
            }
            this.connectedPeers = Arrays.copyOf(this.connectedPeers, this.connectedPeers.length + 1);
            this.connectedPeers[this.connectedPeers.length - 1] = pn;
            if (logMINOR) {
                Logger.minor(this, "Connected peers: " + this.connectedPeers.length);
            }
        }
        if (!pn.isSeed()) {
            this.updatePMUserAlert();
        }
        this.node.getLocationManager().announceLocChange();
    }

    public PeerNode getByPeer(Peer peer) {
        PeerNode[] peerList;
        for (PeerNode pn : peerList = this.myPeers()) {
            if (pn.isDisabled() || !pn.matchesPeerAndPort(peer)) continue;
            return pn;
        }
        FreenetInetAddress addr = peer.getFreenetAddress();
        for (PeerNode pn : peerList) {
            if (pn.isDisabled() || !pn.matchesIP(addr, false)) continue;
            return pn;
        }
        return null;
    }

    public PeerNode getByPeer(Peer peer, FNPPacketMangler mangler) {
        PeerNode[] peerList;
        for (PeerNode pn : peerList = this.myPeers()) {
            if (pn.isDisabled() || !pn.matchesPeerAndPort(peer) || pn.getOutgoingMangler() != mangler) continue;
            return pn;
        }
        FreenetInetAddress addr = peer.getFreenetAddress();
        for (PeerNode pn : peerList) {
            if (pn.isDisabled() || !pn.matchesIP(addr, false) || pn.getOutgoingMangler() != mangler) continue;
            return pn;
        }
        return null;
    }

    public ArrayList<PeerNode> getAllConnectedByAddress(FreenetInetAddress a, boolean strict) {
        PeerNode[] peerList;
        ArrayList<PeerNode> found = null;
        for (PeerNode pn : peerList = this.myPeers()) {
            if (!pn.isConnected() || !pn.isRoutable() || !pn.matchesIP(a, strict)) continue;
            if (found == null) {
                found = new ArrayList<PeerNode>();
            }
            found.add(pn);
        }
        return found;
    }

    public void connect(SimpleFieldSet noderef, OutgoingPacketMangler mangler, DarknetPeerNode.FRIEND_TRUST trust, DarknetPeerNode.FRIEND_VISIBILITY visibility) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException, PeerTooOldException {
        PeerNode[] peerList;
        DarknetPeerNode pn = this.node.createNewDarknetNode(noderef, trust, visibility);
        for (PeerNode mp : peerList = this.myPeers()) {
            if (!Arrays.equals(mp.peerECDSAPubKeyHash, pn.peerECDSAPubKeyHash)) continue;
            return;
        }
        this.addPeer(pn);
    }

    public void disconnectAndRemove(PeerNode pn, boolean sendDisconnectMessage, boolean waitForAck, boolean purge) {
        this.disconnect(pn, sendDisconnectMessage, waitForAck, purge, false, true, Node.MAX_PEER_INACTIVITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(final PeerNode pn, boolean sendDisconnectMessage, final boolean waitForAck, boolean purge, boolean dumpMessagesNow, final boolean remove, long timeout) {
        if (logMINOR) {
            Logger.minor(this, "Disconnecting " + pn.shortToString(), (Throwable)new Exception("debug"));
        }
        PeerManager peerManager = this;
        synchronized (peerManager) {
            if (!this.havePeer(pn)) {
                return;
            }
        }
        if (pn.notifyDisconnecting(dumpMessagesNow)) {
            if (logMINOR) {
                Logger.minor(this, "Already disconnecting " + pn.shortToString());
            }
            return;
        }
        if (sendDisconnectMessage) {
            Message msg = DMT.createFNPDisconnect(remove, purge, -1, new ShortBuffer(new byte[0]));
            try {
                pn.sendAsync(msg, new AsyncMessageCallback(){
                    boolean done = false;

                    @Override
                    public void acknowledged() {
                        this.done();
                    }

                    @Override
                    public void disconnected() {
                        this.done();
                    }

                    @Override
                    public void fatalError() {
                        this.done();
                    }

                    @Override
                    public void sent() {
                        if (!waitForAck) {
                            this.done();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    void done() {
                        4 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.done) {
                                return;
                            }
                            this.done = true;
                        }
                        if (remove && PeerManager.this.removePeer(pn) && !pn.isSeed()) {
                            PeerManager.this.writePeersUrgent(pn.isOpennet());
                        }
                    }
                }, this.ctrDisconn);
            }
            catch (NotConnectedException e) {
                if (remove && pn.isDisconnecting() && this.removePeer(pn) && !pn.isSeed()) {
                    this.writePeersUrgent(pn.isOpennet());
                }
                return;
            }
            if (!pn.isSeed()) {
                this.node.getTicker().queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        if (pn.isDisconnecting()) {
                            if (remove && PeerManager.this.removePeer(pn) && !pn.isSeed()) {
                                PeerManager.this.writePeersUrgent(pn.isOpennet());
                            }
                            pn.disconnected(true, true);
                        }
                    }
                }, timeout);
            }
        } else if (remove && this.removePeer(pn) && !pn.isSeed()) {
            this.writePeersUrgent(pn.isOpennet());
        }
    }

    public double[] getPeerLocationDoubles(boolean pruneBackedOffPeers) {
        if (!this.node.shallWePublishOurPeersLocation()) {
            return new double[0];
        }
        PeerNode[] conns = this.connectedPeers();
        double[] locs = new double[conns.length];
        int x = 0;
        for (PeerNode conn : conns) {
            if (!conn.isRoutable() || pruneBackedOffPeers && conn.shouldBeExcludedFromPeerList()) continue;
            locs[x++] = conn.getLocation();
        }
        Arrays.sort(locs, 0, x);
        if (x != locs.length) {
            return Arrays.copyOf(locs, x);
        }
        return locs;
    }

    public synchronized PeerNode getRandomPeer(PeerNode exclude) {
        if (this.connectedPeers.length == 0) {
            return null;
        }
        for (int i = 0; i < 5; ++i) {
            PeerNode pn = this.connectedPeers[this.node.getRandom().nextInt(this.connectedPeers.length)];
            if (pn == exclude || !pn.isRoutable()) continue;
            return pn;
        }
        ArrayList<Object> v = new ArrayList<Object>(this.connectedPeers.length);
        for (PeerNode pn : this.myPeers) {
            if (pn == exclude) continue;
            if (pn.isRoutable()) {
                v.add(pn);
                continue;
            }
            if (!logMINOR) continue;
            Logger.minor(this, "Excluding " + pn + " because is disconnected");
        }
        int lengthWithoutExcluded = v.size();
        if (exclude != null && exclude.isRoutable()) {
            v.add(exclude);
        }
        PeerNode[] newConnectedPeers = new PeerNode[v.size()];
        newConnectedPeers = v.toArray(newConnectedPeers);
        if (logMINOR) {
            Logger.minor(this, "Connected peers (in getRandomPeer): " + newConnectedPeers.length + " was " + this.connectedPeers.length);
        }
        this.connectedPeers = newConnectedPeers;
        if (lengthWithoutExcluded == 0) {
            return null;
        }
        return this.connectedPeers[this.node.getRandom().nextInt(lengthWithoutExcluded)];
    }

    public void localBroadcast(Message msg, boolean ignoreRoutability, boolean onlyRealConnections, ByteCounter ctr) {
        this.localBroadcast(msg, ignoreRoutability, onlyRealConnections, ctr, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void localBroadcast(Message msg, boolean ignoreRoutability, boolean onlyRealConnections, ByteCounter ctr, int minVersion, int maxVersion) {
        PeerNode[] peers;
        for (PeerNode peer : peers = this.myPeers()) {
            int version;
            if (!ignoreRoutability ? !peer.isRoutable() : !peer.isConnected()) continue;
            if (onlyRealConnections && !peer.isRealConnection() || (version = peer.getVersionNumber()) < minVersion || version > maxVersion) continue;
            try {
                peer.sendAsync(msg, null, ctr);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
    }

    public void locallyBroadcastDiffNodeRef(SimpleFieldSet fs, boolean toDarknetOnly, boolean toOpennetOnly) {
        PeerNode[] peers;
        for (PeerNode peer : peers = this.myPeers()) {
            if (!peer.isConnected() || toDarknetOnly && !peer.isDarknet() || toOpennetOnly && !peer.isOpennet()) continue;
            peer.sendNodeToNodeMessage(fs, 2, false, 0L, false);
        }
    }

    public PeerNode getRandomPeer() {
        return this.getRandomPeer(null);
    }

    public PeerNode closerPeer(PeerNode pn, Set<PeerNode> routedTo, double loc, boolean ignoreSelf, boolean calculateMisrouting, int minVersion, List<Double> addUnpickedLocsTo, Key key, short outgoingHTL, long ignoreBackoffUnder, boolean isLocal, boolean realTime, boolean excludeMandatoryBackoff) {
        return this.closerPeer(pn, routedTo, loc, ignoreSelf, calculateMisrouting, minVersion, addUnpickedLocsTo, 2.0, key, outgoingHTL, ignoreBackoffUnder, isLocal, realTime, null, false, System.currentTimeMillis(), excludeMandatoryBackoff);
    }

    public PeerNode closerPeer(PeerNode pn, Set<PeerNode> routedTo, double target, boolean ignoreSelf, boolean calculateMisrouting, int minVersion, List<Double> addUnpickedLocsTo, double maxDistance, Key key, short outgoingHTL, long ignoreBackoffUnder, boolean isLocal, boolean realTime, RecentlyFailedReturn recentlyFailed, boolean ignoreTimeout, long now, boolean newLoadManagement) {
        PeerNode first;
        int countWaiting = 0;
        long soonestTimeoutWakeup = Long.MAX_VALUE;
        PeerNode[] peers = this.connectedPeers();
        if (!this.node.isEnablePerNodeFailureTables()) {
            key = null;
        }
        if (logMINOR) {
            Logger.minor(this, "Choosing closest peer: connectedPeers=" + peers.length + " key " + key);
        }
        double myLoc = this.node.getLocation();
        double maxDiff = Double.MAX_VALUE;
        if (!ignoreSelf) {
            maxDiff = Location.distance(myLoc, target);
        }
        double prevLoc = -1.0;
        if (pn != null) {
            prevLoc = pn.getLocation();
        }
        double closestDistance = Double.MAX_VALUE;
        double closestRealDistance = Double.MAX_VALUE;
        PeerNode closestBackedOff = null;
        double closestBackedOffDistance = Double.MAX_VALUE;
        double closestRealBackedOffDistance = Double.MAX_VALUE;
        PeerNode closestNotBackedOff = null;
        double closestNotBackedOffDistance = Double.MAX_VALUE;
        double closestRealNotBackedOffDistance = Double.MAX_VALUE;
        PeerNode leastRecentlyTimedOut = null;
        long timeLeastRecentlyTimedOut = Long.MAX_VALUE;
        double leastRecentlyTimedOutDistance = Double.MAX_VALUE;
        PeerNode leastRecentlyTimedOutBackedOff = null;
        long timeLeastRecentlyTimedOutBackedOff = Long.MAX_VALUE;
        double leastRecentlyTimedOutBackedOffDistance = Double.MAX_VALUE;
        TimedOutNodesList entry = null;
        if (key != null) {
            entry = this.node.getFailureTable().getTimedOutNodesList(key);
        }
        double[] selectionRates = new double[peers.length];
        double totalSelectionRate = 0.0;
        for (int i = 0; i < peers.length; ++i) {
            selectionRates[i] = peers[i].selectionRate();
            totalSelectionRate += selectionRates[i];
        }
        boolean enableFOAFMitigationHack = peers.length >= 5 && totalSelectionRate > 0.0;
        HashSet<Double> excludeLocations = new HashSet<Double>();
        excludeLocations.add(myLoc);
        excludeLocations.add(prevLoc);
        for (PeerNode routedToNode : routedTo) {
            excludeLocations.add(routedToNode.getLocation());
        }
        for (int i = 0; i < peers.length; ++i) {
            Double d;
            boolean backedOff;
            double realDiff;
            double selectionPercentage;
            PeerNode p = peers[i];
            if (routedTo.contains(p)) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping (already routed to): " + p.getPeer());
                continue;
            }
            if (p == pn) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping (req came from): " + p.getPeer());
                continue;
            }
            if (!p.isRoutable()) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping (not connected): " + p.getPeer());
                continue;
            }
            if (p.isDisconnecting()) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping (disconnecting): " + p.getPeer());
                continue;
            }
            if (newLoadManagement && p.outputLoadTracker(realTime).getLastIncomingLoadStats() == null) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping (no load stats): " + p.getPeer());
                continue;
            }
            if (minVersion > 0 && Version.getArbitraryBuildNumber(p.getVersion(), -1) < minVersion) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping old version: " + p.getPeer());
                continue;
            }
            if (enableFOAFMitigationHack && (selectionPercentage = 100.0 * selectionRates[i] / totalSelectionRate) > 30.0) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping over-selected peer(" + selectionPercentage + "%): " + p.getPeer());
                continue;
            }
            if (newLoadManagement && p.isInMandatoryBackoff(now, realTime)) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping (mandatory backoff): " + p.getPeer());
                continue;
            }
            long timeoutRF = -1L;
            long timeoutFT = -1L;
            if (entry != null && !ignoreTimeout) {
                timeoutFT = entry.getTimeoutTime(p, outgoingHTL, now, true);
                timeoutRF = entry.getTimeoutTime(p, outgoingHTL, now, false);
                if (timeoutRF > now) {
                    soonestTimeoutWakeup = Math.min(soonestTimeoutWakeup, timeoutRF);
                    ++countWaiting;
                }
            }
            boolean timedOut = timeoutFT > now;
            double loc = p.getLocation();
            boolean direct = true;
            double diff = realDiff = Location.distance(loc, target);
            if (p.shallWeRouteAccordingToOurPeersLocation(outgoingHTL)) {
                double newDiff;
                double l = p.getClosestPeerLocation(target, excludeLocations);
                if (!Double.isNaN(l) && (newDiff = Location.distance(l, target)) < diff) {
                    loc = l;
                    diff = newDiff;
                    direct = false;
                }
                if (logMINOR) {
                    Logger.minor(this, "The peer " + p + " has published his peer's locations and the closest we have found to the target is " + diff + " away.");
                }
            }
            if (diff > maxDistance) continue;
            if (!ignoreSelf && diff > maxDiff) {
                if (!logMINOR) continue;
                Logger.minor(this, "Ignoring, further than self >maxDiff=" + maxDiff);
                continue;
            }
            if (logMINOR) {
                Logger.minor(this, "p.loc=" + loc + ", target=" + target + ", d=" + Location.distance(loc, target) + " usedD=" + diff + " timedOut=" + timedOut + " for " + p.getPeer());
            }
            boolean chosen = false;
            if (diff < closestDistance || Math.abs(diff - closestDistance) < 9.9E-324 && (direct || realDiff < closestRealDistance)) {
                closestDistance = diff;
                chosen = true;
                closestRealDistance = realDiff;
                if (logMINOR) {
                    Logger.minor(this, "New best: " + diff + " (" + loc + " for " + p.getPeer());
                }
            }
            if ((backedOff = p.isRoutingBackedOff(ignoreBackoffUnder, realTime)) && (diff < closestBackedOffDistance || Math.abs(diff - closestBackedOffDistance) < 9.9E-324 && (direct || realDiff < closestRealBackedOffDistance)) && !timedOut) {
                closestBackedOffDistance = diff;
                closestBackedOff = p;
                chosen = true;
                closestRealBackedOffDistance = realDiff;
                if (logMINOR) {
                    Logger.minor(this, "New best-backed-off: " + diff + " (" + loc + " for " + p.getPeer());
                }
            }
            if (!backedOff && (diff < closestNotBackedOffDistance || Math.abs(diff - closestNotBackedOffDistance) < 9.9E-324 && (direct || realDiff < closestRealNotBackedOffDistance)) && !timedOut) {
                closestNotBackedOffDistance = diff;
                closestNotBackedOff = p;
                chosen = true;
                closestRealNotBackedOffDistance = realDiff;
                if (logMINOR) {
                    Logger.minor(this, "New best-not-backed-off: " + diff + " (" + loc + " for " + p.getPeer());
                }
            }
            if (timedOut) {
                if (!backedOff) {
                    if (timeoutFT < timeLeastRecentlyTimedOut) {
                        timeLeastRecentlyTimedOut = timeoutFT;
                        leastRecentlyTimedOut = p;
                        leastRecentlyTimedOutDistance = diff;
                    }
                } else if (timeoutFT < timeLeastRecentlyTimedOutBackedOff) {
                    timeLeastRecentlyTimedOutBackedOff = timeoutFT;
                    leastRecentlyTimedOutBackedOff = p;
                    leastRecentlyTimedOutBackedOffDistance = diff;
                }
            }
            if (addUnpickedLocsTo == null || chosen || addUnpickedLocsTo.contains(d = Double.valueOf(loc))) continue;
            addUnpickedLocsTo.add(d);
        }
        PeerNode best = closestNotBackedOff;
        double bestDistance = closestNotBackedOffDistance;
        if (best == null) {
            if (leastRecentlyTimedOut != null) {
                best = leastRecentlyTimedOut;
                bestDistance = leastRecentlyTimedOutDistance;
                if (logMINOR) {
                    Logger.minor(this, "Using least recently failed in-timeout-period peer for key: " + best.shortToString() + " for " + key);
                }
            } else if (closestBackedOff != null) {
                best = closestBackedOff;
                bestDistance = closestBackedOffDistance;
                if (logMINOR) {
                    Logger.minor(this, "Using best backed-off peer for key: " + best.shortToString());
                }
            } else if (leastRecentlyTimedOutBackedOff != null) {
                best = leastRecentlyTimedOutBackedOff;
                bestDistance = leastRecentlyTimedOutBackedOffDistance;
                if (logMINOR) {
                    Logger.minor(this, "Using least recently failed in-timeout-period backed-off peer for key: " + best.shortToString() + " for " + key);
                }
            }
        }
        if (recentlyFailed != null && logMINOR) {
            Logger.minor(this, "Count waiting: " + countWaiting);
        }
        int maxCountWaiting = this.maxCountWaiting(peers);
        if (recentlyFailed != null && countWaiting >= maxCountWaiting && this.node.isEnableULPRDataPropagation() && (first = this.closerPeer(pn, routedTo, target, ignoreSelf, false, minVersion, null, maxDistance, key, outgoingHTL, ignoreBackoffUnder, isLocal, realTime, null, true, now, newLoadManagement)) != null) {
            long firstTime = entry.getTimeoutTime(first, outgoingHTL, now, false);
            if (firstTime > now) {
                if (logMINOR) {
                    Logger.minor(this, "First choice is past now");
                }
                HashSet<PeerNode> newRoutedTo = new HashSet<PeerNode>(routedTo);
                newRoutedTo.add(first);
                PeerNode second = this.closerPeer(pn, newRoutedTo, target, ignoreSelf, false, minVersion, null, maxDistance, key, outgoingHTL, ignoreBackoffUnder, isLocal, realTime, null, true, now, newLoadManagement);
                if (second != null) {
                    long secondTime = entry.getTimeoutTime(first, outgoingHTL, now, false);
                    if (secondTime > now) {
                        long check;
                        if (logMINOR) {
                            Logger.minor(this, "Second choice is past now");
                        }
                        long until = Math.min(secondTime, firstTime);
                        if (countWaiting == maxCountWaiting) {
                            until = Math.min(until, soonestTimeoutWakeup);
                            if (logMINOR) {
                                Logger.minor(this, "Recently failed: " + (int)Math.min(Integer.MAX_VALUE, soonestTimeoutWakeup - now) + "ms");
                            }
                        }
                        if ((check = best == closestNotBackedOff ? Long.MAX_VALUE : this.checkBackoffsForRecentlyFailed(peers, best, target, bestDistance, myLoc, prevLoc, now, entry, outgoingHTL)) < until) {
                            if (logMINOR) {
                                Logger.minor(this, "Reducing RecentlyFailed from " + (until - now) + "ms to " + (check - now) + "ms because of check for peers to wakeup");
                            }
                            until = check;
                        }
                        if (until > now + 2000L) {
                            if (until > now + FailureTable.RECENTLY_FAILED_TIME) {
                                Logger.error(this, "Wakeup time is too long: " + TimeUtil.formatTime(until - now));
                                until = now + FailureTable.RECENTLY_FAILED_TIME;
                            }
                            if (!this.node.getFailureTable().hadAnyOffers(key)) {
                                recentlyFailed.fail(countWaiting, until);
                                return null;
                            }
                            if (logMINOR) {
                                Logger.minor(this, "Have an offer for the key so not sending RecentlyFailed");
                            }
                        } else if (logMINOR) {
                            Logger.minor(this, "Not sending RecentlyFailed because will wake up in " + (check - now) + "ms");
                        }
                    }
                } else if (logMINOR) {
                    Logger.minor(this, "Second choice is not in timeout (for recentlyfailed): " + second);
                }
            } else if (logMINOR) {
                Logger.minor(this, "First choice is not in timeout (for recentlyfailed): " + first);
            }
        }
        if (best != null) {
            if (calculateMisrouting) {
                int numberOfConnected = this.getPeerNodeStatusSize(1, false);
                int numberOfRoutingBackedOff = this.getPeerNodeStatusSize(2, false);
                if (numberOfRoutingBackedOff + numberOfConnected > 0) {
                    this.node.getNodeStats().backedOffPercent.report((double)numberOfRoutingBackedOff / (double)(numberOfRoutingBackedOff + numberOfConnected));
                }
            }
            if (addUnpickedLocsTo != null && closestNotBackedOff != null && closestBackedOff != null) {
                addUnpickedLocsTo.add(closestBackedOff.getLocation());
            }
        }
        return best;
    }

    private int maxCountWaiting(PeerNode[] peers) {
        int count = this.countConnectedPeers(peers);
        return Math.min(10, Math.max(3, count / 4));
    }

    private long checkBackoffsForRecentlyFailed(PeerNode[] peers, PeerNode best, double target, double bestDistance, double myLoc, double prevLoc, long now, TimedOutNodesList entry, short outgoingHTL) {
        long overallWakeup = Long.MAX_VALUE;
        HashSet<Double> excludeLocations = new HashSet<Double>();
        excludeLocations.add(myLoc);
        excludeLocations.add(prevLoc);
        for (PeerNode p : peers) {
            double realDiff;
            if (p == best || !p.isRoutable()) continue;
            double loc = p.getLocation();
            double diff = realDiff = Location.distance(loc, target);
            if (p.shallWeRouteAccordingToOurPeersLocation(outgoingHTL)) {
                double newDiff;
                double l = p.getClosestPeerLocation(target, excludeLocations);
                if (!Double.isNaN(l) && (newDiff = Location.distance(l, target)) < diff) {
                    loc = l;
                    diff = newDiff;
                }
                if (logMINOR) {
                    Logger.minor(this, "The peer " + p + " has published his peer's locations and the closest we have found to the target is " + diff + " away.");
                }
            }
            if (diff >= bestDistance) continue;
            long wakeup = 0L;
            long timeoutFT = entry.getTimeoutTime(p, outgoingHTL, now, true);
            long timeoutRF = entry.getTimeoutTime(p, outgoingHTL, now, false);
            if (timeoutFT > now) {
                wakeup = Math.max(wakeup, timeoutFT);
            }
            if (timeoutRF > now) {
                wakeup = Math.max(wakeup, timeoutRF);
            }
            long bulkBackoff = p.getRoutingBackedOffUntilBulk();
            long rtBackoff = p.getRoutingBackedOffUntilRT();
            if (bulkBackoff > now && rtBackoff <= now) {
                wakeup = Math.max(wakeup, bulkBackoff);
            } else if (bulkBackoff <= now && rtBackoff > now) {
                wakeup = Math.max(wakeup, rtBackoff);
            } else if (bulkBackoff > now && rtBackoff > now) {
                wakeup = Math.max(wakeup, Math.min(bulkBackoff, rtBackoff));
            }
            if (wakeup > now) {
                if (logMINOR) {
                    Logger.minor(this, "Peer " + p + " will wake up from backoff, failure table and recentlyfailed in " + (wakeup - now) + "ms");
                }
                overallWakeup = Math.min(overallWakeup, wakeup);
                continue;
            }
            if (!logMINOR) continue;
            Logger.minor(this, "Better node in check backoffs for RecentlyFailed??? " + p);
        }
        return overallWakeup;
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        PeerNode[] peers = this.myPeers();
        Object[] status = new String[peers.length];
        for (int i = 0; i < peers.length; ++i) {
            PeerNode pn = peers[i];
            status[i] = pn.getStatus(true).toString();
        }
        Arrays.sort(status);
        for (Object s : status) {
            sb.append((String)s);
            sb.append('\n');
        }
        return sb.toString();
    }

    public String getTMCIPeerList() {
        StringBuilder sb = new StringBuilder();
        PeerNode[] peers = this.myPeers();
        Object[] peerList = new String[peers.length];
        for (int i = 0; i < peers.length; ++i) {
            PeerNode pn = peers[i];
            peerList[i] = pn.getTMCIPeerInfo();
        }
        Arrays.sort(peerList);
        for (Object p : peerList) {
            sb.append((String)p);
            sb.append('\n');
        }
        return sb.toString();
    }

    void writePeers(boolean opennet) {
        if (opennet) {
            this.writePeersOpennet();
        } else {
            this.writePeersDarknet();
        }
    }

    void writePeersUrgent(boolean opennet) {
        if (opennet) {
            this.writePeersOpennetUrgent();
        } else {
            this.writePeersDarknetUrgent();
        }
    }

    void writePeersOpennetUrgent() {
        this.node.getExecutor().execute(new PrioRunnable(){

            @Override
            public void run() {
                PeerManager.this.writePeersOpennetNow(true);
            }

            @Override
            public int getPriority() {
                return NativeThread.HIGH_PRIORITY;
            }
        });
    }

    void writePeersDarknetUrgent() {
        this.node.getExecutor().execute(new PrioRunnable(){

            @Override
            public void run() {
                PeerManager.this.writePeersDarknetNow(true);
            }

            @Override
            public int getPriority() {
                return NativeThread.HIGH_PRIORITY;
            }
        });
    }

    void writePeersDarknet() {
        this.shouldWritePeersDarknet = true;
    }

    void writePeersOpennet() {
        this.shouldWritePeersOpennet = true;
    }

    protected String getDarknetPeersString() {
        PeerNode[] peers;
        StringBuilder sb = new StringBuilder();
        for (PeerNode pn : peers = this.myPeers()) {
            if (!(pn instanceof DarknetPeerNode)) continue;
            sb.append(pn.exportDiskFieldSet().toOrderedString());
        }
        return sb.toString();
    }

    protected String getOpennetPeersString() {
        PeerNode[] peers;
        StringBuilder sb = new StringBuilder();
        for (PeerNode pn : peers = this.myPeers()) {
            if (!(pn instanceof OpennetPeerNode)) continue;
            sb.append(pn.exportDiskFieldSet().toOrderedString());
        }
        return sb.toString();
    }

    protected String getOldOpennetPeersString(OpennetManager om) {
        StringBuilder sb = new StringBuilder();
        for (OpennetPeerNode pn : om.getOldPeers()) {
            if (!(pn instanceof OpennetPeerNode)) continue;
            sb.append(pn.exportDiskFieldSet().toOrderedString());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePeersInnerDarknet(boolean rotateBackups) {
        String newDarknetPeersString = null;
        Object object = this.writePeersSync;
        synchronized (object) {
            if (this.darkFilename != null) {
                newDarknetPeersString = this.getDarknetPeersString();
            }
        }
        object = this.writePeerFileSync;
        synchronized (object) {
            if (newDarknetPeersString != null && !newDarknetPeersString.equals(this.darknetPeersStringCache)) {
                this.darknetPeersStringCache = newDarknetPeersString;
                this.writePeersInner(this.darkFilename, this.darknetPeersStringCache, 10, rotateBackups);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePeersInnerOpennet(boolean rotateBackups) {
        String newOpennetPeersString = null;
        String newOldOpennetPeersString = null;
        Object object = this.writePeersSync;
        synchronized (object) {
            OpennetManager om = this.node.getOpennet();
            if (om != null) {
                if (this.openFilename != null) {
                    newOpennetPeersString = this.getOpennetPeersString();
                }
                this.oldOpennetPeersFilename = om.getOldPeersFilename();
                newOldOpennetPeersString = this.getOldOpennetPeersString(om);
            }
        }
        object = this.writePeerFileSync;
        synchronized (object) {
            if (newOpennetPeersString != null && !newOpennetPeersString.equals(this.opennetPeersStringCache)) {
                this.opennetPeersStringCache = newOpennetPeersString;
                this.writePeersInner(this.openFilename, this.opennetPeersStringCache, 1, rotateBackups);
            }
            if (newOldOpennetPeersString != null && !newOldOpennetPeersString.equals(this.oldOpennetPeersStringCache)) {
                this.oldOpennetPeersStringCache = newOldOpennetPeersString;
                this.writePeersInner(this.oldOpennetPeersFilename, this.oldOpennetPeersStringCache, 1, rotateBackups);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePeersInner(String filename, String sb, int maxBackups, boolean rotateBackups) {
        assert (maxBackups >= 1);
        Object object = this.writePeerFileSync;
        synchronized (object) {
            File f;
            FileOutputStream fos = null;
            File full = new File(filename).getAbsoluteFile();
            try {
                f = File.createTempFile(full.getName() + ".", ".tmp", full.getParentFile());
            }
            catch (IOException e2) {
                Logger.error(this, "Cannot write peers to disk: Cannot create temp file - " + e2, (Throwable)e2);
                Closer.close(fos);
                return;
            }
            try {
                fos = new FileOutputStream(f);
            }
            catch (FileNotFoundException e2) {
                Logger.error(this, "Cannot write peers to disk: Cannot create " + f + " - " + e2, (Throwable)e2);
                Closer.close(fos);
                f.delete();
                return;
            }
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
            try {
                w.write(sb);
                w.flush();
                fos.getFD().sync();
                w.close();
                w = null;
                if (rotateBackups) {
                    File prevFile = null;
                    for (int i = maxBackups; i >= 0; --i) {
                        File thisFile = this.getBackupFilename(filename, i);
                        if (prevFile == null) {
                            thisFile.delete();
                        } else if (thisFile.exists()) {
                            FileUtil.renameTo(thisFile, prevFile);
                        }
                        prevFile = thisFile;
                    }
                    FileUtil.renameTo(f, prevFile);
                } else {
                    FileUtil.renameTo(f, this.getBackupFilename(filename, 0));
                }
            }
            catch (IOException e) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    Logger.error(this, "Cannot close peers file: " + e, (Throwable)e);
                }
                Logger.error(this, "Cannot write file: " + e, (Throwable)e);
                f.delete();
                return;
            }
            finally {
                Closer.close(w);
                Closer.close(fos);
                f.delete();
            }
        }
    }

    private File getBackupFilename(String filename, int i) {
        if (i == 0) {
            return new File(filename);
        }
        if (i == 1) {
            return new File(filename + ".bak");
        }
        return new File(filename + ".bak." + i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePMUserAlert() {
        boolean opennetAssumeNAT;
        boolean opennetDefinitelyPortForwarded;
        boolean opennetEnabled;
        int peers;
        int darknetPeers;
        if (this.ua == null) {
            return;
        }
        PeerManager peerManager = this;
        synchronized (peerManager) {
            darknetPeers = this.getDarknetPeers().length;
            int opennetPeers = this.getOpennetPeers().length;
            peers = darknetPeers + opennetPeers;
        }
        OpennetManager om = this.node.getOpennet();
        if (om != null) {
            opennetEnabled = true;
            opennetDefinitelyPortForwarded = om.getCrypto().definitelyPortForwarded();
            opennetAssumeNAT = om.getCrypto().getConfig().alwaysHandshakeAggressively();
        } else {
            opennetEnabled = false;
            opennetDefinitelyPortForwarded = false;
            opennetAssumeNAT = false;
        }
        boolean darknetDefinitelyPortForwarded = this.node.darknetDefinitelyPortForwarded();
        boolean darknetAssumeNAT = this.node.getDarknetCrypto().getConfig().alwaysHandshakeAggressively();
        PeerManagerUserAlert peerManagerUserAlert = this.ua;
        synchronized (peerManagerUserAlert) {
            this.ua.opennetDefinitelyPortForwarded = opennetDefinitelyPortForwarded;
            this.ua.darknetDefinitelyPortForwarded = darknetDefinitelyPortForwarded;
            this.ua.opennetAssumeNAT = opennetAssumeNAT;
            this.ua.darknetAssumeNAT = darknetAssumeNAT;
            this.ua.darknetConns = this.getPeerNodeStatusSize(1, true) + this.getPeerNodeStatusSize(2, true);
            this.ua.conns = this.getPeerNodeStatusSize(1, false) + this.getPeerNodeStatusSize(2, false);
            this.ua.darknetPeers = darknetPeers;
            this.ua.disconnDarknetPeers = darknetPeers - this.ua.darknetConns;
            this.ua.peers = peers;
            this.ua.neverConn = this.getPeerNodeStatusSize(6, true);
            this.ua.clockProblem = this.getPeerNodeStatusSize(11, false);
            this.ua.connError = this.getPeerNodeStatusSize(12, true);
            this.ua.isOpennetEnabled = opennetEnabled;
            this.ua.tooNewPeersDarknet = this.getPeerNodeStatusSize(3, true);
            this.ua.tooNewPeersTotal = this.getPeerNodeStatusSize(3, false);
        }
        if (this.anyConnectedPeers()) {
            this.node.onConnectedPeer();
        }
    }

    public boolean anyConnectedPeers() {
        PeerNode[] conns;
        for (PeerNode conn : conns = this.connectedPeers()) {
            if (!conn.isRoutable()) continue;
            return true;
        }
        return false;
    }

    public boolean anyDarknetPeers() {
        PeerNode[] conns;
        for (PeerNode p : conns = this.connectedPeers()) {
            if (!p.isDarknet()) continue;
            return true;
        }
        return false;
    }

    public void readExtraPeerData() {
        DarknetPeerNode[] peers;
        for (DarknetPeerNode peer : peers = this.getDarknetPeers()) {
            try {
                peer.readExtraPeerData();
            }
            catch (Exception e) {
                Logger.error(this, "Got exception while reading extra peer data", (Throwable)e);
            }
        }
        String msg = "Extra peer data reading and processing completed";
        Logger.normal(this, msg);
        System.out.println(msg);
    }

    public void start() {
        this.ua = new PeerManagerUserAlert(this.node.getNodeStats(), this.node.getNodeUpdater());
        this.updatePMUserAlert();
        this.node.getClientCore().getAlerts().register(this.ua);
        this.node.getTicker().queueTimedJob(this.writePeersRunnable, 0L);
    }

    public int countNonBackedOffPeers(boolean realTime) {
        PeerNode[] peers = this.connectedPeers();
        int countNoBackoff = 0;
        for (PeerNode peer : peers) {
            if (!peer.isRoutable() || peer.isRoutingBackedOff(realTime)) continue;
            ++countNoBackoff;
        }
        return countNoBackoff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeUpdateOldestNeverConnectedDarknetPeerAge(long now) {
        PeerNode[] peerNodeArray = this;
        synchronized (this) {
            if (now <= this.nextOldestNeverConnectedDarknetPeerAgeUpdateTime) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return;
            }
            this.nextOldestNeverConnectedDarknetPeerAgeUpdateTime = now + 5000L;
            PeerNode[] peerList = this.myPeers;
            // ** MonitorExit[var4_2] (shouldn't be in output)
            this.oldestNeverConnectedDarknetPeerAge = 0L;
            for (PeerNode pn : peerList) {
                if (!pn.isDarknet() || pn.getPeerNodeStatus() != 6 || now - pn.getPeerAddedTime() <= this.oldestNeverConnectedDarknetPeerAge) continue;
                this.oldestNeverConnectedDarknetPeerAge = now - pn.getPeerAddedTime();
            }
            if (this.oldestNeverConnectedDarknetPeerAge > 0L && logMINOR) {
                Logger.minor(this, "Oldest never connected peer is " + this.oldestNeverConnectedDarknetPeerAge + "ms old");
            }
            this.nextOldestNeverConnectedDarknetPeerAgeUpdateTime = now + 5000L;
            return;
        }
    }

    public long getOldestNeverConnectedDarknetPeerAge() {
        return this.oldestNeverConnectedDarknetPeerAge;
    }

    public void maybeLogPeerNodeStatusSummary(long now) {
        if (now > this.nextPeerNodeStatusLogTime) {
            PeerNode[] peers;
            if (now - this.nextPeerNodeStatusLogTime > TimeUnit.SECONDS.toMillis(10L) && this.nextPeerNodeStatusLogTime > 0L) {
                Logger.error(this, "maybeLogPeerNodeStatusSummary() not called for more than 10 seconds (" + (now - this.nextPeerNodeStatusLogTime) + ").  PacketSender getting bogged down or something?");
            }
            int numberOfConnected = 0;
            int numberOfRoutingBackedOff = 0;
            int numberOfTooNew = 0;
            int numberOfTooOld = 0;
            int numberOfDisconnected = 0;
            int numberOfNeverConnected = 0;
            int numberOfDisabled = 0;
            int numberOfListenOnly = 0;
            int numberOfListening = 0;
            int numberOfBursting = 0;
            int numberOfClockProblem = 0;
            int numberOfConnError = 0;
            int numberOfDisconnecting = 0;
            int numberOfRoutingDisabled = 0;
            int numberOfNoLoadStats = 0;
            block17: for (PeerNode peer : peers = this.myPeers()) {
                if (peer == null) {
                    Logger.error(this, "getPeerNodeStatuses(true) == null!");
                    continue;
                }
                int status = peer.getPeerNodeStatus();
                switch (status) {
                    case 1: {
                        ++numberOfConnected;
                        continue block17;
                    }
                    case 2: {
                        ++numberOfRoutingBackedOff;
                        continue block17;
                    }
                    case 3: {
                        ++numberOfTooNew;
                        continue block17;
                    }
                    case 4: {
                        ++numberOfTooOld;
                        continue block17;
                    }
                    case 5: {
                        ++numberOfDisconnected;
                        continue block17;
                    }
                    case 6: {
                        ++numberOfNeverConnected;
                        continue block17;
                    }
                    case 7: {
                        ++numberOfDisabled;
                        continue block17;
                    }
                    case 10: {
                        ++numberOfListenOnly;
                        continue block17;
                    }
                    case 9: {
                        ++numberOfListening;
                        continue block17;
                    }
                    case 8: {
                        ++numberOfBursting;
                        continue block17;
                    }
                    case 11: {
                        ++numberOfClockProblem;
                        continue block17;
                    }
                    case 12: {
                        ++numberOfConnError;
                        continue block17;
                    }
                    case 13: {
                        ++numberOfDisconnecting;
                        continue block17;
                    }
                    case 14: {
                        ++numberOfRoutingDisabled;
                        continue block17;
                    }
                    case 15: {
                        ++numberOfNoLoadStats;
                        continue block17;
                    }
                    default: {
                        Logger.error(this, "Unknown peer status value : " + status);
                    }
                }
            }
            Logger.normal(this, "Connected: " + numberOfConnected + "  Routing Backed Off: " + numberOfRoutingBackedOff + "  Too New: " + numberOfTooNew + "  Too Old: " + numberOfTooOld + "  Disconnected: " + numberOfDisconnected + "  Never Connected: " + numberOfNeverConnected + "  Disabled: " + numberOfDisabled + "  Bursting: " + numberOfBursting + "  Listening: " + numberOfListening + "  Listen Only: " + numberOfListenOnly + "  Clock Problem: " + numberOfClockProblem + "  Connection Problem: " + numberOfConnError + "  Disconnecting: " + numberOfDisconnecting + " RoutingDisabled " + numberOfRoutingDisabled + " No load stats: " + numberOfNoLoadStats);
            this.nextPeerNodeStatusLogTime = now + 5000L;
        }
    }

    public void changePeerNodeStatus(PeerNode peerNode, int oldPeerNodeStatus, int peerNodeStatus, boolean noLog) {
        this.allPeersStatuses.changePeerNodeStatus(peerNode, oldPeerNodeStatus, peerNodeStatus, noLog);
        if (!peerNode.isOpennet()) {
            this.darknetPeersStatuses.changePeerNodeStatus(peerNode, oldPeerNodeStatus, peerNodeStatus, noLog);
        }
        this.node.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                PeerManager.this.updatePMUserAlert();
            }
        });
    }

    private void addPeerNodeStatus(int pnStatus, PeerNode peerNode, boolean noLog) {
        this.allPeersStatuses.addStatus(pnStatus, peerNode, noLog);
        if (!peerNode.isOpennet()) {
            this.darknetPeersStatuses.addStatus(pnStatus, peerNode, noLog);
        }
    }

    public int getPeerNodeStatusSize(int pnStatus, boolean darknet) {
        if (darknet) {
            return this.darknetPeersStatuses.statusSize(pnStatus);
        }
        return this.allPeersStatuses.statusSize(pnStatus);
    }

    private void removePeerNodeStatus(int pnStatus, PeerNode peerNode, boolean noLog) {
        this.allPeersStatuses.removeStatus(pnStatus, peerNode, noLog);
        if (!peerNode.isOpennet()) {
            this.darknetPeersStatuses.removeStatus(pnStatus, peerNode, noLog);
        }
    }

    public void addPeerNodeRoutingBackoffReason(String peerNodeRoutingBackoffReason, PeerNode peerNode, boolean realTime) {
        if (peerNodeRoutingBackoffReason == null) {
            Logger.error(this, "Impossible backoff reason null on " + peerNode + " realtime=" + realTime, (Throwable)new Exception("error"));
            return;
        }
        PeerStatusTracker<String> peerNodeRoutingBackoffReasons = realTime ? this.peerNodeRoutingBackoffReasonsRT : this.peerNodeRoutingBackoffReasonsBulk;
        peerNodeRoutingBackoffReasons.addStatus(peerNodeRoutingBackoffReason, peerNode, false);
    }

    public String[] getPeerNodeRoutingBackoffReasons(boolean realTime) {
        ArrayList list = new ArrayList();
        PeerStatusTracker<String> peerNodeRoutingBackoffReasons = realTime ? this.peerNodeRoutingBackoffReasonsRT : this.peerNodeRoutingBackoffReasonsBulk;
        peerNodeRoutingBackoffReasons.addStatusList(list);
        return list.toArray(new String[list.size()]);
    }

    public int getPeerNodeRoutingBackoffReasonSize(String peerNodeRoutingBackoffReason, boolean realTime) {
        PeerStatusTracker<String> peerNodeRoutingBackoffReasons = realTime ? this.peerNodeRoutingBackoffReasonsRT : this.peerNodeRoutingBackoffReasonsBulk;
        return peerNodeRoutingBackoffReasons.statusSize(peerNodeRoutingBackoffReason);
    }

    public void removePeerNodeRoutingBackoffReason(String peerNodeRoutingBackoffReason, PeerNode peerNode, boolean realTime) {
        PeerStatusTracker<String> peerNodeRoutingBackoffReasons = realTime ? this.peerNodeRoutingBackoffReasonsRT : this.peerNodeRoutingBackoffReasonsBulk;
        peerNodeRoutingBackoffReasons.removeStatus(peerNodeRoutingBackoffReason, peerNode, false);
    }

    public PeerNodeStatus[] getPeerNodeStatuses(boolean noHeavy) {
        PeerNode[] peers = this.myPeers();
        PeerNodeStatus[] _peerNodeStatuses = new PeerNodeStatus[peers.length];
        int peerCount = peers.length;
        for (int peerIndex = 0; peerIndex < peerCount; ++peerIndex) {
            _peerNodeStatuses[peerIndex] = peers[peerIndex].getStatus(noHeavy);
        }
        return _peerNodeStatuses;
    }

    public DarknetPeerNodeStatus[] getDarknetPeerNodeStatuses(boolean noHeavy) {
        DarknetPeerNode[] peers = this.getDarknetPeers();
        DarknetPeerNodeStatus[] _peerNodeStatuses = new DarknetPeerNodeStatus[peers.length];
        int peerCount = peers.length;
        for (int peerIndex = 0; peerIndex < peerCount; ++peerIndex) {
            _peerNodeStatuses[peerIndex] = (DarknetPeerNodeStatus)peers[peerIndex].getStatus(noHeavy);
        }
        return _peerNodeStatuses;
    }

    public OpennetPeerNodeStatus[] getOpennetPeerNodeStatuses(boolean noHeavy) {
        OpennetPeerNode[] peers = this.getOpennetPeers();
        OpennetPeerNodeStatus[] _peerNodeStatuses = new OpennetPeerNodeStatus[peers.length];
        int peerCount = peers.length;
        for (int peerIndex = 0; peerIndex < peerCount; ++peerIndex) {
            _peerNodeStatuses[peerIndex] = (OpennetPeerNodeStatus)peers[peerIndex].getStatus(noHeavy);
        }
        return _peerNodeStatuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeUpdatePeerNodeRoutableConnectionStats(long now) {
        PeerNode[] peerNodeArray = this;
        synchronized (this) {
            if (now <= this.nextRoutableConnectionStatsUpdateTime) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return;
            }
            this.nextRoutableConnectionStatsUpdateTime = now + routableConnectionStatsUpdateInterval;
            PeerNode[] peerList = this.myPeers;
            // ** MonitorExit[var4_2] (shouldn't be in output)
            if (-1L != this.nextRoutableConnectionStatsUpdateTime) {
                for (PeerNode pn : peerList) {
                    pn.checkRoutableConnectionStatus();
                }
            }
            return;
        }
    }

    public DarknetPeerNode[] getDarknetPeers() {
        PeerNode[] peers = this.myPeers();
        ArrayList<PeerNode> v = new ArrayList<PeerNode>(peers.length);
        for (PeerNode peer : peers) {
            if (!(peer instanceof DarknetPeerNode)) continue;
            v.add(peer);
        }
        return v.toArray(new DarknetPeerNode[v.size()]);
    }

    public List<SeedServerPeerNode> getConnectedSeedServerPeersVector(HashSet<ByteArrayWrapper> exclude) {
        PeerNode[] peers = this.myPeers();
        ArrayList<SeedServerPeerNode> v = new ArrayList<SeedServerPeerNode>(peers.length);
        for (PeerNode p : peers) {
            if (!(p instanceof SeedServerPeerNode)) continue;
            SeedServerPeerNode sspn = (SeedServerPeerNode)p;
            if (exclude != null && exclude.contains(new ByteArrayWrapper(sspn.getPubKeyHash()))) {
                if (!logMINOR) continue;
                Logger.minor(this, "Not including in getConnectedSeedServerPeersVector() as in exclude set: " + sspn.userToString());
                continue;
            }
            if (!sspn.isConnected()) {
                if (!logMINOR) continue;
                Logger.minor(this, "Not including in getConnectedSeedServerPeersVector() as disconnected: " + sspn.userToString());
                continue;
            }
            v.add(sspn);
        }
        return v;
    }

    public List<SeedServerPeerNode> getSeedServerPeersVector() {
        PeerNode[] peers = this.myPeers();
        ArrayList<SeedServerPeerNode> v = new ArrayList<SeedServerPeerNode>(peers.length);
        for (PeerNode peer : peers) {
            if (!(peer instanceof SeedServerPeerNode)) continue;
            v.add((SeedServerPeerNode)peer);
        }
        return v;
    }

    public OpennetPeerNode[] getOpennetPeers() {
        PeerNode[] peers = this.myPeers();
        ArrayList<PeerNode> v = new ArrayList<PeerNode>(peers.length);
        for (PeerNode peer : peers) {
            if (!(peer instanceof OpennetPeerNode)) continue;
            v.add(peer);
        }
        return v.toArray(new OpennetPeerNode[v.size()]);
    }

    public PeerNode[] getOpennetAndSeedServerPeers() {
        PeerNode[] peers = this.myPeers();
        ArrayList<PeerNode> v = new ArrayList<PeerNode>(peers.length);
        for (PeerNode peer : peers) {
            if (peer instanceof OpennetPeerNode) {
                v.add(peer);
                continue;
            }
            if (!(peer instanceof SeedServerPeerNode)) continue;
            v.add(peer);
        }
        return v.toArray(new PeerNode[v.size()]);
    }

    public boolean anyConnectedPeerHasAddress(FreenetInetAddress addr, PeerNode pn) {
        PeerNode[] peers;
        for (PeerNode p : peers = this.myPeers()) {
            if (p == pn || !p.isConnected() || !p.isRealConnection() || p.isDarknet() && !pn.isDarknet() || !p.getPeer().getFreenetAddress().equals(addr)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOpennetPeers() {
        PeerManager peerManager = this;
        synchronized (peerManager) {
            ArrayList<PeerNode> keep = new ArrayList<PeerNode>();
            ArrayList<PeerNode> conn = new ArrayList<PeerNode>();
            for (PeerNode pn : this.myPeers) {
                if (pn instanceof OpennetPeerNode) continue;
                keep.add(pn);
                if (!pn.isConnected()) continue;
                conn.add(pn);
            }
            this.myPeers = keep.toArray(new PeerNode[keep.size()]);
            this.connectedPeers = keep.toArray(new PeerNode[conn.size()]);
        }
        this.updatePMUserAlert();
        this.notifyPeerStatusChangeListeners();
    }

    public PeerNode containsPeer(PeerNode pn) {
        PeerNode[] peers;
        for (PeerNode peer : peers = pn.isOpennet() ? this.getOpennetAndSeedServerPeers() : this.getDarknetPeers()) {
            if (!Arrays.equals(pn.getPubKeyHash(), peer.getPubKeyHash())) continue;
            return peer;
        }
        return null;
    }

    public int countConnectedDarknetPeers() {
        PeerNode[] peers;
        int count = 0;
        for (PeerNode peer : peers = this.myPeers()) {
            if (peer == null || !(peer instanceof DarknetPeerNode) || peer.isOpennet() || !peer.isRoutable()) continue;
            ++count;
        }
        if (logMINOR) {
            Logger.minor(this, "countConnectedDarknetPeers() returning " + count);
        }
        return count;
    }

    public int countConnectedPeers() {
        return this.countConnectedPeers(this.myPeers());
    }

    private int countConnectedPeers(PeerNode[] peers) {
        int count = 0;
        for (PeerNode peer : peers) {
            if (peer == null || !peer.isRoutable()) continue;
            ++count;
        }
        return count;
    }

    public int countAlmostConnectedDarknetPeers() {
        PeerNode[] peers;
        int count = 0;
        for (PeerNode peer : peers = this.myPeers()) {
            if (peer == null || !(peer instanceof DarknetPeerNode) || peer.isOpennet() || !peer.isConnected()) continue;
            ++count;
        }
        return count;
    }

    public int countCompatibleDarknetPeers() {
        PeerNode[] peers;
        int count = 0;
        for (PeerNode peer : peers = this.myPeers()) {
            if (peer == null || !(peer instanceof DarknetPeerNode) || peer.isOpennet() || !peer.isConnected() || !peer.isRoutingCompatible()) continue;
            ++count;
        }
        return count;
    }

    public int countCompatibleRealPeers() {
        PeerNode[] peers;
        int count = 0;
        for (PeerNode peer : peers = this.myPeers()) {
            if (peer == null || !peer.isRealConnection() || !peer.isConnected() || !peer.isRoutingCompatible()) continue;
            ++count;
        }
        return count;
    }

    public int countConnectedOpennetPeers() {
        PeerNode[] peers;
        int count = 0;
        for (PeerNode peer : peers = this.connectedPeers()) {
            if (peer == null || !(peer instanceof OpennetPeerNode) || !peer.isRoutable()) continue;
            ++count;
        }
        return count;
    }

    public int countValidPeers() {
        PeerNode[] peers = this.myPeers();
        int count = 0;
        for (PeerNode peer : peers) {
            if (!peer.isRealConnection() || peer.isDisabled()) continue;
            ++count;
        }
        return count;
    }

    public int countConnectiblePeers() {
        PeerNode[] peers = this.myPeers();
        int count = 0;
        for (PeerNode peer : peers) {
            if (peer.isDisabled() || peer instanceof DarknetPeerNode && ((DarknetPeerNode)peer).isListenOnly()) continue;
            ++count;
        }
        return count;
    }

    public int countSeednodes() {
        int count = 0;
        for (PeerNode peer : this.myPeers()) {
            if (!(peer instanceof SeedServerPeerNode) && !(peer instanceof SeedClientPeerNode)) continue;
            ++count;
        }
        return count;
    }

    public int countBackedOffPeers(boolean realTime) {
        PeerNode[] peers = this.myPeers();
        int count = 0;
        for (PeerNode peer : peers) {
            if (!peer.isRealConnection() || peer.isDisabled() || !peer.isRoutingBackedOff(realTime)) continue;
            ++count;
        }
        return count;
    }

    public PeerNode getByPubKeyHash(byte[] pkHash) {
        PeerNode[] peers;
        for (PeerNode peer : peers = this.myPeers()) {
            if (!Arrays.equals(peer.peerECDSAPubKeyHash, pkHash)) continue;
            return peer;
        }
        return null;
    }

    void incrementSelectionSamples(long now, PeerNode pn) {
        pn.incrementNumberOfSelections(now);
    }

    private void notifyPeerStatusChangeListeners() {
        for (PeerStatusChangeListener l : this.listeners) {
            l.onPeerStatusChange();
            for (PeerNode pn : this.myPeers()) {
                pn.registerPeerNodeStatusChangeListener(l);
            }
        }
    }

    public void addPeerStatusChangeListener(PeerStatusChangeListener listener) {
        this.listeners.add(listener);
        for (PeerNode pn : this.myPeers()) {
            pn.registerPeerNodeStatusChangeListener(listener);
        }
    }

    public void removePeerStatusChangeListener(PeerStatusChangeListener listener) {
        this.listeners.remove(listener);
    }

    synchronized PeerNode[] myPeers() {
        return this.myPeers;
    }

    synchronized PeerNode[] connectedPeers() {
        return this.connectedPeers;
    }

    public int countByStatus(int status) {
        PeerNode[] peers;
        int count = 0;
        for (PeerNode peer : peers = this.myPeers()) {
            if (peer.getPeerNodeStatus() != status) continue;
            ++count;
        }
        return count;
    }

    public boolean isOutdated() {
        int tooNewDarknet = this.getPeerNodeStatusSize(3, true);
        if (tooNewDarknet >= 1) {
            return true;
        }
        int tooNewOpennet = this.getPeerNodeStatusSize(3, false);
        int connections = this.getPeerNodeStatusSize(1, false) + this.getPeerNodeStatusSize(2, false);
        if (tooNewOpennet >= 5) {
            return connections < 5;
        }
        return false;
    }

    static {
        Logger.registerClass(PeerManager.class);
        routableConnectionStatsUpdateInterval = TimeUnit.SECONDS.toMillis(7L);
        MIN_WRITEPEERS_DELAY = TimeUnit.MINUTES.toMillis(5L);
    }

    public static interface PeerStatusChangeListener {
        public void onPeerStatusChange();
    }
}

