/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.crypt.RandomSource;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.DarknetPeerNode;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.PeerNode;
import freenet.node.PeerTooOldException;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.PooledExecutor;

public class RealNodePingTest {
    public static final int DARKNET_PORT1 = 5033;
    public static final int DARKNET_PORT2 = 5034;
    public static final int DARKNET_PORT_END = 5035;
    static final DarknetPeerNode.FRIEND_TRUST trust = DarknetPeerNode.FRIEND_TRUST.LOW;
    static final DarknetPeerNode.FRIEND_VISIBILITY visibility = DarknetPeerNode.FRIEND_VISIBILITY.NO;

    public static void main(String[] args) throws FSParseException, PeerParseException, InterruptedException, ReferenceSignatureVerificationException, NodeInitException, LoggerHook.InvalidThresholdException, PeerTooOldException {
        RandomSource random = NodeStarter.globalTestInit("pingtest", false, Logger.LogLevel.ERROR, "", true);
        PooledExecutor executor = new PooledExecutor();
        Node node1 = NodeStarter.createTestNode(5033, 0, "pingtest", true, (short)18, 0, random, executor, 1000, 65536L, true, false, false, false, false, false, true, 0, false, false, true, false, null);
        Node node2 = NodeStarter.createTestNode(5034, 0, "pingtest", true, (short)18, 0, random, executor, 1000, 65536L, true, false, false, false, false, false, true, 0, false, false, true, false, null);
        node1.connect(node2, trust, visibility);
        node2.connect(node1, trust, visibility);
        node1.start(true);
        node2.start(true);
        PeerNode pn = node1.getPeerNodes()[0];
        int pingID = 0;
        Thread.sleep(20000L);
        while (true) {
            boolean success;
            Logger.error(RealNodePingTest.class, "Sending PING " + pingID);
            try {
                success = pn.ping(pingID);
            }
            catch (NotConnectedException e1) {
                Logger.error(RealNodePingTest.class, "Not connected");
                continue;
            }
            if (success) {
                Logger.error(RealNodePingTest.class, "PING " + pingID + " successful");
            } else {
                Logger.error(RealNodePingTest.class, "PING FAILED: " + pingID);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++pingID;
        }
    }
}

