/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.plugins.helpers1;

import freenet.clients.http.InfoboxNode;
import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.keys.FreenetURI;
import freenet.support.HTMLNode;
import freenet.support.api.HTTPRequest;
import freenet.support.plugins.helpers1.PluginContext;
import java.util.List;

public abstract class WebInterfaceToadlet
extends Toadlet
implements LinkEnabledCallback {
    protected final PluginContext pluginContext;
    private final String _path;

    protected WebInterfaceToadlet(PluginContext pluginContext2, String pluginURL, String pageName) {
        super(pluginContext2.hlsc);
        this.pluginContext = pluginContext2;
        this._path = pluginURL + "/" + pageName;
    }

    @Override
    public String path() {
        return this._path;
    }

    @Override
    public boolean isEnabled(ToadletContext ctx) {
        return true;
    }

    protected String normalizePath(String path) {
        String result = path.substring(this._path.length());
        if (result.isEmpty()) {
            return "/";
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    protected boolean isFormPassword(HTTPRequest req) {
        String passwd = req.getParam("formPassword", null);
        if (passwd == null) {
            passwd = req.getPartAsStringFailsafe("formPassword", 32);
        }
        return passwd != null && passwd.equals(this.pluginContext.clientCore.getFormPassword());
    }

    public HTMLNode createErrorBox(List<String> errors) {
        return this.createErrorBox(errors, null, null, null);
    }

    public HTMLNode createErrorBox(List<String> errors, String path, FreenetURI retryUri, String extraParams) {
        InfoboxNode box = this.pluginContext.pageMaker.getInfobox("infobox-alert", "ERROR");
        HTMLNode errorBox = box.content;
        for (String error : errors) {
            errorBox.addChild("#", error);
            errorBox.addChild("br");
        }
        if (retryUri != null) {
            errorBox.addChild("#", "Retry: ");
            errorBox.addChild(new HTMLNode("a", "href", path + "?key=" + (extraParams == null ? retryUri : retryUri + extraParams), retryUri.toString(false, false)));
        }
        return box.outer;
    }
}

