/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.client.filter.RIFFFilter;
import freenet.client.filter.VP8PacketFilter;
import freenet.l10n.NodeL10n;
import freenet.support.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class WebPFilter
extends RIFFFilter {
    private final int ANIMATION_FLAG = 2;
    private final int XMP_FLAG = 4;
    private final int EXIF_FLAG = 8;
    private final int ALPHA_FLAG = 16;
    private final int ICCP_FLAG = 32;
    private final int ALL_VALID_FLAGS = 62;

    @Override
    protected byte[] getChunkMagicNumber() {
        return new byte[]{87, 69, 66, 80};
    }

    @Override
    protected Object createContext() {
        return new WebPFilterContext();
    }

    @Override
    protected void readFilterChunk(byte[] ID, int size, Object context, DataInputStream input, DataOutputStream output, String charset, Map<String, String> otherParams, String schemeHostAndPort, FilterCallback cb) throws DataFilterException, IOException {
        boolean logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, this.getClass());
        WebPFilterContext ctx = (WebPFilterContext)context;
        if (ID[0] == 86 && ID[1] == 80 && ID[2] == 56 && ID[3] == 32) {
            if (ctx.hasVP8 || ctx.hasVP8L || ctx.hasANIM) {
                throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected VP8 chunk was encountered");
            }
            if (size < 10) {
                throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "The VP8 chunk was too small to be valid");
            }
            output.write(ID);
            if (logDEBUG) {
                Logger.debug(this, "Passing through WebP VP8 block with " + size + " bytes.");
            }
            VP8PacketFilter VP8filter = new VP8PacketFilter(true);
            byte[] buf = new byte[6];
            input.readFully(buf);
            VP8filter.parse(buf, size);
            WebPFilter.writeLittleEndianInt(output, size);
            output.write(buf);
            this.passthroughBytes(input, output, size - buf.length);
            if ((size & 1) != 0) {
                output.writeByte(input.readByte());
            }
            ctx.hasVP8 = true;
        } else {
            if (ID[0] == 86 && ID[1] == 80 && ID[2] == 56 && ID[3] == 76) {
                if (ctx.hasVP8 || ctx.hasVP8L || ctx.hasANIM || ctx.hasALPH) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected VP8L chunk was encountered");
                }
                ctx.hasVP8L = true;
                throw new DataFilterException(WebPFilter.l10n("losslessUnsupportedTitle"), WebPFilter.l10n("losslessUnsupportedTitle"), WebPFilter.l10n("losslessUnsupported"));
            }
            if (ID[0] == 65 && ID[1] == 76 && ID[2] == 80 && ID[3] == 72) {
                if (ctx.hasVP8L || ctx.hasANIM || ctx.hasALPH || !ctx.hasVP8X || (ctx.VP8XFlags & 0x10) == 0) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected ALPH chunk was encountered");
                }
                if (size == 0) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected empty ALPH chunk");
                }
                int flags = input.readUnsignedByte();
                if ((flags & 2) != 0) {
                    throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "WebP alpha channel contains reserved bits");
                }
                if ((flags & 0xC0) != 0) {
                    throw new DataFilterException(WebPFilter.l10n("alphUnsupportedTitle"), WebPFilter.l10n("alphUnsupportedTitle"), WebPFilter.l10n("alphUnsupported"));
                }
                output.write(ID);
                if (logDEBUG) {
                    Logger.debug(this, "Passing through WebP ALPH block with " + size + " bytes.");
                }
                WebPFilter.writeLittleEndianInt(output, size);
                output.writeByte(flags);
                this.passthroughBytes(input, output, size - 1);
                if ((size & 1) != 0) {
                    output.writeByte(input.readByte());
                }
                ctx.hasALPH = true;
            } else {
                if (ID[0] == 65 && ID[1] == 78 && ID[2] == 73 && ID[3] == 77) {
                    if (ctx.hasVP8 || ctx.hasVP8L || ctx.hasANIM) {
                        throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected ANIM chunk was encountered");
                    }
                    ctx.hasANIM = true;
                    throw new DataFilterException(WebPFilter.l10n("animUnsupportedTitle"), WebPFilter.l10n("animUnsupportedTitle"), WebPFilter.l10n("animUnsupported"));
                }
                if (ID[0] == 65 && ID[1] == 78 && ID[2] == 77 && ID[3] == 70) {
                    if ((ctx.VP8XFlags & 2) == 0 || ctx.hasVP8 || ctx.hasVP8L || !ctx.hasANIM) {
                        throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected ANMF chunk was encountered");
                    }
                    ctx.hasANMF = true;
                    throw new DataFilterException(WebPFilter.l10n("animUnsupportedTitle"), WebPFilter.l10n("animUnsupportedTitle"), WebPFilter.l10n("animUnsupported"));
                }
                if (ID[0] == 86 && ID[1] == 80 && ID[2] == 56 && ID[3] == 88) {
                    if (ctx.hasVP8 || ctx.hasVP8L || ctx.hasANIM || ctx.hasVP8X) {
                        throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "Unexpected VP8X chunk was encountered");
                    }
                    ctx.VP8XFlags = WebPFilter.readLittleEndianInt(input);
                    if ((ctx.VP8XFlags & 0xFFFFFFC1) != 0) {
                        throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "VP8X header has reserved flags");
                    }
                    if (size != 10) {
                        throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "VP8X header is too small or too big");
                    }
                    output.write(ID);
                    WebPFilter.writeLittleEndianInt(output, size);
                    ctx.VP8XFlags &= 0xFFFFFFD3;
                    WebPFilter.writeLittleEndianInt(output, ctx.VP8XFlags);
                    ctx.hasVP8X = true;
                    byte[] widthHeight = new byte[6];
                    input.readFully(widthHeight);
                    int width = widthHeight[0] | widthHeight[1] << 8 | widthHeight[2] << 16;
                    int height = widthHeight[3] | widthHeight[4] << 8 | widthHeight[5] << 16;
                    if (++width > 16384 || ++height > 16384) {
                        throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "WebP image size is too big");
                    }
                    output.write(widthHeight);
                } else if (ID[0] == 73 && ID[1] == 67 && ID[2] == 67 && ID[3] == 80) {
                    if (logDEBUG) {
                        Logger.debug(this, "WebP image has ICCP block with " + size + " bytes converted into JUNK chunk.");
                    }
                    this.writeJunkChunk(input, output, size);
                } else if (ID[0] == 69 && ID[1] == 88 && ID[2] == 73 && ID[3] == 70) {
                    if (logDEBUG) {
                        Logger.debug(this, "WebP image has EXIF block with " + size + " bytes converted into JUNK chunk.");
                    }
                    this.writeJunkChunk(input, output, size);
                } else if (ID[0] == 88 && ID[1] == 77 && ID[2] == 80 && ID[3] == 32) {
                    if (logDEBUG) {
                        Logger.debug(this, "WebP image has XMP block with " + size + " bytes converted into JUNK chunk.");
                    }
                    this.writeJunkChunk(input, output, size);
                } else {
                    if (logDEBUG) {
                        Logger.debug(this, "WebP image has Unknown block with " + size + " bytes converted into JUNK chunk.");
                    }
                    this.writeJunkChunk(input, output, size);
                }
            }
        }
    }

    @Override
    protected void EOFCheck(Object context) throws DataFilterException {
        WebPFilterContext ctx = (WebPFilterContext)context;
        if (!(ctx.hasVP8 || ctx.hasVP8L || ctx.hasANMF)) {
            throw new DataFilterException(WebPFilter.l10n("invalidTitle"), WebPFilter.l10n("invalidTitle"), "No image chunk in the WebP file is found");
        }
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("WebPFilter." + key);
    }

    class WebPFilterContext {
        public int VP8XFlags = 0;
        public boolean hasVP8X = false;
        public boolean hasANIM = false;
        public boolean hasANMF = false;
        public boolean hasALPH = false;
        public boolean hasVP8 = false;
        public boolean hasVP8L = false;

        WebPFilterContext() {
        }
    }
}

