/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPrivateKey;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.Global;
import freenet.crypt.PCFBMode;
import freenet.crypt.RandomSource;
import freenet.crypt.SHA256;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.Util;
import freenet.crypt.ciphers.Rijndael;
import freenet.keys.ClientKSK;
import freenet.keys.ClientSSK;
import freenet.keys.ClientSSKBlock;
import freenet.keys.FreenetURI;
import freenet.keys.Key;
import freenet.keys.KeyEncodeException;
import freenet.keys.SSKEncodeException;
import freenet.keys.SSKVerifyException;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.compress.InvalidCompressionCodecException;
import freenet.support.math.MersenneTwister;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Random;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;

public class InsertableClientSSK
extends ClientSSK {
    private static final long serialVersionUID = 1L;
    public final DSAPrivateKey privKey;
    private static boolean logMINOR;

    public InsertableClientSSK(String docName, byte[] pubKeyHash, DSAPublicKey pubKey, DSAPrivateKey privKey, byte[] cryptoKey, byte cryptoAlgorithm) throws MalformedURLException {
        super(docName, pubKeyHash, InsertableClientSSK.getExtraBytes(cryptoAlgorithm), pubKey, cryptoKey);
        if (pubKey == null) {
            throw new NullPointerException();
        }
        this.privKey = privKey;
    }

    protected InsertableClientSSK() {
        this.privKey = null;
    }

    public static InsertableClientSSK create(FreenetURI uri) throws MalformedURLException {
        DSAPrivateKey privKey;
        byte keyType;
        if (uri.getKeyType().equalsIgnoreCase("KSK")) {
            return ClientKSK.create(uri);
        }
        if (uri.getRoutingKey() == null) {
            throw new MalformedURLException("Insertable SSK URIs must have a private key!: " + uri);
        }
        if (uri.getCryptoKey() == null) {
            throw new MalformedURLException("Insertable SSK URIs must have a private key!: " + uri);
        }
        byte[] extra = uri.getExtra();
        if (uri.getKeyType().equals("SSK")) {
            if (extra == null) {
                throw new MalformedURLException("Inserting pre-1010 keys not supported");
            }
            if (extra.length < 5) {
                throw new MalformedURLException("SSK private key ,extra too short");
            }
            if (extra[1] != 1) {
                throw new MalformedURLException("SSK not a private key");
            }
            keyType = extra[2];
            if (keyType != 2) {
                throw new MalformedURLException("Unrecognized crypto type in SSK private key");
            }
        } else {
            throw new MalformedURLException("Not a valid SSK insert URI type: " + uri.getKeyType());
        }
        if (uri.getDocName() == null) {
            throw new MalformedURLException("SSK URIs must have a document name (to avoid ambiguity)");
        }
        DSAGroup g = Global.DSAgroupBigA;
        try {
            privKey = new DSAPrivateKey(new BigInteger(1, uri.getRoutingKey()), g);
        }
        catch (IllegalArgumentException e) {
            Logger.error(InsertableClientSSK.class, "Caught " + e, (Throwable)e);
            throw new MalformedURLException("SSK private key (routing key) is invalid: " + e);
        }
        DSAPublicKey pubKey = new DSAPublicKey(g, privKey);
        byte[] pkHash = pubKey.asBytesHash();
        return new InsertableClientSSK(uri.getDocName(), pkHash, pubKey, privKey, uri.getCryptoKey(), keyType);
    }

    public ClientSSKBlock encode(Bucket sourceData, boolean asMetadata, boolean dontCompress, short alreadyCompressedCodec, long sourceLength, RandomSource r, String compressordescriptor) throws SSKEncodeException, IOException, InvalidCompressionCodecException {
        Rijndael aes;
        byte[] data;
        short compressionAlgo;
        byte[] compressedData;
        try {
            Key.Compressed comp = Key.compress(sourceData, dontCompress, alreadyCompressedCodec, sourceLength, 32768L, 1024, true, compressordescriptor);
            compressedData = comp.compressedData;
            compressionAlgo = comp.compressionAlgorithm;
        }
        catch (KeyEncodeException e) {
            throw new SSKEncodeException(e.getMessage(), e);
        }
        MessageDigest md256 = SHA256.getMessageDigest();
        if (compressedData.length != 1024) {
            if (compressedData.length != 0) {
                md256.update(compressedData);
            }
            byte[] digest = md256.digest();
            MersenneTwister mt = new MersenneTwister(digest);
            data = Arrays.copyOf(compressedData, 1024);
            if (compressedData.length > data.length) {
                throw new RuntimeException("compressedData.length = " + compressedData.length + " but data.length=" + data.length);
            }
            Util.randomBytes((Random)((Object)mt), data, compressedData.length, 1024 - compressedData.length);
        } else {
            data = compressedData;
        }
        byte[] origDataHash = md256.digest(data);
        try {
            aes = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new Error("256/256 Rijndael not supported!");
        }
        aes.initialize(origDataHash);
        PCFBMode pcfb = PCFBMode.create(aes, origDataHash);
        pcfb.blockEncipher(data, 0, data.length);
        byte[] encryptedDataHash = md256.digest(data);
        byte[] headers = new byte[136];
        int x = 0;
        headers[x++] = 0;
        headers[x++] = 1;
        headers[x++] = 0;
        headers[x++] = 2;
        System.arraycopy(this.ehDocname, 0, headers, x, this.ehDocname.length);
        x += this.ehDocname.length;
        byte[] encryptedHeaders = Arrays.copyOf(origDataHash, 36);
        int y = origDataHash.length;
        short len = (short)compressedData.length;
        if (asMetadata) {
            len = (short)(len | 0x8000);
        }
        encryptedHeaders[y++] = (byte)(len >> 8);
        encryptedHeaders[y++] = (byte)len;
        encryptedHeaders[y++] = (byte)(compressionAlgo >> 8);
        encryptedHeaders[y++] = (byte)compressionAlgo;
        if (encryptedHeaders.length != y) {
            throw new IllegalStateException("Have more bytes to generate encoding SSK");
        }
        aes.initialize(this.cryptoKey);
        pcfb.reset(this.ehDocname);
        pcfb.blockEncipher(encryptedHeaders, 0, encryptedHeaders.length);
        System.arraycopy(encryptedHeaders, 0, headers, x, encryptedHeaders.length);
        md256.update(headers, 0, x += encryptedHeaders.length);
        md256.update(encryptedDataHash);
        byte[] overallHash = md256.digest();
        DSASigner dsa = new DSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        dsa.init(true, (CipherParameters)new DSAPrivateKeyParameters(this.privKey.getX(), Global.getDSAgroupBigAParameters()));
        BigInteger[] sig = dsa.generateSignature(Global.truncateHash(overallHash));
        byte[] rBuf = this.truncate(sig[0].toByteArray(), 32);
        byte[] sBuf = this.truncate(sig[1].toByteArray(), 32);
        System.arraycopy(rBuf, 0, headers, x, rBuf.length);
        System.arraycopy(sBuf, 0, headers, x += rBuf.length, sBuf.length);
        if ((x += sBuf.length) != 136) {
            throw new IllegalStateException("Too long");
        }
        try {
            return new ClientSSKBlock(data, headers, this, !logMINOR);
        }
        catch (SSKVerifyException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Impossible encoding error"))).initCause(e));
        }
    }

    private byte[] truncate(byte[] bs, int len) {
        if (bs.length == len) {
            return bs;
        }
        if (bs.length < len) {
            byte[] buf = new byte[len];
            System.arraycopy(bs, 0, buf, len - bs.length, bs.length);
            return buf;
        }
        for (int i = 0; i < bs.length - len; ++i) {
            if (bs[i] == 0) continue;
            throw new IllegalStateException("Cannot truncate");
        }
        return Arrays.copyOfRange(bs, bs.length - len, bs.length);
    }

    public static InsertableClientSSK createRandom(RandomSource r, String docName) {
        byte[] ckey = new byte[32];
        r.nextBytes(ckey);
        DSAGroup g = Global.DSAgroupBigA;
        DSAPrivateKey privKey = new DSAPrivateKey(g, r);
        DSAPublicKey pubKey = new DSAPublicKey(g, privKey);
        try {
            byte[] pkHash = SHA256.digest(pubKey.asBytes());
            return new InsertableClientSSK(docName, pkHash, pubKey, privKey, ckey, 2);
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    public FreenetURI getInsertURI() {
        return new FreenetURI("SSK", this.docName, this.privKey.getX().toByteArray(), this.cryptoKey, this.getInsertExtraBytes());
    }

    private byte[] getInsertExtraBytes() {
        byte[] extra = this.getExtraBytes();
        extra[1] = 1;
        return extra;
    }

    public DSAGroup getCryptoGroup() {
        return Global.DSAgroupBigA;
    }

    static {
        Logger.registerClass(InsertableClientSSK.class);
    }
}

