/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.config.EnumerableOptionCallback;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.PersistentConfig;
import freenet.config.SubConfig;
import freenet.l10n.NodeL10n;
import freenet.node.DarknetPeerNode;
import freenet.node.Node;
import freenet.node.SecurityLevelListener;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.api.StringCallback;
import java.util.ArrayList;

public class SecurityLevels {
    private final Node node;
    NETWORK_THREAT_LEVEL networkThreatLevel;
    FRIENDS_THREAT_LEVEL friendsThreatLevel;
    PHYSICAL_THREAT_LEVEL physicalThreatLevel;
    private MyCallback<NETWORK_THREAT_LEVEL> networkThreatLevelCallback;
    private MyCallback<PHYSICAL_THREAT_LEVEL> physicalThreatLevelCallback;

    public SecurityLevels(Node node, PersistentConfig config) {
        this.node = node;
        SubConfig myConfig = config.createSubConfig("security-levels");
        int sortOrder = 0;
        this.networkThreatLevelCallback = new MyCallback<NETWORK_THREAT_LEVEL>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String get() {
                SecurityLevels securityLevels = SecurityLevels.this;
                synchronized (securityLevels) {
                    return SecurityLevels.this.networkThreatLevel.name();
                }
            }

            @Override
            public String[] getPossibleValues() {
                NETWORK_THREAT_LEVEL[] values = NETWORK_THREAT_LEVEL.values();
                String[] names = new String[values.length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = values[i].name();
                }
                return names;
            }

            @Override
            protected NETWORK_THREAT_LEVEL getValue() {
                return SecurityLevels.this.networkThreatLevel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void setValue(String val) throws InvalidConfigValueException {
                NETWORK_THREAT_LEVEL newValue = SecurityLevels.parseNetworkThreatLevel(val);
                if (newValue == null) {
                    throw new InvalidConfigValueException("Invalid value for network threat level: " + val);
                }
                SecurityLevels securityLevels = SecurityLevels.this;
                synchronized (securityLevels) {
                    SecurityLevels.this.networkThreatLevel = newValue;
                }
            }
        };
        myConfig.register("networkThreatLevel", "HIGH", sortOrder++, false, true, "SecurityLevels.networkThreatLevelShort", "SecurityLevels.networkThreatLevel", this.networkThreatLevelCallback);
        NETWORK_THREAT_LEVEL netLevel = NETWORK_THREAT_LEVEL.valueOf(myConfig.getString("networkThreatLevel"));
        if (myConfig.getRawOption("networkThreatLevel") != null) {
            this.networkThreatLevel = netLevel;
        } else {
            this.setThreatLevel(netLevel);
        }
        String s = myConfig.getRawOption("friendsThreatLevel");
        this.friendsThreatLevel = s != null ? SecurityLevels.parseFriendsThreatLevel(s) : null;
        this.physicalThreatLevelCallback = new MyCallback<PHYSICAL_THREAT_LEVEL>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String get() {
                SecurityLevels securityLevels = SecurityLevels.this;
                synchronized (securityLevels) {
                    return SecurityLevels.this.physicalThreatLevel.name();
                }
            }

            @Override
            public String[] getPossibleValues() {
                PHYSICAL_THREAT_LEVEL[] values = PHYSICAL_THREAT_LEVEL.values();
                String[] names = new String[values.length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = values[i].name();
                }
                return names;
            }

            @Override
            protected PHYSICAL_THREAT_LEVEL getValue() {
                return SecurityLevels.this.physicalThreatLevel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void setValue(String val) throws InvalidConfigValueException {
                PHYSICAL_THREAT_LEVEL newValue = PHYSICAL_THREAT_LEVEL.valueOf(val);
                if (newValue != null) {
                    throw new InvalidConfigValueException("Invalid value for physical threat level: " + val);
                }
                SecurityLevels securityLevels = SecurityLevels.this;
                synchronized (securityLevels) {
                    SecurityLevels.this.physicalThreatLevel = newValue;
                }
            }
        };
        myConfig.register("physicalThreatLevel", "NORMAL", sortOrder++, false, true, "SecurityLevels.physicalThreatLevelShort", "SecurityLevels.physicalThreatLevel", this.physicalThreatLevelCallback);
        PHYSICAL_THREAT_LEVEL physLevel = PHYSICAL_THREAT_LEVEL.valueOf(myConfig.getString("physicalThreatLevel"));
        if (myConfig.getRawOption("physicalThreatLevel") != null) {
            this.physicalThreatLevel = physLevel;
        } else {
            this.setThreatLevel(physLevel);
        }
        myConfig.finishedInitialization();
    }

    public synchronized void addNetworkThreatLevelListener(SecurityLevelListener<NETWORK_THREAT_LEVEL> listener) {
        this.networkThreatLevelCallback.addListener(listener);
    }

    public synchronized void addPhysicalThreatLevelListener(SecurityLevelListener<PHYSICAL_THREAT_LEVEL> listener) {
        this.physicalThreatLevelCallback.addListener(listener);
    }

    public NETWORK_THREAT_LEVEL getNetworkThreatLevel() {
        return this.networkThreatLevel;
    }

    public PHYSICAL_THREAT_LEVEL getPhysicalThreatLevel() {
        return this.physicalThreatLevel;
    }

    public static NETWORK_THREAT_LEVEL parseNetworkThreatLevel(String arg) {
        try {
            return NETWORK_THREAT_LEVEL.valueOf(arg);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static FRIENDS_THREAT_LEVEL parseFriendsThreatLevel(String arg) {
        try {
            return FRIENDS_THREAT_LEVEL.valueOf(arg);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static PHYSICAL_THREAT_LEVEL parsePhysicalThreatLevel(String arg) {
        try {
            return PHYSICAL_THREAT_LEVEL.valueOf(arg);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public HTMLNode getConfirmWarning(NETWORK_THREAT_LEVEL newThreatLevel, String checkboxName) {
        if (newThreatLevel == this.networkThreatLevel) {
            return null;
        }
        HTMLNode parent = new HTMLNode("div");
        if (newThreatLevel == NETWORK_THREAT_LEVEL.HIGH && this.networkThreatLevel != NETWORK_THREAT_LEVEL.MAXIMUM || newThreatLevel == NETWORK_THREAT_LEVEL.MAXIMUM) {
            if (this.node.getPeers().getDarknetPeers().length == 0) {
                parent.addChild("p", this.l10n("noFriendsWarning"));
                if (newThreatLevel == NETWORK_THREAT_LEVEL.MAXIMUM) {
                    HTMLNode p = parent.addChild("p");
                    NodeL10n.getBase().addL10nSubstitution(p, "SecurityLevels.maximumNetworkThreatLevelWarning", new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
                }
                parent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", checkboxName, "off"}, this.l10n("noFriendsCheckbox"));
                return parent;
            }
            if (this.node.getPeers().countConnectedDarknetPeers() == 0) {
                parent.addChild("p", this.l10n("noConnectedFriendsWarning", "added", Integer.toString(this.node.getPeers().getDarknetPeers().length)));
                if (newThreatLevel == NETWORK_THREAT_LEVEL.MAXIMUM) {
                    HTMLNode p = parent.addChild("p");
                    NodeL10n.getBase().addL10nSubstitution(p, "SecurityLevels.maximumNetworkThreatLevelWarning", new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
                }
                parent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", checkboxName, "off"}, this.l10n("noConnectedFriendsCheckbox"));
                return parent;
            }
            if (this.node.getPeers().countConnectedDarknetPeers() < 10) {
                parent.addChild("p", this.l10n("fewConnectedFriendsWarning", new String[]{"connected", "added"}, new String[]{Integer.toString(this.node.getPeers().countConnectedDarknetPeers()), Integer.toString(this.node.getPeers().getDarknetPeers().length)}));
                if (newThreatLevel == NETWORK_THREAT_LEVEL.MAXIMUM) {
                    HTMLNode p = parent.addChild("p");
                    NodeL10n.getBase().addL10nSubstitution(p, "SecurityLevels.maximumNetworkThreatLevelWarning", new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
                }
                parent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", checkboxName, "off"}, this.l10n("fewConnectedFriendsCheckbox"));
                return parent;
            }
        } else if (newThreatLevel == NETWORK_THREAT_LEVEL.LOW) {
            parent.addChild("p", this.l10n("networkThreatLevelLowWarning"));
            parent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", checkboxName, "off"}, this.l10n("networkThreatLevelLowCheckbox"));
            return parent;
        }
        if (newThreatLevel == NETWORK_THREAT_LEVEL.MAXIMUM) {
            HTMLNode p = parent.addChild("p");
            NodeL10n.getBase().addL10nSubstitution(p, "SecurityLevels.maximumNetworkThreatLevelWarning", new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
            p.addChild("#", " ");
            NodeL10n.getBase().addL10nSubstitution(p, "SecurityLevels.maxSecurityYouNeedFriends", new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
            parent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", checkboxName, "off"}, this.l10n("maximumNetworkThreatLevelCheckbox"));
            return parent;
        }
        return null;
    }

    private String l10n(String string) {
        return NodeL10n.getBase().getString("SecurityLevels." + string);
    }

    private String l10n(String string, String pattern, String value) {
        return NodeL10n.getBase().getString("SecurityLevels." + string, pattern, value);
    }

    private String l10n(String string, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("SecurityLevels." + string, patterns, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreatLevel(NETWORK_THREAT_LEVEL newThreatLevel) {
        NETWORK_THREAT_LEVEL oldLevel;
        if (newThreatLevel == null) {
            throw new NullPointerException();
        }
        SecurityLevels securityLevels = this;
        synchronized (securityLevels) {
            if (this.networkThreatLevel == newThreatLevel) {
                return;
            }
            oldLevel = this.networkThreatLevel;
            this.networkThreatLevel = newThreatLevel;
        }
        this.networkThreatLevelCallback.onSet(oldLevel, newThreatLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreatLevel(PHYSICAL_THREAT_LEVEL newThreatLevel) {
        PHYSICAL_THREAT_LEVEL oldLevel;
        if (newThreatLevel == null) {
            throw new NullPointerException();
        }
        SecurityLevels securityLevels = this;
        synchronized (securityLevels) {
            if (this.physicalThreatLevel == newThreatLevel) {
                return;
            }
            oldLevel = this.physicalThreatLevel;
            this.physicalThreatLevel = newThreatLevel;
        }
        this.physicalThreatLevelCallback.onSet(oldLevel, newThreatLevel);
    }

    public void resetPhysicalThreatLevel(PHYSICAL_THREAT_LEVEL level) {
        this.physicalThreatLevel = level;
    }

    public static String localisedName(NETWORK_THREAT_LEVEL newThreatLevel) {
        return NodeL10n.getBase().getString("SecurityLevels.networkThreatLevel.name." + newThreatLevel.name());
    }

    public static String localisedName(PHYSICAL_THREAT_LEVEL newPhysicalLevel) {
        return NodeL10n.getBase().getString("SecurityLevels.physicalThreatLevel.name." + newPhysicalLevel.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DarknetPeerNode.FRIEND_TRUST getDefaultFriendTrust() {
        SecurityLevels securityLevels = this;
        synchronized (securityLevels) {
            if (this.friendsThreatLevel == null) {
                Logger.error(this, "Asking for default friend trust yet we have no friend security level!");
                return DarknetPeerNode.FRIEND_TRUST.NORMAL;
            }
            if (this.friendsThreatLevel == FRIENDS_THREAT_LEVEL.HIGH) {
                return DarknetPeerNode.FRIEND_TRUST.LOW;
            }
            if (this.friendsThreatLevel == FRIENDS_THREAT_LEVEL.NORMAL) {
                return DarknetPeerNode.FRIEND_TRUST.NORMAL;
            }
            return DarknetPeerNode.FRIEND_TRUST.HIGH;
        }
    }

    private abstract class MyCallback<T>
    extends StringCallback
    implements EnumerableOptionCallback {
        private final ArrayList<SecurityLevelListener<T>> listeners = new ArrayList();

        MyCallback() {
        }

        public void addListener(SecurityLevelListener<T> listener) {
            if (this.listeners.contains(listener)) {
                Logger.error(this, "Already have listener " + listener + " in " + this);
                return;
            }
            this.listeners.add(listener);
        }

        @Override
        public void set(String val) throws InvalidConfigValueException, NodeNeedRestartException {
            T oldLevel = this.getValue();
            this.setValue(val);
            T newLevel = this.getValue();
            this.onSet(oldLevel, newLevel);
        }

        void onSet(T oldLevel, T newLevel) {
            for (SecurityLevelListener<T> listener : this.listeners) {
                listener.onChange(oldLevel, newLevel);
            }
        }

        protected abstract void setValue(String var1) throws InvalidConfigValueException;

        protected abstract T getValue();
    }

    public static enum PHYSICAL_THREAT_LEVEL {
        LOW,
        NORMAL,
        HIGH,
        MAXIMUM;

    }

    public static enum FRIENDS_THREAT_LEVEL {
        LOW,
        NORMAL,
        HIGH;

    }

    public static enum NETWORK_THREAT_LEVEL {
        LOW,
        NORMAL,
        HIGH,
        MAXIMUM;


        public static final NETWORK_THREAT_LEVEL[] getOpennetValues() {
            return new NETWORK_THREAT_LEVEL[]{LOW, NORMAL};
        }

        public static final NETWORK_THREAT_LEVEL[] getDarknetValues() {
            return new NETWORK_THREAT_LEVEL[]{HIGH, MAXIMUM};
        }
    }
}

