/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.PluginInfoMessage;
import freenet.clients.fcp.ProtocolErrorMessage;
import freenet.node.Node;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.support.SimpleFieldSet;

public class ReloadPlugin
extends FCPMessage {
    static final String NAME = "ReloadPlugin";
    private final String identifier;
    private final String plugname;
    private final int maxWaitTime;
    private final boolean purge;
    private final boolean store;

    public ReloadPlugin(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "Must contain an Identifier field", null, false);
        }
        this.plugname = fs.get("PluginName");
        if (this.plugname == null) {
            throw new MessageInvalidException(5, "Must contain a PluginName field", this.identifier, false);
        }
        this.maxWaitTime = fs.getInt("MaxWaitTime", 0);
        this.purge = fs.getBoolean("Purge", false);
        this.store = fs.getBoolean("Store", false);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(final FCPConnectionHandler handler, final Node node) throws MessageInvalidException {
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "LoadPlugin requires full access", this.identifier, false);
        }
        node.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                PluginInfoWrapper pi = node.getPluginManager().getPluginInfo(ReloadPlugin.this.plugname);
                if (pi == null) {
                    handler.send(new ProtocolErrorMessage(32, false, "Plugin '" + ReloadPlugin.this.plugname + "' does not exist or is not a FCP plugin", ReloadPlugin.this.identifier, false));
                } else {
                    String source = pi.getFilename();
                    pi.stopPlugin(node.getPluginManager(), ReloadPlugin.this.maxWaitTime, true);
                    if (ReloadPlugin.this.purge) {
                        node.getPluginManager().removeCachedCopy(pi.getFilename());
                    }
                    if ((pi = node.getPluginManager().startPluginAuto(source, ReloadPlugin.this.store)) == null) {
                        handler.send(new ProtocolErrorMessage(32, false, "Plugin '" + ReloadPlugin.this.plugname + "' does not exist or is not a FCP plugin", ReloadPlugin.this.identifier, false));
                    } else {
                        handler.send(new PluginInfoMessage(pi, ReloadPlugin.this.identifier, true));
                    }
                }
            }
        }, "Reload plugin");
    }
}

