/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.DefaultMIMETypes;
import freenet.client.HighLevelSimpleClient;
import freenet.client.filter.ContentFilter;
import freenet.client.filter.FilterOperation;
import freenet.client.filter.UnsafeContentTypeException;
import freenet.clients.http.BadRequestException;
import freenet.clients.http.HTTPRequestImpl;
import freenet.clients.http.InfoboxNode;
import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.NodeL10n;
import freenet.node.NodeClientCore;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.api.Bucket;
import freenet.support.api.HTTPRequest;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;

public class ContentFilterToadlet
extends Toadlet
implements LinkEnabledCallback {
    public static final String PATH = "/filterfile/";
    private final NodeClientCore core;

    public ContentFilterToadlet(HighLevelSimpleClient client, NodeClientCore clientCore) {
        super(client);
        this.core = clientCore;
    }

    @Override
    public String path() {
        return PATH;
    }

    @Override
    public boolean isEnabled(ToadletContext ctx) {
        if (ctx == null) {
            return false;
        }
        boolean fullAccess = !this.container.publicGatewayMode() || ctx.isAllowedFullAccess();
        return ctx.isAdvancedModeEnabled() && fullAccess;
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        if (this.container.publicGatewayMode() && !ctx.isAllowedFullAccess()) {
            this.sendUnauthorizedPage(ctx);
            return;
        }
        PageMaker pageMaker = ctx.getPageMaker();
        PageNode page = pageMaker.getPageNode(ContentFilterToadlet.l10n("pageTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        contentNode.addChild(ctx.getAlertManager().createSummary());
        contentNode.addChild(this.createContent(pageMaker, ctx));
        this.writeHTMLReply(ctx, 200, "OK", null, pageNode.generate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        block16: {
            if (this.container.publicGatewayMode() && !ctx.isAllowedFullAccess()) {
                this.sendUnauthorizedPage(ctx);
                return;
            }
            try {
                if (request.isPartSet("filter-local")) {
                    try {
                        FilterOperation filterOperation = this.getFilterOperation(request);
                        ResultHandling resultHandling = this.getResultHandling(request);
                        String mimeType = request.getPartAsStringFailsafe("mime-type", 100);
                        String location = "/filter-browse/?filter-operation=" + (Object)((Object)filterOperation) + "&result-handling=" + (Object)((Object)resultHandling) + "&mime-type=" + mimeType;
                        MultiValueTable<String, String> responseHeaders = MultiValueTable.from("Location", location);
                        ctx.sendReplyHeaders(302, "Found", responseHeaders, null, 0L);
                        break block16;
                    }
                    catch (BadRequestException e) {
                        String invalidPart = e.getInvalidRequestPart();
                        if ("filter-operation".equals(invalidPart)) {
                            this.writeBadRequestError(ContentFilterToadlet.l10n("errorMustSpecifyFilterOperationTitle"), ContentFilterToadlet.l10n("errorMustSpecifyFilterOperation"), ctx, true);
                        } else if ("result-handling".equals(invalidPart)) {
                            this.writeBadRequestError(ContentFilterToadlet.l10n("errorMustSpecifyResultHandlingTitle"), ContentFilterToadlet.l10n("errorMustSpecifyResultHandling"), ctx, true);
                        } else {
                            this.writeBadRequestError(ContentFilterToadlet.l10n("errorBadRequestTitle"), ContentFilterToadlet.l10n("errorBadRequest"), ctx, true);
                        }
                        request.freeParts();
                        return;
                    }
                }
                if (request.isPartSet("select-file")) {
                    this.handleFilterRequest(request, ctx, this.core, true);
                } else if (request.isPartSet("filter-upload")) {
                    this.handleFilterRequest(request, ctx, this.core, false);
                } else {
                    this.handleMethodGET(uri, new HTTPRequestImpl(uri, "GET"), ctx);
                }
            }
            finally {
                request.freeParts();
            }
        }
    }

    private HTMLNode createContent(PageMaker pageMaker, ToadletContext ctx) {
        InfoboxNode infobox = pageMaker.getInfobox(ContentFilterToadlet.l10n("filterFile"), "filter-file", true);
        HTMLNode filterBox = infobox.outer;
        HTMLNode filterContent = infobox.content;
        HTMLNode filterForm = ctx.addFormChild(filterContent, PATH, "filterForm");
        filterForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "filter-operation", FilterOperation.BOTH.toString()});
        filterForm.addChild("input", new String[]{"type", "name", "value", "id"}, new String[]{"radio", "result-handling", ResultHandling.DISPLAY.toString(), "result-handling-display"});
        filterForm.addChild("label", new String[]{"for"}, new String[]{"result-handling-display"}, ContentFilterToadlet.l10n("displayResultLabel"));
        filterForm.addChild("br");
        filterForm.addChild("input", new String[]{"type", "name", "value", "id"}, new String[]{"radio", "result-handling", ResultHandling.SAVE.toString(), "result-handling-save"});
        filterForm.addChild("label", new String[]{"for"}, new String[]{"result-handling-save"}, ContentFilterToadlet.l10n("saveResultLabel"));
        filterForm.addChild("br");
        filterForm.addChild("br");
        filterForm.addChild("#", ContentFilterToadlet.l10n("mimeTypeLabel") + ": ");
        filterForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"text", "mime-type", ""});
        filterForm.addChild("br");
        filterForm.addChild("#", ContentFilterToadlet.l10n("mimeTypeText"));
        filterForm.addChild("br");
        filterForm.addChild("br");
        if (ctx.isAllowedFullAccess()) {
            filterForm.addChild("#", ContentFilterToadlet.l10n("filterFileBrowseLabel") + ": ");
            filterForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "filter-local", ContentFilterToadlet.l10n("filterFileBrowseButton") + "..."});
            filterForm.addChild("br");
        }
        filterForm.addChild("#", ContentFilterToadlet.l10n("filterFileUploadLabel") + ": ");
        filterForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"file", "filename", ""});
        filterForm.addChild("#", " \u00a0 ");
        filterForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "filter-upload", ContentFilterToadlet.l10n("filterFileFilterLabel")});
        filterForm.addChild("#", " \u00a0 ");
        return filterBox;
    }

    private void writeBadRequestError(String header, String message, ToadletContext context, boolean returnToFilterPage) throws ToadletContextClosedException, IOException {
        PageMaker pageMaker = context.getPageMaker();
        PageNode page = pageMaker.getPageNode(header, context);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (context.isAllowedFullAccess()) {
            contentNode.addChild(context.getAlertManager().createSummary());
        }
        HTMLNode infoboxContent = pageMaker.getInfobox("infobox-error", header, contentNode, "filter-error", false);
        infoboxContent.addChild("#", message);
        if (returnToFilterPage) {
            NodeL10n.getBase().addL10nSubstitution(infoboxContent.addChild("div"), "ContentFilterToadlet.tryAgainFilterFilePage", new String[]{"link"}, new HTMLNode[]{HTMLNode.link(PATH)});
        }
        this.writeHTMLReply(context, 400, "Bad request", pageNode.generate());
    }

    private void handleFilterRequest(HTTPRequest request, ToadletContext ctx, NodeClientCore core, boolean localFile) throws ToadletContextClosedException, IOException {
        try {
            Bucket bucket;
            Object file;
            String filename;
            FilterOperation filterOperation = this.getFilterOperation(request);
            ResultHandling resultHandling = this.getResultHandling(request);
            String mimeType = request.getPartAsStringFailsafe("mime-type", 100);
            if (localFile) {
                filename = request.getPartAsStringFailsafe("filename", 0x100000);
                if (mimeType.isEmpty()) {
                    mimeType = DefaultMIMETypes.guessMIMEType(filename, false);
                }
                file = new File(filename);
                bucket = new FileBucket((File)file, true, false, false, false);
            } else {
                file = request.getUploadedFile("filename");
                if (file == null) {
                    throw new BadRequestException("filename");
                }
                filename = file.getFilename();
                if (mimeType.isEmpty()) {
                    mimeType = file.getContentType();
                }
                bucket = file.getData();
            }
            if (filename.isEmpty()) {
                throw new BadRequestException("filename");
            }
            String resultFilename = this.makeResultFilename(filename, mimeType);
            try {
                this.handleFilter(bucket, mimeType, filterOperation, resultHandling, resultFilename, ctx, core);
            }
            catch (FileNotFoundException e) {
                this.writeBadRequestError(ContentFilterToadlet.l10n("errorNoFileOrCannotReadTitle"), ContentFilterToadlet.l10n("errorNoFileOrCannotRead", "file", filename), ctx, true);
            }
        }
        catch (BadRequestException e) {
            String invalidPart = e.getInvalidRequestPart();
            if ("filter-operation".equals(invalidPart)) {
                this.writeBadRequestError(ContentFilterToadlet.l10n("errorMustSpecifyFilterOperationTitle"), ContentFilterToadlet.l10n("errorMustSpecifyFilterOperation"), ctx, true);
            }
            if ("result-handling".equals(invalidPart)) {
                this.writeBadRequestError(ContentFilterToadlet.l10n("errorMustSpecifyResultHandlingTitle"), ContentFilterToadlet.l10n("errorMustSpecifyResultHandling"), ctx, true);
            }
            if ("filename".equals(invalidPart)) {
                this.writeBadRequestError(ContentFilterToadlet.l10n("errorNoFileSelectedTitle"), ContentFilterToadlet.l10n("errorNoFileSelected"), ctx, true);
            }
            this.writeBadRequestError(ContentFilterToadlet.l10n("errorBadRequestTitle"), ContentFilterToadlet.l10n("errorBadRequest"), ctx, true);
        }
    }

    private FilterOperation getFilterOperation(HTTPRequest request) throws BadRequestException {
        String s = request.getPartAsStringFailsafe("filter-operation", 100);
        try {
            return FilterOperation.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("filter-operation", e);
        }
    }

    private ResultHandling getResultHandling(HTTPRequest request) throws BadRequestException {
        String s = request.getPartAsStringFailsafe("result-handling", 100);
        try {
            return ResultHandling.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("result-handling", e);
        }
    }

    private String makeResultFilename(String originalFilename, String mimeType) {
        int p = originalFilename.indexOf(46, 1);
        String filteredFilename = p > 0 ? originalFilename.substring(0, p) + ".filtered" + originalFilename.substring(p) : originalFilename + ".filtered";
        filteredFilename = FileUtil.sanitize(filteredFilename, mimeType);
        return filteredFilename;
    }

    private void handleFilter(Bucket data, String mimeType, FilterOperation operation, ResultHandling resultHandling, String resultFilename, ToadletContext ctx, NodeClientCore core) throws ToadletContextClosedException, IOException, BadRequestException {
        RandomAccessBucket resultBucket = ctx.getBucketFactory().makeBucket(-1L);
        String resultMimeType = null;
        boolean unsafe = false;
        try {
            ContentFilter.FilterStatus status = this.applyFilter(data, resultBucket, mimeType, operation, core);
            resultMimeType = status.mimeType;
        }
        catch (UnsafeContentTypeException e) {
            unsafe = true;
        }
        catch (IOException e) {
            Logger.error(this, "IO error running content filter", (Throwable)e);
            throw e;
        }
        if (unsafe) {
            this.sendErrorPage(ctx, 200, ContentFilterToadlet.l10n("errorUnsafeContentTitle"), ContentFilterToadlet.l10n("errorUnsafeContent"));
        } else if (resultHandling == ResultHandling.DISPLAY) {
            ctx.sendReplyHeaders(200, "OK", null, resultMimeType, resultBucket.size());
            ctx.writeData(resultBucket);
        } else if (resultHandling == ResultHandling.SAVE) {
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
            headers.put("Content-Disposition", "attachment; filename=\"" + resultFilename + '\"');
            headers.put("Cache-Control", "private");
            headers.put("Content-Transfer-Encoding", "binary");
            ctx.sendReplyHeaders(200, "OK", headers, "application/force-download", resultBucket.size());
            ctx.writeData(resultBucket);
        } else {
            throw new BadRequestException("result-handling");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentFilter.FilterStatus applyFilter(Bucket input, Bucket output, String mimeType, FilterOperation operation, NodeClientCore core) throws UnsafeContentTypeException, IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = input.getInputStream();
            outputStream = output.getOutputStream();
            ContentFilter.FilterStatus filterStatus = this.applyFilter(inputStream, outputStream, mimeType, operation, core);
            return filterStatus;
        }
        finally {
            Closer.close(inputStream);
            Closer.close(outputStream);
        }
    }

    private ContentFilter.FilterStatus applyFilter(InputStream input, OutputStream output, String mimeType, FilterOperation operation, NodeClientCore core) throws UnsafeContentTypeException, IOException {
        URI fakeUri;
        try {
            fakeUri = new URI("http://127.0.0.1:8888/");
        }
        catch (URISyntaxException e) {
            Logger.error(ContentFilterToadlet.class, "Inexplicable URI error", (Throwable)e);
            return null;
        }
        return ContentFilter.filter(input, output, mimeType, fakeUri, null, null, null, null, core.getLinkFilterExceptionProvider());
    }

    static String l10n(String key) {
        return NodeL10n.getBase().getString("ContentFilterToadlet." + key);
    }

    static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("ContentFilterToadlet." + key, pattern, value);
    }

    public static enum ResultHandling {
        DISPLAY,
        SAVE;

    }
}

