/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.NodeL10n;
import freenet.node.NodeClientCore;
import freenet.support.HTMLNode;
import freenet.support.SizeUtil;
import freenet.support.api.HTTPRequest;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;

public abstract class LocalFileBrowserToadlet
extends Toadlet {
    protected final NodeClientCore core;
    private static final int MAX_POST_SIZE = 0x100000;
    private File lastSuccessful;
    public static final String selectDir = "select-dir";
    public static final String selectFile = "select-file";
    public static final String changeDir = "change-dir";

    public LocalFileBrowserToadlet(NodeClientCore core, HighLevelSimpleClient highLevelSimpleClient) {
        super(highLevelSimpleClient);
        this.core = core;
    }

    @Override
    public abstract String path();

    protected abstract String postTo();

    protected String filenameField() {
        return "filename";
    }

    protected abstract boolean allowedDir(File var1);

    protected abstract Hashtable<String, String> persistenceFields(Hashtable<String, String> var1);

    protected abstract String startingDir();

    protected String defaultUploadDir() {
        if (this.core.getAllowedUploadDirs().length == 1 && this.core.getAllowedUploadDirs()[0].toString().equals("all") || this.core.getAllowedUploadDirs().length == 0) {
            return System.getProperty("user.home");
        }
        return this.core.getAllowedUploadDirs()[0].getAbsolutePath();
    }

    protected String defaultDownloadDir() {
        if (this.core.getAllowedDownloadDirs().length == 1 && this.core.getAllowedDownloadDirs()[0].toString().equals("all") || this.core.getAllowedDownloadDirs().length == 0) {
            return this.core.getDownloadsDir().getAbsolutePath();
        }
        return this.core.getAllowedDownloadDirs()[0].getAbsolutePath();
    }

    protected void createSelectDirectoryButton(HTMLNode node, String absolutePath, HTMLNode persistence) {
        node.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", selectDir, this.l10n("insert")});
        node.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", this.filenameField(), absolutePath});
        node.addChild(persistence);
    }

    protected void createSelectFileButton(HTMLNode node, String absolutePath, HTMLNode persistence) {
        node.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", selectFile, this.l10n("insert")});
        node.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", this.filenameField(), absolutePath});
        node.addChild(persistence);
    }

    private void createChangeDirButton(HTMLNode node, String buttonText, String path, HTMLNode persistence) {
        node.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", changeDir, buttonText});
        node.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "path", path});
        node.addChild(persistence);
    }

    private Hashtable<String, String> readGET(HTTPRequest request) {
        Hashtable<String, String> set = new Hashtable<String, String>();
        for (String key : request.getParameterNames()) {
            set.put(key, request.getParam(key));
        }
        return set;
    }

    private Hashtable<String, String> readPOST(HTTPRequest request) {
        Hashtable<String, String> set = new Hashtable<String, String>();
        for (String key : request.getParts()) {
            set.put(key, request.getPartAsStringFailsafe(key, 0x100000));
        }
        return set;
    }

    private HTMLNode renderPersistenceFields(Hashtable<String, String> fieldPairs) {
        HTMLNode result = new HTMLNode("div", "id", "persistenceFields");
        for (Map.Entry<String, String> entry : fieldPairs.entrySet()) {
            result.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", entry.getKey(), entry.getValue()});
        }
        return result;
    }

    private String selectedValue(HTTPRequest request) {
        if (request.isParameterSet(this.filenameField()) && (request.isParameterSet(selectDir) || request.isParameterSet(selectFile))) {
            return request.getParam(this.filenameField());
        }
        if (request.isPartSet(this.filenameField()) && (request.isPartSet(selectDir) || request.isPartSet(selectFile))) {
            return request.getPartAsStringFailsafe(this.filenameField(), 0x100000);
        }
        return null;
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        this.renderPage(this.persistenceFields(this.readGET(request)), request.getParam("path"), ctx, this.selectedValue(request));
    }

    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        this.renderPage(this.persistenceFields(this.readPOST(request)), request.getPartAsStringFailsafe("path", 0x100000), ctx, this.selectedValue(request));
    }

    private void renderPage(Hashtable<String, String> fieldPairs, String path, ToadletContext ctx, String filename) throws ToadletContextClosedException, IOException, RedirectException {
        HTMLNode pageNode;
        File currentPath;
        HTMLNode persistenceFields = this.renderPersistenceFields(fieldPairs);
        if (filename != null) {
            File file = new File(filename);
            this.lastSuccessful = file.isDirectory() ? file.getAbsoluteFile() : file.getParentFile().getAbsoluteFile();
            try {
                throw new RedirectException(this.postTo());
            }
            catch (URISyntaxException e) {
                this.sendErrorPage(ctx, 500, NodeL10n.getBase().getString("Toadlet.internalErrorPleaseReport"), e.getMessage());
            }
        }
        if (path.isEmpty()) {
            path = this.lastSuccessful != null && this.lastSuccessful.isDirectory() && this.allowedDir(this.lastSuccessful) ? this.lastSuccessful.getAbsolutePath() : this.startingDir();
        }
        String attemptedPath = (currentPath = new File(path).getCanonicalFile()) == null ? "null" : currentPath.getAbsolutePath();
        PageMaker pageMaker = ctx.getPageMaker();
        if (currentPath != null && !this.allowedDir(currentPath)) {
            PageNode page = pageMaker.getPageNode(this.l10n("listingTitle", "path", attemptedPath), ctx);
            pageMaker.getInfobox("infobox-error", "Forbidden", page.content, "access-denied", true).addChild("#", this.l10n("dirAccessDenied"));
            this.sendErrorPage(ctx, 403, "Forbidden", this.l10n("dirAccessDenied"));
            return;
        }
        if (currentPath != null && currentPath.exists() && currentPath.isDirectory() && currentPath.canRead()) {
            PageNode page = pageMaker.getPageNode(this.l10n("listingTitle", "path", currentPath.getAbsolutePath()), ctx);
            pageNode = page.outer;
            HTMLNode contentNode = page.content;
            if (ctx.isAllowedFullAccess()) {
                contentNode.addChild(ctx.getAlertManager().createSummary());
            }
            HTMLNode infoboxDiv = contentNode.addChild("div", "class", "infobox");
            infoboxDiv.addChild("div", "class", "infobox-header", this.l10n("listing", "path", currentPath.getAbsolutePath()));
            HTMLNode listingDiv = infoboxDiv.addChild("div", "class", "infobox-content");
            File[] files = currentPath.listFiles();
            if (files == null) {
                this.sendErrorPage(ctx, 403, "Forbidden", this.l10n("dirAccessDenied"));
                return;
            }
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File firstFile, File secondFile) {
                    if (firstFile.isDirectory() && !secondFile.isDirectory()) {
                        return -1;
                    }
                    if (!firstFile.isDirectory() && secondFile.isDirectory()) {
                        return 1;
                    }
                    return firstFile.getName().compareToIgnoreCase(secondFile.getName());
                }
            });
            HTMLNode listingTable = listingDiv.addChild("table", "class", "directory-listing");
            HTMLNode headerRow = listingTable.addChild("tr");
            headerRow.addChild("th");
            headerRow.addChild("th", this.l10n("fileHeader"));
            headerRow.addChild("th", this.l10n("sizeHeader"));
            for (File currentRoot : File.listRoots()) {
                if (!this.allowedDir(currentRoot)) continue;
                HTMLNode rootRow = listingTable.addChild("tr");
                rootRow.addChild("td");
                HTMLNode rootLinkCellNode = rootRow.addChild("td");
                HTMLNode rootLinkFormNode = ctx.addFormChild(rootLinkCellNode, this.path(), "insertLocalFileForm");
                this.createChangeDirButton(rootLinkFormNode, currentRoot.getCanonicalPath(), currentRoot.getAbsolutePath(), persistenceFields);
                rootRow.addChild("td");
            }
            if (currentPath.getParent() != null && this.allowedDir(currentPath.getParentFile())) {
                HTMLNode backlinkRow = listingTable.addChild("tr");
                backlinkRow.addChild("td");
                HTMLNode backLinkCellNode = backlinkRow.addChild("td");
                HTMLNode backLinkFormNode = ctx.addFormChild(backLinkCellNode, this.path(), "insertLocalFileForm");
                this.createChangeDirButton(backLinkFormNode, "..", currentPath.getParent(), persistenceFields);
                backlinkRow.addChild("td");
            }
            for (File currentFile : files) {
                HTMLNode formNode;
                HTMLNode cellNode;
                if (currentFile.isHidden()) continue;
                HTMLNode fileRow = listingTable.addChild("tr");
                if (currentFile.isDirectory()) {
                    if (currentFile.canRead()) {
                        if (this.allowedDir(currentFile)) {
                            cellNode = fileRow.addChild("td");
                            formNode = ctx.addFormChild(cellNode, this.path(), "insertLocalFileForm");
                            this.createSelectDirectoryButton(formNode, currentFile.getAbsolutePath(), persistenceFields);
                            HTMLNode directoryCellNode = fileRow.addChild("td");
                            HTMLNode directoryFormNode = ctx.addFormChild(directoryCellNode, this.path(), "insertLocalFileForm");
                            this.createChangeDirButton(directoryFormNode, currentFile.getName(), currentFile.getAbsolutePath(), persistenceFields);
                        }
                    } else {
                        fileRow.addChild("td");
                        fileRow.addChild("td", "class", "unreadable-file", currentFile.getName());
                    }
                    fileRow.addChild("td");
                    continue;
                }
                if (currentFile.canRead()) {
                    cellNode = fileRow.addChild("td");
                    formNode = ctx.addFormChild(cellNode, this.path(), "insertLocalFileForm");
                    this.createSelectFileButton(formNode, currentFile.getAbsolutePath(), persistenceFields);
                    fileRow.addChild("td", currentFile.getName());
                    fileRow.addChild("td", "class", "right-align", SizeUtil.formatSize(currentFile.length(), true));
                    continue;
                }
                fileRow.addChild("td");
                fileRow.addChild("td", "class", "unreadable-file", currentFile.getName());
                fileRow.addChild("td", "class", "right-align", SizeUtil.formatSize(currentFile.length(), true));
            }
        } else {
            PageNode page = pageMaker.getPageNode(this.l10n("listingTitle", "path", attemptedPath), ctx);
            pageNode = page.outer;
            HTMLNode contentNode = page.content;
            if (ctx.isAllowedFullAccess()) {
                contentNode.addChild(ctx.getAlertManager().createSummary());
            }
            HTMLNode infoboxDiv = contentNode.addChild("div", "class", "infobox");
            infoboxDiv.addChild("div", "class", "infobox-header", this.l10n("listing", "path", attemptedPath));
            HTMLNode listingDiv = infoboxDiv.addChild("div", "class", "infobox-content");
            listingDiv.addChild("#", this.l10n("dirCannotBeRead", "path", attemptedPath));
            HTMLNode ulNode = listingDiv.addChild("ul");
            ulNode.addChild("li", this.l10n("checkPathExist"));
            ulNode.addChild("li", this.l10n("checkPathIsDir"));
            ulNode.addChild("li", this.l10n("checkPathReadable"));
        }
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("LocalFileInsertToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private String l10n(String msg) {
        return NodeL10n.getBase().getString("LocalFileInsertToadlet." + msg);
    }
}

