/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.wizardsteps;

import freenet.clients.http.FirstTimeWizardToadlet;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.wizardsteps.PersistFields;
import freenet.support.HTMLNode;

public class PageHelper {
    private final ToadletContext toadletContext;
    private final PersistFields persistFields;
    private final FirstTimeWizardToadlet.WIZARD_STEP step;
    private PageNode pageNode;

    public PageHelper(ToadletContext ctx, PersistFields persistFields, FirstTimeWizardToadlet.WIZARD_STEP step) {
        this.toadletContext = ctx;
        this.persistFields = persistFields;
        this.step = step;
    }

    public HTMLNode getPageContent(String title) {
        this.pageNode = this.toadletContext.getPageMaker().getPageNode(title, this.toadletContext, new PageMaker.RenderParameters().renderNavigationLinks(false).renderStatus(false));
        return this.pageNode.content;
    }

    public HTMLNode getPageOuter() {
        if (this.pageNode == null) {
            throw new NullPointerException("pageNode was not initialized. getPageContent must be called first.");
        }
        return this.pageNode.outer;
    }

    public HTMLNode getInfobox(String category, String header, HTMLNode parent, String title, boolean isUnique) {
        return this.toadletContext.getPageMaker().getInfobox(category, header, parent, title, isUnique);
    }

    public HTMLNode addFormChild(HTMLNode parentNode, String target, String id) {
        return this.addFormChild(parentNode, target, id, true);
    }

    public HTMLNode addFormChild(HTMLNode parentNode, String target, String id, boolean includeOpennet) {
        HTMLNode form = this.toadletContext.addFormChild(parentNode, target, id);
        if (this.persistFields.isUsingPreset()) {
            form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "preset", this.persistFields.preset.name()});
        }
        if (this.persistFields.isSingleStep()) {
            form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "singlestep", "true"});
        }
        if (includeOpennet) {
            form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "opennet", String.valueOf(this.persistFields.opennet)});
        }
        form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "step", this.step.name()});
        return form;
    }
}

