/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;
import freenet.crypt.EntropySource;
import freenet.crypt.PersistentRandomSource;
import freenet.crypt.RandomSource;
import freenet.crypt.Util;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.Closer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class Yarrow
extends RandomSource
implements PersistentRandomSource {
    private static final long serialVersionUID = -1L;
    private static volatile boolean logMINOR;
    private static final boolean DEBUG = false;
    private static final int Pg = 10;
    private final SecureRandom sr;
    public final File seedfile;
    private long timeLastWroteSeed = -1L;
    private BlockCipher cipher_ctx;
    private byte[] output_buffer;
    private byte[] counter;
    private byte[] allZeroString;
    private byte[] tmp;
    private int output_count;
    private int fetch_counter;
    static final int[][] bitTable;
    private MessageDigest fast_pool;
    private MessageDigest slow_pool;
    private int fast_entropy;
    private int slow_entropy;
    private boolean fast_select;
    private Map<EntropySource, int[]> entropySeen;
    private static final int Pt = 5;
    private MessageDigest reseed_ctx;
    private static final int FAST_THRESHOLD = 100;
    private static final int SLOW_THRESHOLD = 160;
    private static final int SLOW_K = 2;

    public Yarrow() {
        this("prng.seed", "SHA1", "Rijndael", true, true);
    }

    public Yarrow(boolean canBlock) {
        this("prng.seed", "SHA1", "Rijndael", true, canBlock);
    }

    public Yarrow(File seed) {
        this(seed, "SHA1", "Rijndael", true, true);
    }

    public Yarrow(String seed, String digest, String cipher, boolean updateSeed, boolean canBlock) {
        this(new File(seed), digest, cipher, updateSeed, canBlock);
    }

    public Yarrow(File seed, String digest, String cipher, boolean updateSeed, boolean canBlock) {
        this(seed, digest, cipher, updateSeed, canBlock, true);
    }

    Yarrow(File seed, String digest, String cipher, boolean updateSeed, boolean canBlock, boolean reseedOnStartup) {
        SecureRandom s;
        try {
            s = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            s = null;
        }
        this.sr = s;
        try {
            this.accumulator_init(digest);
            this.reseed_init(digest);
            this.generator_init(cipher);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error(this, "Could not init pools trying to getInstance(" + digest + "): " + e, (Throwable)e);
            throw new RuntimeException("Cannot initialize Yarrow!: " + e, e);
        }
        this.seedfile = updateSeed && !seed.toString().equals("/dev/urandom") ? seed : null;
        if (reseedOnStartup) {
            this.entropy_init(seed, reseedOnStartup);
            this.seedFromExternalStuff(canBlock);
            this.fast_pool_reseed();
            this.slow_pool_reseed();
        } else {
            this.read_seed(seed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seedFromExternalStuff(boolean canBlock) {
        byte[] buf;
        block20: {
            block18: {
                buf = new byte[32];
                if (File.separatorChar != '/') break block18;
                DataInputStream dis = null;
                FileInputStream fis = null;
                File hwrng = new File("/dev/hwrng");
                if (hwrng.exists() && hwrng.canRead()) {
                    try {
                        fis = new FileInputStream(hwrng);
                        dis = new DataInputStream(fis);
                        dis.readFully(buf);
                        this.consumeBytes(buf);
                        dis.readFully(buf);
                        this.consumeBytes(buf);
                        dis.close();
                    }
                    catch (Throwable t) {
                        try {
                            Logger.normal(this, "Can't read /dev/hwrng even though exists and is readable: " + t, t);
                        }
                        catch (Throwable throwable) {
                            Closer.close(dis);
                            Closer.close(fis);
                            throw throwable;
                        }
                        Closer.close(dis);
                        Closer.close(fis);
                    }
                    Closer.close(dis);
                    Closer.close(fis);
                }
                try {
                    fis = new FileInputStream("/dev/urandom");
                    dis = new DataInputStream(fis);
                    dis.readFully(buf);
                    this.consumeBytes(buf);
                    dis.readFully(buf);
                    this.consumeBytes(buf);
                }
                catch (Throwable t) {
                    try {
                        Logger.normal(this, "Can't read /dev/urandom: " + t, t);
                        canBlock = true;
                    }
                    catch (Throwable throwable) {
                        Closer.close(dis);
                        Closer.close(fis);
                        throw throwable;
                    }
                    Closer.close(dis);
                    Closer.close(fis);
                }
                Closer.close(dis);
                Closer.close(fis);
                if (canBlock) {
                    try {
                        fis = new FileInputStream("/dev/random");
                        dis = new DataInputStream(fis);
                        dis.readFully(buf);
                        this.consumeBytes(buf);
                        dis.readFully(buf);
                        this.consumeBytes(buf);
                    }
                    catch (Throwable t) {
                        Logger.normal(this, "Can't read /dev/random: " + t, t);
                    }
                    finally {
                        Closer.close(dis);
                        Closer.close(fis);
                    }
                }
                fis = null;
                break block20;
            }
            canBlock = true;
        }
        if (canBlock) {
            buf = this.sr.generateSeed(32);
            this.consumeBytes(buf);
            buf = this.sr.generateSeed(32);
            this.consumeBytes(buf);
        }
        this.consumeString(Long.toHexString(Runtime.getRuntime().freeMemory()));
        this.consumeString(Long.toHexString(Runtime.getRuntime().totalMemory()));
    }

    private void entropy_init(File seed, boolean reseedOnStartup) {
        if (reseedOnStartup) {
            Properties sys = System.getProperties();
            EntropySource startupEntropy = new EntropySource();
            Enumeration<?> enu = sys.propertyNames();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                this.consumeString(key);
                this.consumeString(sys.getProperty(key));
            }
            try {
                this.consumeString(InetAddress.getLocalHost().toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.readStartupEntropy(startupEntropy);
        }
        this.read_seed(seed);
    }

    protected void readStartupEntropy(EntropySource startupEntropy) {
        this.acceptEntropy(startupEntropy, System.currentTimeMillis(), 0);
        this.acceptEntropy(startupEntropy, System.nanoTime(), 0);
        this.acceptEntropy(startupEntropy, Runtime.getRuntime().freeMemory(), 0);
        this.acceptEntropy(startupEntropy, Runtime.getRuntime().totalMemory(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void read_seed(File filename) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        try {
            fis = new FileInputStream(filename);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            EntropySource seedFile = new EntropySource();
            for (int i = 0; i < 32; ++i) {
                this.acceptEntropy(seedFile, dis.readLong(), 64);
            }
            dis.close();
        }
        catch (EOFException seedFile) {
            Closer.close(dis);
            Closer.close(bis);
            Closer.close(fis);
        }
        catch (IOException e) {
            Logger.error(this, "IOE trying to read the seedfile from disk : " + e.getMessage());
            {
                catch (Throwable throwable) {
                    Closer.close(dis);
                    Closer.close(bis);
                    Closer.close(fis);
                    throw throwable;
                }
            }
            Closer.close(dis);
            Closer.close(bis);
            Closer.close(fis);
        }
        Closer.close(dis);
        Closer.close(bis);
        Closer.close(fis);
        this.fast_pool_reseed();
    }

    private void write_seed(File filename) {
        this.write_seed(filename, false);
    }

    @Override
    public void write_seed(boolean force) {
        this.write_seed(this.seedfile, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write_seed(File filename, boolean force) {
        if (!force) {
            Yarrow yarrow = this;
            synchronized (yarrow) {
                long now = System.currentTimeMillis();
                if (now - this.timeLastWroteSeed <= TimeUnit.HOURS.toMillis(1L)) {
                    return;
                }
                this.timeLastWroteSeed = now;
            }
        }
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        DataOutputStream dos = null;
        try {
            fos = new FileOutputStream(filename);
            bos = new BufferedOutputStream(fos);
            dos = new DataOutputStream(bos);
            for (int i = 0; i < 32; ++i) {
                dos.writeLong(this.nextLong());
            }
            dos.flush();
            dos.close();
        }
        catch (IOException e) {
            try {
                Logger.error(this, "IOE while saving the seed file! : " + e.getMessage());
            }
            catch (Throwable throwable) {
                Closer.close(dos);
                Closer.close(bos);
                Closer.close(fos);
                throw throwable;
            }
            Closer.close(dos);
            Closer.close(bos);
            Closer.close(fos);
        }
        Closer.close(dos);
        Closer.close(bos);
        Closer.close(fos);
    }

    private void generator_init(String cipher) {
        this.cipher_ctx = Util.getCipherByName(cipher);
        this.output_buffer = new byte[this.cipher_ctx.getBlockSize() / 8];
        this.counter = new byte[this.cipher_ctx.getBlockSize() / 8];
        this.allZeroString = new byte[this.cipher_ctx.getBlockSize() / 8];
        this.tmp = new byte[this.cipher_ctx.getKeySize() / 8];
        this.fetch_counter = this.output_buffer.length;
    }

    private void counterInc() {
        int i = this.counter.length - 1;
        while (i >= 0) {
            int n = i--;
            this.counter[n] = (byte)(this.counter[n] + 1);
            if (this.counter[n] != 0) break;
        }
    }

    private void generateOutput() {
        this.counterInc();
        this.output_buffer = new byte[this.counter.length];
        this.cipher_ctx.encipher(this.counter, this.output_buffer);
        if (this.output_count++ > 10) {
            this.output_count = 0;
            this.nextBytes(this.tmp);
            this.rekey(this.tmp);
        }
    }

    private void rekey(byte[] key) {
        this.cipher_ctx.initialize(key);
        this.counter = new byte[this.allZeroString.length];
        this.cipher_ctx.encipher(this.allZeroString, this.counter);
        Arrays.fill(key, (byte)0);
    }

    private synchronized int getBytes(int count) {
        if (this.fetch_counter + count > this.output_buffer.length) {
            this.fetch_counter = 0;
            this.generateOutput();
            return this.getBytes(count);
        }
        int rv = this.fetch_counter;
        this.fetch_counter += count;
        return rv;
    }

    @Override
    protected synchronized int next(int bits) {
        int[] parameters = bitTable[bits];
        int offset = this.getBytes(parameters[0]);
        int val = this.output_buffer[offset];
        if (parameters[0] == 4) {
            val += (this.output_buffer[offset + 1] << 24) + (this.output_buffer[offset + 2] << 16) + (this.output_buffer[offset + 3] << 8);
        } else if (parameters[0] == 3) {
            val += (this.output_buffer[offset + 1] << 16) + (this.output_buffer[offset + 2] << 8);
        } else if (parameters[0] == 2) {
            val += this.output_buffer[offset + 2] << 8;
        }
        return val & parameters[1];
    }

    private void accumulator_init(String digest) throws NoSuchAlgorithmException {
        this.fast_pool = MessageDigest.getInstance(digest, Util.mdProviders.get(digest));
        this.slow_pool = MessageDigest.getInstance(digest, Util.mdProviders.get(digest));
        this.entropySeen = new HashMap<EntropySource, int[]>();
    }

    @Override
    public int acceptEntropy(EntropySource source, long data, int entropyGuess) {
        return this.acceptEntropy(source, data, entropyGuess, 1.0);
    }

    @Override
    public int acceptEntropyBytes(EntropySource source, byte[] buf, int offset, int length, double bias) {
        int totalRealEntropy = 0;
        for (int i = 0; i < length; i += 8) {
            long thingy = 0L;
            int bytes = 0;
            for (int j = 0; j < Math.min(length, i + 8); ++j) {
                thingy = (thingy << 8) + (long)(buf[j] & 0xFF);
                ++bytes;
            }
            totalRealEntropy += this.acceptEntropy(source, thingy, bytes * 8, bias);
        }
        return totalRealEntropy;
    }

    private int acceptEntropy(EntropySource source, long data, int entropyGuess, double bias) {
        return this.accept_entropy(data, source, (int)(bias * (double)Math.min(32, Math.min(this.estimateEntropy(source, data), entropyGuess))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int accept_entropy(long data, EntropySource source, int actualEntropy) {
        boolean performedPoolReseed;
        block12: {
            performedPoolReseed = false;
            byte[] b = new byte[]{(byte)data, (byte)(data >> 8), (byte)(data >> 16), (byte)(data >> 24), (byte)(data >> 32), (byte)(data >> 40), (byte)(data >> 48), (byte)(data >> 56)};
            Yarrow yarrow = this;
            synchronized (yarrow) {
                block11: {
                    this.fast_select = !this.fast_select;
                    MessageDigest pool = this.fast_select ? this.fast_pool : this.slow_pool;
                    pool.update(b);
                    if (!this.fast_select) break block11;
                    this.fast_entropy += actualEntropy;
                    if (this.fast_entropy <= 100) break block12;
                    this.fast_pool_reseed();
                    performedPoolReseed = true;
                    break block12;
                }
                this.slow_entropy += actualEntropy;
                if (source != null) {
                    int[] contributedEntropy = this.entropySeen.get(source);
                    if (contributedEntropy == null) {
                        contributedEntropy = new int[]{actualEntropy};
                        this.entropySeen.put(source, contributedEntropy);
                    } else {
                        contributedEntropy[0] = contributedEntropy[0] + actualEntropy;
                    }
                    if (this.slow_entropy >= 320) {
                        int kc = 0;
                        for (Map.Entry<EntropySource, int[]> e : this.entropySeen.entrySet()) {
                            EntropySource key = e.getKey();
                            int[] v = e.getValue();
                            if (v[0] <= 160 || ++kc < 2) continue;
                            this.slow_pool_reseed();
                            performedPoolReseed = true;
                            break;
                        }
                    }
                }
            }
        }
        if (performedPoolReseed && this.seedfile != null) {
            if (logMINOR) {
                Logger.minor(this, "Writing seedfile");
            }
            this.write_seed(this.seedfile);
            if (logMINOR) {
                Logger.minor(this, "Written seedfile");
            }
        }
        return actualEntropy;
    }

    private int estimateEntropy(EntropySource source, long newVal) {
        int delta = (int)(newVal - source.lastVal);
        int delta2 = delta - source.lastDelta;
        source.lastDelta = delta;
        int delta3 = delta2 - source.lastDelta2;
        source.lastDelta2 = delta2;
        if (delta < 0) {
            delta = -delta;
        }
        if (delta2 < 0) {
            delta2 = -delta2;
        }
        if (delta3 < 0) {
            delta3 = -delta3;
        }
        if (delta > delta2) {
            delta = delta2;
        }
        if (delta > delta3) {
            delta = delta3;
        }
        delta >>= 1;
        delta &= 0xFFF;
        delta |= delta >> 8;
        delta |= delta >> 4;
        delta |= delta >> 2;
        delta |= delta >> 1;
        delta >>= 1;
        delta -= delta >> 1 & 0x555;
        delta = (delta & 0x333) + (delta >> 2 & 0x333);
        delta += delta >> 4;
        delta += delta >> 8;
        source.lastVal = newVal;
        return delta & 0xF;
    }

    @Override
    public int acceptTimerEntropy(EntropySource timer) {
        return this.acceptTimerEntropy(timer, 1.0);
    }

    @Override
    public int acceptTimerEntropy(EntropySource timer, double bias) {
        long now = System.currentTimeMillis();
        return this.acceptEntropy(timer, now - timer.lastVal, 32, bias);
    }

    @Override
    public void waitForEntropy(int bits) {
    }

    private void reseed_init(String digest) throws NoSuchAlgorithmException {
        this.reseed_ctx = MessageDigest.getInstance(digest, Util.mdProviders.get(digest));
    }

    private void fast_pool_reseed() {
        byte[] v0;
        long startTime = System.currentTimeMillis();
        byte[] vi = v0 = this.fast_pool.digest();
        for (byte i = 0; i < 5; i = (byte)(i + 1)) {
            this.reseed_ctx.update(vi, 0, vi.length);
            this.reseed_ctx.update(v0, 0, v0.length);
            this.reseed_ctx.update(i);
            vi = this.reseed_ctx.digest();
        }
        Util.makeKey(vi, this.tmp, 0, this.tmp.length);
        this.rekey(this.tmp);
        Arrays.fill(v0, (byte)0);
        this.fast_entropy = 0;
    }

    private void slow_pool_reseed() {
        byte[] slow_hash = this.slow_pool.digest();
        this.fast_pool.update(slow_hash, 0, slow_hash.length);
        this.fast_pool_reseed();
        this.slow_entropy = 0;
        this.entropySeen.clear();
    }

    @Override
    public void close() {
    }

    public static void main(String[] args) throws Exception {
        block21: {
            Yarrow r;
            block25: {
                int i;
                block24: {
                    byte[] b;
                    block23: {
                        int i2;
                        block22: {
                            block20: {
                                int i3;
                                r = new Yarrow(new File("/dev/urandom"), "SHA1", "Rijndael", true, false);
                                b = new byte[1024];
                                if (args.length != 0 && !args[0].equalsIgnoreCase("latency")) break block20;
                                if (args.length == 2) {
                                    b = new byte[Integer.parseInt(args[1])];
                                }
                                long start = System.currentTimeMillis();
                                for (i3 = 0; i3 < 100; ++i3) {
                                    r.nextBytes(b);
                                }
                                System.out.println((double)(System.currentTimeMillis() - start) / (double)(100 * b.length) * 1024.0 + " ms/k");
                                start = System.currentTimeMillis();
                                for (i3 = 0; i3 < 1000; ++i3) {
                                    r.nextInt();
                                }
                                System.out.println((double)(System.currentTimeMillis() - start) / 1000.0 + " ms/int");
                                start = System.currentTimeMillis();
                                for (i3 = 0; i3 < 1000; ++i3) {
                                    r.nextLong();
                                }
                                System.out.println((double)(System.currentTimeMillis() - start) / 1000.0 + " ms/long");
                                break block21;
                            }
                            if (!args[0].equalsIgnoreCase("randomness")) break block22;
                            int kb = Integer.parseInt(args[1]);
                            for (int i4 = 0; i4 < kb; ++i4) {
                                r.nextBytes(b);
                                System.out.write(b);
                            }
                            break block21;
                        }
                        if (!args[0].equalsIgnoreCase("gathering")) break block23;
                        System.gc();
                        EntropySource t = new EntropySource();
                        long start = System.currentTimeMillis();
                        for (i2 = 0; i2 < 100000; ++i2) {
                            r.acceptEntropy(t, System.currentTimeMillis(), 32);
                        }
                        System.err.println((double)(System.currentTimeMillis() - start) / 100000.0);
                        System.gc();
                        start = System.currentTimeMillis();
                        for (i2 = 0; i2 < 100000; ++i2) {
                            r.acceptTimerEntropy(t);
                        }
                        System.err.println((double)(System.currentTimeMillis() - start) / 100000.0);
                        break block21;
                    }
                    if (!args[0].equalsIgnoreCase("volume")) break block24;
                    b = new byte[1020];
                    long duration = System.currentTimeMillis() + (long)Integer.parseInt(args[1]);
                    while (System.currentTimeMillis() < duration) {
                        r.nextBytes(b);
                        System.out.write(b);
                    }
                    break block21;
                }
                if (args[0].equalsIgnoreCase("bitstream")) {
                    block7: while (true) {
                        int v = r.nextInt();
                        int i5 = 0;
                        while (true) {
                            if (i5 >= 32) continue block7;
                            if ((v >> i5 & 1) == 1) {
                                System.out.print('1');
                            } else {
                                System.out.print('0');
                            }
                            ++i5;
                        }
                        break;
                    }
                }
                if (!args[0].equalsIgnoreCase("sample")) break block21;
                if (args.length != 1 && !args[1].equals("general")) break block25;
                System.out.println("nextInt(): ");
                for (i = 0; i < 3; ++i) {
                    System.out.println(r.nextInt());
                }
                System.out.println("nextLong(): ");
                for (i = 0; i < 3; ++i) {
                    System.out.println(r.nextLong());
                }
                System.out.println("nextFloat(): ");
                for (i = 0; i < 3; ++i) {
                    System.out.println(r.nextFloat());
                }
                System.out.println("nextDouble(): ");
                for (i = 0; i < 3; ++i) {
                    System.out.println(r.nextDouble());
                }
                System.out.println("nextFullFloat(): ");
                for (i = 0; i < 3; ++i) {
                    System.out.println(r.nextFullFloat());
                }
                System.out.println("nextFullDouble(): ");
                for (i = 0; i < 3; ++i) {
                    System.out.println(r.nextFullDouble());
                }
                break block21;
            }
            if (!args[1].equals("normalized")) break block21;
            for (int i = 0; i < 20; ++i) {
                System.out.println(r.nextDouble());
            }
        }
    }

    private void consumeString(String str) {
        this.consumeBytes(str.getBytes(StandardCharsets.UTF_8));
    }

    private void consumeBytes(byte[] bytes) {
        if (this.fast_select) {
            this.fast_pool.update(bytes, 0, bytes.length);
        } else {
            this.slow_pool.update(bytes, 0, bytes.length);
        }
        this.fast_select = !this.fast_select;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        bitTable = new int[][]{{0, 0}, {1, 1}, {1, 3}, {1, 7}, {1, 15}, {1, 31}, {1, 63}, {1, 127}, {1, 255}, {2, 511}, {2, 1023}, {2, 2047}, {2, 4095}, {2, 8191}, {2, 16383}, {2, Short.MAX_VALUE}, {2, 65535}, {3, 131071}, {3, 262143}, {3, 524287}, {3, 1048575}, {3, 0x1FFFFF}, {3, 0x3FFFFF}, {3, 0x7FFFFF}, {3, 0xFFFFFF}, {4, 0x1FFFFFF}, {4, 0x3FFFFFF}, {4, 0x7FFFFFF}, {4, 0xFFFFFFF}, {4, 0x1FFFFFFF}, {4, 0x3FFFFFFF}, {4, Integer.MAX_VALUE}, {4, -1}};
    }
}

