/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.MessageItem;
import freenet.node.PacketSender;
import freenet.support.DoublyLinkedList;
import freenet.support.DoublyLinkedListImpl;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;

public class PeerMessageQueue {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final PrioQueue[] queuesByPriority;
    private final Random fastWeakRandom;

    PeerMessageQueue(Random fastWeakRandom) {
        this.fastWeakRandom = fastWeakRandom;
        this.queuesByPriority = new PrioQueue[6];
        for (int i = 0; i < this.queuesByPriority.length; ++i) {
            this.queuesByPriority[i] = i == 5 ? new PrioQueue(PacketSender.MAX_COALESCING_DELAY_BULK, true) : (i == 4 ? new PrioQueue(PacketSender.MAX_COALESCING_DELAY, true) : new PrioQueue(PacketSender.MAX_COALESCING_DELAY, false));
        }
    }

    public synchronized int queueAndEstimateSize(MessageItem item, int maxSize) {
        this.enqueuePrioritizedMessageItem(item);
        int x = 0;
        for (PrioQueue pq : this.queuesByPriority) {
            if (pq.itemsNonUrgent != null) {
                MessageItem it;
                Iterator<Object> iterator = pq.itemsNonUrgent.iterator();
                while (iterator.hasNext() && (x += (it = (MessageItem)iterator.next()).getLength() + 2) <= maxSize) {
                }
            }
            if (pq.nonEmptyItemsWithID == null) continue;
            for (PrioQueue.Items q : pq.nonEmptyItemsWithID) {
                MessageItem it;
                Iterator iterator = q.items.iterator();
                while (iterator.hasNext() && (x += (it = (MessageItem)iterator.next()).getLength() + 2) <= maxSize) {
                }
            }
        }
        return x;
    }

    public synchronized long getMessageQueueLengthBytes() {
        long x = 0L;
        for (PrioQueue pq : this.queuesByPriority) {
            if (pq.nonEmptyItemsWithID == null) continue;
            for (PrioQueue.Items q : pq.nonEmptyItemsWithID) {
                for (MessageItem it : q.items) {
                    x += (long)(it.getLength() + 2);
                }
            }
        }
        return x;
    }

    private synchronized void enqueuePrioritizedMessageItem(MessageItem addMe) {
        short prio = addMe.getPriority();
        this.queuesByPriority[prio].addLast(addMe);
    }

    synchronized void pushfrontPrioritizedMessageItem(MessageItem addMe) {
        short prio = addMe.getPriority();
        this.queuesByPriority[prio].addFirst(addMe);
    }

    public synchronized MessageItem[] grabQueuedMessageItems() {
        int size = 0;
        for (PrioQueue queue : this.queuesByPriority) {
            size += queue.size();
        }
        MessageItem[] output = new MessageItem[size];
        int ptr = 0;
        for (PrioQueue queue : this.queuesByPriority) {
            ptr = queue.addTo(output, ptr);
            queue.clear();
        }
        return output;
    }

    public synchronized long getNextUrgentTime(long t, long returnIfBefore) {
        for (PrioQueue queue : this.queuesByPriority) {
            if ((t = Math.min(t, queue.getNextUrgentTime(t, returnIfBefore))) > returnIfBefore) continue;
            return t;
        }
        return t;
    }

    public boolean mustSendNow(long now) {
        return this.getNextUrgentTime(Long.MAX_VALUE, now) <= now;
    }

    public synchronized boolean mustSendSize(int minSize, int maxSize) {
        int length = minSize;
        for (PrioQueue items : this.queuesByPriority) {
            if ((length = items.addSize(length, maxSize)) <= maxSize) continue;
            return true;
        }
        return false;
    }

    public synchronized MessageItem grabQueuedMessageItem(int minPriority) {
        boolean tryRealtimeFirst;
        MessageItem ret;
        long now = System.currentTimeMillis();
        for (int i = 0; i < 4; ++i) {
            if (i < minPriority) continue;
            if (logMINOR) {
                Logger.minor(this, "Adding from priority " + i);
            }
            if ((ret = this.queuesByPriority[i].addPriorityMessages(now)) == null) continue;
            return ret;
        }
        if (this.queuesByPriority[4].isEmpty()) {
            tryRealtimeFirst = false;
        } else if (this.queuesByPriority[5].isEmpty()) {
            tryRealtimeFirst = true;
        } else if (this.queuesByPriority[5].getNextUrgentTime(Long.MAX_VALUE, 0L) >= this.queuesByPriority[4].getNextUrgentTime(Long.MAX_VALUE, 0L)) {
            tryRealtimeFirst = true;
        } else {
            boolean bl = tryRealtimeFirst = this.fastWeakRandom.nextInt(10) > 0;
        }
        if (tryRealtimeFirst) {
            if (logMINOR) {
                Logger.minor(this, "Trying realtime first");
            }
            if ((ret = this.queuesByPriority[4].addPriorityMessages(now)) != null) {
                return ret;
            }
            if (logMINOR) {
                Logger.minor(this, "Trying bulk");
            }
            if ((ret = this.queuesByPriority[5].addPriorityMessages(now)) != null) {
                return ret;
            }
        } else {
            if (logMINOR) {
                Logger.minor(this, "Trying bulk first");
            }
            if ((ret = this.queuesByPriority[5].addPriorityMessages(now)) != null) {
                return ret;
            }
            if (logMINOR) {
                Logger.minor(this, "Trying realtime");
            }
            if ((ret = this.queuesByPriority[4].addPriorityMessages(now)) != null) {
                return ret;
            }
        }
        for (int i = 6; i < 6; ++i) {
            MessageItem ret2;
            if (i < minPriority) continue;
            if (logMINOR) {
                Logger.minor(this, "Adding from priority " + i);
            }
            if ((ret2 = this.queuesByPriority[i].addPriorityMessages(now)) == null) continue;
            return ret2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMessage(MessageItem message) {
        PeerMessageQueue peerMessageQueue = this;
        synchronized (peerMessageQueue) {
            short prio = message.getPriority();
            if (!this.queuesByPriority[prio].removeMessage(message)) {
                return false;
            }
        }
        message.onFailed();
        return true;
    }

    public synchronized void removeUIDsFromMessageQueues(Long[] list) {
        for (PrioQueue queue : this.queuesByPriority) {
            queue.removeUIDs(list);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }

    private static class PrioQueue {
        final long timeout;
        final boolean roundRobinBetweenUIDs;
        static final long FORGET_AFTER = 180000L;
        DoublyLinkedListImpl<Items> nonEmptyItemsWithID;
        DoublyLinkedListImpl<Items> emptyItemsWithID;
        Map<Long, Items> itemsByID;
        LinkedList<MessageItem> itemsNonUrgent;

        PrioQueue(long timeout, boolean timeoutSinceLastSend) {
            this.timeout = timeout;
            this.roundRobinBetweenUIDs = timeoutSinceLastSend;
        }

        public void addLast(MessageItem item) {
            item.clearDeadline();
            if (logMINOR) {
                this.checkOrder();
            }
            if (this.roundRobinBetweenUIDs) {
                Items it;
                long id = item.getID();
                if (this.itemsByID != null && (it = this.itemsByID.get(id)) != null && it.timeLastSent > 0L && it.timeLastSent + this.timeout <= System.currentTimeMillis()) {
                    it.addLast(item);
                    if (it.getParent() == this.emptyItemsWithID) {
                        this.moveFromEmptyToNonEmptyBackward(it);
                    } else assert (it.getParent() == this.nonEmptyItemsWithID);
                    if (logMINOR) {
                        this.checkOrder();
                    }
                    return;
                }
            }
            this.addToNonUrgent(item);
        }

        private void addToNonUrgent(MessageItem item) {
            MessageItem prev;
            if (this.itemsNonUrgent == null) {
                this.itemsNonUrgent = new LinkedList();
            }
            ListIterator<MessageItem> it = this.itemsNonUrgent.listIterator(this.itemsNonUrgent.size());
            do {
                if (!it.hasPrevious()) {
                    it.add(item);
                    if (logMINOR) {
                        this.checkOrder();
                    }
                    return;
                }
                prev = it.previous();
            } while (item.submitted < prev.submitted);
            it.next();
            it.add(item);
            if (logMINOR) {
                this.checkOrder();
            }
        }

        private void moveToUrgent(long now) {
            if (logMINOR) {
                this.checkOrder();
            }
            if (this.itemsNonUrgent == null) {
                return;
            }
            ListIterator it = this.itemsNonUrgent.listIterator();
            int moved = 0;
            while (it.hasNext()) {
                MessageItem item = (MessageItem)it.next();
                Items list = null;
                long id = item.getID();
                if (this.itemsByID != null) {
                    list = this.itemsByID.get(id);
                }
                boolean moveIt = false;
                if (list != null && this.roundRobinBetweenUIDs && list.timeLastSent + this.timeout <= now) {
                    moveIt = true;
                }
                if (item.submitted + this.timeout <= now) {
                    moveIt = true;
                }
                if (moveIt) {
                    if (logMINOR) {
                        Logger.minor(this, "Moving message to urgent list: " + item);
                    }
                    if (logMINOR) {
                        this.checkOrder();
                    }
                    if (this.itemsByID == null) {
                        this.itemsByID = new HashMap<Long, Items>();
                        if (this.nonEmptyItemsWithID == null) {
                            this.nonEmptyItemsWithID = new DoublyLinkedListImpl();
                        }
                        list = new Items(id, item.submitted);
                        this.addToNonEmptyForward(list);
                        this.itemsByID.put(id, list);
                        if (logMINOR) {
                            this.checkOrder();
                        }
                    } else if (list == null) {
                        list = new Items(id, item.submitted);
                        if (this.nonEmptyItemsWithID == null) {
                            this.nonEmptyItemsWithID = new DoublyLinkedListImpl();
                        }
                        this.addToNonEmptyForward(list);
                        this.itemsByID.put(id, list);
                        if (logMINOR) {
                            this.checkOrder();
                        }
                    } else {
                        if (list.items.isEmpty()) {
                            if (list.getParent() == this.nonEmptyItemsWithID) {
                                Logger.error(this, "Was empty but was in nonEmptyItemsWithID: " + list);
                            } else {
                                assert (list.getParent() == this.emptyItemsWithID);
                                this.moveFromEmptyToNonEmptyForward(list);
                            }
                        } else assert (list.getParent() == this.nonEmptyItemsWithID);
                        if (logMINOR) {
                            this.checkOrder();
                        }
                    }
                    list.addLast(item);
                    it.remove();
                    ++moved;
                    if (!logMINOR) continue;
                    this.checkOrder();
                    continue;
                }
                if (this.roundRobinBetweenUIDs) continue;
                break;
            }
            if (logDEBUG && moved > 0) {
                Logger.debug(this, "Moved " + moved + " items to urgent round-robin");
            }
            if (logMINOR) {
                this.checkOrder();
            }
        }

        private void moveFromEmptyToNonEmptyForward(Items list) {
            assert (list.items.isEmpty());
            if (logMINOR && list.getParent() == this.nonEmptyItemsWithID) {
                Logger.error(this, "Already in non-empty yet empty?!");
                return;
            }
            if (this.emptyItemsWithID != null) {
                this.emptyItemsWithID.remove(list);
            }
            this.addToNonEmptyForward(list);
        }

        private void addToNonEmptyForward(Items list) {
            if (this.nonEmptyItemsWithID == null) {
                this.nonEmptyItemsWithID = new DoublyLinkedListImpl();
            }
            Enumeration<Items> it = this.nonEmptyItemsWithID.elements();
            while (it.hasMoreElements()) {
                Items compare = it.nextElement();
                if (compare.timeLastSent < list.timeLastSent) continue;
                this.nonEmptyItemsWithID.insertPrev(compare, list);
                return;
            }
            this.nonEmptyItemsWithID.push(list);
        }

        private void moveFromEmptyToNonEmptyBackward(Items list) {
            this.emptyItemsWithID.remove(list);
            this.addToNonEmptyBackward(list);
        }

        private void addToNonEmptyBackward(Items list) {
            if (this.nonEmptyItemsWithID == null) {
                this.nonEmptyItemsWithID = new DoublyLinkedListImpl();
            }
            Enumeration<Items> it = this.nonEmptyItemsWithID.reverseElements();
            while (it.hasMoreElements()) {
                Items compare = it.nextElement();
                if (compare.timeLastSent > list.timeLastSent) continue;
                this.nonEmptyItemsWithID.insertNext(compare, list);
                return;
            }
            this.nonEmptyItemsWithID.unshift(list);
        }

        private void addToEmptyBackward(Items list) {
            if (this.emptyItemsWithID == null) {
                this.emptyItemsWithID = new DoublyLinkedListImpl();
            }
            Enumeration<Items> it = this.emptyItemsWithID.reverseElements();
            while (it.hasMoreElements()) {
                Items compare = it.nextElement();
                if (compare.timeLastSent > list.timeLastSent) continue;
                this.emptyItemsWithID.insertNext(compare, list);
                return;
            }
            this.emptyItemsWithID.unshift(list);
        }

        public void addFirst(MessageItem item) {
            Items list;
            if (!this.roundRobinBetweenUIDs) {
                this.addToNonUrgent(item);
                return;
            }
            if (logMINOR) {
                this.checkOrder();
            }
            long id = item.getID();
            if (this.itemsByID == null) {
                this.itemsByID = new HashMap<Long, Items>();
                if (this.nonEmptyItemsWithID == null) {
                    this.nonEmptyItemsWithID = new DoublyLinkedListImpl();
                }
                list = new Items(id, -1L);
                this.addToNonEmptyForward(list);
                this.itemsByID.put(id, list);
            } else {
                list = this.itemsByID.get(id);
                if (list == null) {
                    list = new Items(id, -1L);
                    if (this.nonEmptyItemsWithID == null) {
                        this.nonEmptyItemsWithID = new DoublyLinkedListImpl();
                    }
                    this.nonEmptyItemsWithID.unshift(list);
                    this.itemsByID.put(id, list);
                } else if (list.items.isEmpty()) {
                    assert (list.getParent() == this.emptyItemsWithID);
                    this.moveFromEmptyToNonEmptyForward(list);
                } else assert (list.getParent() == this.nonEmptyItemsWithID);
            }
            list.addFirst(item);
            if (logMINOR) {
                this.checkOrder();
            }
        }

        public int size() {
            int size = 0;
            if (this.nonEmptyItemsWithID != null) {
                for (Items items : this.nonEmptyItemsWithID) {
                    size += items.items.size();
                }
            }
            if (this.itemsNonUrgent != null) {
                size += this.itemsNonUrgent.size();
            }
            return size;
        }

        public int addTo(MessageItem[] output, int ptr) {
            if (this.nonEmptyItemsWithID != null) {
                for (Items list : this.nonEmptyItemsWithID) {
                    for (MessageItem item : list.items) {
                        output[ptr++] = item;
                    }
                }
            }
            if (this.itemsNonUrgent != null) {
                for (MessageItem item : this.itemsNonUrgent) {
                    output[ptr++] = item;
                }
            }
            return ptr;
        }

        private void checkOrder() {
            long prev;
            if (this.nonEmptyItemsWithID != null) {
                prev = -1L;
                Items prevItems = null;
                for (Items items : this.nonEmptyItemsWithID) {
                    long thisTime = items.timeLastSent;
                    if (thisTime < prev) {
                        Logger.error(this, "Inconsistent order in non empty items with ID: prev timeout was " + prev + " for " + prevItems + " but this timeout is " + thisTime + " for " + items, (Throwable)new Exception("error"));
                    }
                    prev = thisTime;
                    prevItems = items;
                }
            }
            if (this.itemsNonUrgent != null) {
                prev = -1L;
                MessageItem prevItem = null;
                for (MessageItem item : this.itemsNonUrgent) {
                    if (item.submitted < prev) {
                        Logger.error(this, "Inconsistent order in itemsNonUrgent: prev submitted at " + prev + " but this at " + item.submitted + " prev is " + prevItem + " this is " + item);
                    }
                    prev = item.submitted;
                    prevItem = item;
                }
            }
        }

        public long getNextUrgentTime(long t, long stopIfBeforeTime) {
            if (!this.roundRobinBetweenUIDs) {
                if (this.itemsNonUrgent != null && !this.itemsNonUrgent.isEmpty() && (t = Math.min(t, this.itemsNonUrgent.getFirst().submitted + this.timeout)) <= stopIfBeforeTime) {
                    return t;
                }
                assert (this.nonEmptyItemsWithID == null);
                assert (this.itemsByID == null);
            } else {
                if (this.nonEmptyItemsWithID != null) {
                    for (Items items : this.nonEmptyItemsWithID) {
                        if (items.items.isEmpty() || !(items.timeLastSent > 0L ? (t = Math.min(t, items.timeLastSent + this.timeout)) <= stopIfBeforeTime : (t = Math.min(t, items.items.getFirst().submitted + this.timeout)) <= stopIfBeforeTime)) continue;
                        return t;
                    }
                }
                if (this.itemsNonUrgent != null && !this.itemsNonUrgent.isEmpty()) {
                    for (MessageItem item : this.itemsNonUrgent) {
                        Items items;
                        long uid = item.getID();
                        Items items2 = items = this.itemsByID == null ? null : this.itemsByID.get(uid);
                        if (items != null && items.timeLastSent > 0L) {
                            if ((t = Math.min(t, items.timeLastSent + this.timeout)) > stopIfBeforeTime) continue;
                            return t;
                        }
                        if ((t = Math.min(t, item.submitted + this.timeout)) <= stopIfBeforeTime) {
                            return t;
                        }
                        if (this.itemsByID != null) continue;
                        break;
                    }
                }
            }
            return t;
        }

        public int addSize(int length, int maxSize) {
            if (this.itemsNonUrgent != null) {
                for (MessageItem item : this.itemsNonUrgent) {
                    int thisLen = item.getLength();
                    if ((length += thisLen) <= maxSize) continue;
                    return length;
                }
            }
            if (this.nonEmptyItemsWithID != null) {
                for (Items list : this.nonEmptyItemsWithID) {
                    for (MessageItem item : list.items) {
                        int thisLen = item.getLength();
                        if ((length += thisLen) <= maxSize) continue;
                        return length;
                    }
                }
            }
            return length;
        }

        private MessageItem addNonUrgentMessages(long now) {
            if (logMINOR) {
                this.checkOrder();
            }
            if (this.itemsNonUrgent == null) {
                return null;
            }
            ListIterator items = this.itemsNonUrgent.listIterator();
            while (items.hasNext()) {
                long id;
                Items tracker;
                MessageItem item = (MessageItem)items.next();
                items.remove();
                item.setDeadline(item.submitted + this.timeout);
                MessageItem ret = item;
                if (this.itemsByID != null && (tracker = this.itemsByID.get(id = item.getID())) != null) {
                    tracker.timeLastSent = now;
                    DoublyLinkedList parent = tracker.getParent();
                    if (tracker.items.isEmpty()) {
                        if (logDEBUG) {
                            Logger.debug(this, "Moving " + tracker + " to end of empty list in addNonUrgentMessages");
                        }
                        if (this.emptyItemsWithID == null) {
                            this.emptyItemsWithID = new DoublyLinkedListImpl();
                        }
                        if (parent == null) {
                            Logger.error(this, "Tracker is in itemsByID but not in either list! (empty)");
                        } else if (parent == this.emptyItemsWithID) {
                            this.emptyItemsWithID.remove(tracker);
                        } else if (parent == this.nonEmptyItemsWithID) {
                            Logger.error(this, "Tracker is in non empty items list when is empty");
                            this.nonEmptyItemsWithID.remove(tracker);
                        } else assert (false);
                        this.addToEmptyBackward(tracker);
                    } else {
                        if (logDEBUG) {
                            Logger.debug(this, "Moving " + tracker + " to end of non-empty list in addNonUrgentMessages");
                        }
                        if (this.nonEmptyItemsWithID == null) {
                            this.nonEmptyItemsWithID = new DoublyLinkedListImpl();
                        }
                        if (parent == null) {
                            Logger.error(this, "Tracker is in itemsByID but not in either list! (non-empty)");
                        } else if (parent == this.nonEmptyItemsWithID) {
                            this.nonEmptyItemsWithID.remove(tracker);
                        } else if (parent == this.emptyItemsWithID) {
                            Logger.error(this, "Tracker is in empty items list when is non-empty");
                            this.emptyItemsWithID.remove(tracker);
                        } else assert (false);
                        this.addToNonEmptyBackward(tracker);
                    }
                }
                if (logMINOR) {
                    this.checkOrder();
                }
                if (ret == null) continue;
                return ret;
            }
            if (logMINOR) {
                this.checkOrder();
            }
            return null;
        }

        private MessageItem addUrgentMessages(long now) {
            if (logMINOR) {
                this.checkOrder();
            }
            int lists = 0;
            if (this.nonEmptyItemsWithID == null) {
                if (logMINOR) {
                    Logger.minor(this, "No non-empty items to send, not sending any urgent messages");
                }
                return null;
            }
            lists += this.nonEmptyItemsWithID.size();
            Items list = this.nonEmptyItemsWithID.head();
            for (int i = 0; i < lists && list != null; ++i) {
                if (logMINOR) {
                    this.checkOrder();
                }
                if (list.items.isEmpty()) {
                    Logger.error(this, "List is in nonEmptyItemsWithID yet it is empty?!: " + list);
                    this.nonEmptyItemsWithID.remove(list);
                    this.addToEmptyBackward(list);
                    if (this.nonEmptyItemsWithID.isEmpty()) {
                        if (logMINOR) {
                            Logger.minor(this, "Run out of non-empty items to send");
                        }
                        return null;
                    }
                    list = this.nonEmptyItemsWithID.head();
                    continue;
                }
                MessageItem item = list.items.getFirst();
                list.items.removeFirst();
                Items prev = (Items)list.getPrev();
                this.nonEmptyItemsWithID.remove(list);
                item.setDeadline(list.timeLastSent + this.timeout);
                list.timeLastSent = now;
                if (!list.items.isEmpty()) {
                    if (logDEBUG) {
                        Logger.debug(this, "Moving " + list + " to end of non empty list in addUrgentMessages");
                    }
                    this.addToNonEmptyBackward(list);
                } else {
                    if (logDEBUG) {
                        Logger.debug(this, "Moving " + list + " to end of empty list in addUrgentMessages");
                    }
                    this.addToEmptyBackward(list);
                }
                list = prev == null ? this.nonEmptyItemsWithID.head() : (Items)prev.getNext();
                MessageItem ret = item;
                if (logMINOR) {
                    this.checkOrder();
                }
                if (ret == null) continue;
                return ret;
            }
            if (logDEBUG) {
                Logger.debug(this, "No more messages queued at this priority");
            }
            if (logMINOR) {
                this.checkOrder();
            }
            return null;
        }

        MessageItem addPriorityMessages(long now) {
            if (logMINOR) {
                int byID;
                int nonEmpty = this.nonEmptyItemsWithID == null ? 0 : this.nonEmptyItemsWithID.size();
                int empty = this.emptyItemsWithID == null ? 0 : this.emptyItemsWithID.size();
                int n = byID = this.itemsByID == null ? 0 : this.itemsByID.size();
                if (nonEmpty + empty < byID) {
                    Logger.error(this, "Leaking itemsByID? non empty = " + nonEmpty + " empty = " + empty + " by ID = " + byID + " on " + this);
                } else if (logDEBUG) {
                    Logger.debug(this, "Items: non empty " + nonEmpty + " empty " + empty + " by ID " + byID + " on " + this);
                }
            }
            if (this.roundRobinBetweenUIDs) {
                this.moveToUrgent(now);
            }
            this.clearOldNonUrgent(now);
            if (this.roundRobinBetweenUIDs) {
                MessageItem item = this.addUrgentMessages(now);
                if (item != null) {
                    return item;
                }
            } else assert (this.itemsByID == null);
            return this.addNonUrgentMessages(now);
        }

        private void clearOldNonUrgent(long now) {
            block9: {
                if (logMINOR) {
                    this.checkOrder();
                }
                int removed = 0;
                if (this.emptyItemsWithID == null) {
                    return;
                }
                while (true) {
                    if (logMINOR) {
                        this.checkOrder();
                    }
                    if (this.emptyItemsWithID.isEmpty()) {
                        return;
                    }
                    Items list = this.emptyItemsWithID.head();
                    if (!list.items.isEmpty()) {
                        Logger.error(this, "List with items in emptyItemsWithID!!");
                        this.emptyItemsWithID.remove(list);
                        this.addToNonEmptyBackward(list);
                        return;
                    }
                    if (list.timeLastSent != -1L && now - list.timeLastSent <= 180000L) break;
                    Items old = this.itemsByID.remove(list.id);
                    if (old == null) {
                        Logger.error(this, "List was not in the items by ID tracker: " + list.id);
                    } else if (old != list) {
                        Logger.error(this, "Different list in the items by ID tracker: " + old + " not " + list + " for " + list.id);
                    }
                    this.emptyItemsWithID.remove(list);
                    ++removed;
                }
                if (!logDEBUG || removed <= 0) break block9;
                Logger.debug(this, "Removed " + removed + " old empty UID trackers");
            }
        }

        public void clear() {
            this.emptyItemsWithID = null;
            this.nonEmptyItemsWithID = null;
            this.itemsByID = null;
            this.itemsNonUrgent = null;
            if (logMINOR) {
                this.checkOrder();
            }
        }

        public boolean removeMessage(MessageItem item) {
            Items list;
            if (logMINOR) {
                this.checkOrder();
            }
            long id = item.getID();
            if (this.itemsByID != null && (list = this.itemsByID.get(id)) != null && list.remove(item)) {
                if (list.items.isEmpty()) {
                    this.nonEmptyItemsWithID.remove(list);
                    this.addToEmptyBackward(list);
                }
                if (logMINOR) {
                    this.checkOrder();
                }
                return true;
            }
            if (logMINOR) {
                this.checkOrder();
            }
            if (this.itemsNonUrgent != null) {
                return this.itemsNonUrgent.remove(item);
            }
            return false;
        }

        public void removeUIDs(Long[] list) {
            if (logMINOR) {
                this.checkOrder();
            }
            if (this.itemsByID == null) {
                return;
            }
            for (Long l : list) {
                Items items = this.itemsByID.get(l);
                if (items == null || !items.items.isEmpty()) continue;
                this.itemsByID.remove(l);
                assert (this.emptyItemsWithID != null);
                assert (items.getParent() == this.emptyItemsWithID);
                this.emptyItemsWithID.remove(items);
            }
            if (logMINOR) {
                this.checkOrder();
            }
        }

        public boolean isEmpty() {
            if (this.itemsNonUrgent != null && !this.itemsNonUrgent.isEmpty()) {
                return false;
            }
            if (this.nonEmptyItemsWithID != null) {
                for (Items items : this.nonEmptyItemsWithID) {
                    if (items.items.isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }

        private static class Items
        extends DoublyLinkedListImpl.Item<Items> {
            final LinkedList<MessageItem> items = new LinkedList();
            final long id;
            long timeLastSent;

            Items(long id, long initialTimeLastSent) {
                this.id = id;
                this.timeLastSent = initialTimeLastSent;
            }

            public void addLast(MessageItem item) {
                this.items.addLast(item);
            }

            public void addFirst(MessageItem item) {
                this.items.addFirst(item);
            }

            public boolean remove(MessageItem item) {
                return this.items.remove(item);
            }

            public String toString() {
                return super.toString() + ":" + this.id + ":" + this.items.size() + ":" + this.timeLastSent;
            }
        }
    }
}

