/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.clients.fcp.BookmarkFeed;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.DarknetPeerNode;
import freenet.node.PeerNode;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.support.HTMLNode;
import java.lang.ref.WeakReference;

public class BookmarkFeedUserAlert
extends AbstractUserAlert {
    private final WeakReference<PeerNode> peerRef;
    private final FreenetURI uri;
    private final int fileNumber;
    private final String name;
    private final String description;
    private final boolean hasAnActivelink;
    private final long composed;
    private final long sent;
    private final long received;
    private String sourceNodeName;

    public BookmarkFeedUserAlert(DarknetPeerNode sourcePeerNode, String name, String description, boolean hasAnActivelink, int fileNumber, FreenetURI uri, long composed, long sent, long received) {
        super(true, null, null, null, null, (short)3, true, null, true, null);
        this.name = name;
        this.description = description;
        this.uri = uri;
        this.fileNumber = fileNumber;
        this.hasAnActivelink = hasAnActivelink;
        this.composed = composed;
        this.sent = sent;
        this.received = received;
        this.peerRef = sourcePeerNode.getWeakRef();
        this.sourceNodeName = sourcePeerNode.getName();
    }

    @Override
    public String getTitle() {
        return this.l10n("title", "from", this.sourceNodeName);
    }

    @Override
    public String getText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.l10n("peerName")).append(" ").append(this.name).append("\n");
        sb.append(this.l10n("bookmarkURI")).append(" ").append(this.uri).append("\n");
        if (this.description != null && !this.description.isEmpty()) {
            sb.append(this.l10n("bookmarkDescription")).append(" ").append(this.description);
        }
        return sb.toString();
    }

    @Override
    public String getShortText() {
        return this.getTitle();
    }

    @Override
    public HTMLNode getHTMLText() {
        HTMLNode alertNode = new HTMLNode("div");
        alertNode.addChild("a", "href", "/?newbookmark=" + this.uri + "&desc=" + this.name + "&hasAnActivelink=" + this.hasAnActivelink).addChild("img", new String[]{"src", "alt", "title"}, new String[]{"/static/icon/bookmark-new.png", this.l10n("addAsABookmark"), this.l10n("addAsABookmark")});
        alertNode.addChild("a", "href", "/freenet:" + this.uri.toString()).addChild("#", this.name);
        if (this.description != null && !this.description.isEmpty()) {
            String[] lines = this.description.split("\n");
            alertNode.addChild("br");
            alertNode.addChild("br");
            alertNode.addChild("#", this.l10n("bookmarkDescription"));
            alertNode.addChild("br");
            for (int i = 0; i < lines.length; ++i) {
                alertNode.addChild("#", lines[i]);
                if (i == lines.length - 1) continue;
                alertNode.addChild("br");
            }
        }
        return alertNode;
    }

    @Override
    public String dismissButtonText() {
        return this.l10n("delete");
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("BookmarkFeedUserAlert." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("BookmarkFeedUserAlert." + key, pattern, value);
    }

    @Override
    public void onDismiss() {
        DarknetPeerNode pn = (DarknetPeerNode)this.peerRef.get();
        if (pn != null) {
            pn.deleteExtraPeerDataFile(this.fileNumber);
        }
    }

    @Override
    public BookmarkFeed getFCPMessage() {
        return new BookmarkFeed(this.getTitle(), this.getShortText(), this.getText(), this.getPriorityClass(), this.getUpdatedTime(), this.sourceNodeName, this.composed, this.sent, this.received, this.name, this.uri, this.description, this.hasAnActivelink);
    }

    @Override
    public boolean isValid() {
        DarknetPeerNode pn = (DarknetPeerNode)this.peerRef.get();
        if (pn != null) {
            this.sourceNodeName = pn.getName();
        }
        return true;
    }
}

