/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.crypt.MasterSecret;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.io.BucketTools;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ReadOnlyRandomAccessBuffer
implements LockableRandomAccessBuffer {
    private final LockableRandomAccessBuffer underlying;
    static final int MAGIC = 1686971610;

    public ReadOnlyRandomAccessBuffer(LockableRandomAccessBuffer underlying) {
        this.underlying = underlying;
    }

    public ReadOnlyRandomAccessBuffer(DataInputStream dis, FilenameGenerator fg, PersistentFileTracker persistentFileTracker, MasterSecret masterSecret) throws IOException, StorageFormatException, ResumeFailedException {
        this.underlying = BucketTools.restoreRAFFrom(dis, fg, persistentFileTracker, masterSecret);
    }

    @Override
    public long size() {
        return this.underlying.size();
    }

    @Override
    public void pread(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        this.underlying.pread(fileOffset, buf, bufOffset, length);
    }

    @Override
    public void pwrite(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        throw new IOException("Read only");
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    @Override
    public void free() {
        this.underlying.free();
    }

    @Override
    public LockableRandomAccessBuffer.RAFLock lockOpen() throws IOException {
        return this.underlying.lockOpen();
    }

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
        this.underlying.onResume(context);
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(1686971610);
        this.underlying.storeTo(dos);
    }

    @Override
    public int hashCode() {
        return this.underlying.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReadOnlyRandomAccessBuffer other = (ReadOnlyRandomAccessBuffer)obj;
        return this.underlying.equals(other.underlying);
    }
}

