/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientBaseCallback;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientPutState;
import freenet.client.async.HealingDecisionSupplier;
import freenet.client.async.HealingQueue;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleBlockInserter;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.node.RequestClientBuilder;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import java.util.HashMap;
import java.util.Map;

public class SimpleHealingQueue
extends BaseClientPutter
implements HealingQueue,
PutCompletionCallback {
    private static final long serialVersionUID = -2884613086588264043L;
    final int maxRunning;
    int counter;
    InsertContext ctx;
    private final HealingDecisionSupplier healingDecisionSupplier;
    final Map<Bucket, SingleBlockInserter> runningInserters;
    private static volatile boolean logMINOR;
    static final RequestClient REQUEST_CLIENT;

    public SimpleHealingQueue(InsertContext context, short prio, int maxRunning, HealingDecisionSupplier healingDecisionSupplier) {
        super(prio, REQUEST_CLIENT);
        this.ctx = context;
        this.healingDecisionSupplier = healingDecisionSupplier;
        this.runningInserters = new HashMap<Bucket, SingleBlockInserter>();
        this.maxRunning = maxRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean innerQueue(Bucket data, byte[] cryptoKey, byte cryptoAlgorithm, ClientContext context) {
        SingleBlockInserter sbi;
        int ctr;
        SimpleHealingQueue simpleHealingQueue = this;
        synchronized (simpleHealingQueue) {
            ctr = this.counter++;
            if (this.runningInserters.size() > this.maxRunning) {
                return false;
            }
            try {
                sbi = new SingleBlockInserter(this, data, -1, FreenetURI.EMPTY_CHK_URI, this.ctx, this.realTimeFlag, this, false, 32768, ctr, false, false, data, context, false, true, 0, cryptoAlgorithm, cryptoKey);
            }
            catch (Throwable e) {
                Logger.error(this, "Caught trying to insert healing block: " + e, e);
                return false;
            }
            if (this.isHealingThisBlockSimilarToForwarding(context, sbi)) {
                this.runningInserters.put(data, sbi);
            }
        }
        try {
            sbi.schedule(context);
            if (logMINOR) {
                Logger.minor(this, "Started healing insert " + ctr + " for " + data);
            }
            return true;
        }
        catch (Throwable e) {
            Logger.error(this, "Caught trying to insert healing block: " + e, e);
            return false;
        }
    }

    private boolean isHealingThisBlockSimilarToForwarding(ClientContext context, SingleBlockInserter sbi) {
        sbi.tryEncode(context);
        double keyLocation = sbi.getKeyNoEncode().getNodeKey().toNormalizedDouble();
        return this.healingDecisionSupplier.shouldHeal(keyLocation);
    }

    @Override
    public void queue(Bucket data, byte[] cryptoKey, byte cryptoAlgorithm, ClientContext context) {
        if (!this.innerQueue(data, cryptoKey, cryptoAlgorithm, context)) {
            data.free();
        }
    }

    @Override
    public FreenetURI getURI() {
        return FreenetURI.EMPTY_CHK_URI;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    protected void innerNotifyClients(ClientContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(ClientPutState state, ClientContext context) {
        SingleBlockInserter sbi = (SingleBlockInserter)state;
        Bucket data = (Bucket)sbi.getToken();
        SimpleHealingQueue simpleHealingQueue = this;
        synchronized (simpleHealingQueue) {
            this.runningInserters.remove(data);
        }
        if (logMINOR) {
            Logger.minor(this, "Successfully inserted healing block: " + sbi.getURINoEncode() + " for " + data + " (" + sbi.token + ')');
        }
        data.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(InsertException e, ClientPutState state, ClientContext context) {
        SingleBlockInserter sbi = (SingleBlockInserter)state;
        Bucket data = (Bucket)sbi.getToken();
        SimpleHealingQueue simpleHealingQueue = this;
        synchronized (simpleHealingQueue) {
            this.runningInserters.remove(data);
        }
        if (logMINOR) {
            Logger.minor(this, "Failed to insert healing block: " + sbi.getURINoEncode() + " : " + e + " for " + data + " (" + sbi.token + ')', (Throwable)e);
        }
        data.free();
    }

    @Override
    public void onEncode(BaseClientKey usk, ClientPutState state, ClientContext context) {
    }

    @Override
    public void onTransition(ClientPutState oldState, ClientPutState newState, ClientContext context) {
        Logger.error(this, "impossible: onTransition on SimpleHealingQueue from " + oldState + " to " + newState, (Throwable)new Exception("debug"));
    }

    @Override
    public void onMetadata(Metadata m, ClientPutState state, ClientContext context) {
        Logger.error(this, "Got metadata on SimpleHealingQueue from " + state + ": " + m, (Throwable)new Exception("debug"));
    }

    @Override
    public void onBlockSetFinished(ClientPutState state, ClientContext context) {
    }

    @Override
    public void onFetchable(ClientPutState state) {
    }

    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ClientContext context) {
    }

    @Override
    protected void innerToNetwork(ClientContext context) {
    }

    @Override
    public void cancel(ClientContext context) {
        super.cancel();
    }

    @Override
    public int getMinSuccessFetchBlocks() {
        return 0;
    }

    @Override
    public void onMetadata(Bucket meta, ClientPutState state, ClientContext context) {
        Logger.error(this, "onMetadata() in SimpleHealingQueue - impossible", (Throwable)new Exception("error"));
        meta.free();
    }

    @Override
    public void innerOnResume(ClientContext context) {
    }

    @Override
    protected ClientBaseCallback getCallback() {
        return null;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        REQUEST_CLIENT = new RequestClientBuilder().build();
    }
}

