/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.DataFilterException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class VP8PacketFilter {
    private boolean isWebP;

    public VP8PacketFilter(boolean isWebp) {
        this.isWebP = isWebp;
    }

    public void parse(byte[] buf, int size) throws IOException {
        try (DataInputStream input = new DataInputStream(new ByteArrayInputStream(buf));){
            boolean isKeyframe;
            int[] header = new int[6];
            for (int i = 0; i < 6; ++i) {
                header[i] = input.readUnsignedByte();
            }
            int tmp = header[0] | header[1] << 8 | header[2] << 16;
            boolean bl = isKeyframe = (tmp & 1) == 0;
            if (!isKeyframe && this.isWebP) {
                throw new DataFilterException("VP8 decode error", "VP8 decode error", "Not a keyframe in WebP image");
            }
            if ((tmp & 8) != 0) {
                throw new DataFilterException("VP8 decode error", "VP8 decode error", "VP8 frame version is unsupported");
            }
            if ((tmp & 0x10) == 0 && this.isWebP) {
                throw new DataFilterException("VP8 decode error", "VP8 decode error", "WebP frame contains an image without is_shown flag");
            }
            int sizeInHeader = tmp >> 5 & 0x7FFFF;
            if (size <= sizeInHeader + (isKeyframe ? 10 : 3)) {
                throw new DataFilterException("VP8 decode error", "VP8 decode error", "VP8 frame size is invalid");
            }
            if (isKeyframe && (header[3] != 157 || header[4] != 1 || header[5] != 42)) {
                throw new DataFilterException("VP8 decode error", "VP8 decode error", "VP8 frame sync code is invalid");
            }
        }
    }
}

