/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.clients.http.Cookie;
import freenet.clients.http.FProxyFetchInProgress;
import freenet.clients.http.HTTPRequestImpl;
import freenet.clients.http.PageMaker;
import freenet.clients.http.ReceivedCookie;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContainer;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.annotation.AllowData;
import freenet.clients.http.bookmark.BookmarkManager;
import freenet.crypt.SSL;
import freenet.l10n.NodeL10n;
import freenet.node.useralerts.UserAlertManager;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.TimeUtil;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.HTTPRequest;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class ToadletContextImpl
implements ToadletContext {
    private static final Class<?>[] HANDLE_PARAMETERS = new Class[]{URI.class, HTTPRequest.class, ToadletContext.class};
    private static final String METHODS_MUST_HAVE_DATA = "POST";
    private static final String METHODS_CANNOT_HAVE_DATA = "GET";
    private static final String METHODS_RESTRICTED_MODE = "GET POST";
    private final MultiValueTable<String, String> headers;
    private ArrayList<ReceivedCookie> cookies;
    private ArrayList<Cookie> replyCookies;
    private final OutputStream sockOutputStream;
    private final PageMaker pagemaker;
    private final BucketFactory bf;
    private final ToadletContainer container;
    private final UserAlertManager userAlertManager;
    private final BookmarkManager bookmarkManager;
    private final InetAddress remoteAddr;
    private Exception firstReplySendingException;
    private volatile Toadlet activeToadlet;
    private final String uniqueId;
    private URI uri;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private boolean closed;
    private boolean shouldDisconnect;
    static TimeZone TZ_UTC;

    public ToadletContextImpl(Socket sock, MultiValueTable<String, String> headers, BucketFactory bf, PageMaker pageMaker, ToadletContainer container, UserAlertManager userAlertManager, BookmarkManager bookmarkManager, URI uri, long uniqueID) throws IOException {
        this.headers = headers;
        this.cookies = null;
        this.replyCookies = null;
        this.closed = false;
        this.uri = uri;
        this.sockOutputStream = sock.getOutputStream();
        this.remoteAddr = sock.getInetAddress();
        if (logDEBUG) {
            Logger.debug(this, "Connection from " + this.remoteAddr);
        }
        this.bf = bf;
        this.pagemaker = pageMaker;
        this.container = container;
        this.userAlertManager = userAlertManager;
        this.bookmarkManager = bookmarkManager;
        this.uniqueId = String.valueOf(Math.random());
    }

    private void close() {
        this.closed = true;
    }

    private void sendMethodNotAllowed(String method, boolean shouldDisconnect) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        MultiValueTable<String, String> mvt = MultiValueTable.from("Allow", "GET, PUT");
        ToadletContextImpl.sendError(this.sockOutputStream, 405, "Method Not Allowed", ToadletContextImpl.l10n("methodNotAllowed"), shouldDisconnect, mvt);
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("ToadletContextImpl." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("ToadletContextImpl." + key, new String[]{pattern}, new String[]{value});
    }

    private static void sendError(OutputStream os, int code, String httpReason, String message, boolean shouldDisconnect, MultiValueTable<String, String> mvt) throws IOException {
        ToadletContextImpl.sendHTMLError(os, code, httpReason, "<html><head><title>" + message + "</title></head><body><h1>" + message + "</h1></body>", shouldDisconnect, mvt);
    }

    private static void sendHTMLError(OutputStream os, int code, String httpReason, String htmlMessage, boolean disconnect, MultiValueTable<String, String> mvt) throws IOException {
        if (mvt == null) {
            mvt = new MultiValueTable();
        }
        byte[] messageBytes = htmlMessage.getBytes(StandardCharsets.UTF_8);
        ToadletContextImpl.sendReplyHeaders(os, code, httpReason, mvt, "text/html; charset=UTF-8", messageBytes.length, null, disconnect, false, false);
        os.write(messageBytes);
    }

    private void sendNoToadletError(boolean shouldDisconnect) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        ToadletContextImpl.sendError(this.sockOutputStream, 404, "Not Found", ToadletContextImpl.l10n("noSuchToadlet"), shouldDisconnect, null);
    }

    private static void sendURIParseError(OutputStream os, boolean shouldDisconnect, Throwable e) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        String message = "<html><head><title>" + ToadletContextImpl.l10n("uriParseErrorTitle") + "</title></head><body><p>" + HTMLEncoder.encode(e.getMessage()) + "</p><pre>\n" + sw.toString();
        ToadletContextImpl.sendHTMLError(os, 400, "Bad Request", message, shouldDisconnect, null);
    }

    @Override
    public void sendReplyHeaders(int code, String desc, MultiValueTable<String, String> mvt, String mimeType, long length) throws ToadletContextClosedException, IOException {
        this.sendReplyHeaders(code, desc, mvt, mimeType, length, false);
    }

    @Override
    public void sendReplyHeaders(int code, String desc, MultiValueTable<String, String> mvt, String mimeType, long length, boolean forceDisableJavascript) throws ToadletContextClosedException, IOException {
        boolean enableJavascript = !forceDisableJavascript && this.container.isFProxyJavascriptEnabled();
        this.sendReplyHeaders(code, desc, mvt, mimeType, length, null, false, false, enableJavascript);
    }

    @Override
    @Deprecated
    public void sendReplyHeaders(int code, String desc, MultiValueTable<String, String> mvt, String mimeType, long length, Date mTime) throws ToadletContextClosedException, IOException {
        if (mTime != null) {
            this.sendReplyHeadersStatic(code, desc, mvt, mimeType, length, mTime);
        } else {
            this.sendReplyHeaders(code, desc, mvt, mimeType, length);
        }
    }

    @Override
    public void sendReplyHeadersStatic(int replyCode, String replyDescription, MultiValueTable<String, String> mvt, String mimeType, long contentLength, Date mTime) throws ToadletContextClosedException, IOException {
        if (mTime == null) {
            throw new IllegalArgumentException();
        }
        this.sendReplyHeaders(replyCode, replyDescription, mvt, mimeType, contentLength, mTime, false, false, false);
    }

    @Override
    public void sendReplyHeadersFProxy(int replyCode, String replyDescription, MultiValueTable<String, String> mvt, String mimeType, long contentLength) throws ToadletContextClosedException, IOException {
        boolean enableJavascript = this.container.isFProxyWebPushingEnabled() && this.container.isFProxyJavascriptEnabled();
        this.sendReplyHeaders(replyCode, replyDescription, mvt, mimeType, contentLength, null, false, true, enableJavascript);
    }

    private void sendReplyHeaders(int replyCode, String replyDescription, MultiValueTable<String, String> mvt, String mimeType, long contentLength, Date mTime, boolean isOutlinkConfirmationPage, boolean allowFrames, boolean enableJavascript) throws ToadletContextClosedException, IOException {
        String HSTS;
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        if (this.firstReplySendingException != null) {
            throw new IllegalStateException("Already sent headers!", this.firstReplySendingException);
        }
        this.firstReplySendingException = new Exception();
        if (mvt == null) {
            mvt = new MultiValueTable();
        }
        if (this.replyCookies != null) {
            for (Cookie cookie : this.replyCookies) {
                String cookieHeader = cookie.encodeToHeaderValue();
                mvt.put("set-cookie", cookieHeader);
                if (!logMINOR) continue;
                Logger.minor(this, "set-cookie: " + cookieHeader);
            }
        }
        if (this.container.isSSL() && !(HSTS = SSL.getHSTSHeader()).isEmpty() && !mvt.containsKey("strict-transport-security")) {
            mvt.put("strict-transport-security", HSTS);
        }
        ToadletContextImpl.sendReplyHeaders(this.sockOutputStream, replyCode, replyDescription, mvt, mimeType, contentLength, mTime, this.shouldDisconnect, enableJavascript, allowFrames);
    }

    @Override
    public PageMaker getPageMaker() {
        return this.pagemaker;
    }

    @Override
    public String getFormPassword() {
        return this.container.getFormPassword();
    }

    @Override
    public boolean checkFormPassword(HTTPRequest request) throws ToadletContextClosedException, IOException {
        return this.checkFormPassword(request, "/");
    }

    @Override
    public boolean checkFormPassword(HTTPRequest request, String redirectTo) throws ToadletContextClosedException, IOException {
        if (!this.hasFormPassword(request)) {
            MultiValueTable<String, String> headers = MultiValueTable.from("Location", redirectTo);
            this.sendReplyHeaders(302, "Found", headers, null, 0L);
            return false;
        }
        return true;
    }

    @Override
    public boolean checkFullAccess(Toadlet toadlet) throws ToadletContextClosedException, IOException {
        if (this.isAllowedFullAccess()) {
            return true;
        }
        toadlet.sendUnauthorizedPage(this);
        return false;
    }

    @Override
    public boolean hasFormPassword(HTTPRequest request) throws IOException {
        byte[] compareBytes;
        String pass = request.getPartAsStringFailsafe("formPassword", 32);
        byte[] inputBytes = pass.getBytes(StandardCharsets.UTF_8);
        if (!MessageDigest.isEqual(inputBytes, compareBytes = this.getFormPassword().getBytes(StandardCharsets.UTF_8))) {
            if (logMINOR) {
                Logger.minor(this, "Bad formPassword: " + pass);
            }
            return false;
        }
        return true;
    }

    @Override
    public UserAlertManager getAlertManager() {
        return this.userAlertManager;
    }

    @Override
    public BookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    @Override
    public MultiValueTable<String, String> getHeaders() {
        return this.headers;
    }

    private void parseCookies() throws ParseException {
        if (this.cookies != null) {
            return;
        }
        int cookieAmount = this.headers.countAll("cookie");
        if (cookieAmount == 0) {
            return;
        }
        this.cookies = new ArrayList(cookieAmount + 1);
        for (String cookieHeader : this.headers.iterateAll("cookie")) {
            ArrayList<ReceivedCookie> parsedCookies = ReceivedCookie.parseHeader(cookieHeader);
            this.cookies.addAll(parsedCookies);
        }
    }

    @Override
    public ReceivedCookie getCookie(URI domain, URI path, String name) throws ParseException {
        this.parseCookies();
        if (this.cookies == null) {
            return null;
        }
        name = name.toLowerCase();
        for (ReceivedCookie cookie : this.cookies) {
            try {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
            catch (RuntimeException e) {
                Logger.error(this, "Error in cookie", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setCookie(Cookie newCookie) {
        if (this.replyCookies == null) {
            this.replyCookies = new ArrayList(4);
        }
        this.replyCookies.add(newCookie);
    }

    static void sendReplyHeaders(OutputStream sockOutputStream, int replyCode, String replyDescription, MultiValueTable<String, String> mvt, String mimeType, long contentLength, Date mTime, boolean disconnect, boolean allowScripts, boolean allowFrames) throws IOException {
        String cacheControl;
        String expiresTime;
        boolean allowCaching;
        if (mvt == null) {
            mvt = new MultiValueTable();
        }
        if (mimeType != null) {
            if (mimeType.equalsIgnoreCase("text/html")) {
                mvt.put("content-type", mimeType + "; charset=UTF-8");
            } else {
                mvt.put("content-type", mimeType);
            }
        }
        if (contentLength >= 0L) {
            mvt.put("content-length", Long.toString(contentLength));
        }
        boolean bl = allowCaching = mTime != null;
        if (allowCaching) {
            expiresTime = TimeUtil.makeHTTPDate(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(30L));
            cacheControl = "public, max-age=" + String.valueOf(2592000);
        } else {
            expiresTime = "Thu, 01 Jan 1970 00:00:00 GMT";
            cacheControl = "private, max-age=0, must-revalidate, no-cache, no-store, post-check=0, pre-check=0";
            mvt.put("pragma", "no-cache");
        }
        mvt.put("expires", expiresTime);
        mvt.put("cache-control", cacheControl);
        String nowString = TimeUtil.makeHTTPDate(System.currentTimeMillis());
        String lastModString = mTime == null ? nowString : TimeUtil.makeHTTPDate(mTime.getTime());
        mvt.put("last-modified", lastModString);
        mvt.put("date", nowString);
        if (disconnect) {
            mvt.put("connection", "close");
        } else {
            mvt.put("connection", "keep-alive");
        }
        String contentSecurityPolicy = ToadletContextImpl.generateCSP(allowScripts, allowFrames);
        mvt.put("content-security-policy", contentSecurityPolicy);
        mvt.put("x-content-security-policy", contentSecurityPolicy);
        mvt.put("x-webkit-csp", contentSecurityPolicy);
        mvt.put("x-frame-options", allowFrames ? "SAMEORIGIN" : "DENY");
        StringBuilder buf = new StringBuilder(1024);
        buf.append("HTTP/1.1 ");
        buf.append(replyCode);
        buf.append(' ');
        buf.append(replyDescription);
        buf.append("\r\n");
        for (Map.Entry<String, List<String>> entry : mvt.entrySet()) {
            String key = ToadletContextImpl.fixKey(entry.getKey());
            List<String> list = entry.getValue();
            for (String s : list) {
                buf.append(key);
                buf.append(": ");
                buf.append(s);
                buf.append("\r\n");
            }
        }
        buf.append("\r\n");
        sockOutputStream.write(buf.toString().getBytes(StandardCharsets.US_ASCII));
    }

    private static String generateCSP(boolean allowScripts, boolean allowFrames) {
        StringBuilder sb = new StringBuilder();
        sb.append("default-src 'self' blob:; script-src ");
        sb.append(allowScripts ? "'self' 'unsafe-inline'; options inline-script" : ToadletContextImpl.generateRestrictedScriptSrc());
        sb.append("; frame-src ");
        sb.append(allowFrames ? "'self'" : "'none'");
        sb.append("; object-src 'none'");
        sb.append("; style-src 'self' 'unsafe-inline'");
        return sb.toString();
    }

    private static String generateRestrictedScriptSrc() {
        String[] allowedScriptHashes = new String[]{"sha256-RY9OjosvFxocXEmcUqBJ2v1KByDRdUgnGHYSL3Qx/t8="};
        if (allowedScriptHashes.length == 0) {
            return "'none'";
        }
        StringJoiner stringJoiner = new StringJoiner("' '", "'", "'");
        for (String source : allowedScriptHashes) {
            stringJoiner.add(source);
        }
        return stringJoiner.toString();
    }

    public static Date parseHTTPDate(String httpDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        sdf.setTimeZone(TZ_UTC);
        return sdf.parse(httpDate);
    }

    private static String fixKey(String key) {
        StringBuilder sb = new StringBuilder(key.length());
        int prev = 0;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (i == 0 || prev == 45) {
                c = Character.toUpperCase(c);
            }
            sb.append(c);
            prev = c;
        }
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    public static void handle(Socket sock, ToadletContainer container, PageMaker pageMaker, UserAlertManager userAlertManager, BookmarkManager bookmarkManager) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[TRYBLOCK]], but top level block is 93[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void callToadletMethod(Toadlet t, String method, URI uri, HTTPRequestImpl req, ToadletContextImpl ctx, Bucket data, Socket sock, boolean methodIsConfigurable) throws Throwable {
        String methodName = "handleMethod" + method;
        if (METHODS_CANNOT_HAVE_DATA.equals(method)) {
            if (data != null) {
                ToadletContextImpl.sendError(sock.getOutputStream(), 400, "Bad Request", "Content not allowed", true, null);
                ctx.close();
                return;
            }
            ctx.setActiveToadlet(t);
            t.handleMethodGET(uri, req, ctx);
            return;
        }
        try {
            Class<?> c = t.getClass();
            Method m = c.getMethod(methodName, HANDLE_PARAMETERS);
            if (methodIsConfigurable) {
                AllowData anno = m.getAnnotation(AllowData.class);
                if (anno == null) {
                    if (data != null) {
                        ToadletContextImpl.sendError(sock.getOutputStream(), 400, "Bad Request", "Content not allowed", true, null);
                        ctx.close();
                        return;
                    }
                } else if (anno.value() && data == null) {
                    ToadletContextImpl.sendError(sock.getOutputStream(), 400, "Bad Request", "Missing Content", true, null);
                    ctx.close();
                    return;
                }
            }
            ctx.setActiveToadlet(t);
            Object[] arglist = new Object[]{uri, req, ctx};
            m.invoke((Object)t, arglist);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
    }

    private void setActiveToadlet(Toadlet t) {
        this.activeToadlet = t;
    }

    @Override
    public Toadlet activeToadlet() {
        return this.activeToadlet;
    }

    private static boolean shouldDisconnectAfterHandled(boolean isHTTP10, MultiValueTable<String, String> headers) {
        String connection = headers.getFirst("connection");
        if (connection != null) {
            if (connection.equalsIgnoreCase("close")) {
                return true;
            }
            if (connection.equalsIgnoreCase("keep-alive")) {
                return false;
            }
        }
        return isHTTP10;
    }

    @Override
    public void writeData(byte[] data, int offset, int length) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        this.sockOutputStream.write(data, offset, length);
    }

    @Override
    public void writeData(byte[] data) throws ToadletContextClosedException, IOException {
        this.writeData(data, 0, data.length);
    }

    @Override
    public void writeData(Bucket data) throws ToadletContextClosedException, IOException {
        if (this.closed) {
            throw new ToadletContextClosedException();
        }
        BucketTools.copyTo(data, this.sockOutputStream, Long.MAX_VALUE);
        data.free();
    }

    @Override
    public BucketFactory getBucketFactory() {
        return this.bf;
    }

    @Override
    public HTMLNode addFormChild(HTMLNode parentNode, String target, String name) {
        return this.container.addFormChild(parentNode, target, name);
    }

    @Override
    public boolean isAllowedFullAccess() {
        return this.container.isAllowedFullAccess(this.remoteAddr);
    }

    @Override
    public boolean isAdvancedModeEnabled() {
        return this.container.isAdvancedModeEnabled();
    }

    @Override
    public boolean doRobots() {
        return this.container.doRobots();
    }

    @Override
    public void forceDisconnect() {
        this.shouldDisconnect = true;
    }

    @Override
    public ToadletContainer getContainer() {
        return this.container;
    }

    @Override
    public boolean disableProgressPage() {
        return this.container.disableProgressPage();
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public FProxyFetchInProgress.REFILTER_POLICY getReFilterPolicy() {
        return this.container.getReFilterPolicy();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        TZ_UTC = TimeZone.getTimeZone("UTC");
    }
}

