/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.wizardsteps;

import freenet.clients.http.ExternalLinkToadlet;
import freenet.clients.http.FirstTimeWizardToadlet;
import freenet.clients.http.SecurityLevelsToadlet;
import freenet.clients.http.wizardsteps.PageHelper;
import freenet.clients.http.wizardsteps.Step;
import freenet.clients.http.wizardsteps.WizardL10n;
import freenet.l10n.NodeL10n;
import freenet.node.MasterKeysFileSizeException;
import freenet.node.MasterKeysWrongPasswordException;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.SecurityLevels;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.api.HTTPRequest;
import freenet.support.io.FileUtil;
import java.io.IOException;

public class SECURITY_PHYSICAL
implements Step {
    private final NodeClientCore core;

    public SECURITY_PHYSICAL(NodeClientCore core) {
        this.core = core;
    }

    @Override
    public void getStep(HTTPRequest request, PageHelper helper) {
        if (request.isParameterSet("error") && this.errorHandler(request, helper)) {
            return;
        }
        HTMLNode contentNode = helper.getPageContent(WizardL10n.l10n("physicalSecurityPageTitle"));
        HTMLNode infoboxContent = helper.getInfobox("infobox-normal", WizardL10n.l10nSec("physicalThreatLevelShort"), contentNode, null, false);
        infoboxContent.addChild("p", WizardL10n.l10nSec("physicalThreatLevel"));
        HTMLNode form = helper.addFormChild(infoboxContent, ".", "physicalSecurityForm");
        HTMLNode div = form.addChild("div", "class", "opennetDiv");
        String controlName = "security-levels.physicalThreatLevel";
        HTMLNode swapWarning = div.addChild("p").addChild("i");
        NodeL10n.getBase().addL10nSubstitution(swapWarning, "SecurityLevels.physicalThreatLevelTruecrypt", new String[]{"bold", "truecrypt"}, new HTMLNode[]{HTMLNode.STRONG, HTMLNode.linkInNewWindow(ExternalLinkToadlet.escape("http://www.truecrypt.org/"))});
        FileUtil.OperatingSystem os = FileUtil.detectedOS;
        div.addChild("p", NodeL10n.getBase().getString("SecurityLevels.physicalThreatLevelSwapfile", "operatingSystem", NodeL10n.getBase().getString("OperatingSystemName." + os.name())));
        if (os == FileUtil.OperatingSystem.Windows) {
            swapWarning.addChild("#", " " + WizardL10n.l10nSec("physicalThreatLevelSwapfileWindows"));
        }
        for (SecurityLevels.PHYSICAL_THREAT_LEVEL level : SecurityLevels.PHYSICAL_THREAT_LEVEL.values()) {
            HTMLNode input = div.addChild("p").addChild("input", new String[]{"type", "name", "value", "id"}, new String[]{"radio", controlName, level.name(), controlName + level.name()});
            input.addChild("label", new String[]{"for"}, new String[]{controlName + level.name()}).addChild("b", WizardL10n.l10nSec("physicalThreatLevel.name." + (Object)((Object)level)));
            input.addChild("#", ": ");
            NodeL10n.getBase().addL10nSubstitution(input, "SecurityLevels.physicalThreatLevel.choice." + (Object)((Object)level), new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
            if (level != SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH || this.core.getNode().getSecurityLevels().getPhysicalThreatLevel() == level) continue;
            HTMLNode p = div.addChild("p");
            p.addChild("label", "for", "passwordBox", WizardL10n.l10nSec("setPasswordLabel") + ":");
            p.addChild("input", new String[]{"id", "type", "name"}, new String[]{"passwordBox", "password", "masterPassword"});
            p.addChild("label", "for", "confirmPasswordBox", WizardL10n.l10nSec("confirmPasswordLabel") + ":");
            p.addChild("input", new String[]{"id", "type", "name"}, new String[]{"confirmPasswordBox", "password", "confirmMasterPassword"});
        }
        div.addChild("#", WizardL10n.l10nSec("physicalThreatLevelEnd"));
        form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "back", NodeL10n.getBase().getString("Toadlet.back")});
        form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "next", NodeL10n.getBase().getString("Toadlet.next")});
    }

    private boolean errorHandler(HTTPRequest request, PageHelper helper) {
        String physicalThreatLevel = request.getParam("newThreatLevel");
        SecurityLevels.PHYSICAL_THREAT_LEVEL newThreatLevel = SecurityLevels.parsePhysicalThreatLevel(physicalThreatLevel);
        String error = request.getParam("error");
        if (error.equals("pass")) {
            boolean forUpgrade;
            boolean forDowngrade;
            String infoboxTitleKey;
            String pageTitleKey;
            PASSWORD_PROMPT type;
            try {
                type = PASSWORD_PROMPT.valueOf(request.getParam("type"));
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            boolean wasWrong = type == PASSWORD_PROMPT.DECRYPT_WRONG;
            switch (type) {
                case SET_BLANK: {
                    pageTitleKey = "passwordPageTitle";
                    infoboxTitleKey = "enterPasswordTitle";
                    forDowngrade = false;
                    forUpgrade = true;
                    break;
                }
                case DECRYPT_WRONG: {
                    pageTitleKey = "passwordForDecryptTitle";
                    infoboxTitleKey = "passwordWrongTitle";
                    forDowngrade = false;
                    forUpgrade = false;
                    break;
                }
                case DECRYPT_BLANK: {
                    pageTitleKey = "passwordForDecryptTitle";
                    infoboxTitleKey = "passwordForDecryptTitle";
                    forDowngrade = true;
                    forUpgrade = false;
                    break;
                }
                case SET_NO_MATCH: {
                    pageTitleKey = "passwordPageTitle";
                    infoboxTitleKey = "enterPasswordTitle";
                    forDowngrade = false;
                    forUpgrade = true;
                    break;
                }
                default: {
                    return false;
                }
            }
            HTMLNode contentNode = helper.getPageContent(WizardL10n.l10nSec(pageTitleKey));
            HTMLNode content = helper.getInfobox("infobox-error", WizardL10n.l10nSec(infoboxTitleKey), contentNode, null, true);
            if (type == PASSWORD_PROMPT.SET_BLANK || type == PASSWORD_PROMPT.DECRYPT_BLANK) {
                content.addChild("p", WizardL10n.l10nSec("passwordNotZeroLength"));
            } else if (type == PASSWORD_PROMPT.SET_NO_MATCH) {
                content.addChild("p", WizardL10n.l10nSec("passwordsDoNotMatch"));
            }
            HTMLNode form = helper.addFormChild(content, ".", "masterPasswordForm");
            SecurityLevelsToadlet.generatePasswordFormPage(wasWrong, form, content, forDowngrade, forUpgrade, newThreatLevel.name(), null);
            this.addBackToPhysicalSeclevelsButton(form);
            return true;
        }
        if (error.equals("corrupt")) {
            SecurityLevelsToadlet.sendPasswordFileCorruptedPageInner(helper, this.core.getNode().getMasterPasswordFile().getPath());
            return true;
        }
        if (error.equals("delete")) {
            SecurityLevelsToadlet.sendCantDeleteMasterKeysFileInner(helper, this.core.getNode().getMasterPasswordFile().getPath(), newThreatLevel.name());
            return true;
        }
        return false;
    }

    public SecurityLevels.PHYSICAL_THREAT_LEVEL getCurrentLevel() {
        return this.core.getNode().getSecurityLevels().getPhysicalThreatLevel();
    }

    @Override
    public String postStep(HTTPRequest request) throws IOException {
        String errorCorrupt = (Object)((Object)FirstTimeWizardToadlet.WIZARD_STEP.SECURITY_PHYSICAL) + "&error=corrupt";
        String pass = request.getPartAsStringFailsafe("masterPassword", 1024);
        String confirmPass = request.getPartAsStringFailsafe("confirmMasterPassword", 1024);
        boolean passwordIsBlank = pass.isEmpty() && confirmPass.isEmpty();
        boolean passwordsDoNotMatch = !pass.equals(confirmPass);
        String physicalThreatLevel = request.getPartAsStringFailsafe("security-levels.physicalThreatLevel", 128);
        SecurityLevels.PHYSICAL_THREAT_LEVEL oldThreatLevel = this.core.getNode().getSecurityLevels().getPhysicalThreatLevel();
        SecurityLevels.PHYSICAL_THREAT_LEVEL newThreatLevel = SecurityLevels.parsePhysicalThreatLevel(physicalThreatLevel);
        if (FirstTimeWizardToadlet.shouldLogMinor()) {
            Logger.minor(this, "Old threat level: " + (Object)((Object)oldThreatLevel) + " new threat level: " + (Object)((Object)newThreatLevel));
        }
        if (newThreatLevel == null || !request.isPartSet("security-levels.physicalThreatLevel") || request.isPartSet("backToMain")) {
            return FirstTimeWizardToadlet.WIZARD_STEP.SECURITY_PHYSICAL.name();
        }
        if (newThreatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH && oldThreatLevel != newThreatLevel) {
            if (passwordIsBlank) {
                return this.promptPassword(newThreatLevel, PASSWORD_PROMPT.SET_BLANK);
            }
            if (passwordsDoNotMatch) {
                return this.promptPassword(newThreatLevel, PASSWORD_PROMPT.SET_NO_MATCH);
            }
            try {
                if (oldThreatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.NORMAL || oldThreatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW) {
                    this.core.getNode().changeMasterPassword("", pass, true);
                } else {
                    this.core.getNode().setMasterPassword(pass, true);
                }
            }
            catch (Node.AlreadySetPasswordException alreadySetPasswordException) {
            }
            catch (MasterKeysWrongPasswordException e) {
                throw new IOException("Incorrect password when changing from another level to high", e);
            }
            catch (MasterKeysFileSizeException e) {
                return errorCorrupt;
            }
        }
        if ((newThreatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW || newThreatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.NORMAL) && oldThreatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH) {
            if (passwordIsBlank) {
                return this.promptPassword(newThreatLevel, PASSWORD_PROMPT.DECRYPT_BLANK);
            }
            if (this.core.getNode().getMasterPasswordFile().exists()) {
                try {
                    this.core.getNode().changeMasterPassword(pass, "", true);
                }
                catch (IOException e) {
                    if (!this.core.getNode().getMasterPasswordFile().exists()) {
                        System.out.println("Master password file no longer exists, assuming this is deliberate");
                    }
                    System.err.println("Cannot change password as cannot write new passwords file: " + e);
                    e.printStackTrace();
                    throw new IOException("cantWriteNewMasterKeysFile", e);
                }
                catch (MasterKeysWrongPasswordException e) {
                    return this.promptPassword(newThreatLevel, PASSWORD_PROMPT.DECRYPT_WRONG);
                }
                catch (MasterKeysFileSizeException e) {
                    return errorCorrupt;
                }
                catch (Node.AlreadySetPasswordException e) {
                    System.err.println("Already set a password when changing it - maybe master.keys copied in at the wrong moment???");
                }
            }
        }
        if (newThreatLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM) {
            try {
                this.core.getNode().killMasterKeysFile();
            }
            catch (IOException e) {
                return (Object)((Object)FirstTimeWizardToadlet.WIZARD_STEP.SECURITY_PHYSICAL) + "&error=delete&newThreatLevel=" + newThreatLevel.name();
            }
        }
        this.setThreatLevel(newThreatLevel, oldThreatLevel);
        return FirstTimeWizardToadlet.WIZARD_STEP.NAME_SELECTION.name();
    }

    private String promptPassword(SecurityLevels.PHYSICAL_THREAT_LEVEL newThreatLevel, PASSWORD_PROMPT type) {
        if (type == PASSWORD_PROMPT.DECRYPT_WRONG) {
            System.err.println("Wrong password!");
        }
        StringBuilder destination = new StringBuilder((Object)((Object)FirstTimeWizardToadlet.WIZARD_STEP.SECURITY_PHYSICAL) + "&error=pass&newThreatLevel=").append(newThreatLevel.name()).append("&type=").append(type.name());
        return destination.toString();
    }

    public void setThreatLevel(SecurityLevels.PHYSICAL_THREAT_LEVEL newThreatLevel, SecurityLevels.PHYSICAL_THREAT_LEVEL oldThreatLevel) throws IOException {
        this.core.getNode().getSecurityLevels().setThreatLevel(newThreatLevel);
        this.core.storeConfig();
        try {
            this.core.getNode().lateSetupDatabase(null);
        }
        catch (MasterKeysWrongPasswordException e) {
            System.err.println("Failed starting up database while switching physical security level to " + (Object)((Object)newThreatLevel) + " from " + (Object)((Object)oldThreatLevel) + " : wrong password - this is impossible, it should have been handled by the other cases, suggest you remove master.keys");
        }
        catch (MasterKeysFileSizeException e) {
            System.err.println("Failed starting up database while switching physical security level to " + (Object)((Object)newThreatLevel) + " from " + (Object)((Object)oldThreatLevel) + " : " + this.core.getNode().getMasterPasswordFile() + " is too " + e.sizeToString());
        }
    }

    private void addBackToPhysicalSeclevelsButton(HTMLNode form) {
        form.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "backToMain", WizardL10n.l10n("backToSecurityLevels")});
    }

    private static enum PASSWORD_PROMPT {
        SET_BLANK,
        DECRYPT_WRONG,
        DECRYPT_BLANK,
        SET_NO_MATCH;

    }
}

