/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.updater.NodeUpdateManager;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.TimeUtil;
import java.io.File;

public class UpdatedVersionAvailableUserAlert
extends AbstractUserAlert {
    private final NodeUpdateManager updater;

    public UpdatedVersionAvailableUserAlert(NodeUpdateManager updater) {
        super(false, null, null, null, null, (short)0, false, NodeL10n.getBase().getString("UserAlert.hide"), false, null);
        this.updater = updater;
    }

    @Override
    public String getTitle() {
        return this.l10n("title");
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("UpdatedVersionAvailableUserAlert." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("UpdatedVersionAvailableUserAlert." + key, pattern, value);
    }

    private String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("UpdatedVersionAvailableUserAlert." + key, patterns, values);
    }

    @Override
    public String getText() {
        UpdateThingy ut = this.createUpdateThingy();
        StringBuilder sb = new StringBuilder();
        sb.append(ut.firstBit);
        if (ut.formText != null) {
            sb.append(" <form action=\"/\" method=\"post\"><input type=\"submit\" name=\"update\" value=\"");
            sb.append(ut.formText);
            sb.append("\" /></form>");
        }
        return sb.toString();
    }

    @Override
    public String getShortText() {
        if (!this.updater.isArmed()) {
            if (this.updater.canUpdateNow()) {
                return this.l10n("shortReadyNotArmed");
            }
            return this.l10n("shortNotReadyNotArmed");
        }
        return this.l10n("shortArmed");
    }

    @Override
    public HTMLNode getHTMLText() {
        int version;
        UpdateThingy ut = this.createUpdateThingy();
        HTMLNode alertNode = new HTMLNode("div");
        alertNode.addChild("#", ut.firstBit);
        if (ut.formText != null) {
            alertNode.addChild("form", new String[]{"action", "method"}, new String[]{"/", "post"}).addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "update", ut.formText});
            alertNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.updater.getNode().getClientCore().getFormPassword()});
        }
        if (this.updater.hasNewMainJar()) {
            version = this.updater.newMainJarVersion();
        } else if (this.updater.fetchingNewMainJar()) {
            version = this.updater.fetchingNewMainJarVersion();
        } else {
            Logger.minor(this, "Showing version available notification but not fetching or fetched.");
            version = this.updater.getMainVersion();
        }
        this.updater.addChangelogLinks(version, alertNode);
        this.updater.renderProgress(alertNode);
        return alertNode;
    }

    private UpdateThingy createUpdateThingy() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.l10n("notLatest"));
        sb.append(' ');
        if (this.updater.isArmed() && this.updater.inFinalCheck()) {
            sb.append(this.l10n("finalCheck", new String[]{"count", "max", "time"}, new String[]{Integer.toString(this.updater.getRevocationDNFCounter()), Integer.toString(3), TimeUtil.formatTime(this.updater.timeRemainingOnCheck())}));
            sb.append(' ');
        } else if (this.updater.isArmed()) {
            sb.append(this.l10n("armed"));
        } else {
            String formText;
            if (this.updater.canUpdateNow()) {
                if (this.updater.hasNewMainJar()) {
                    sb.append(this.l10n("downloadedNewJar", "version", Integer.toString(this.updater.newMainJarVersion())));
                    sb.append(' ');
                }
                if (this.updater.canUpdateImmediately()) {
                    sb.append(this.l10n("clickToUpdateNow"));
                    formText = this.l10n("updateNowButton");
                } else {
                    sb.append(this.l10n("clickToUpdateASAP"));
                    formText = this.l10n("updateASAPButton");
                }
            } else {
                if (this.updater.fetchingFromUOM()) {
                    sb.append(this.l10n("fetchingUOM", "updateScript", this.getUpdateScriptName()));
                } else {
                    boolean fetchingNew = this.updater.fetchingNewMainJar();
                    if (fetchingNew) {
                        sb.append(this.l10n("fetchingNewNode", "nodeVersion", Integer.toString(this.updater.fetchingNewMainJarVersion())));
                    }
                }
                sb.append(" ");
                sb.append(this.l10n("updateASAPQuestion"));
                formText = this.l10n("updateASAPButton");
            }
            if (this.updater.getNode().updateIsUrgent()) {
                sb.append(" ");
                sb.append(this.l10n("updateIsUrgent"));
            }
            if (this.updater.brokenDependencies()) {
                sb.append(" ");
                sb.append(this.l10n("brokenDependencies", "version", Integer.toString(this.updater.newMainJarVersion())));
            }
            return new UpdateThingy(sb.toString(), formText);
        }
        return new UpdateThingy(sb.toString(), null);
    }

    private String getUpdateScriptName() {
        String name = File.separatorChar == '\\' ? "update.cmd" : "update.sh";
        File f = new File(this.updater.getNode().getNodeDir(), name);
        if (f.exists()) {
            return f.toString();
        }
        f = new File(new File(this.updater.getNode().getNodeDir(), "bin"), name);
        if (f.exists()) {
            return f.toString();
        }
        return name;
    }

    @Override
    public short getPriorityClass() {
        Node node = this.updater.getNode();
        if (node.updateIsUrgent()) {
            return 0;
        }
        if (this.updater.inFinalCheck() || this.updater.canUpdateNow() || !this.updater.isArmed()) {
            return 1;
        }
        return 3;
    }

    @Override
    public boolean isValid() {
        return this.updater.isEnabled() && !this.updater.isBlown() && (this.updater.fetchingNewMainJar() || this.updater.hasNewMainJar() || this.updater.fetchingFromUOM());
    }

    @Override
    public void isValid(boolean b) {
    }

    private static class UpdateThingy {
        String firstBit;
        String formText;

        public UpdateThingy(String first, String form) {
            this.firstBit = first;
            this.formText = form;
        }
    }
}

