/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;

public class SparseBitmap
implements Iterable<int[]> {
    private final TreeSet<Range> ranges = new TreeSet<Range>(new RangeComparator());

    public SparseBitmap() {
    }

    public SparseBitmap(SparseBitmap original) {
        for (int[] range : original) {
            this.add(range[0], range[1]);
        }
    }

    public void add(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("Tried adding bad range. Start: " + start + ", end: " + end);
        }
        NavigableSet<Range> toReplace = this.overlaps(start, end, true);
        if (!toReplace.isEmpty()) {
            Range first = (Range)toReplace.first();
            if (first.start < start) {
                start = first.start;
            }
            Range last = (Range)toReplace.last();
            if (last.end > end) {
                end = last.end;
            }
            toReplace.clear();
        }
        this.ranges.add(new Range(start, end));
    }

    public void clear() {
        this.ranges.clear();
    }

    public boolean contains(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("Tried checking bad range. Start: " + start + ", end: " + end);
        }
        Range floor = this.ranges.floor(new Range(start, end));
        return floor != null && floor.end >= end;
    }

    public void remove(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("Removing bad range. Start: " + start + ", end: " + end);
        }
        ArrayList<Range> toAdd = new ArrayList<Range>();
        Iterator<Range> it = this.overlaps(start, end, false).iterator();
        while (it.hasNext()) {
            Range range = it.next();
            if (range.start < start) {
                if (range.end <= end) {
                    toAdd.add(new Range(range.start, start - 1));
                } else if (range.end > end) {
                    toAdd.add(new Range(range.start, start - 1));
                    toAdd.add(new Range(end + 1, range.end));
                }
            } else if (range.end > end) {
                toAdd.add(new Range(end + 1, range.end));
            }
            it.remove();
        }
        this.ranges.addAll(toAdd);
    }

    @Override
    public Iterator<int[]> iterator() {
        return new SparseBitmapIterator(this);
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (int[] range : this) {
            if (s.length() != 0) {
                s.append(", ");
            }
            s.append(range[0] + "->" + range[1]);
        }
        return s.toString();
    }

    private NavigableSet<Range> overlaps(int start, int end, boolean includeTouching) {
        Range startRange = new Range(start, 0);
        Range lower = this.ranges.lower(startRange);
        if (lower != null && lower.end >= (includeTouching ? start - 1 : start)) {
            startRange = new Range(lower.start, 0);
        }
        Range endRange = new Range(end + 1, 0);
        return this.ranges.subSet(startRange, true, endRange, includeTouching);
    }

    public int notOverlapping(int start, int end) {
        int count = end - start + 1;
        for (Range range : this.overlaps(start, end, false)) {
            if (range.end < start || range.start > end) {
                throw new IllegalStateException();
            }
            int overlap = range.end - range.start + 1;
            if (range.start < start) {
                overlap -= start - range.start;
            }
            if (range.end > end) {
                overlap -= range.end - end;
            }
            count -= overlap;
        }
        return count;
    }

    private static class RangeComparator
    implements Comparator<Range> {
        private RangeComparator() {
        }

        @Override
        public int compare(Range r1, Range r2) {
            return r1.start - r2.start;
        }
    }

    private static class Range {
        final int start;
        final int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "Range:" + this.start + "->" + this.end;
        }
    }

    private static class SparseBitmapIterator
    implements Iterator<int[]> {
        Iterator<Range> it;

        public SparseBitmapIterator(SparseBitmap map) {
            this.it = map.ranges.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public int[] next() {
            Range r = this.it.next();
            return new int[]{r.start, r.end};
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

