/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CSSParser;
import freenet.client.filter.CSSReadFilter;
import freenet.client.filter.CharsetExtractor;
import freenet.client.filter.CommentException;
import freenet.client.filter.ContentDataFilter;
import freenet.client.filter.ContentFilter;
import freenet.client.filter.DataFilterException;
import freenet.client.filter.ElementInfo;
import freenet.client.filter.FilterCallback;
import freenet.client.filter.NullFilterCallback;
import freenet.client.filter.UnknownCharsetException;
import freenet.clients.http.ToadletContextImpl;
import freenet.l10n.NodeL10n;
import freenet.support.HTMLDecoder;
import freenet.support.HTMLEncoder;
import freenet.support.Logger;
import freenet.support.URLDecoder;
import freenet.support.URLEncodedFormatException;
import freenet.support.io.NullWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;

public class HTMLFilter
implements ContentDataFilter,
CharsetExtractor {
    private static final String M3U_PLAYER_TAG_FILE = "freenet/clients/http/staticfiles/js/m3u-player.js";
    public static boolean embedM3uPlayer = true;
    private static boolean logMINOR;
    private static boolean logDEBUG;
    private static final boolean deleteWierdStuff = true;
    private static final boolean deleteErrors = true;
    private static final boolean allowNoHTMLTag = true;
    public static int metaRefreshSamePageMinInterval;
    public static int metaRefreshRedirectMinInterval;
    private static final String m3uPlayerScriptTagContent;
    private static final Set<String> allowedHTMLTags;
    static final Map<String, TagVerifier> allowedTagsVerifiers;
    private static final String[] emptyStringArray;

    @Override
    public void readFilter(InputStream input, OutputStream output, String charset, Map<String, String> otherParams, String schemeHostAndPort, FilterCallback cb) throws DataFilterException, IOException {
        if (cb == null) {
            cb = new NullFilterCallback();
        }
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
        if (logMINOR) {
            Logger.minor(this, "readFilter(): charset=" + charset);
        }
        BufferedReader r = null;
        BufferedWriter w = null;
        InputStreamReader isr = null;
        OutputStreamWriter osw = null;
        try {
            isr = new InputStreamReader(input, charset);
            osw = new OutputStreamWriter(output, charset);
            r = new BufferedReader(isr, 4096);
            w = new BufferedWriter(osw, 4096);
        }
        catch (UnsupportedEncodingException e) {
            throw UnknownCharsetException.create(e, charset);
        }
        HTMLParseContext pc = new HTMLParseContext(r, w, charset, cb, false);
        pc.run();
        ((Writer)w).flush();
    }

    @Override
    public String getCharset(byte[] input, int length, String parseCharset) throws DataFilterException, IOException {
        HTMLParseContext pc;
        block13: {
            BufferedReader r;
            block12: {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                if (logMINOR) {
                    Logger.minor(this, "getCharset(): default=" + parseCharset);
                }
                if (length > this.getCharsetBufferSize() && Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this)) {
                    Logger.minor(this, "More data than was strictly needed was passed to the charset extractor for extraction");
                }
                ByteArrayInputStream strm = new ByteArrayInputStream(input, 0, length);
                NullWriter w = new NullWriter();
                try {
                    r = new BufferedReader(new InputStreamReader((InputStream)strm, parseCharset), 4096);
                }
                catch (UnsupportedEncodingException e) {
                    strm.close();
                    throw e;
                }
                pc = new HTMLParseContext(r, w, null, new NullFilterCallback(), true);
                try {
                    pc.run();
                }
                catch (MalformedInputException e) {
                    return null;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Throwable t) {
                    if (!logMINOR) break block12;
                    Logger.minor(this, "Caught " + t + " trying to detect MIME type with " + parseCharset);
                }
            }
            try {
                ((Reader)r).close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                if (!logMINOR) break block13;
                Logger.minor(this, "Caught " + t + " closing stream after trying to detect MIME type with " + parseCharset);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Returning charset " + pc.detectedCharset);
        }
        return pc.detectedCharset;
    }

    void saveText(StringBuilder s, String tagName, Writer w, HTMLParseContext pc) throws IOException {
        if (pc.onlyDetectingCharset) {
            return;
        }
        if (logDEBUG) {
            Logger.debug(this, "Saving text: " + s.toString());
        }
        if (pc.killText) {
            return;
        }
        StringBuilder out = new StringBuilder(s.length() * 2);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<' && !pc.inStyle && !pc.inScript) {
                out.append("&lt;");
                continue;
            }
            if (c < ' ' && c != '\t' && c != '\n' && c != '\r') {
                if (!logDEBUG) continue;
                Logger.debug(this, "Removing '" + c + "' from the output stream");
                continue;
            }
            out.append(c);
        }
        String sout = out.toString();
        if (pc.inStyle || pc.inScript) {
            pc.currentStyleScriptChunk = pc.currentStyleScriptChunk + sout;
            return;
        }
        if (pc.cb != null) {
            pc.cb.onText(HTMLDecoder.decode(sout), tagName);
        }
        w.write(sout);
    }

    static String m3uPlayerScriptTagContent() {
        String tagContent;
        InputStream m3uPlayerTagStream = HTMLFilter.class.getClassLoader().getResourceAsStream(M3U_PLAYER_TAG_FILE);
        String errorTag = "/* Error: could not load freenet/clients/http/staticfiles/js/m3u-player.js */";
        if (m3uPlayerTagStream == null) {
            return errorTag;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(m3uPlayerTagStream));){
            String line;
            StringBuilder stringBuilder = new StringBuilder("<script>");
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append("\n");
            }
            stringBuilder.append("</script>");
            tagContent = stringBuilder.toString();
        }
        catch (IOException e) {
            Logger.error(HTMLFilter.class, "Could not read m3uPlayer inline-script.");
            return errorTag;
        }
        return tagContent;
    }

    String processTag(List<String> splitTag, Writer w, HTMLParseContext pc) throws IOException, DataFilterException {
        if (logDEBUG) {
            for (int i = 0; i < splitTag.size(); ++i) {
                Logger.debug(this, "Tag[" + i + "]=" + splitTag.get(i));
            }
        }
        ParsedTag t = new ParsedTag(splitTag);
        if (!pc.killTag) {
            if ((t = t.sanitize(pc)) != null) {
                String headContent;
                if (t.element.compareTo("head") == 0 && !t.startSlash) {
                    pc.wasHeadElementFound = true;
                } else if (!(t.element.compareTo("video") != 0 && t.element.compareTo("audio") != 0 || t.startSlash)) {
                    pc.wasMediaElementFound = true;
                } else if (t.element.compareTo("head") == 0 && t.startSlash) {
                    pc.headEnded = true;
                    if (pc.onlyDetectingCharset) {
                        pc.failedDetectCharset = true;
                    }
                } else if (!(t.element.compareTo("meta") != 0 && t.element.compareTo("title") != 0 || pc.wasHeadElementFound)) {
                    pc.openElements.push("head");
                    pc.wasHeadElementFound = true;
                    headContent = pc.cb.processTag(new ParsedTag("head", new HashMap<String, String>()));
                    if (headContent != null && !pc.onlyDetectingCharset) {
                        w.write(headContent);
                    }
                } else if ((t.element.compareTo("meta") == 0 || t.element.compareTo("title") == 0) && pc.headEnded) {
                    HTMLFilter.throwFilterException(HTMLFilter.l10n("metaOutsideHead"));
                } else if (t.element.compareTo("body") == 0 && pc.openElements.contains("head")) {
                    if (!pc.onlyDetectingCharset) {
                        w.write("</head>");
                    }
                    pc.headEnded = true;
                    if (pc.onlyDetectingCharset) {
                        pc.failedDetectCharset = true;
                    }
                    pc.openElements.pop();
                } else if (t.element.compareTo("body") == 0 && !pc.wasHeadElementFound) {
                    pc.wasHeadElementFound = true;
                    headContent = pc.cb.processTag(new ParsedTag("head", new HashMap<String, String>()));
                    if (headContent != null) {
                        if (!pc.onlyDetectingCharset) {
                            w.write(headContent + "</head>");
                        }
                        pc.headEnded = true;
                        if (pc.onlyDetectingCharset) {
                            pc.failedDetectCharset = true;
                        }
                    }
                } else if (t.element.compareTo("body") == 0 && t.startSlash && pc.wasMediaElementFound && embedM3uPlayer) {
                    w.write(m3uPlayerScriptTagContent);
                }
                if (!pc.onlyDetectingCharset) {
                    String newContent = pc.cb.processTag(t);
                    if (newContent != null) {
                        w.write(newContent);
                        if (!t.endSlash) {
                            pc.openElements.push(t.element);
                        }
                    } else {
                        if (pc.writeStyleScriptWithTag) {
                            pc.writeStyleScriptWithTag = false;
                            String style = pc.currentStyleScriptChunk;
                            if (style == null || style.isEmpty()) {
                                pc.writeAfterTag.append("<!-- " + HTMLFilter.l10n("deletedUnknownStyle") + " -->");
                            } else {
                                w.write(style);
                            }
                            pc.currentStyleScriptChunk = "";
                        }
                        t.write(w, pc);
                        if (pc.writeAfterTag.length() > 0) {
                            w.write(pc.writeAfterTag.toString());
                            pc.writeAfterTag = new StringBuilder(1024);
                        }
                    }
                } else {
                    pc.writeStyleScriptWithTag = false;
                }
            }
            if (t == null || t.startSlash || t.endSlash) {
                if (!pc.openElements.isEmpty()) {
                    return pc.openElements.peek();
                }
                if (pc.writeAfterTag.length() > 0) {
                    w.write(pc.writeAfterTag.toString());
                    pc.writeAfterTag = new StringBuilder(1024);
                }
                return null;
            }
            return t.element;
        }
        pc.killTag = false;
        pc.writeStyleScriptWithTag = false;
        return null;
    }

    void saveComment(StringBuilder s, Writer w, HTMLParseContext pc) throws IOException {
        if (pc.onlyDetectingCharset) {
            return;
        }
        if (s.length() > 3 && s.charAt(0) == '!' && s.charAt(1) == '-' && s.charAt(2) == '-') {
            s.delete(0, 3);
            if (s.charAt(s.length() - 1) == '-') {
                s.setLength(s.length() - 1);
            }
            if (s.charAt(s.length() - 1) == '-') {
                s.setLength(s.length() - 1);
            }
        }
        if (logDEBUG) {
            Logger.debug(this, "Saving comment: " + s.toString());
        }
        if (pc.expectingBadComment) {
            return;
        }
        if (pc.inStyle || pc.inScript) {
            pc.currentStyleScriptChunk = pc.currentStyleScriptChunk + s;
            return;
        }
        if (pc.killTag) {
            pc.killTag = false;
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            sb.append(c);
        }
        s = sb;
        w.write("<!-- ");
        w.write(s.toString());
        w.write(" -->");
    }

    static void throwFilterException(String msg) throws DataFilterException {
        String longer = HTMLFilter.l10n("failedToParseLabel");
        throw new DataFilterException(longer, longer, msg);
    }

    public static Set<String> getAllowedHTMLTags() {
        return Collections.unmodifiableSet(allowedHTMLTags);
    }

    private static Map<String, TagVerifier> getAllowedTagVerifiers() {
        String[] mathmltr;
        String[] mathmlitem;
        String[] mathmlscripts;
        String[] mathmlpresent;
        String[] mathmlempty;
        String[] group2;
        String[] group;
        HashMap<String, TagVerifier> allowedTagsVerifiers = new HashMap<String, TagVerifier>();
        allowedTagsVerifiers.put("?xml", new XmlTagVerifier());
        allowedTagsVerifiers.put("!doctype", new DocTypeTagVerifier("!doctype"));
        allowedTagsVerifiers.put("html", new HtmlTagVerifier());
        allowedTagsVerifiers.put("head", new TagVerifier("head", new String[]{"id"}, new String[0], null, emptyStringArray));
        allowedTagsVerifiers.put("title", new TagVerifier("title", new String[]{"id"}));
        allowedTagsVerifiers.put("meta", new MetaTagVerifier());
        allowedTagsVerifiers.put("body", new CoreTagVerifier("body", new String[]{"bgcolor", "text", "link", "vlink", "alink"}, null, new String[]{"background"}, new String[]{"onload", "onunload"}, emptyStringArray));
        for (String x : group = new String[]{"div", "h1", "h2", "h3", "h4", "h5", "h6", "p", "caption"}) {
            allowedTagsVerifiers.put(x, new CoreTagVerifier(x, new String[]{"align"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        }
        for (String x : group2 = new String[]{"abbr", "acronym", "address", "article", "aside", "b", "bdi", "bdo", "big", "center", "cite", "code", "dd", "details", "dfn", "dt", "em", "fieldset", "figcaption", "figure", "footer", "header", "hgroup", "i", "kbd", "listing", "main", "mark", "nav", "noframes", "plaintext", "rp", "rt", "ruby", "s", "samp", "section", "small", "span", "strike", "strong", "sub", "summary", "sup", "tt", "u", "var", "wbr", "xmp"}) {
            allowedTagsVerifiers.put(x, new CoreTagVerifier(x, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        }
        allowedTagsVerifiers.put("blockquote", new CoreTagVerifier("blockquote", emptyStringArray, new String[]{"cite"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("q", new CoreTagVerifier("q", emptyStringArray, new String[]{"cite"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("br", new BaseCoreTagVerifier("br", new String[]{"clear"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("pre", new CoreTagVerifier("pre", new String[]{"width", "xml:space"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("ins", new CoreTagVerifier("ins", new String[]{"datetime"}, new String[]{"cite"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("del", new CoreTagVerifier("del", new String[]{"datetime"}, new String[]{"cite"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("ul", new CoreTagVerifier("ul", new String[]{"type", "compact"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("ol", new CoreTagVerifier("ol", new String[]{"type", "compact", "start", "reversed"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("li", new CoreTagVerifier("li", new String[]{"type", "value"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("dl", new CoreTagVerifier("dl", new String[]{"compact"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("dir", new CoreTagVerifier("dir", new String[]{"compact"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("menu", new CoreTagVerifier("menu", new String[]{"compact"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("table", new CoreTagVerifier("table", new String[]{"summary", "width", "border", "frame", "rules", "cellspacing", "cellpadding", "align", "bgcolor"}, emptyStringArray, new String[]{"background"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("thead", new CoreTagVerifier("thead", new String[]{"align", "char", "charoff", "valign"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("tfoot", new CoreTagVerifier("tfoot", new String[]{"align", "char", "charoff", "valign"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("tbody", new CoreTagVerifier("tbody", new String[]{"align", "char", "charoff", "valign"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("colgroup", new CoreTagVerifier("colgroup", new String[]{"span", "width", "align", "char", "charoff", "valign"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("col", new CoreTagVerifier("col", new String[]{"span", "width", "align", "char", "charoff", "valign"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("tr", new CoreTagVerifier("tr", new String[]{"align", "char", "charoff", "valign", "bgcolor"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("th", new CoreTagVerifier("th", new String[]{"abbr", "axis", "headers", "scope", "rowspan", "colspan", "align", "char", "charoff", "valign", "nowrap", "bgcolor", "width", "height"}, emptyStringArray, new String[]{"background"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("td", new CoreTagVerifier("td", new String[]{"abbr", "axis", "headers", "scope", "rowspan", "colspan", "align", "char", "charoff", "valign", "nowrap", "bgcolor", "width", "height"}, emptyStringArray, new String[]{"background"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("a", new LinkTagVerifier("a", new String[]{"accesskey", "tabindex", "name", "shape", "coords", "target"}, emptyStringArray, emptyStringArray, new String[]{"onfocus", "onblur"}));
        allowedTagsVerifiers.put("link", new LinkTagVerifier("link", new String[]{"media", "target"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("base", new BaseHrefTagVerifier("base", new String[]{"id", "target"}, new String[0]));
        allowedTagsVerifiers.put("img", new CoreTagVerifier("img", new String[]{"alt", "name", "height", "width", "ismap", "align", "border", "hspace", "vspace"}, new String[]{"longdesc", "usemap"}, new String[]{"src"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("map", new CoreTagVerifier("map", new String[]{"name"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("area", new CoreTagVerifier("area", new String[]{"accesskey", "tabindex", "shape", "coords", "nohref", "alt", "target"}, new String[]{"href"}, emptyStringArray, new String[]{"onfocus", "onblur"}, emptyStringArray));
        allowedTagsVerifiers.put("audio", new MediaTagVerifier("audio", emptyStringArray, emptyStringArray, new String[]{"src"}, emptyStringArray, new String[]{"preload", "controls", "loop"}));
        allowedTagsVerifiers.put("video", new MediaTagVerifier("video", new String[]{"width", "height"}, emptyStringArray, new String[]{"src", "poster"}, emptyStringArray, new String[]{"preload", "controls", "loop"}));
        allowedTagsVerifiers.put("source", new MediaTagVerifier("source", emptyStringArray, emptyStringArray, new String[]{"src"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("style", new StyleTagVerifier());
        allowedTagsVerifiers.put("font", new BaseCoreTagVerifier("font", new String[]{"size", "color", "face"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("basefont", new BaseCoreTagVerifier("basefont", new String[]{"size", "color", "face"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("hr", new CoreTagVerifier("hr", new String[]{"align", "noshade", "size", "width"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("frameset", new CoreTagVerifier("frameset", new String[]{"rows", "cols"}, emptyStringArray, emptyStringArray, new String[]{"onload", "onunload"}, emptyStringArray, false));
        allowedTagsVerifiers.put("frame", new BaseCoreTagVerifier("frame", new String[]{"name", "frameborder", "marginwidth", "marginheight", "noresize", "scrolling"}, new String[]{"longdesc"}, new String[]{"src"}, emptyStringArray));
        allowedTagsVerifiers.put("iframe", new BaseCoreTagVerifier("iframe", new String[]{"name", "frameborder", "marginwidth", "marginheight", "scrolling", "align", "height", "width"}, new String[]{"longdesc"}, new String[]{"src"}, emptyStringArray));
        allowedTagsVerifiers.put("form", new FormTagVerifier("form", new String[]{"name"}, new String[0], new String[]{"onsubmit", "onreset"}));
        allowedTagsVerifiers.put("input", new InputTagVerifier("input", new String[]{"accesskey", "tabindex", "type", "name", "value", "checked", "disabled", "readonly", "size", "maxlength", "alt", "ismap", "accept", "align", "form"}, new String[]{"usemap"}, new String[]{"src"}, new String[]{"onfocus", "onblur", "onselect", "onchange"}));
        allowedTagsVerifiers.put("button", new CoreTagVerifier("button", new String[]{"accesskey", "tabindex", "name", "value", "type", "disabled"}, emptyStringArray, emptyStringArray, new String[]{"onfocus", "onblur"}, emptyStringArray));
        allowedTagsVerifiers.put("select", new CoreTagVerifier("select", new String[]{"name", "size", "multiple", "disabled", "tabindex"}, emptyStringArray, emptyStringArray, new String[]{"onfocus", "onblur", "onchange"}, emptyStringArray));
        allowedTagsVerifiers.put("optgroup", new CoreTagVerifier("optgroup", new String[]{"disabled", "label"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("option", new CoreTagVerifier("option", new String[]{"selected", "disabled", "label", "value"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("textarea", new CoreTagVerifier("textarea", new String[]{"accesskey", "tabindex", "name", "rows", "cols", "disabled", "readonly"}, emptyStringArray, emptyStringArray, new String[]{"onfocus", "onblur", "onselect", "onchange"}, emptyStringArray));
        allowedTagsVerifiers.put("meter", new CoreTagVerifier("meter", new String[]{"form", "high", "low", "max", "min", "optimum", "value"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("progress", new CoreTagVerifier("progress", new String[]{"max", "value"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("isindex", new BaseCoreTagVerifier("isindex", new String[]{"prompt"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("label", new CoreTagVerifier("label", new String[]{"for", "accesskey"}, emptyStringArray, emptyStringArray, new String[]{"onfocus", "onblur"}, emptyStringArray));
        allowedTagsVerifiers.put("legend", new CoreTagVerifier("legend", new String[]{"accesskey", "align"}, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("script", new ScriptTagVerifier());
        allowedTagsVerifiers.put("math", new CoreTagVerifier("math", new String[]{"accent", "accentunder", "align", "alignmentscope", "altimg-height", "altimg-valign", "altimg-width", "alttext", "bevelled", "charalign", "charspacing", "close", "columnalign", "columnlines", "columnspacing", "columnspan", "columnwidth", "crossout", "decimalpoint", "depth", "denomalign", "dir", "display", "displaystyle", "edge", "equalcolumns", "equalrows", "fence", "form", "frame", "framespacing", "groupalign", "height", "indentalign", "indentalignfirst", "indentalignlast", "indentshift", "indentshiftfirst", "indentshiftlast", "indenttarget", "infixlinebreakstyle", "largeop", "leftoverhang", "length", "linebreak", "linebreakmultchar", "linebreakstyle", "lineleading", "location", "lquote", "lspace", "linethickness", "longdivstyle", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "maxwidth", "minlabelspacing", "minsize", "movablelimits", "mslinethickness", "notation", "numalign", "open", "overflow", "position", "rightoverhang", "rowalign", "rowlines", "rowspacing", "rowspan", "rquote", "rspace", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "separator", "separators", "shift", "side", "stackalign", "stretchy", "subscriptshift", "superscriptshift", "symmetric", "voffset", "width"}, new String[]{"href"}, new String[]{"altimg"}, emptyStringArray, emptyStringArray));
        for (String x : mathmlempty = new String[]{"mprescripts", "none"}) {
            allowedTagsVerifiers.put(x, new CoreTagVerifier(x, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray, emptyStringArray));
        }
        for (String x : mathmlpresent = new String[]{"merror", "mphantom", "mroot", "msqrt"}) {
            allowedTagsVerifiers.put(x, new CoreTagVerifier(x, new String[]{"mathbackground", "mathcolor"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        }
        allowedTagsVerifiers.put("msub", new CoreTagVerifier("msub", new String[]{"mathbackground", "mathcolor", "subscriptshift"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("msup", new CoreTagVerifier("msup", new String[]{"mathbackground", "mathcolor", "superscriptshift"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        for (String x : mathmlscripts = new String[]{"msubsup", "mmultiscripts"}) {
            allowedTagsVerifiers.put(x, new CoreTagVerifier(x, new String[]{"mathbackground", "mathcolor", "subscriptshift", "superscriptshift"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        }
        allowedTagsVerifiers.put("msrow", new CoreTagVerifier("msrow", new String[]{"mathbackground", "mathcolor", "position"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("msgroup", new CoreTagVerifier("msgroup", new String[]{"mathbackground", "mathcolor", "position", "shift"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("menclose", new CoreTagVerifier("menclose", new String[]{"mathbackground", "mathcolor", "notation"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("msline", new CoreTagVerifier("msline", new String[]{"leftoverhang", "length", "mathbackground", "mathcolor", "mslinethickness", "position", "rightoverhang"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("maligngroup", new CoreTagVerifier("maligngroup", new String[]{"groupalign", "mathbackground", "mathcolor"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("malignmark", new CoreTagVerifier("malignmark", new String[]{"edge", "mathbackground", "mathcolor"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mrow", new CoreTagVerifier("mrow", new String[]{"dir", "mathbackground", "mathcolor"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        for (String x : mathmlitem = new String[]{"mi", "mn", "mtext"}) {
            allowedTagsVerifiers.put(x, new CoreTagVerifier(x, new String[]{"dir", "mathbackground", "mathcolor", "mathsize", "mathvariant"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        }
        allowedTagsVerifiers.put("ms", new CoreTagVerifier("ms", new String[]{"dir", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "rquote"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mpadded", new CoreTagVerifier("mpadded", new String[]{"depth", "height", "lspace", "mathbackground", "mathcolor", "voffset", "width"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mspace", new CoreTagVerifier("mspace", new String[]{"depth", "dir", "height", "indentalign", "indentalignfirst", "indentalignlast", "indentshift", "indentshiftfirst", "indentshiftlast", "indenttarget", "linebreak", "mathbackground", "mathcolor", "mathsize", "mathvariant", "width"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mscarry", new CoreTagVerifier("mscarry", new String[]{"crossout", "location", "mathbackground", "mathcolor"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mscarries", new CoreTagVerifier("mscarries", new String[]{"crossout", "location", "mathbackground", "mathcolor", "position", "scriptsizemultiplier"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        for (String x : mathmltr = new String[]{"mtr", "mlabeledtr"}) {
            allowedTagsVerifiers.put(x, new CoreTagVerifier(x, new String[]{"columnalign", "groupalign", "mathbackground", "mathcolor", "rowalign"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        }
        allowedTagsVerifiers.put("mtd", new CoreTagVerifier("mtd", new String[]{"columnalign", "columnspan", "groupalign", "mathbackground", "mathcolor", "rowalign", "rowspan"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mfenced", new CoreTagVerifier("mfenced", new String[]{"close", "mathbackground", "mathcolor", "open", "separators"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mfrac", new CoreTagVerifier("mfrac", new String[]{"bevelled", "denomalign", "linethickness", "mathbackground", "mathcolor", "numalign"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mglyph", new CoreTagVerifier("mglyph", new String[]{"alt", "height", "mathbackground", "mathcolor", "valign", "width"}, new String[]{"href"}, new String[]{"src"}, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mstack", new CoreTagVerifier("mstack", new String[]{"align", "charalign", "charspacing", "mathbackground", "mathcolor", "stackalign"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mlongdiv", new CoreTagVerifier("mlongdiv", new String[]{"align", "charalign", "charspacing", "longdivstyle", "mathbackground", "mathcolor", "stackalign"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mtable", new CoreTagVerifier("mtable", new String[]{"align", "alignmentscope", "columnalign", "columnlines", "columnspacing", "columnwidth", "displaystyle", "equalcolumns", "equalrows", "frame", "framespacing", "groupalign", "mathbackground", "mathcolor", "minlabelspacing", "rowalign", "rowlines", "rowspacing", "side", "width"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("munder", new CoreTagVerifier("munder", new String[]{"accentunder", "align", "mathbackground", "mathcolor"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mo", new CoreTagVerifier("mo", new String[]{"accent", "dir", "fence", "form", "indentalign", "indentalignfirst", "indentalignlast", "indentshift", "indentshiftfirst", "indentshiftlast", "indenttarget", "largeop", "linebreak", "linebreakmultchar", "linebreakstyle", "lineleading", "lspace", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "rspace", "separator", "stretchy", "symmetric"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mover", new CoreTagVerifier("mover", new String[]{"accent", "align", "mathbackground", "mathcolor"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("munderover", new CoreTagVerifier("munderover", new String[]{"accent", "accentunder", "align", "mathbackground", "mathcolor"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        allowedTagsVerifiers.put("mstyle", new CoreTagVerifier("mstyle", new String[]{"accent", "accentunder", "align", "alignmentscope", "bevelled", "charalign", "charspacing", "close", "columnalign", "columnlines", "columnspacing", "columnspan", "columnwidth", "crossout", "decimalpoint", "depth", "denomalign", "dir", "displaystyle", "edge", "equalcolumns", "equalrows", "fence", "form", "frame", "framespacing", "groupalign", "height", "indentalign", "indentalignfirst", "indentalignlast", "indentshift", "indentshiftfirst", "indentshiftlast", "indenttarget", "infixlinebreakstyle", "largeop", "leftoverhang", "length", "linebreak", "linebreakmultchar", "linebreakstyle", "lineleading", "location", "lquote", "lspace", "linethickness", "longdivstyle", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minlabelspacing", "minsize", "movablelimits", "mslinethickness", "notation", "numalign", "open", "position", "rightoverhang", "rowalign", "rowlines", "rowspacing", "rowspan", "rquote", "rspace", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "separator", "separators", "shift", "side", "stackalign", "stretchy", "subscriptshift", "superscriptshift", "symmetric", "voffset", "width"}, new String[]{"href"}, emptyStringArray, emptyStringArray, emptyStringArray));
        return allowedTagsVerifiers;
    }

    static String stripQuotes(String s) {
        String quotes = "\"'";
        if (s.length() >= 2) {
            int n = "\"'".length();
            for (int x = 0; x < n; ++x) {
                char cc = "\"'".charAt(x);
                if (s.charAt(0) != cc || s.charAt(s.length() - 1) != cc) continue;
                if (s.length() > 2) {
                    s = s.substring(1, s.length() - 1);
                    break;
                }
                s = "";
                break;
            }
        }
        return s;
    }

    static String sanitizeStyle(String style, FilterCallback cb, HTMLParseContext hpc, boolean isInline) throws DataFilterException {
        if (style == null) {
            return null;
        }
        if (hpc.onlyDetectingCharset) {
            return null;
        }
        StringReader r = new StringReader(style);
        StringWriter w = new StringWriter();
        style = style.trim();
        if (logMINOR) {
            Logger.minor(HTMLFilter.class, "Sanitizing style: " + style);
        }
        CSSParser pc = new CSSParser(r, w, false, cb, hpc.charset, false, isInline);
        try {
            pc.parse();
        }
        catch (IOException e) {
            Logger.error(HTMLFilter.class, "IOException parsing inline CSS!");
        }
        catch (Error e) {
            if (e.getMessage().equals("Error: could not match input")) {
                Logger.normal(HTMLFilter.class, "CSS Parse Error!", (Throwable)e);
                return "/* " + HTMLFilter.l10n("couldNotParseStyle") + " */";
            }
            throw e;
        }
        String s = ((Object)w).toString();
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (logMINOR) {
            Logger.minor(HTMLFilter.class, "Style finally: " + s);
        }
        return s;
    }

    static String escapeQuotes(String s) {
        StringBuilder buf = new StringBuilder(s.length());
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c == '\"') {
                buf.append("&quot;");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    static String sanitizeScripting(String script) {
        return null;
    }

    static String sanitizeURI(String uri, FilterCallback cb, boolean inline) throws CommentException {
        return HTMLFilter.sanitizeURI(uri, null, null, null, cb, inline);
    }

    public static String[] splitType(String type) {
        String charset = null;
        StringFieldParser sfp = new StringFieldParser(type, ';');
        type = sfp.nextField().trim();
        while (sfp.hasMoreFields()) {
            String param = sfp.nextField();
            int x = param.indexOf(61);
            if (x == -1) continue;
            String name = param.substring(0, x).trim();
            String value = param.substring(x + 1).trim();
            if (!name.equals("charset")) continue;
            charset = value;
        }
        return new String[]{type, charset};
    }

    static String htmlSanitizeURI(String suri, String overrideType, String overrideCharset, String maybeCharset, FilterCallback cb, HTMLParseContext pc, boolean inline) {
        try {
            return HTMLFilter.sanitizeURI(suri, overrideType, overrideCharset, maybeCharset, cb, inline);
        }
        catch (CommentException e) {
            pc.writeAfterTag.append("<!-- ").append(HTMLEncoder.encode(e.toString())).append(" -->");
            return null;
        }
    }

    static String sanitizeURI(String suri, String overrideType, String overrideCharset, String maybeCharset, FilterCallback cb, boolean inline) throws CommentException {
        if (logMINOR) {
            Logger.minor(HTMLFilter.class, "Sanitizing URI: " + suri + " ( override type " + overrideType + " override charset " + overrideCharset + " ) inline=" + inline, (Throwable)new Exception("debug"));
        }
        boolean addMaybe = false;
        if (overrideCharset != null && !overrideCharset.isEmpty()) {
            overrideType = overrideType + "; charset=" + overrideCharset;
        } else if (maybeCharset != null) {
            addMaybe = true;
        }
        String retval = cb.processURI(suri, overrideType, false, inline);
        if (addMaybe) {
            retval = retval.indexOf(63) != -1 ? retval + "&maybecharset=" + maybeCharset : retval + "?maybecharset=" + maybeCharset;
        }
        return retval;
    }

    static String getHashString(Map<String, Object> h, String key) {
        Object o = h.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("HTMLFilter." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("HTMLFilter." + key, pattern, value);
    }

    @Override
    public CharsetExtractor.BOMDetection getCharsetByBOM(byte[] input, int length) throws DataFilterException {
        return null;
    }

    @Override
    public int getCharsetBufferSize() {
        return 65536;
    }

    static {
        metaRefreshSamePageMinInterval = 1;
        metaRefreshRedirectMinInterval = 30;
        m3uPlayerScriptTagContent = HTMLFilter.m3uPlayerScriptTagContent();
        allowedHTMLTags = new HashSet<String>();
        allowedTagsVerifiers = Collections.unmodifiableMap(HTMLFilter.getAllowedTagVerifiers());
        emptyStringArray = new String[0];
    }

    static class StringFieldParser {
        private String str;
        private int maxPos;
        private int curPos;
        private char c;

        public StringFieldParser(String str) {
            this(str, '\t');
        }

        public StringFieldParser(String str, char c) {
            this.str = str;
            this.maxPos = str.length();
            this.curPos = 0;
            this.c = c;
        }

        public boolean hasMoreFields() {
            return this.curPos <= this.maxPos;
        }

        public String nextField() {
            if (this.curPos > this.maxPos) {
                return null;
            }
            int start = this.curPos;
            while (this.curPos < this.maxPos && this.str.charAt(this.curPos) != this.c) {
                ++this.curPos;
            }
            int end = this.curPos++;
            return this.str.substring(start, end);
        }
    }

    static class BaseHrefTagVerifier
    extends TagVerifier {
        private static final String[] locallyVerifiedAttrs = new String[]{"href"};

        BaseHrefTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs) {
            super(tag, allowedAttrs, uriAttrs, null, emptyStringArray);
            this.parsedAttrs.addAll(Arrays.asList(locallyVerifiedAttrs));
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            String ref;
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            String baseHref = HTMLFilter.getHashString(h, "href");
            if (baseHref != null && (ref = pc.cb.onBaseHref(baseHref = HTMLDecoder.decode(baseHref))) != null) {
                hn.put("href", HTMLEncoder.encode(ref));
                return hn;
            }
            pc.writeAfterTag.append("<!-- deleted invalid base href -->");
            return null;
        }
    }

    static class HtmlTagVerifier
    extends TagVerifier {
        private static final String[] locallyVerifiedAttrs = new String[]{"xmlns"};

        HtmlTagVerifier() {
            super("html", new String[]{"id", "version"});
            this.parsedAttrs.addAll(Arrays.asList(locallyVerifiedAttrs));
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            String xmlns = HTMLFilter.getHashString(h, "xmlns");
            if (xmlns != null && xmlns.equals("http://www.w3.org/1999/xhtml")) {
                hn.put("xmlns", xmlns);
                pc.setisXHTML(true);
            }
            return hn;
        }
    }

    static class XmlTagVerifier
    extends TagVerifier {
        XmlTagVerifier() {
            super("?xml", null);
        }

        @Override
        ParsedTag sanitize(ParsedTag t, HTMLParseContext pc) throws DataFilterException {
            String charset;
            if (t.unparsedAttrs.length != 2 && t.unparsedAttrs.length != 3) {
                if (logMINOR) {
                    Logger.minor(this, "Deleting xml declaration, invalid length");
                }
                return null;
            }
            if (t.unparsedAttrs.length == 3 && !t.unparsedAttrs[2].equals("?")) {
                if (logMINOR) {
                    Logger.minor(this, "Deleting xml declaration, invalid ending (length 2)");
                }
                return null;
            }
            if (t.unparsedAttrs.length == 2 && !t.unparsedAttrs[1].endsWith("?")) {
                if (logMINOR) {
                    Logger.minor(this, "Deleting xml declaration, invalid ending (length 3)");
                }
                return null;
            }
            if (!t.unparsedAttrs[0].equals("version=\"1.0\"") && !t.unparsedAttrs[0].equals("version='1.0'")) {
                if (logMINOR) {
                    Logger.minor(this, "Deleting xml declaration, invalid version");
                }
                return null;
            }
            String encodingAttr = t.unparsedAttrs[1];
            if (encodingAttr.startsWith("encoding=\"")) {
                if (!encodingAttr.endsWith("\"")) {
                    if (logMINOR) {
                        Logger.minor(this, "Deleting xml declaration, invalid encoding");
                    }
                    return null;
                }
            } else if (encodingAttr.startsWith("encoding='")) {
                if (!encodingAttr.endsWith("'")) {
                    if (logMINOR) {
                        Logger.minor(this, "Deleting xml declaration, invalid encoding");
                    }
                    return null;
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Deleting xml declaration, invalid encoding");
                }
                return null;
            }
            if (!(charset = encodingAttr.substring("encoding='".length(), encodingAttr.length() - 1)).equalsIgnoreCase(pc.charset)) {
                if (pc.charset != null && !charset.equalsIgnoreCase(pc.charset)) {
                    if (logMINOR) {
                        Logger.minor(this, "Deleting xml declaration (invalid charset " + charset + " should be " + pc.charset + ")");
                    }
                    return null;
                }
                if (pc.detectedCharset != null) {
                    HTMLFilter.throwFilterException(HTMLFilter.l10n("multipleCharsetsInMeta"));
                } else {
                    pc.detectedCharset = charset;
                }
            }
            return t;
        }
    }

    static class DocTypeTagVerifier
    extends TagVerifier {
        private static final Map<String, Object> DTDs = new HashMap<String, Object>();

        DocTypeTagVerifier(String tag) {
            super(tag, null);
        }

        @Override
        ParsedTag sanitize(ParsedTag t, HTMLParseContext pc) {
            if (t.unparsedAttrs.length == 1) {
                if (!t.unparsedAttrs[0].equalsIgnoreCase("html")) {
                    return null;
                }
                return t;
            }
            if (t.unparsedAttrs.length != 3 && t.unparsedAttrs.length != 4) {
                return null;
            }
            if (!t.unparsedAttrs[0].equalsIgnoreCase("html")) {
                return null;
            }
            if (t.unparsedAttrs[1].equalsIgnoreCase("system") && t.unparsedAttrs.length == 3) {
                String s = HTMLFilter.stripQuotes(t.unparsedAttrs[2]);
                if (s.equals("about:legacy-compat") && t.unparsedAttrs.length == 3) {
                    return t;
                }
                return null;
            }
            if (!t.unparsedAttrs[1].equalsIgnoreCase("public")) {
                return null;
            }
            String s = HTMLFilter.stripQuotes(t.unparsedAttrs[2]);
            if (!DTDs.containsKey(s)) {
                return null;
            }
            if (t.unparsedAttrs.length == 4) {
                String ss = HTMLFilter.stripQuotes(t.unparsedAttrs[3]);
                String spec = HTMLFilter.getHashString(DTDs, s);
                if (spec != null && !spec.equals(ss)) {
                    return null;
                }
            }
            return t;
        }

        static {
            DTDs.put("-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
            DTDs.put("-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
            DTDs.put("-//W3C//DTD XHTML 1.0 Frameset//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
            DTDs.put("-//W3C//DTD XHTML 1.1//EN", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd");
            DTDs.put("-//W3C//DTD HTML 4.01//EN", "http://www.w3.org/TR/html4/strict.dtd");
            DTDs.put("-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/html4/loose.dtd");
            DTDs.put("-//W3C//DTD HTML 4.01 Frameset//EN", "http://www.w3.org/TR/html4/frameset.dtd");
            DTDs.put("-//W3C//DTD HTML 3.2 Final//EN", new Object());
        }
    }

    static class MetaTagVerifier
    extends TagVerifier {
        private static final String[] allowedContentTypes = ContentFilter.HTML_MIME_TYPES;
        private static final String[] locallyVerifiedAttrs = new String[]{"http-equiv", "name", "content", "charset"};
        private static final String[] validRobotsValue = new String[]{"all", "follow", "index", "noarchive", "nocache", "nofollow", "noimageindex", "noindex", "none", "nosnippet"};
        private static final HashSet<String> validRobotsValues = new HashSet();

        MetaTagVerifier() {
            super("meta", new String[]{"id"});
            this.parsedAttrs.addAll(Arrays.asList(locallyVerifiedAttrs));
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            String charset;
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            String http_equiv = HTMLFilter.getHashString(h, "http-equiv");
            String name = HTMLFilter.getHashString(h, "name");
            String content = HTMLFilter.getHashString(h, "content");
            String scheme = HTMLFilter.getHashString(h, "scheme");
            if (logMINOR) {
                Logger.minor(this, "meta: name=" + name + ", content=" + content + ", http-equiv=" + http_equiv + ", scheme=" + scheme);
            }
            if (content != null) {
                if (name != null && http_equiv == null) {
                    if (name.equalsIgnoreCase("Author")) {
                        hn.put("name", name);
                        hn.put("content", content);
                    } else if (name.equalsIgnoreCase("Keywords")) {
                        hn.put("name", name);
                        hn.put("content", content);
                    } else if (name.equalsIgnoreCase("Description")) {
                        hn.put("name", name);
                        hn.put("content", content);
                    } else if (name.equalsIgnoreCase("Viewport")) {
                        hn.put("name", name);
                        hn.put("content", content);
                    } else if (name.equalsIgnoreCase("robots") || name.equalsIgnoreCase("googlebot")) {
                        String[] tokens = content.split(",");
                        StringBuilder sb = new StringBuilder(content.length());
                        for (String token : tokens) {
                            if (!validRobotsValues.contains(token.trim().toLowerCase())) continue;
                            if (sb.length() != 0) {
                                sb.append(',');
                            }
                            sb.append(token);
                        }
                        if (sb.length() > 0) {
                            hn.put("name", name);
                            hn.put("content", sb.toString());
                        }
                    }
                } else if (http_equiv != null && name == null) {
                    if (http_equiv.equalsIgnoreCase("Expires")) {
                        try {
                            ToadletContextImpl.parseHTTPDate(content);
                            hn.put("http-equiv", http_equiv);
                            hn.put("content", content);
                        }
                        catch (ParseException e) {
                            return null;
                        }
                    }
                    if (!http_equiv.equalsIgnoreCase("Content-Script-Type")) {
                        if (http_equiv.equalsIgnoreCase("Content-Style-Type")) {
                            if (content.equalsIgnoreCase("text/css")) {
                                hn.put("http-equiv", http_equiv);
                                hn.put("content", content);
                            }
                        } else if (http_equiv.equalsIgnoreCase("Content-Type")) {
                            if (logMINOR) {
                                Logger.minor(this, "Found http-equiv content-type=" + content);
                            }
                            String[] typesplit = HTMLFilter.splitType(content);
                            if (logDEBUG) {
                                for (int i = 0; i < typesplit.length; ++i) {
                                    Logger.debug(this, "[" + i + "] = " + typesplit[i]);
                                }
                            }
                            boolean detected = false;
                            for (String allowedContentType : allowedContentTypes) {
                                if (!typesplit[0].equalsIgnoreCase(allowedContentType)) continue;
                                if (typesplit[1] == null || pc.charset != null && typesplit[1].equalsIgnoreCase(pc.charset)) {
                                    hn.put("http-equiv", http_equiv);
                                    hn.put("content", typesplit[0] + (typesplit[1] != null ? "; charset=" + typesplit[1] : ""));
                                } else if (typesplit[1] != null && pc.charset != null && !typesplit[1].equalsIgnoreCase(pc.charset)) {
                                    HTMLFilter.throwFilterException(HTMLFilter.l10n("wrongCharsetInMeta"));
                                } else if (typesplit[1] != null) {
                                    if (pc.detectedCharset != null) {
                                        HTMLFilter.throwFilterException(HTMLFilter.l10n("multipleCharsetsInMeta"));
                                    }
                                    pc.detectedCharset = typesplit[1].trim();
                                }
                                detected = true;
                                break;
                            }
                            if (!detected) {
                                HTMLFilter.throwFilterException(HTMLFilter.l10n("invalidMetaType"));
                            }
                        } else if (http_equiv.equalsIgnoreCase("Content-Language")) {
                            if (content.matches("((?>[a-zA-Z0-9]*)(?>-[A-Za-z0-9]*)*(?>,\\s*)?)*") && !content.trim().isEmpty()) {
                                hn.put("http-equiv", "Content-Language");
                                hn.put("content", content);
                            }
                        } else if (http_equiv.equalsIgnoreCase("refresh")) {
                            int idx = content.indexOf(59);
                            if (idx == -1 && metaRefreshSamePageMinInterval >= 0) {
                                try {
                                    int seconds = Integer.parseInt(content);
                                    if (seconds < 0) {
                                        return null;
                                    }
                                    if (seconds < metaRefreshSamePageMinInterval) {
                                        seconds = metaRefreshSamePageMinInterval;
                                    }
                                    hn.put("http-equiv", "refresh");
                                    hn.put("content", Integer.toString(seconds));
                                }
                                catch (NumberFormatException e) {
                                    pc.writeAfterTag.append("<!-- doesn't parse as number in meta refresh -->");
                                    return null;
                                }
                            }
                            if (metaRefreshRedirectMinInterval >= 0) {
                                String before = content.substring(0, idx);
                                String after = content.substring(idx + 1).trim();
                                try {
                                    int seconds = Integer.parseInt(before);
                                    if (seconds < 0) {
                                        return null;
                                    }
                                    if (seconds < metaRefreshRedirectMinInterval) {
                                        seconds = metaRefreshRedirectMinInterval;
                                    }
                                    if (!after.toLowerCase().startsWith("url=")) {
                                        pc.writeAfterTag.append("<!-- no url but doesn't parse as number in meta refresh -->");
                                        return null;
                                    }
                                    after = after.substring("url=".length()).trim();
                                    try {
                                        String url = HTMLFilter.sanitizeURI(after, null, null, null, pc.cb, false);
                                        hn.put("http-equiv", "refresh");
                                        hn.put("content", "" + seconds + "; url=" + HTMLEncoder.encode(url));
                                    }
                                    catch (CommentException e) {
                                        pc.writeAfterTag.append("<!-- " + e.getMessage() + "-->");
                                        return null;
                                    }
                                }
                                catch (NumberFormatException e) {
                                    pc.writeAfterTag.append("<!-- doesn't parse as number in meta refresh possibly with url -->");
                                    return null;
                                }
                            }
                        }
                    }
                }
            }
            if ((charset = HTMLFilter.getHashString(h, "charset")) != null) {
                if (pc.detectedCharset != null && !charset.equalsIgnoreCase(pc.detectedCharset)) {
                    HTMLFilter.throwFilterException(HTMLFilter.l10n("multipleCharsetsInMeta"));
                }
                pc.detectedCharset = charset;
                hn.put("charset", charset);
            }
            return hn;
        }

        @Override
        protected boolean expungeTagIfNoAttributes() {
            return true;
        }

        static {
            validRobotsValues.addAll(Arrays.asList(validRobotsValue));
        }
    }

    static class InputTagVerifier
    extends CoreTagVerifier {
        private final HashSet<String> allowedTypes;
        private String[] types = new String[]{"text", "password", "checkbox", "radio", "submit", "reset", "hidden", "image", "button", "email", "number", "search", "tel", "url"};

        InputTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] inlineURIAttrs, String[] eventAttrs) {
            super(tag, allowedAttrs, uriAttrs, inlineURIAttrs, eventAttrs, null);
            this.allowedTypes = new HashSet();
            if (this.types != null) {
                this.allowedTypes.addAll(Arrays.asList(this.types));
            }
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            if (!this.allowedTypes.contains(hn.get("type").toString().toLowerCase())) {
                return null;
            }
            return hn;
        }
    }

    static class FormTagVerifier
    extends CoreTagVerifier {
        private static final String[] locallyVerifiedAttrs = new String[]{"method", "action", "enctype", "accept-charset"};

        FormTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] eventAttrs) {
            super(tag, allowedAttrs, uriAttrs, null, eventAttrs, null);
            this.parsedAttrs.addAll(Arrays.asList(locallyVerifiedAttrs));
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            String finalAction;
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            if (p.startSlash) {
                return hn;
            }
            String method = HTMLFilter.getHashString(h, "method");
            String action = HTMLFilter.getHashString(h, "action");
            try {
                finalAction = pc.cb.processForm(method, action);
            }
            catch (CommentException e) {
                pc.writeAfterTag.append("<!-- ").append(HTMLEncoder.encode(e.toString())).append(" -->");
                return null;
            }
            if (finalAction == null) {
                return null;
            }
            hn.put("method", method);
            hn.put("action", finalAction);
            hn.put("enctype", "multipart/form-data");
            hn.put("accept-charset", "UTF-8");
            return hn;
        }
    }

    static class MediaTagVerifier
    extends CoreTagVerifier {
        private static final String[] locallyVerifiedAttrs = new String[]{"src"};

        MediaTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] inlineURIAttrs, String[] eventAttrs, String[] booleanAttrs) {
            super(tag, allowedAttrs, uriAttrs, inlineURIAttrs, eventAttrs, booleanAttrs);
            this.parsedAttrs.addAll(Arrays.asList(locallyVerifiedAttrs));
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            String src = HTMLFilter.getHashString(h, "src");
            if (src != null) {
                src = HTMLDecoder.decode(src);
                String type = ContentFilter.mimeTypeForSrc(src);
                if ((src = HTMLFilter.htmlSanitizeURI(src, type, null, null, pc.cb, pc, false)) != null) {
                    src = HTMLEncoder.encode(src);
                    hn.put("src", src);
                }
            }
            return hn;
        }
    }

    static class LinkTagVerifier
    extends CoreTagVerifier {
        private static final String[] locallyVerifiedAttrs = new String[]{"type", "charset", "rel", "rev", "media", "hreflang", "href"};
        private static final HashSet<String> standardRelTypes = new HashSet();

        LinkTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] inlineURIAttrs, String[] eventAttrs) {
            super(tag, allowedAttrs, uriAttrs, inlineURIAttrs, eventAttrs, null);
            this.parsedAttrs.addAll(Arrays.asList(locallyVerifiedAttrs));
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            String href;
            String rev;
            String c;
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            String hreflang = HTMLFilter.getHashString(h, "hreflang");
            String charset = null;
            String maybecharset = null;
            String type = HTMLFilter.getHashString(h, "type");
            if (type != null) {
                String[] typesplit = HTMLFilter.splitType(type);
                type = typesplit[0];
                if (typesplit[1] != null && !typesplit[1].isEmpty()) {
                    charset = typesplit[1];
                }
                if (logDEBUG) {
                    Logger.debug(this, "Processing link tag, type=" + type + ", charset=" + charset);
                }
            }
            if ((c = HTMLFilter.getHashString(h, "charset")) != null) {
                charset = c;
            }
            if (charset != null) {
                try {
                    charset = URLDecoder.decode(charset, false);
                }
                catch (URLEncodedFormatException e) {
                    charset = null;
                }
            }
            if (charset != null && charset.indexOf(38) != -1) {
                charset = null;
            }
            if (charset != null && !Charset.isSupported(charset)) {
                charset = null;
            }
            String rel = HTMLFilter.getHashString(h, "rel");
            String parsedRel = "";
            String parsedRev = "";
            boolean isStylesheet = false;
            boolean isIcon = false;
            if (rel != null) {
                rel = rel.toLowerCase();
                StringTokenizer tok = new StringTokenizer(rel, " ");
                int i = 0;
                String prevToken = null;
                StringBuffer sb = new StringBuffer(rel.length());
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (token.equalsIgnoreCase("stylesheet")) {
                        isStylesheet = true;
                        if (!(i == 0 || i == 1 && prevToken != null && prevToken.equalsIgnoreCase("alternate"))) {
                            return null;
                        }
                        if (tok.hasMoreTokens()) {
                            return null;
                        }
                    } else if (token.equalsIgnoreCase("icon")) {
                        isIcon = true;
                    } else if (!this.isStandardLinkType(token)) continue;
                    ++i;
                    if (sb.length() == 0) {
                        sb.append(token);
                    } else {
                        sb.append(' ');
                        sb.append(token);
                    }
                    prevToken = token;
                }
                parsedRel = sb.toString();
            }
            if ((rev = HTMLFilter.getHashString(h, "rev")) != null) {
                StringBuffer sb = new StringBuffer(rev.length());
                rev = rev.toLowerCase();
                StringTokenizer tok = new StringTokenizer(rev, " ");
                sb = new StringBuffer(rev.length());
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (!this.isStandardLinkType(token)) continue;
                    if (sb.length() == 0) {
                        sb.append(token);
                        continue;
                    }
                    sb.append(' ');
                    sb.append(token);
                }
                parsedRev = sb.toString();
            }
            if (!parsedRel.isEmpty()) {
                hn.put("rel", parsedRel);
            }
            if (!parsedRev.isEmpty()) {
                hn.put("rev", parsedRev);
            }
            if (rel != null) {
                if (rel.equals("stylesheet") || rel.equals("alternate stylesheet")) {
                    isStylesheet = true;
                }
            } else if (type != null && type.startsWith("text/css")) {
                return null;
            }
            if (isStylesheet) {
                String media;
                if (charset == null) {
                    maybecharset = pc.charset;
                }
                if ((media = HTMLFilter.getHashString(h, "media")) != null) {
                    media = CSSReadFilter.filterMediaList(media);
                }
                if (media != null) {
                    hn.put("media", media);
                }
                if (type != null && !type.startsWith("text/css")) {
                    return null;
                }
                type = "text/css";
            }
            if ((href = HTMLFilter.getHashString(h, "href")) != null) {
                href = HTMLDecoder.decode(href);
                href = isIcon ? HTMLFilter.htmlSanitizeURI(href, type, null, null, pc.cb, pc, false) : HTMLFilter.htmlSanitizeURI(href, type, charset, maybecharset, pc.cb, pc, false);
                if (href != null) {
                    href = HTMLEncoder.encode(href);
                    hn.put("href", href);
                    if (type != null) {
                        hn.put("type", type);
                    }
                    if (charset != null) {
                        hn.put("charset", charset);
                    }
                    if (charset != null && hreflang != null) {
                        hn.put("hreflang", hreflang);
                    }
                }
            }
            return hn;
        }

        private boolean isStandardLinkType(String token) {
            return standardRelTypes.contains(token.toLowerCase());
        }

        static {
            standardRelTypes.addAll(Arrays.asList("alternate", "start", "next", "prev", "contents", "index", "glossary", "copyright", "chapter", "section", "subsection", "appendix", "help", "bookmark"));
        }
    }

    static class CoreTagVerifier
    extends BaseCoreTagVerifier {
        private final HashSet<String> eventAttrs = new HashSet();
        private static final String[] stdEvents = new String[]{"onclick", "ondblclick", "onmousedown", "onmouseup", "onmouseover", "onmousemove", "onmouseout", "onkeypress", "onkeydown", "onkeyup", "onload", "onfocus", "onblur", "oncontextmenu", "onresize", "onscroll", "onunload", "onmouseenter", "onchange", "onreset", "onselect", "onsubmit", "onerror"};

        CoreTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] inlineURIAttrs, String[] eventAttrs, String[] booleanAttrs) {
            this(tag, allowedAttrs, uriAttrs, inlineURIAttrs, eventAttrs, booleanAttrs, true);
        }

        CoreTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] inlineURIAttrs, String[] eventAttrs, String[] booleanAttrs, boolean addStdEvents) {
            super(tag, allowedAttrs, uriAttrs, inlineURIAttrs, booleanAttrs);
            if (eventAttrs != null) {
                for (String eventAttr : eventAttrs) {
                    this.eventAttrs.add(eventAttr);
                    this.parsedAttrs.add(eventAttr);
                }
            }
            if (addStdEvents) {
                for (String stdEvent : stdEvents) {
                    this.eventAttrs.add(stdEvent);
                    this.parsedAttrs.add(stdEvent);
                }
            }
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            for (String name : this.eventAttrs) {
                String arg = HTMLFilter.getHashString(h, name);
                if (arg == null || (arg = HTMLFilter.sanitizeScripting(arg)) == null) continue;
                hn.put(name, arg);
            }
            return hn;
        }
    }

    static class BaseCoreTagVerifier
    extends TagVerifier {
        private static final String[] locallyVerifiedAttrs = new String[]{"id", "class", "style"};

        BaseCoreTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] inlineURIAttrs, String[] booleanAttrs) {
            super(tag, allowedAttrs, uriAttrs, inlineURIAttrs, booleanAttrs);
            allowedHTMLTags.add(tag);
            this.parsedAttrs.addAll(Arrays.asList(locallyVerifiedAttrs));
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            String title;
            String style;
            String classNames;
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            String id = HTMLFilter.getHashString(h, "id");
            if (id != null) {
                hn.put("id", id);
            }
            if ((classNames = HTMLFilter.getHashString(h, "class")) != null) {
                hn.put("class", classNames);
            }
            if ((style = HTMLFilter.getHashString(h, "style")) != null) {
                if ((style = HTMLFilter.sanitizeStyle(style, pc.cb, pc, true)) != null) {
                    style = HTMLFilter.escapeQuotes(style);
                }
                if (style != null) {
                    hn.put("style", style);
                }
            }
            if ((title = HTMLFilter.getHashString(h, "title")) != null) {
                hn.put("title", title);
            }
            return hn;
        }
    }

    static class ScriptTagVerifier
    extends ScriptStyleTagVerifier {
        ScriptTagVerifier() {
            super("script", new String[]{"id", "charset", "type", "language", "defer", "xml:space"}, new String[]{"src"});
        }

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> hn, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            super.sanitizeHash(hn, p, pc);
            return null;
        }

        @Override
        void setStyle(boolean b, HTMLParseContext pc) {
            pc.inScript = b;
        }

        @Override
        boolean getStyle(HTMLParseContext pc) {
            return pc.inScript;
        }

        @Override
        void processStyle(HTMLParseContext pc) {
            pc.currentStyleScriptChunk = HTMLFilter.sanitizeScripting(pc.currentStyleScriptChunk);
        }
    }

    static class StyleTagVerifier
    extends ScriptStyleTagVerifier {
        StyleTagVerifier() {
            super("style", new String[]{"id", "media", "title", "xml:space"}, emptyStringArray);
        }

        @Override
        void setStyle(boolean b, HTMLParseContext pc) {
            pc.inStyle = b;
        }

        @Override
        boolean getStyle(HTMLParseContext pc) {
            return pc.inStyle;
        }

        @Override
        void processStyle(HTMLParseContext pc) {
            try {
                pc.currentStyleScriptChunk = HTMLFilter.sanitizeStyle(pc.currentStyleScriptChunk, pc.cb, pc, false);
            }
            catch (DataFilterException e) {
                Logger.error(this, "Error parsing style: " + e, (Throwable)e);
                pc.currentStyleScriptChunk = "";
            }
        }
    }

    static abstract class ScriptStyleTagVerifier
    extends TagVerifier {
        ScriptStyleTagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs) {
            super(tag, allowedAttrs, uriAttrs, null, null);
        }

        abstract void setStyle(boolean var1, HTMLParseContext var2);

        abstract boolean getStyle(HTMLParseContext var1);

        abstract void processStyle(HTMLParseContext var1);

        @Override
        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            Map<String, Object> hn = super.sanitizeHash(h, p, pc);
            if (p.startSlash) {
                return this.finish(h, hn, pc);
            }
            return this.start(h, hn, pc);
        }

        Map<String, Object> finish(Map<String, Object> h, Map<String, Object> hn, HTMLParseContext pc) throws DataFilterException {
            if (logDEBUG) {
                Logger.debug(this, "Finishing script/style");
            }
            this.setStyle(false, pc);
            --pc.styleScriptRecurseCount;
            if (pc.styleScriptRecurseCount < 0) {
                pc.writeAfterTag.append("<!-- " + HTMLFilter.l10n("tooManyNestedStyleOrScriptTags") + " -->");
                return null;
            }
            if (!pc.killStyle) {
                this.processStyle(pc);
                pc.writeStyleScriptWithTag = true;
            } else {
                pc.killStyle = false;
                pc.currentStyleScriptChunk = "";
            }
            pc.expectingBadComment = false;
            return hn;
        }

        Map<String, Object> start(Map<String, Object> h, Map<String, Object> hn, HTMLParseContext pc) throws DataFilterException {
            if (logDEBUG) {
                Logger.debug(this, "Starting script/style");
            }
            ++pc.styleScriptRecurseCount;
            if (pc.styleScriptRecurseCount > 1) {
                pc.writeAfterTag.append("<!-- " + HTMLFilter.l10n("tooManyNestedStyleOrScriptTags") + " -->");
                return null;
            }
            this.setStyle(true, pc);
            String type = HTMLFilter.getHashString(h, "type");
            if (type != null) {
                if (!type.equalsIgnoreCase("text/css")) {
                    pc.killStyle = true;
                    pc.expectingBadComment = true;
                    return null;
                }
                hn.put("type", "text/css");
            }
            return hn;
        }
    }

    static class TagVerifier {
        private final String tag;
        private final HashSet<String> allowedAttrs;
        protected final HashSet<String> parsedAttrs;
        private final HashSet<String> uriAttrs;
        private final HashSet<String> inlineURIAttrs;
        final HashSet<String> booleanAttrs;
        private final HashSet<String> allowedRole;

        TagVerifier(String tag, String[] allowedAttrs) {
            this(tag, allowedAttrs, null, null, null);
        }

        TagVerifier(String tag, String[] allowedAttrs, String[] uriAttrs, String[] inlineURIAttrs, String[] booleanAttrs) {
            this.tag = tag;
            this.allowedAttrs = new HashSet();
            this.parsedAttrs = new HashSet();
            if (allowedAttrs != null) {
                this.allowedAttrs.addAll(Arrays.asList(allowedAttrs));
            }
            this.uriAttrs = new HashSet();
            if (uriAttrs != null) {
                this.uriAttrs.addAll(Arrays.asList(uriAttrs));
            }
            this.inlineURIAttrs = new HashSet();
            if (inlineURIAttrs != null) {
                this.inlineURIAttrs.addAll(Arrays.asList(inlineURIAttrs));
            }
            this.booleanAttrs = new HashSet();
            if (booleanAttrs != null) {
                this.booleanAttrs.addAll(Arrays.asList(booleanAttrs));
            }
            this.allowedRole = new HashSet<String>(Arrays.asList("alert", "alertdialog", "application", "article", "banner", "blockquote", "button", "caption", "cell", "checkbox", "code", "columnheader", "combobox", "command", "comment", "complementary", "composite", "contentinfo", "definition", "deletion", "dialog", "directory", "document", "emphasis", "feed", "figure", "form", "generic", "grid", "gridcell", "group", "heading", "image", "img", "input", "insertion", "landmark", "link", "list", "listbox", "listitem", "log", "main", "mark", "marquee", "math", "menu", "menubar", "menuitem", "menuitemcheckbox", "menuitemradio", "meter", "navigation", "none", "note", "option", "paragraph", "presentation", "progressbar", "radio", "radiogroup", "range", "region", "roletype", "row", "rowgroup", "rowheader", "scrollbar", "search", "searchbox", "section", "sectionhead", "select", "separator", "slider", "spinbutton", "status", "strong", "structure", "subscript", "suggestion", "superscript", "switch", "tab", "table", "tablist", "tabpanel", "term", "textbox", "time", "timer", "toolbar", "tooltip", "tree", "treegrid", "treeitem", "widget", "window"));
        }

        ParsedTag sanitize(ParsedTag t, HTMLParseContext pc) throws DataFilterException {
            String y;
            Map<String, Object> h = new LinkedHashMap<String, Object>();
            boolean equals = false;
            String prevX = "";
            if (t.unparsedAttrs != null) {
                for (String s : t.unparsedAttrs) {
                    if (equals) {
                        equals = false;
                        s = HTMLFilter.stripQuotes(s);
                        h.remove(prevX);
                        h.put(prevX, s);
                        prevX = "";
                        continue;
                    }
                    int idx = s.indexOf(61);
                    if (idx == s.length() - 1) {
                        equals = true;
                        if (idx == 0) continue;
                        prevX = s.substring(0, s.length() - 1);
                        prevX = prevX.toLowerCase();
                        continue;
                    }
                    if (idx > -1) {
                        String x = s.substring(0, idx);
                        if (x.isEmpty()) {
                            x = prevX;
                        }
                        x = x.toLowerCase();
                        y = idx == s.length() - 1 ? "" : s.substring(idx + 1, s.length());
                        y = HTMLFilter.stripQuotes(y);
                        h.remove(x);
                        h.put(x, y);
                        prevX = x;
                        continue;
                    }
                    h.remove(s);
                    h.put(s, new Object());
                    prevX = s;
                }
            }
            if ((h = this.sanitizeHash(h, t, pc)) == null) {
                return null;
            }
            h.entrySet().removeIf(entry -> entry.getValue() == null || entry.getValue().equals("") && pc.isXHTML);
            if (h.isEmpty() && this.expungeTagIfNoAttributes()) {
                return null;
            }
            if (t.startSlash) {
                return new ParsedTag(t, (String[])null);
            }
            String[] outAttrs = new String[h.size()];
            int i = 0;
            for (Map.Entry<String, Object> entry2 : h.entrySet()) {
                String x = entry2.getKey();
                Object o = entry2.getValue();
                y = o instanceof String ? (String)o : null;
                StringBuilder out = new StringBuilder(x);
                if (y != null) {
                    out.append("=\"").append(y).append('\"');
                }
                outAttrs[i++] = out.toString();
            }
            return new ParsedTag(t, outAttrs);
        }

        Map<String, Object> sanitizeHash(Map<String, Object> h, ParsedTag p, HTMLParseContext pc) throws DataFilterException {
            LinkedHashMap<String, Object> hn = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : h.entrySet()) {
                if (logDEBUG) {
                    Logger.debug(this, "HTML Filter is sanitizing: " + entry.getKey() + " = " + entry.getValue());
                }
                String x = entry.getKey();
                Object o = entry.getValue();
                boolean inline = this.inlineURIAttrs.contains(x);
                if (inline || this.uriAttrs.contains(x)) {
                    if (!inline) {
                        if (logMINOR) {
                            Logger.minor(this, "Non-inline URI attribute: " + x);
                        }
                    } else if (logMINOR) {
                        Logger.minor(this, "Inline URI attribute: " + x);
                    }
                    if (o instanceof String) {
                        String uri = (String)o;
                        uri = HTMLDecoder.decode(uri);
                        if ((uri = HTMLFilter.htmlSanitizeURI(uri, null, null, null, pc.cb, pc, inline)) == null) continue;
                        uri = HTMLEncoder.encode(uri);
                        o = uri;
                    }
                    if (logDEBUG) {
                        Logger.debug(this, "HTML Filter is putting " + (inline ? "inline" : "") + " uri attribute: " + x + " =  " + o);
                    }
                    hn.put(x, o);
                    continue;
                }
                if (this.parsedAttrs.contains(x)) {
                    hn.put(x, null);
                    continue;
                }
                if (this.allowedAttrs.contains(x)) {
                    hn.put(x, o);
                    continue;
                }
                if (this.booleanAttrs.contains(x)) {
                    String value = null;
                    if (o instanceof String) {
                        value = (String)o;
                    }
                    if (value != null && value.equalsIgnoreCase(x) || !pc.isXHTML && o == null) {
                        hn.put(x, o);
                        continue;
                    }
                }
                if (x.equals("xml:lang") || x.equals("lang") || x.equals("dir") && o instanceof String && (((String)o).equalsIgnoreCase("ltr") || ((String)o).equalsIgnoreCase("rtl") || ((String)o).equalsIgnoreCase("auto"))) {
                    if (logDEBUG) {
                        Logger.debug(this, "HTML Filter is putting attribute: " + x + " =  " + o);
                    }
                    hn.put(x, o);
                }
                if (!x.equals("role") || !(o instanceof String) || !this.allowedRole.contains((String)o)) continue;
                hn.put(x, o);
            }
            return hn;
        }

        protected boolean expungeTagIfNoAttributes() {
            return false;
        }
    }

    public static class ParsedTag {
        public final String element;
        public final String[] unparsedAttrs;
        final boolean startSlash;
        final boolean endSlash;

        public ParsedTag(String elementName, Map<String, String> attributes) {
            this.element = elementName;
            this.startSlash = false;
            this.endSlash = true;
            String[] attrs = new String[attributes.size()];
            int pos = 0;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                attrs[pos++] = entry.getKey() + "=\"" + entry.getValue() + "\"";
            }
            this.unparsedAttrs = attrs;
        }

        public ParsedTag(ParsedTag t, String[] outAttrs) {
            this.element = t.element;
            this.unparsedAttrs = outAttrs;
            this.startSlash = t.startSlash;
            this.endSlash = t.endSlash;
        }

        public ParsedTag(ParsedTag t, Map<String, String> attributes) {
            String[] attrs = new String[attributes.size()];
            int pos = 0;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                attrs[pos++] = entry.getKey() + "=\"" + entry.getValue() + "\"";
            }
            this.element = t.element;
            this.unparsedAttrs = attrs;
            this.startSlash = t.startSlash;
            this.endSlash = t.endSlash;
        }

        public ParsedTag(List<String> v) {
            int len = v.size();
            if (len == 0) {
                this.element = null;
                this.unparsedAttrs = new String[0];
                this.endSlash = false;
                this.startSlash = false;
                return;
            }
            String s = v.get(len - 1);
            if ((len - 1 != 0 || s.length() > 1) && s.endsWith("/")) {
                s = s.substring(0, s.length() - 1);
                v.set(len - 1, s);
                if (s.isEmpty()) {
                    --len;
                }
                this.endSlash = true;
            } else {
                this.endSlash = false;
            }
            s = v.get(0);
            if (s.length() > 1 && s.startsWith("/")) {
                s = s.substring(1);
                v.set(0, s);
                this.startSlash = true;
            } else {
                this.startSlash = false;
            }
            this.element = v.get(0);
            if (len > 1) {
                this.unparsedAttrs = new String[len - 1];
                for (int x = 1; x < len; ++x) {
                    this.unparsedAttrs[x - 1] = v.get(x);
                }
            } else {
                this.unparsedAttrs = new String[0];
            }
            if (logDEBUG) {
                Logger.debug(this, "Element = " + this.element);
            }
        }

        public ParsedTag sanitize(HTMLParseContext pc) throws DataFilterException {
            TagVerifier tv = allowedTagsVerifiers.get(this.element.toLowerCase());
            if (logDEBUG) {
                Logger.debug(this, "Got verifier: " + tv + " for " + this.element);
            }
            if (tv == null) {
                return null;
            }
            return tv.sanitize(this, pc);
        }

        public String toString() {
            if (this.element == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder("<");
            if (this.startSlash) {
                sb.append('/');
            }
            sb.append(this.element);
            if (this.unparsedAttrs != null) {
                int n = this.unparsedAttrs.length;
                for (int i = 0; i < n; ++i) {
                    sb.append(' ').append(this.unparsedAttrs[i]);
                }
            }
            if (this.endSlash) {
                sb.append(" /");
            }
            sb.append('>');
            return sb.toString();
        }

        public Map<String, String> getAttributesAsMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String attr : this.unparsedAttrs) {
                String name = attr.substring(0, attr.indexOf(61));
                String value = attr.substring(attr.indexOf(61) + 2, attr.length() - 1);
                map.put(name, value);
            }
            return map;
        }

        public void htmlwrite(Writer w, HTMLParseContext pc) throws IOException {
            String s = this.toString();
            if (pc.getisXHTML() && ElementInfo.isVoidElement(this.element) && s.charAt(s.length() - 2) != '/') {
                s = s.substring(0, s.length() - 1) + " />";
            }
            if (s != null) {
                w.write(s);
            }
        }

        public void write(Writer w, HTMLParseContext pc) throws IOException {
            if (!this.startSlash) {
                if (ElementInfo.tryAutoClose(this.element) && this.element.equals(pc.peekTopElement())) {
                    pc.closeXHTMLTag(this.element, w);
                }
                if (pc.getisXHTML() && !ElementInfo.isVoidElement(this.element)) {
                    pc.pushElementInStack(this.element);
                }
                this.htmlwrite(w, pc);
            } else if (pc.getisXHTML()) {
                pc.closeXHTMLTag(this.element, w);
            } else {
                this.htmlwrite(w, pc);
            }
        }
    }

    class HTMLParseContext {
        Reader r;
        Writer w;
        String charset;
        String detectedCharset;
        final FilterCallback cb;
        final boolean onlyDetectingCharset;
        boolean isXHTML = false;
        Stack<String> openElements;
        boolean failedDetectCharset;
        boolean wasHeadElementFound = false;
        boolean headEnded = false;
        boolean wasMediaElementFound = false;
        int mode;
        static final int INTEXT = 0;
        static final int INTAG = 1;
        static final int INTAGQUOTES = 2;
        static final int INTAGSQUOTES = 3;
        static final int INTAGCOMMENT = 4;
        static final int INTAGCOMMENTCLOSING = 5;
        static final int INTAGWHITESPACE = 6;
        boolean killTag = false;
        boolean writeStyleScriptWithTag = false;
        boolean expectingBadComment = false;
        boolean inStyle = false;
        boolean inScript = false;
        boolean killText = false;
        boolean killStyle = false;
        int styleScriptRecurseCount = 0;
        String currentStyleScriptChunk = "";
        StringBuilder writeAfterTag = new StringBuilder(1024);

        HTMLParseContext(Reader r, Writer w, String charset, FilterCallback cb, boolean onlyDetectingCharset) {
            this.r = r;
            this.w = w;
            this.charset = charset;
            this.cb = cb;
            this.onlyDetectingCharset = onlyDetectingCharset;
            this.openElements = new Stack();
        }

        public void setisXHTML(boolean value) {
            this.isXHTML = value;
        }

        public boolean getisXHTML() {
            return this.isXHTML;
        }

        public void pushElementInStack(String element) {
            this.openElements.push(element);
        }

        public String popElementFromStack() {
            if (!this.openElements.isEmpty()) {
                return this.openElements.pop();
            }
            return null;
        }

        public String peekTopElement() {
            if (this.openElements.isEmpty()) {
                return null;
            }
            return this.openElements.peek();
        }

        void run() throws IOException, DataFilterException {
            StringBuilder b = new StringBuilder(100);
            StringBuilder balt = new StringBuilder(4000);
            ArrayList<String> splitTag = new ArrayList<String>();
            String currentTag = null;
            char pprevC = '\u0000';
            char prevC = '\u0000';
            char c = '\u0000';
            this.mode = 0;
            boolean textAllowed = false;
            boolean firstChar = true;
            block18: while (true) {
                if (this.onlyDetectingCharset && this.failedDetectCharset) {
                    return;
                }
                if (this.onlyDetectingCharset && this.detectedCharset != null) {
                    return;
                }
                int x = this.r.read();
                if (x == -1) {
                    switch (this.mode) {
                        case 0: {
                            if (textAllowed) {
                                HTMLFilter.this.saveText(b, currentTag, this.w, this);
                                break;
                            }
                            if (b.toString().trim().isEmpty()) break block18;
                            HTMLFilter.throwFilterException(HTMLFilter.l10n("textBeforeHTML"));
                            break;
                        }
                        case 1: {
                            this.w.write("<!-- truncated page: last tag not unfinished -->");
                            break;
                        }
                        case 2: {
                            this.w.write("<!-- truncated page: deleted unfinished tag: still in quotes -->");
                            break;
                        }
                        case 3: {
                            this.w.write("<!-- truncated page: deleted unfinished tag: still in single quotes -->");
                            break;
                        }
                        case 6: {
                            this.w.write("<!-- truncated page: deleted unfinished tag: still in whitespace -->");
                            break;
                        }
                        case 4: {
                            this.w.write("<!-- truncated page: deleted unfinished comment -->");
                            break;
                        }
                        case 5: {
                            this.w.write("<!-- truncated page: deleted unfinished comment, might be closing -->");
                            break;
                        }
                    }
                    break;
                }
                pprevC = prevC;
                prevC = c;
                c = (char)x;
                if (c == '\ufeff') {
                    if (!firstChar || this.w == null) continue;
                    this.w.write(c);
                    continue;
                }
                if (c == '\u0000') continue;
                firstChar = false;
                switch (this.mode) {
                    case 0: {
                        if (c == '<') {
                            if (textAllowed) {
                                HTMLFilter.this.saveText(b, currentTag, this.w, this);
                            } else if (!b.toString().trim().isEmpty()) {
                                HTMLFilter.throwFilterException(HTMLFilter.l10n("textBeforeHTML"));
                            }
                            b.setLength(0);
                            balt.setLength(0);
                            this.mode = 1;
                            break;
                        }
                        b.append(c);
                        break;
                    }
                    case 1: {
                        balt.append(c);
                        if (HTMLDecoder.isWhitespace(c)) {
                            splitTag.add(b.toString());
                            this.mode = 6;
                            b.setLength(0);
                            break;
                        }
                        if (c == '<' && Character.isWhitespace(balt.charAt(0))) {
                            if (textAllowed) {
                                HTMLFilter.this.saveText(b, currentTag, this.w, this);
                            } else if (!b.toString().trim().isEmpty()) {
                                HTMLFilter.throwFilterException(HTMLFilter.l10n("textBeforeHTML"));
                            }
                            balt.setLength(0);
                            b.setLength(0);
                            splitTag.clear();
                            break;
                        }
                        if (c == '>') {
                            String s;
                            splitTag.add(b.toString());
                            b.setLength(0);
                            currentTag = s = HTMLFilter.this.processTag(splitTag, this.w, this);
                            splitTag.clear();
                            balt.setLength(0);
                            this.mode = 0;
                            if (s == null) continue block18;
                            textAllowed = true;
                            break;
                        }
                        if (b.length() == 2 && c == '-' && prevC == '-' && pprevC == '!') {
                            this.mode = 4;
                            b.append(c);
                            break;
                        }
                        if (c == '\"') {
                            this.mode = 2;
                            b.append(c);
                            break;
                        }
                        if (c == '\'') {
                            this.mode = 3;
                            b.append(c);
                            break;
                        }
                        if (c == '/') {
                            currentTag = null;
                            b.append(c);
                            break;
                        }
                        b.append(c);
                        break;
                    }
                    case 2: {
                        if (c == '\"') {
                            this.mode = 1;
                            b.append(c);
                            break;
                        }
                        if (c == '>') {
                            b.append("&gt;");
                            break;
                        }
                        if (c == '<') {
                            b.append("&lt;");
                            break;
                        }
                        if (c == '\u00a0') {
                            b.append("&nbsp;");
                            break;
                        }
                        b.append(c);
                        break;
                    }
                    case 3: {
                        if (c == '\'') {
                            this.mode = 1;
                            b.append(c);
                            break;
                        }
                        if (c == '<') {
                            b.append("&lt;");
                            break;
                        }
                        if (c == '>') {
                            b.append("&gt;");
                            break;
                        }
                        if (c == '\u00a0') {
                            b.append("&nbsp;");
                            break;
                        }
                        b.append(c);
                        break;
                    }
                    case 4: {
                        if (b.length() >= 4 && c == '-' && prevC == '-') {
                            b.append(c);
                            this.mode = 5;
                            break;
                        }
                        b.append(c);
                        break;
                    }
                    case 5: {
                        if (c == '>') {
                            HTMLFilter.this.saveComment(b, this.w, this);
                            b.setLength(0);
                            this.mode = 0;
                            break;
                        }
                        b.append(c);
                        if (c == '-') break;
                        this.mode = 4;
                        break;
                    }
                    case 6: {
                        if (c == '\"') {
                            this.mode = 2;
                            b.append(c);
                            break;
                        }
                        if (c == '\'') {
                            this.mode = 3;
                            b.append(c);
                            break;
                        }
                        if (c == '>') {
                            currentTag = !this.killTag ? HTMLFilter.this.processTag(splitTag, this.w, this) : null;
                            this.killTag = false;
                            splitTag.clear();
                            b.setLength(0);
                            balt.setLength(0);
                            this.mode = 0;
                            if (currentTag == null) break;
                            textAllowed = true;
                            break;
                        }
                        if (c == '<' && Character.isWhitespace(balt.charAt(0))) {
                            if (textAllowed) {
                                HTMLFilter.this.saveText(b, currentTag, this.w, this);
                            } else if (!b.toString().trim().isEmpty()) {
                                HTMLFilter.throwFilterException(HTMLFilter.l10n("textBeforeHTML"));
                            }
                            balt.setLength(0);
                            b.setLength(0);
                            splitTag.clear();
                            this.mode = 1;
                            break;
                        }
                        if (HTMLDecoder.isWhitespace(c)) continue block18;
                        this.mode = 1;
                        b.append(c);
                    }
                }
            }
            if (this.onlyDetectingCharset && this.openElements.contains("head")) {
                throw new MalformedInputException(65536);
            }
            if (this.getisXHTML()) {
                while (!this.openElements.isEmpty()) {
                    this.w.write("</" + this.openElements.pop() + ">");
                }
            }
            this.w.flush();
        }

        public void closeXHTMLTag(String element, Writer w) throws IOException {
            if (this.openElements.isEmpty()) {
                return;
            }
            if (element.equals(this.openElements.peek())) {
                w.write("</" + this.openElements.pop() + ">");
            } else if (this.openElements.contains(element)) {
                String top;
                do {
                    top = this.openElements.pop();
                    w.write("</" + top + ">");
                } while (!top.equals(element));
                return;
            }
        }
    }
}

