/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.WebTemplateToadlet;
import freenet.clients.http.wizardsteps.BandwidthLimit;
import freenet.clients.http.wizardsteps.BandwidthManipulator;
import freenet.clients.http.wizardsteps.DATASTORE_SIZE;
import freenet.config.Config;
import freenet.config.ConfigException;
import freenet.config.Option;
import freenet.l10n.NodeL10n;
import freenet.node.MasterKeysFileSizeException;
import freenet.node.MasterKeysWrongPasswordException;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.SecurityLevels;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.support.Fields;
import freenet.support.IllegalValueException;
import freenet.support.Logger;
import freenet.support.api.HTTPRequest;
import freenet.support.io.DatastoreUtil;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class FirstTimeWizardNewToadlet
extends WebTemplateToadlet {
    public static final String TOADLET_URL = "/wiz/";
    private static final long MIN_STORAGE_LIMIT = 0x2800000L;
    private final NodeClientCore core;
    private final Config config;
    private static final String l10nPrefix = "FirstTimeWizardToadlet.";
    private boolean isPasswordAlreadySet;
    private final int KiB = 1024;

    FirstTimeWizardNewToadlet(HighLevelSimpleClient client, NodeClientCore core, Config config) {
        super(client);
        this.core = core;
        this.config = config;
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        this.isPasswordAlreadySet = this.core.getNode().getSecurityLevels().getPhysicalThreatLevel() == SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH;
        this.showForm(ctx, new FormModel().toModel());
    }

    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        FormModel formModel = new FormModel(request);
        if (formModel.isValid()) {
            formModel.save();
            super.writeTemporaryRedirect(ctx, "Wizard complete", "/");
        }
        this.showForm(ctx, formModel.toModel());
    }

    private void showForm(ToadletContext ctx, Map<String, Object> model) throws IOException, ToadletContextClosedException {
        model.put("formPassword", this.core.getToadletContainer().getFormPassword());
        PageNode page = ctx.getPageMaker().getPageNode(FirstTimeWizardNewToadlet.l10n("homepageTitle"), ctx, new PageMaker.RenderParameters().renderNavigationLinks(false).renderStatus(false));
        page.addCustomStyleSheet("/static/first-time-wizard.css");
        this.addChild(page.getContentNode(), "first-time-wizard", model, l10nPrefix);
        this.writeHTMLReply(ctx, 200, "OK", page.generate());
    }

    @Override
    public String path() {
        return TOADLET_URL;
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString(l10nPrefix + key);
    }

    private static String l10n(String key, String value) {
        return NodeL10n.getBase().getString(l10nPrefix + key, value);
    }

    private class FormModel {
        private String knowSomeone = "";
        private String connectToStrangers = "";
        private String haveMonthlyLimit = "";
        private String downloadLimit = "1024";
        private String uploadLimit = "160";
        private String bandwidthMonthlyLimit = "500";
        private String storageLimit;
        private final String minStorageLimit = String.format(Locale.ENGLISH, "%.2f", Float.valueOf(0.0390625f));
        private String setPassword = "";
        private String password = "";
        private String downloadLimitDetected;
        private String uploadLimitDetected;
        private Map<String, String> errors = new HashMap<String, String>();

        FormModel() {
            float storage = 100.0f;
            Option<?> sizeOption = FirstTimeWizardNewToadlet.this.config.get("node").getOption("storeSize");
            if (!sizeOption.isDefault()) {
                Option<?> clientCacheSizeOption = FirstTimeWizardNewToadlet.this.config.get("node").getOption("clientCacheSize");
                Option<?> slashdotCacheSizeOption = FirstTimeWizardNewToadlet.this.config.get("node").getOption("slashdotCacheSize");
                long totalSize = (Long)sizeOption.getValue() + (Long)clientCacheSizeOption.getValue() + (Long)slashdotCacheSizeOption.getValue();
                storage = (float)totalSize / 1.0737418E9f;
            } else {
                long autodetectedDatastoreSize = DatastoreUtil.autodetectDatastoreSize(FirstTimeWizardNewToadlet.this.core, FirstTimeWizardNewToadlet.this.config);
                if (autodetectedDatastoreSize > 0L) {
                    storage = (float)autodetectedDatastoreSize / 1.0737418E9f;
                }
            }
            this.storageLimit = String.format(Locale.ENGLISH, "%.2f", Float.valueOf(storage));
            this.detectBandwidthLimit();
            if (this.downloadLimitDetected != null) {
                this.downloadLimit = this.downloadLimitDetected;
            }
            if (this.uploadLimitDetected != null) {
                this.uploadLimit = this.uploadLimitDetected;
            }
        }

        FormModel(HTTPRequest request) {
            this.knowSomeone = request.getPartAsStringFailsafe("knowSomeone", 20);
            this.connectToStrangers = request.getPartAsStringFailsafe("connectToStrangers", 20);
            this.haveMonthlyLimit = request.getPartAsStringFailsafe("haveMonthlyLimit", 20);
            this.downloadLimit = request.getPartAsStringFailsafe("downLimit", 100);
            this.uploadLimit = request.getPartAsStringFailsafe("upLimit", 100);
            this.bandwidthMonthlyLimit = request.getPartAsStringFailsafe("monthlyLimit", 100);
            this.storageLimit = request.getPartAsStringFailsafe("storage", 100);
            this.setPassword = request.getPartAsStringFailsafe("setPassword", 20);
            this.password = request.getPartAsStringFailsafe("password", 1025);
            String passwordConfirmation = request.getPartAsStringFailsafe("confirmPassword", 1024);
            if (this.haveMonthlyLimit.isEmpty()) {
                try {
                    long downloadLimit;
                    long l = downloadLimit = this.downloadLimit.isEmpty() ? 0L : (long)Fields.parseInt(this.downloadLimit + "KiB");
                    if (downloadLimit < (long)Node.getMinimumBandwidth()) {
                        this.errors.put("downloadLimitError", FirstTimeWizardNewToadlet.l10n("valid.downloadLimit", Integer.toString(Node.getMinimumBandwidth() / 1024)));
                    }
                }
                catch (NumberFormatException e) {
                    this.errors.put("downloadLimitError", FirstTimeWizardNewToadlet.l10n("valid.number.prefix.downloadLimit") + " " + e.getMessage());
                }
                try {
                    int nanosInSecond;
                    long uploadLimit;
                    long l = uploadLimit = this.uploadLimit.isEmpty() ? 0L : (long)Fields.parseInt(this.uploadLimit + "KiB");
                    if (uploadLimit < (long)Node.getMinimumBandwidth()) {
                        this.errors.put("uploadLimitError", FirstTimeWizardNewToadlet.l10n("valid.uploadLimit", Integer.toString(Node.getMinimumBandwidth() / 1024)));
                    }
                    if ((long)(nanosInSecond = (int)TimeUnit.SECONDS.toNanos(1L)) < uploadLimit) {
                        this.errors.put("uploadLimitError", FirstTimeWizardNewToadlet.l10n("valid.uploadLimitMax", Integer.toString(nanosInSecond / 1024)));
                    }
                }
                catch (NumberFormatException e) {
                    this.errors.put("uploadLimitError", FirstTimeWizardNewToadlet.l10n("valid.number.prefix.uploadLimit") + " " + e.getMessage());
                }
            } else {
                try {
                    double monthlyLimit = 0.0;
                    if (!this.bandwidthMonthlyLimit.isEmpty()) {
                        monthlyLimit = Double.parseDouble(this.bandwidthMonthlyLimit);
                    }
                    if (monthlyLimit < BandwidthLimit.minMonthlyLimit) {
                        this.errors.put("bandwidthMonthlyLimitError", FirstTimeWizardNewToadlet.l10n("valid.bandwidthMonthlyLimit", String.format("%.2f", BandwidthLimit.minMonthlyLimit)));
                    }
                }
                catch (NumberFormatException e) {
                    this.errors.put("bandwidthMonthlyLimitError", FirstTimeWizardNewToadlet.l10n("valid.number.prefix.bandwidthMonthlyLimit") + " " + e.getMessage());
                }
            }
            try {
                long storageLimit;
                long l = storageLimit = this.storageLimit.isEmpty() ? 0L : Fields.parseLong(this.storageLimit + "GiB");
                if (storageLimit < 0x2800000L) {
                    this.errors.put("storageLimitError", NodeL10n.getBase().getString("Node.invalidMinStoreSizeWithCaches"));
                } else {
                    long maxDatastoreSize = DatastoreUtil.maxDatastoreSize();
                    if (storageLimit > maxDatastoreSize) {
                        this.errors.put("storageLimitError", NodeL10n.getBase().getString("Node.invalidMaxStoreSize", String.format("%.2f", Float.valueOf((float)maxDatastoreSize / 1.0737418E9f))));
                    }
                }
            }
            catch (NumberFormatException e) {
                this.errors.put("storageLimitError", FirstTimeWizardNewToadlet.l10n("valid.number.prefix.storageLimit") + " " + e.getMessage());
            }
            if (!this.setPassword.isEmpty()) {
                if (this.password.isEmpty()) {
                    this.errors.put("passwordError", NodeL10n.getBase().getString("SecurityLevels.passwordNotZeroLength"));
                }
                if (this.password.length() > 1024) {
                    this.errors.put("passwordError", NodeL10n.getBase().getString("SecurityLevels.passwordTooLong"));
                }
                if (!this.password.equals(passwordConfirmation)) {
                    this.errors.put("passwordError", NodeL10n.getBase().getString("SecurityLevels.passwordsDoNotMatch"));
                }
            }
        }

        private boolean isValid() {
            return this.errors.isEmpty();
        }

        private void detectBandwidthLimit() {
            try {
                BandwidthLimit detected = BandwidthManipulator.detectBandwidthLimits(FirstTimeWizardNewToadlet.this.core.getNode().getIpDetector().getBandwidthIndicator());
                this.downloadLimitDetected = Long.toString(detected.downBytes / 2L / 1024L);
                this.uploadLimitDetected = Long.toString(detected.upBytes / 2L / 1024L);
            }
            catch (PluginNotFoundException | IllegalValueException e) {
                Logger.normal(this, e.getMessage(), (Throwable)e);
            }
        }

        private Map<String, Object> toModel() {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("knowSomeone", this.knowSomeone.length() > 0 ? "checked" : "");
            model.put("connectToStrangers", this.connectToStrangers.length() > 0 ? "checked" : "");
            model.put("haveMonthlyLimit", this.haveMonthlyLimit.length() > 0 ? "checked" : "");
            model.put("downloadLimit", this.downloadLimit);
            model.put("uploadLimit", this.uploadLimit);
            model.put("bandwidthMonthlyLimit", this.bandwidthMonthlyLimit);
            model.put("minBandwidthMonthlyLimit", String.format("%.2f", BandwidthLimit.minMonthlyLimit));
            model.put("storageLimit", this.storageLimit);
            model.put("minStorageLimit", this.minStorageLimit);
            if (!FirstTimeWizardNewToadlet.this.isPasswordAlreadySet) {
                model.put("setPassword", this.setPassword.length() > 0 ? "checked" : "");
            }
            model.put("isPasswordAlreadySet", FirstTimeWizardNewToadlet.this.isPasswordAlreadySet);
            if (this.downloadLimitDetected == null || this.uploadLimitDetected == null) {
                this.detectBandwidthLimit();
            }
            model.put("downloadLimitDetected", this.downloadLimitDetected != null ? this.downloadLimitDetected : FirstTimeWizardNewToadlet.l10n("bandwidthCommonInternetConnectionSpeedsDetectedUnavailable"));
            model.put("uploadLimitDetected", this.uploadLimitDetected != null ? this.uploadLimitDetected : FirstTimeWizardNewToadlet.l10n("bandwidthCommonInternetConnectionSpeedsDetectedUnavailable"));
            model.put("errors", this.errors);
            return model;
        }

        private void save() {
            if (this.knowSomeone.isEmpty()) {
                FirstTimeWizardNewToadlet.this.core.getNode().getSecurityLevels().setThreatLevel(SecurityLevels.NETWORK_THREAT_LEVEL.NORMAL);
            } else if (this.connectToStrangers.isEmpty()) {
                FirstTimeWizardNewToadlet.this.core.getNode().getSecurityLevels().setThreatLevel(SecurityLevels.NETWORK_THREAT_LEVEL.HIGH);
            } else {
                FirstTimeWizardNewToadlet.this.core.getNode().getSecurityLevels().setThreatLevel(SecurityLevels.NETWORK_THREAT_LEVEL.NORMAL);
            }
            try {
                if (this.haveMonthlyLimit.isEmpty()) {
                    FirstTimeWizardNewToadlet.this.config.get("node").set("inputBandwidthLimit", this.downloadLimit + "KiB");
                    FirstTimeWizardNewToadlet.this.config.get("node").set("outputBandwidthLimit", this.uploadLimit + "KiB");
                } else {
                    BandwidthLimit bandwidth = new BandwidthLimit(Fields.parseLong(this.bandwidthMonthlyLimit + "GiB"));
                    FirstTimeWizardNewToadlet.this.config.get("node").set("inputBandwidthLimit", Long.toString(bandwidth.downBytes));
                    FirstTimeWizardNewToadlet.this.config.get("node").set("outputBandwidthLimit", Long.toString(bandwidth.upBytes));
                }
            }
            catch (ConfigException e) {
                Logger.error(this, "Should not happen, please report! " + e, (Throwable)e);
            }
            DATASTORE_SIZE.setDatastoreSize(this.storageLimit + "GiB", FirstTimeWizardNewToadlet.this.config, this);
            if (!FirstTimeWizardNewToadlet.this.isPasswordAlreadySet) {
                try {
                    if (this.setPassword.isEmpty()) {
                        FirstTimeWizardNewToadlet.this.core.getNode().getSecurityLevels().setThreatLevel(SecurityLevels.PHYSICAL_THREAT_LEVEL.NORMAL);
                        FirstTimeWizardNewToadlet.this.core.getNode().setMasterPassword("", true);
                    } else {
                        FirstTimeWizardNewToadlet.this.core.getNode().getSecurityLevels().setThreatLevel(SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH);
                        FirstTimeWizardNewToadlet.this.core.getNode().setMasterPassword(this.password, true);
                    }
                }
                catch (MasterKeysFileSizeException | MasterKeysWrongPasswordException | Node.AlreadySetPasswordException | IOException e) {
                    Logger.error(this, "Should not happen, please report! " + e, (Throwable)e);
                }
            }
            try {
                FirstTimeWizardNewToadlet.this.config.get("fproxy").set("hasCompletedWizard", true);
            }
            catch (ConfigException e) {
                Logger.error(this, "Should not happen, please report! " + e, (Throwable)e);
            }
            FirstTimeWizardNewToadlet.this.core.storeConfig();
        }
    }
}

