/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;

class BlockCiphers {
    private static final boolean USE_JCE_FOR_AES = BlockCiphers.checkJceSupported("AES", 16, 24, 32);

    BlockCiphers() {
    }

    static BlockCipher aes() {
        try {
            return USE_JCE_FOR_AES ? new JceEcbBlockCipher("AES") : new AESEngine();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean checkJceSupported(String algorithm, int ... keySizes) {
        try {
            for (int keySize : keySizes) {
                new JceEcbBlockCipher(algorithm).init(false, (CipherParameters)new KeyParameter(new byte[keySize]));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static final class JceEcbBlockCipher
    implements BlockCipher {
        private final String algorithm;
        private final Cipher cipher;
        private final int blockSize;
        private final byte[] buf;

        JceEcbBlockCipher(String algorithm) throws NoSuchPaddingException, NoSuchAlgorithmException {
            this.algorithm = algorithm;
            this.cipher = Cipher.getInstance(algorithm + "/ECB/NoPadding");
            this.blockSize = this.cipher.getBlockSize();
            this.buf = new byte[this.blockSize];
        }

        public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
            SecretKeySpec key = new SecretKeySpec(((KeyParameter)params).getKey(), "AES");
            try {
                this.cipher.init(forEncryption ? 1 : 2, key);
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public String getAlgorithmName() {
            return this.algorithm;
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException {
            try {
                this.cipher.update(in, inOff, this.blockSize, this.buf, 0);
                System.arraycopy(this.buf, 0, out, outOff, this.blockSize);
                return this.blockSize;
            }
            catch (ShortBufferException e) {
                throw new DataLengthException(e.getMessage());
            }
        }

        public void reset() {
            Arrays.fill(this.buf, (byte)0);
        }
    }
}

