/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.Ed2MessageDigest;
import freenet.crypt.Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import org.bitpedia.util.TigerTree;

public enum HashType {
    SHA1(1, "SHA1", 20),
    MD5(2, "MD5", 16),
    SHA256(4, "SHA-256", 32),
    SHA384(8, "SHA-384", 48),
    SHA512(16, "SHA-512", 64),
    ED2K(32, null, 16),
    TTH(64, null, 24);

    public final int bitmask;
    public final String javaName;
    public final int hashLength;
    private final Provider provider;

    private HashType(int bitmask, String name, int hashLength) {
        this.bitmask = bitmask;
        this.javaName = name;
        this.hashLength = hashLength;
        this.provider = this.javaName != null ? Util.mdProviders.get(this.javaName) : null;
    }

    public final MessageDigest get() {
        if (this == ED2K) {
            return new Ed2MessageDigest();
        }
        if (this == TTH) {
            return new TigerTree();
        }
        try {
            return MessageDigest.getInstance(this.javaName, this.provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unsupported digest algorithm " + this.javaName, e);
        }
    }

    @Deprecated
    public final void recycle(MessageDigest md) {
    }
}

