/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.xfer;

import freenet.io.comm.MessageCore;
import freenet.io.xfer.BulkReceiver;
import freenet.io.xfer.BulkTransmitter;
import freenet.support.BitArray;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.RandomAccessBuffer;
import java.io.IOException;
import java.util.Arrays;

public class PartiallyReceivedBulk {
    final long size;
    final int blockSize;
    private final RandomAccessBuffer raf;
    private final BitArray blocksReceived;
    final int blocks;
    private BulkTransmitter[] transmitters;
    final MessageCore usm;
    BulkReceiver recv;
    private int blocksReceivedCount;
    boolean _aborted;
    int _abortReason;
    String _abortDescription;
    private static volatile boolean logMINOR;

    public PartiallyReceivedBulk(MessageCore usm, long size, int blockSize, RandomAccessBuffer raf, boolean initialState) {
        this.size = size;
        this.blockSize = blockSize;
        this.raf = raf;
        this.usm = usm;
        long blocks = (size + (long)blockSize - 1L) / (long)blockSize;
        if (blocks > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too big");
        }
        this.blocks = (int)blocks;
        this.blocksReceived = new BitArray(this.blocks);
        if (initialState) {
            this.blocksReceived.setAllOnes();
            this.blocksReceivedCount = this.blocks;
        }
        assert (raf.size() >= size);
    }

    synchronized BitArray cloneBlocksReceived() {
        return new BitArray(this.blocksReceived);
    }

    synchronized void add(BulkTransmitter bt) {
        if (this.transmitters == null) {
            this.transmitters = new BulkTransmitter[]{bt};
        } else {
            this.transmitters = Arrays.copyOf(this.transmitters, this.transmitters.length + 1);
            this.transmitters[this.transmitters.length - 1] = bt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void received(int blockNum, byte[] data, int offset, int length) {
        BulkTransmitter[] notifyBTs;
        long fileOffset;
        int bs;
        if (blockNum > this.blocks) {
            Logger.error(this, "Received block " + blockNum + " of " + this.blocks + " !");
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Received block " + blockNum);
        }
        if (length < (bs = (int)Math.min((long)this.blockSize, this.size - (fileOffset = (long)blockNum * (long)this.blockSize)))) {
            String err = "Data too short! Should be " + bs + " actually " + length;
            Logger.error(this, err + " for " + this);
            this.abort(2, err);
            return;
        }
        PartiallyReceivedBulk err = this;
        synchronized (err) {
            if (this.blocksReceived.bitAt(blockNum)) {
                return;
            }
            this.blocksReceived.setBit(blockNum, true);
            ++this.blocksReceivedCount;
            notifyBTs = this.transmitters;
        }
        try {
            this.raf.pwrite(fileOffset, data, offset, bs);
        }
        catch (Throwable t) {
            Logger.error(this, "Failed to store received block " + blockNum + " on " + this + " : " + t, t);
            this.abort(3, t.toString());
        }
        if (notifyBTs == null) {
            return;
        }
        for (BulkTransmitter notifyBT : notifyBTs) {
            notifyBT.blockReceived(blockNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(int errCode, String why) {
        if (logMINOR) {
            Logger.normal(this, "Aborting " + this + ": " + errCode + " : " + why + " first missing is " + this.blocksReceived.firstZero(0), (Throwable)new Exception("debug"));
        }
        BulkTransmitter[] bulkTransmitterArray = this;
        synchronized (this) {
            this._aborted = true;
            this._abortReason = errCode;
            this._abortDescription = why;
            BulkTransmitter[] notifyBTs = this.transmitters;
            BulkReceiver notifyBR = this.recv;
            // ** MonitorExit[var5_3] (shouldn't be in output)
            if (notifyBTs != null) {
                for (BulkTransmitter notifyBT : notifyBTs) {
                    notifyBT.onAborted();
                }
            }
            if (notifyBR != null) {
                notifyBR.onAborted();
            }
            this.raf.close();
            return;
        }
    }

    public synchronized boolean isAborted() {
        return this._aborted;
    }

    public boolean hasWholeFile() {
        return this.blocksReceivedCount >= this.blocks;
    }

    public byte[] getBlockData(int blockNum) {
        long fileOffset = (long)blockNum * (long)this.blockSize;
        int bs = (int)Math.min((long)this.blockSize, this.size - fileOffset);
        byte[] data = new byte[bs];
        try {
            this.raf.pread(fileOffset, data, 0, bs);
        }
        catch (IOException e) {
            Logger.error(this, "Failed to read stored block " + blockNum + " on " + this + " : " + e, (Throwable)e);
            this.abort(3, e.toString());
            return null;
        }
        return data;
    }

    public synchronized void remove(BulkTransmitter remove) {
        boolean found = false;
        for (BulkTransmitter t : this.transmitters) {
            if (t != remove) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        BulkTransmitter[] newTrans = new BulkTransmitter[this.transmitters.length - 1];
        int j = 0;
        for (BulkTransmitter t : this.transmitters) {
            if (t == remove) continue;
            newTrans[j++] = t;
        }
        this.transmitters = newTrans;
    }

    public int getAbortReason() {
        return this._abortReason;
    }

    public String getAbortDescription() {
        return this._abortDescription;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

