/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.AEADCryptBucket;
import freenet.crypt.HMAC;
import freenet.crypt.RandomSource;
import freenet.support.api.Bucket;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.bouncycastle.util.Arrays;

public class DatabaseKey {
    private static final byte[] PLUGIN = "PLUGIN".getBytes(StandardCharsets.UTF_8);
    private static final byte[] CLIENT_LAYER = "CLIENT".getBytes(StandardCharsets.UTF_8);
    private final byte[] databaseKey;

    @Deprecated
    DatabaseKey(byte[] key, Random unused) {
        this(key);
    }

    DatabaseKey(byte[] key) {
        this.databaseKey = Arrays.copyOf((byte[])key, (int)key.length);
    }

    public Bucket createEncryptedBucketForClientLayer(Bucket underlying) {
        return new AEADCryptBucket(underlying, this.getKeyForClientLayer());
    }

    public static DatabaseKey createRandom(RandomSource random) {
        byte[] databaseKey = new byte[32];
        random.nextBytes(databaseKey);
        return new DatabaseKey(databaseKey);
    }

    public byte[] getPluginStoreKey(String storeIdentifier) {
        byte[] id = storeIdentifier.getBytes(StandardCharsets.UTF_8);
        byte[] full = new byte[this.databaseKey.length + PLUGIN.length + id.length];
        int x = 0;
        System.arraycopy(this.databaseKey, 0, full, 0, this.databaseKey.length);
        System.arraycopy(PLUGIN, 0, full, x += this.databaseKey.length, PLUGIN.length);
        System.arraycopy(id, 0, full, x += PLUGIN.length, id.length);
        return HMAC.macWithSHA256(this.databaseKey, full);
    }

    public byte[] getKeyForClientLayer() {
        byte[] full = new byte[this.databaseKey.length + CLIENT_LAYER.length];
        int x = 0;
        System.arraycopy(this.databaseKey, 0, full, 0, this.databaseKey.length);
        System.arraycopy(CLIENT_LAYER, 0, full, x += this.databaseKey.length, CLIENT_LAYER.length);
        return HMAC.macWithSHA256(this.databaseKey, full);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + java.util.Arrays.hashCode(this.databaseKey);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatabaseKey other = (DatabaseKey)obj;
        return java.util.Arrays.equals(this.databaseKey, other.databaseKey);
    }
}

