/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.api.LockableRandomAccessBuffer;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

abstract class SwitchableProxyRandomAccessBuffer
implements LockableRandomAccessBuffer {
    final long size;
    private LockableRandomAccessBuffer underlying;
    private int lockOpenCount;
    private LockableRandomAccessBuffer.RAFLock underlyingLock;
    private boolean closed;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    SwitchableProxyRandomAccessBuffer(LockableRandomAccessBuffer initialWrap, long size) throws IOException {
        this.underlying = initialWrap;
        this.size = size;
        if (this.underlying.size() < size) {
            throw new IOException("Underlying must be >= size given");
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pread(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (fileOffset < 0L) {
            throw new IllegalArgumentException();
        }
        if (fileOffset + (long)length > this.size) {
            throw new IOException("Tried to read past end of file");
        }
        try {
            this.lock.readLock().lock();
            if (this.underlying == null || this.closed) {
                throw new IOException("Already closed");
            }
            this.underlying.pread(fileOffset, buf, bufOffset, length);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pwrite(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (fileOffset < 0L) {
            throw new IllegalArgumentException();
        }
        if (fileOffset + (long)length > this.size) {
            throw new IOException("Tried to write past end of file");
        }
        try {
            this.lock.readLock().lock();
            if (this.underlying == null || this.closed) {
                throw new IOException("Already closed");
            }
            this.underlying.pwrite(fileOffset, buf, bufOffset, length);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.lock.writeLock().lock();
            if (this.underlying == null) {
                return;
            }
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.underlying.close();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void free() {
        this.innerFree();
    }

    protected boolean innerFree() {
        try {
            this.lock.writeLock().lock();
            this.closed = true;
            if (this.underlying == null) {
                boolean bl = false;
                return bl;
            }
            this.underlying.free();
            this.underlying = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.afterFreeUnderlying();
        return true;
    }

    public boolean hasBeenFreed() {
        try {
            this.lock.readLock().lock();
            boolean bl = this.underlying == null;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void afterFreeUnderlying() {
    }

    @Override
    public LockableRandomAccessBuffer.RAFLock lockOpen() throws IOException {
        try {
            this.lock.writeLock().lock();
            if (this.closed || this.underlying == null) {
                throw new IOException("Already closed");
            }
            LockableRandomAccessBuffer.RAFLock lock = new LockableRandomAccessBuffer.RAFLock(){

                @Override
                protected void innerUnlock() {
                    SwitchableProxyRandomAccessBuffer.this.externalUnlock();
                }
            };
            ++this.lockOpenCount;
            if (this.lockOpenCount == 1) {
                assert (this.underlyingLock == null);
                this.underlyingLock = this.underlying.lockOpen();
            }
            LockableRandomAccessBuffer.RAFLock rAFLock = lock;
            return rAFLock;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void externalUnlock() {
        try {
            this.lock.writeLock().lock();
            --this.lockOpenCount;
            if (this.lockOpenCount == 0) {
                this.underlyingLock.unlock();
                this.underlyingLock = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void migrate() throws IOException {
        try {
            this.lock.writeLock().lock();
            if (this.closed) {
                return;
            }
            if (this.underlying == null) {
                throw new IOException("Already freed");
            }
            LockableRandomAccessBuffer successor = this.innerMigrate(this.underlying);
            if (successor == null) {
                throw new NullPointerException();
            }
            LockableRandomAccessBuffer.RAFLock newLock = null;
            if (this.lockOpenCount > 0) {
                try {
                    newLock = successor.lockOpen();
                }
                catch (IOException e) {
                    successor.close();
                    successor.free();
                    throw e;
                }
            }
            if (this.lockOpenCount > 0) {
                this.underlyingLock.unlock();
            }
            this.underlying.close();
            this.underlying.free();
            this.underlying = successor;
            this.underlyingLock = newLock;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.afterFreeUnderlying();
    }

    protected abstract LockableRandomAccessBuffer innerMigrate(LockableRandomAccessBuffer var1) throws IOException;

    synchronized LockableRandomAccessBuffer getUnderlying() {
        return this.underlying;
    }
}

