/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.xfer;

import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.AsyncMessageFilterCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageCore;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerContext;
import freenet.io.comm.SlowAsyncMessageFilterCallback;
import freenet.io.xfer.AbortedException;
import freenet.io.xfer.BlockReceiver;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.node.HighHtlAware;
import freenet.node.MessageItem;
import freenet.node.PrioRunnable;
import freenet.support.BitArray;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.TimeUtil;
import freenet.support.io.NativeThread;
import freenet.support.math.MedianMeanRunningAverage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;

public class BlockTransmitter {
    private static final int MAX_ARTIFICIAL_FINAL_PACKETS_DELAY = 1000;
    private static volatile boolean logMINOR;
    public static final int SEND_TIMEOUT = 60000;
    final MessageCore _usm;
    final PeerContext _destination;
    private boolean _sentSendAborted;
    final long _uid;
    private final boolean realTime;
    final PartiallyReceivedBlock _prb;
    private Deque<Integer> _unsent;
    private BlockSenderJob _senderThread = new BlockSenderJob();
    private BitArray _sentPackets;
    private long timeAllSent = -1L;
    final ByteCounter _ctr;
    final int PACKET_SIZE;
    private final ReceiverAbortHandler abortHandler;
    private HashSet<MessageItem> itemsPending = new HashSet();
    private final Ticker _ticker;
    private final Executor _executor;
    private final BlockTransmitterCompletion _callback;
    private final BlockTimeCallback blockTimeCallback;
    private boolean _receivedSendCompletion;
    private boolean _receivedSendSuccess;
    private boolean _completed;
    private boolean _failed;
    static int runningBlockTransmits;
    private Runnable timeoutJob;
    private final Future nullFuture = new Future(){

        @Override
        public void execute() {
        }
    };
    public static final ReceiverAbortHandler ALWAYS_CASCADE;
    public static final ReceiverAbortHandler NEVER_CASCADE;
    private PartiallyReceivedBlock.PacketReceivedListener myListener = null;
    private AsyncMessageFilterCallback cbAllReceived = new SlowAsyncMessageFilterCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMatched(Message m) {
            if (logMINOR) {
                long endTime = System.currentTimeMillis();
                long transferTime = endTime - BlockTransmitter.this.startTime;
                MedianMeanRunningAverage medianMeanRunningAverage = avgTimeTaken;
                synchronized (medianMeanRunningAverage) {
                    avgTimeTaken.report(transferTime);
                    Logger.minor(this, "Block send took " + transferTime + " : " + avgTimeTaken + " on " + BlockTransmitter.this);
                }
            }
            BlockSenderJob blockSenderJob = BlockTransmitter.this._senderThread;
            synchronized (blockSenderJob) {
                BlockTransmitter.this._receivedSendCompletion = true;
                BlockTransmitter.this._receivedSendSuccess = true;
                if (!BlockTransmitter.this.maybeAllSent()) {
                    return;
                }
                if (!BlockTransmitter.this.maybeComplete()) {
                    return;
                }
            }
            BlockTransmitter.this.callCallback(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean shouldTimeout() {
            BlockSenderJob blockSenderJob = BlockTransmitter.this._senderThread;
            synchronized (blockSenderJob) {
                if (BlockTransmitter.this._receivedSendCompletion || BlockTransmitter.this._completed) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onTimeout() {
        }

        @Override
        public void onDisconnect(PeerContext ctx) {
            BlockTransmitter.this.onDisconnect();
        }

        @Override
        public void onRestarted(PeerContext ctx) {
            BlockTransmitter.this.onDisconnect();
        }

        @Override
        public int getPriority() {
            return NativeThread.NORM_PRIORITY;
        }
    };
    private AsyncMessageFilterCallback cbSendAborted = new SlowAsyncMessageFilterCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMatched(Message msg) {
            Future fail;
            if (!BlockTransmitter.this._prb.isAborted() && BlockTransmitter.this.abortHandler.onAbort()) {
                BlockTransmitter.this._prb.abort(9, "Cascading cancel from receiver", true);
            }
            BlockSenderJob blockSenderJob = BlockTransmitter.this._senderThread;
            synchronized (blockSenderJob) {
                BlockTransmitter.this._receivedSendCompletion = true;
                BlockTransmitter.this._receivedSendSuccess = false;
                fail = BlockTransmitter.this.maybeFail(msg.getInt("reason"), msg.getString("description"));
                if (logMINOR) {
                    Logger.minor(this, "Transfer got sendAborted on " + BlockTransmitter.this);
                }
            }
            fail.execute();
            BlockTransmitter.this.cancelItemsPending();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean shouldTimeout() {
            BlockSenderJob blockSenderJob = BlockTransmitter.this._senderThread;
            synchronized (blockSenderJob) {
                if (BlockTransmitter.this._receivedSendCompletion || BlockTransmitter.this._completed) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onTimeout() {
        }

        @Override
        public void onDisconnect(PeerContext ctx) {
            BlockTransmitter.this.onDisconnect();
        }

        @Override
        public void onRestarted(PeerContext ctx) {
            BlockTransmitter.this.onDisconnect();
        }

        @Override
        public int getPriority() {
            return NativeThread.NORM_PRIORITY;
        }
    };
    private long startTime;
    long timeLastBlockSendCompleted = -1L;
    private int blockSendsPending = 0;
    private long lastSentPacket = -1L;
    private static MedianMeanRunningAverage avgTimeTaken;

    public BlockTransmitter(MessageCore usm, Ticker ticker, PeerContext destination, long uid, PartiallyReceivedBlock source, ByteCounter ctr, ReceiverAbortHandler abortHandler, BlockTransmitterCompletion callback, boolean realTime, BlockTimeCallback blockTimes) {
        this.realTime = realTime;
        this._ticker = ticker;
        this._executor = this._ticker.getExecutor();
        this._callback = callback;
        this.abortHandler = abortHandler;
        this._usm = usm;
        this._destination = destination;
        this._uid = uid;
        this._prb = source;
        this._ctr = ctr;
        if (this._ctr == null) {
            throw new NullPointerException();
        }
        this.PACKET_SIZE = DMT.packetTransmitSize(this._prb._packetSize, this._prb._packets);
        try {
            this._sentPackets = new BitArray(this._prb.getNumPackets());
        }
        catch (AbortedException e) {
            Logger.error(this, "Aborted during setup");
        }
        this.blockTimeCallback = blockTimes;
        if (logMINOR) {
            Logger.minor(this, "Starting block transmit for " + uid + " to " + destination.shortToString() + " realtime=" + realTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTimeoutAfterBlockSends() {
        BlockSenderJob blockSenderJob = this._senderThread;
        synchronized (blockSenderJob) {
            if (this._receivedSendCompletion) {
                return;
            }
            if (this.timeoutJob != null) {
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Scheduling timeout on " + this);
            }
            this.timeoutJob = new PrioRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Future fail;
                    BlockSenderJob blockSenderJob = BlockTransmitter.this._senderThread;
                    synchronized (blockSenderJob) {
                        String abortReason;
                        if (BlockTransmitter.this._completed) {
                            return;
                        }
                        boolean hadSendCompletion = BlockTransmitter.this._receivedSendCompletion;
                        if (!BlockTransmitter.this._receivedSendCompletion) {
                            BlockTransmitter.this._receivedSendCompletion = true;
                            BlockTransmitter.this._receivedSendSuccess = false;
                        }
                        if (BlockTransmitter.this._failed) {
                            if (!hadSendCompletion) {
                                Logger.warning(this, "Terminating send after failure on " + this);
                                abortReason = "Already failed and no acknowledgement";
                            } else {
                                if (logMINOR) {
                                    Logger.minor(this, "Trying to terminate send after timeout");
                                }
                                abortReason = "Already failed";
                            }
                        } else {
                            String timeString = TimeUtil.formatTime(System.currentTimeMillis() - BlockTransmitter.this.timeAllSent, 2, true);
                            Logger.warning(this, "Terminating send " + BlockTransmitter.this._uid + " to " + BlockTransmitter.this._destination + " from " + BlockTransmitter.this._destination.getSocketHandler() + " as we haven't heard from receiver in " + timeString + '.');
                            abortReason = "Haven't heard from you (receiver) in " + timeString;
                        }
                        fail = BlockTransmitter.this.maybeFail(11, abortReason);
                    }
                    fail.execute();
                }

                @Override
                public int getPriority() {
                    return NativeThread.NORM_PRIORITY;
                }
            };
            this._ticker.queueTimedJob(this.timeoutJob, "Timeout for " + this, 60000L, false, false);
        }
    }

    public boolean maybeAllSent() {
        if (this.blockSendsPending == 0 && this._unsent.isEmpty() && this.getNumSent() == this._prb._packets) {
            this.timeAllSent = System.currentTimeMillis();
            if (logMINOR) {
                Logger.minor(this, "Sent all blocks, none unsent on " + this);
            }
            this._senderThread.notifyAll();
            return true;
        }
        if (this.blockSendsPending == 0 && this._failed) {
            this.timeAllSent = System.currentTimeMillis();
            if (logMINOR) {
                Logger.minor(this, "Sent blocks and failed on " + this);
            }
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "maybeAllSent: block sends pending = " + this.blockSendsPending + " unsent = " + this._unsent.size() + " sent = " + this.getNumSent() + " on " + this);
        }
        return false;
    }

    public boolean maybeComplete() {
        if (!this._receivedSendCompletion) {
            if (logMINOR) {
                Logger.minor(this, "maybeComplete() not completing because send not completed on " + this);
            }
            this.scheduleTimeoutAfterBlockSends();
            return false;
        }
        if (this._completed) {
            if (logMINOR) {
                Logger.minor(this, "maybeComplete() already completed on " + this);
            }
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "maybeComplete() completing on " + this);
        }
        this._completed = true;
        BlockTransmitter.decRunningBlockTransmits();
        return true;
    }

    public Future maybeFail(final int reason, final String description) {
        if (this._completed) {
            if (logMINOR) {
                Logger.minor(this, "maybeFail() already completed on " + this);
            }
            return this.nullFuture;
        }
        this._failed = true;
        if (!this._receivedSendCompletion) {
            if (logMINOR) {
                Logger.minor(this, "maybeFail() waiting for acknowledgement on " + this);
            }
            if (this._sentSendAborted) {
                this.scheduleTimeoutAfterBlockSends();
                return this.nullFuture;
            }
            this._sentSendAborted = true;
            return new Future(){

                @Override
                public void execute() {
                    try {
                        BlockTransmitter.this.innerSendAborted(reason, description);
                        BlockTransmitter.this.scheduleTimeoutAfterBlockSends();
                    }
                    catch (NotConnectedException e) {
                        BlockTransmitter.this.onDisconnect();
                    }
                }
            };
        }
        if (this.blockSendsPending != 0) {
            if (logMINOR) {
                Logger.minor(this, "maybeFail() waiting for " + this.blockSendsPending + " block sends on " + this);
            }
            if (this._sentSendAborted) {
                return this.nullFuture;
            }
            this._sentSendAborted = true;
            return new Future(){

                @Override
                public void execute() {
                    try {
                        BlockTransmitter.this.innerSendAborted(reason, description);
                    }
                    catch (NotConnectedException e) {
                        BlockTransmitter.this.onDisconnect();
                    }
                }
            };
        }
        if (logMINOR) {
            Logger.minor(this, "maybeFail() completing on " + this);
        }
        this._completed = true;
        BlockTransmitter.decRunningBlockTransmits();
        final boolean sendAborted = this._sentSendAborted;
        this._sentSendAborted = true;
        return new Future(){

            @Override
            public void execute() {
                if (!sendAborted) {
                    try {
                        BlockTransmitter.this.innerSendAborted(reason, description);
                    }
                    catch (NotConnectedException e) {
                        BlockTransmitter.this.onDisconnect();
                    }
                }
                BlockTransmitter.this.callCallback(false);
            }
        };
    }

    public void innerSendAborted(int reason, String desc) throws NotConnectedException {
        this._usm.send(this._destination, DMT.createSendAborted(this._uid, reason, desc), this._ctr);
    }

    private void sendAllSentNotification() {
        try {
            this._usm.send(this._destination, DMT.createAllSent(this._uid, this.realTime), this._ctr);
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "disconnected for allSent()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDisconnect() {
        Future fail;
        Logger.normal(this, "Terminating send " + this._uid + " to " + this._destination + " from " + this._destination.getSocketHandler() + " because node disconnected while waiting");
        BlockSenderJob blockSenderJob = this._senderThread;
        synchronized (blockSenderJob) {
            this._receivedSendCompletion = true;
            this.blockSendsPending = 0;
            this._sentSendAborted = true;
            fail = this.maybeFail(7, "Sender disconnected");
        }
        fail.execute();
        this.cancelItemsPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAborted(int reason, String description) {
        Future fail;
        if (logMINOR) {
            Logger.minor(this, "Aborting on " + this);
        }
        BlockSenderJob blockSenderJob = this._senderThread;
        synchronized (blockSenderJob) {
            this.timeAllSent = -1L;
            this._failed = true;
            this._senderThread.notifyAll();
            fail = this.maybeFail(reason, description);
        }
        fail.execute();
        this.cancelItemsPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsync() {
        this.startTime = System.currentTimeMillis();
        if (logMINOR) {
            Logger.minor(this, "Starting async send on " + this);
        }
        BlockTransmitter.incRunningBlockTransmits();
        try {
            PartiallyReceivedBlock partiallyReceivedBlock = this._prb;
            synchronized (partiallyReceivedBlock) {
                this.myListener = new PartiallyReceivedBlock.PacketReceivedListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void packetReceived(int packetNo) {
                        BlockSenderJob blockSenderJob = BlockTransmitter.this._senderThread;
                        synchronized (blockSenderJob) {
                            if (logMINOR) {
                                Logger.minor(this, "Got packet " + packetNo + " for " + BlockTransmitter.this._uid + " to " + BlockTransmitter.this._destination);
                            }
                            if (BlockTransmitter.this._unsent.contains(packetNo)) {
                                Logger.error(this, "Already in unsent: " + packetNo + " for " + this + " unsent is " + BlockTransmitter.this._unsent, (Throwable)new Exception("error"));
                                return;
                            }
                            if (BlockTransmitter.this._sentPackets.bitAt(packetNo)) {
                                Logger.error(this, "Already sent packet in packetReceived: " + packetNo + " for " + this + " unsent is " + BlockTransmitter.this._unsent + " sent is " + BlockTransmitter.this._sentPackets, (Throwable)new Exception("error"));
                                return;
                            }
                            BlockTransmitter.this._unsent.addLast(packetNo);
                            BlockTransmitter.this.timeAllSent = -1L;
                            BlockTransmitter.this._senderThread.schedule();
                        }
                    }

                    @Override
                    public void receiveAborted(int reason, String description) {
                        BlockTransmitter.this.onAborted(reason, description);
                    }
                };
                this._unsent = this._prb.addListener(this.myListener);
            }
            if (this.isHighHtl() && this._unsent.size() == 32) {
                ArrayList<Integer> temp = new ArrayList<Integer>(this._unsent);
                this._unsent.clear();
                Collections.shuffle(temp);
                this._unsent.addAll(temp);
            }
            this._senderThread.schedule();
            MessageFilter mfAllReceived = MessageFilter.create().setType(DMT.allReceived).setField("uid", this._uid).setSource(this._destination).setNoTimeout();
            MessageFilter mfSendAborted = MessageFilter.create().setType(DMT.sendAborted).setField("uid", this._uid).setSource(this._destination).setNoTimeout();
            try {
                this._usm.addAsyncFilter(mfAllReceived, this.cbAllReceived, this._ctr);
                this._usm.addAsyncFilter(mfSendAborted, this.cbSendAborted, this._ctr);
            }
            catch (DisconnectedException e) {
                this.onDisconnect();
            }
        }
        catch (AbortedException e) {
            this.onAborted(this._prb._abortReason, this._prb._abortDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelItemsPending() {
        MessageItem[] messageItemArray = this.itemsPending;
        synchronized (this.itemsPending) {
            MessageItem[] items = this.itemsPending.toArray(new MessageItem[this.itemsPending.size()]);
            this.itemsPending.clear();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (MessageItem item : items) {
                if (this._destination.unqueueMessage(item) || !logMINOR) continue;
                Logger.minor(this, "Message not queued ?!?!?!? on " + this + " : " + item);
            }
            return;
        }
    }

    private static synchronized void incRunningBlockTransmits() {
        ++runningBlockTransmits;
        if (logMINOR) {
            Logger.minor(BlockTransmitter.class, "Started a block transmit, running: " + runningBlockTransmits);
        }
    }

    private static synchronized void decRunningBlockTransmits() {
        --runningBlockTransmits;
        if (logMINOR) {
            Logger.minor(BlockTransmitter.class, "Finished a block transmit, running: " + runningBlockTransmits);
        }
    }

    private void cleanup() {
        if (this.myListener != null) {
            this._prb.removeListener(this.myListener);
        }
    }

    private int getNumSent() {
        int ret = 0;
        for (int x = 0; x < this._sentPackets.getSize(); ++x) {
            if (!this._sentPackets.bitAt(x)) continue;
            ++ret;
        }
        return ret;
    }

    public void callCallback(final boolean success) {
        if (this._callback != null) {
            this._executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        BlockTransmitter.this._callback.blockTransferFinished(success);
                    }
                    finally {
                        BlockTransmitter.this.cleanup();
                    }
                }
            }, "BlockTransmitter completion callback for " + this);
        } else {
            this.cleanup();
        }
    }

    public PeerContext getDestination() {
        return this._destination;
    }

    public String toString() {
        return "BlockTransmitter for " + this._uid + " to " + this._destination.shortToString();
    }

    public static synchronized int getRunningSends() {
        return runningBlockTransmits;
    }

    private boolean isHighHtl() {
        if (this._ctr instanceof HighHtlAware) {
            return ((HighHtlAware)((Object)this._ctr)).isHighHtl();
        }
        return false;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        runningBlockTransmits = 0;
        ALWAYS_CASCADE = new ReceiverAbortHandler(){

            @Override
            public boolean onAbort() {
                return true;
            }
        };
        NEVER_CASCADE = new ReceiverAbortHandler(){

            @Override
            public boolean onAbort() {
                return false;
            }
        };
        avgTimeTaken = new MedianMeanRunningAverage();
    }

    private class MyAsyncMessageCallback
    implements AsyncMessageCallback {
        private boolean completed = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MyAsyncMessageCallback() {
            BlockSenderJob blockSenderJob = BlockTransmitter.this._senderThread;
            synchronized (blockSenderJob) {
                BlockTransmitter.this.blockSendsPending++;
            }
        }

        @Override
        public void sent() {
            if (logMINOR) {
                Logger.minor(this, "Sent block on " + BlockTransmitter.this);
            }
        }

        @Override
        public void acknowledged() {
            this.complete(false);
        }

        @Override
        public void disconnected() {
            this.complete(true);
        }

        @Override
        public void fatalError() {
            this.complete(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete(boolean failed) {
            if (logMINOR) {
                Logger.minor(this, "Completed send on a block for " + BlockTransmitter.this);
            }
            boolean success = false;
            long now = System.currentTimeMillis();
            boolean callCallback = false;
            long delta = -1L;
            BlockSenderJob blockSenderJob = BlockTransmitter.this._senderThread;
            synchronized (blockSenderJob) {
                if (this.completed) {
                    return;
                }
                this.completed = true;
                if (BlockTransmitter.this.lastSentPacket > 0L) {
                    long threshold;
                    delta = now - BlockTransmitter.this.lastSentPacket;
                    long l = threshold = BlockTransmitter.this.realTime ? BlockReceiver.RECEIPT_TIMEOUT_REALTIME : BlockReceiver.RECEIPT_TIMEOUT_BULK;
                    if (delta > threshold) {
                        Logger.warning(this, "Time between packets on " + BlockTransmitter.this + " : " + TimeUtil.formatTime(delta, 2, true) + " ( " + delta + "ms) realtime=" + BlockTransmitter.this.realTime);
                    } else if (delta > threshold / 5L) {
                        Logger.normal(this, "Time between packets on " + BlockTransmitter.this + " : " + TimeUtil.formatTime(delta, 2, true) + " ( " + delta + "ms) realtime=" + BlockTransmitter.this.realTime);
                    } else if (logMINOR) {
                        Logger.minor(this, "Time between packets on " + BlockTransmitter.this + " : " + TimeUtil.formatTime(delta, 2, true) + " ( " + delta + "ms) realtime=" + BlockTransmitter.this.realTime);
                    }
                }
                BlockTransmitter.this.lastSentPacket = now;
                BlockTransmitter.this.blockSendsPending--;
                if (logMINOR) {
                    Logger.minor(this, "Pending: " + BlockTransmitter.this.blockSendsPending);
                }
                if (BlockTransmitter.this.maybeAllSent() && BlockTransmitter.this.maybeComplete()) {
                    callCallback = true;
                    success = BlockTransmitter.this._receivedSendSuccess;
                }
            }
            if (!failed) {
                BlockTransmitter.this._ctr.sentPayload(BlockTransmitter.this.PACKET_SIZE);
            }
            if (callCallback) {
                BlockTransmitter.this.callCallback(success);
            }
            if (delta > 0L && BlockTransmitter.this.blockTimeCallback != null) {
                BlockTransmitter.this.blockTimeCallback.blockTime(delta, BlockTransmitter.this.realTime);
            }
        }
    }

    public static interface BlockTransmitterCompletion {
        public void blockTransferFinished(boolean var1);
    }

    public static interface ReceiverAbortHandler {
        public boolean onAbort();
    }

    static interface Future {
        public void execute();
    }

    class BlockSenderJob
    implements PrioRunnable {
        private boolean running = false;
        private int count = 0;

        BlockSenderJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            BlockSenderJob blockSenderJob;
            int packetNo;
            BlockSenderJob blockSenderJob2 = this;
            // MONITORENTER : blockSenderJob2
            if (this.running) {
                // MONITOREXIT : blockSenderJob2
                return;
            }
            this.running = true;
            // MONITOREXIT : blockSenderJob2
            while (true) {
                packetNo = -1;
                blockSenderJob = BlockTransmitter.this._senderThread;
                // MONITORENTER : blockSenderJob
                if (!BlockTransmitter.this._failed && !BlockTransmitter.this._receivedSendCompletion && !BlockTransmitter.this._completed) break block25;
                // MONITOREXIT : blockSenderJob
                BlockSenderJob blockSenderJob3 = this;
                break;
            }
            catch (Throwable throwable) {
                BlockSenderJob blockSenderJob4 = this;
                // MONITORENTER : blockSenderJob4
                this.running = false;
                // MONITOREXIT : blockSenderJob4
                throw throwable;
            }
            {
                block26: {
                    block25: {
                        // MONITORENTER : blockSenderJob3
                        this.running = false;
                        // MONITOREXIT : blockSenderJob3
                        return;
                    }
                    if (BlockTransmitter.this._unsent.isEmpty()) {
                        // MONITOREXIT : blockSenderJob
                        BlockSenderJob blockSenderJob5 = this;
                        // MONITORENTER : blockSenderJob5
                        this.running = false;
                        // MONITOREXIT : blockSenderJob5
                        return;
                    }
                    packetNo = (Integer)BlockTransmitter.this._unsent.removeFirst();
                    if (BlockTransmitter.this._sentPackets.bitAt(packetNo)) {
                        Logger.error(this, "Already sent packet in run(): " + packetNo + " for " + this + " unsent is " + BlockTransmitter.this._unsent + " sent is " + BlockTransmitter.this._sentPackets, (Throwable)new Exception("error"));
                        // MONITOREXIT : blockSenderJob
                        continue;
                    }
                    BitArray copy = BlockTransmitter.this._sentPackets.copy();
                    BlockTransmitter.this._sentPackets.setBit(packetNo, true);
                    ++this.count;
                    if (BlockTransmitter.this.isHighHtl() && this.count >= 31) {
                        try {
                            this.wait((int)(Math.random() * 1000.0), 1);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    // MONITOREXIT : blockSenderJob
                    if (this.innerRun(packetNo, copy)) break block26;
                    blockSenderJob = this;
                    // MONITORENTER : blockSenderJob
                    this.running = false;
                    // MONITOREXIT : blockSenderJob
                    return;
                }
                continue;
            }
        }

        public void schedule() {
            if (BlockTransmitter.this._failed || BlockTransmitter.this._receivedSendCompletion || BlockTransmitter.this._completed) {
                if (logMINOR) {
                    Logger.minor(this, "Not scheduling for " + BlockTransmitter.this._uid + " to " + BlockTransmitter.this._destination + " :" + (BlockTransmitter.this._failed ? "(failed) " : "") + (BlockTransmitter.this._receivedSendCompletion ? "(receivedSendCompletion) " : "") + (BlockTransmitter.this._completed ? "(completed) " : ""));
                }
                return;
            }
            BlockTransmitter.this._executor.execute(this, "BlockTransmitter block sender for " + BlockTransmitter.this._uid + " to " + BlockTransmitter.this._destination);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private boolean innerRun(int packetNo, BitArray copied) {
            try {
                Message msg = DMT.createPacketTransmit(BlockTransmitter.this._uid, packetNo, copied, BlockTransmitter.this._prb.getPacket(packetNo), BlockTransmitter.this.realTime);
                MyAsyncMessageCallback cb = new MyAsyncMessageCallback();
                MessageItem item = BlockTransmitter.this._destination.sendAsync(msg, cb, BlockTransmitter.this._ctr);
                HashSet hashSet = BlockTransmitter.this.itemsPending;
                // MONITORENTER : hashSet
                BlockTransmitter.this.itemsPending.add(item);
                // MONITOREXIT : hashSet
            }
            catch (NotConnectedException e) {
                BlockTransmitter.this.onDisconnect();
                return false;
            }
            catch (AbortedException e) {
                Logger.normal(this, "Terminating send due to abort: " + e);
                return false;
            }
            boolean success = false;
            boolean complete = false;
            BlockSenderJob blockSenderJob = BlockTransmitter.this._senderThread;
            // MONITORENTER : blockSenderJob
            if (BlockTransmitter.this._unsent.isEmpty() && BlockTransmitter.this.getNumSent() == BlockTransmitter.this._prb._packets) {
                BlockTransmitter.this.sendAllSentNotification();
                if (!BlockTransmitter.this.maybeAllSent()) {
                    // MONITOREXIT : blockSenderJob
                    return false;
                }
                if (!BlockTransmitter.this.maybeComplete()) {
                    // MONITOREXIT : blockSenderJob
                    return false;
                }
                complete = true;
                success = BlockTransmitter.this._receivedSendSuccess;
            }
            // MONITOREXIT : blockSenderJob
            if (!complete) return true;
            BlockTransmitter.this.callCallback(success);
            return false;
        }

        @Override
        public int getPriority() {
            return NativeThread.HIGH_PRIORITY;
        }
    }

    public static interface BlockTimeCallback {
        public void blockTime(long var1, boolean var3);
    }
}

