/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPrivateKey;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.Global;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.keys.USK;
import freenet.support.Logger;
import java.net.MalformedURLException;

public class InsertableUSK
extends USK {
    private static final long serialVersionUID = 1L;
    public final DSAPrivateKey privKey;

    public static InsertableUSK createInsertable(FreenetURI uri, boolean persistent) throws MalformedURLException {
        if (!uri.getKeyType().equalsIgnoreCase("USK")) {
            throw new MalformedURLException();
        }
        InsertableClientSSK ssk = InsertableClientSSK.create(uri.setKeyType("SSK"));
        return new InsertableUSK(ssk.docName, ssk.pubKeyHash, ssk.cryptoKey, ssk.privKey, uri.getSuggestedEdition(), ssk.cryptoAlgorithm);
    }

    InsertableUSK(String docName, byte[] pubKeyHash, byte[] cryptoKey, DSAPrivateKey key, long suggestedEdition, byte cryptoAlgorithm) throws MalformedURLException {
        super(pubKeyHash, cryptoKey, docName, suggestedEdition, cryptoAlgorithm);
        if (cryptoKey.length != 32) {
            throw new MalformedURLException("Decryption key wrong length: " + cryptoKey.length + " should be " + 32);
        }
        this.privKey = key;
    }

    public USK getUSK() {
        return new USK(this.pubKeyHash, this.cryptoKey, this.siteName, this.suggestedEdition, this.cryptoAlgorithm);
    }

    public InsertableClientSSK getInsertableSSK(long ver) {
        return this.getInsertableSSK(this.siteName + "-" + ver);
    }

    public InsertableClientSSK getInsertableSSK(String string) {
        try {
            return new InsertableClientSSK(string, this.pubKeyHash, new DSAPublicKey(this.getCryptoGroup(), this.privKey), this.privKey, this.cryptoKey, this.cryptoAlgorithm);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Caught " + e + " should not be possible in USK.getSSK", (Throwable)e);
            throw new Error(e);
        }
    }

    public InsertableUSK privCopy(long edition) {
        if (edition == this.suggestedEdition) {
            return this;
        }
        try {
            return new InsertableUSK(this.siteName, this.pubKeyHash, this.cryptoKey, this.privKey, edition, this.cryptoAlgorithm);
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }

    public final DSAGroup getCryptoGroup() {
        return Global.DSAgroupBigA;
    }
}

