/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.FetchWaiter;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertException;
import freenet.client.async.ClientGetter;
import freenet.client.async.DumperSnoopMetadata;
import freenet.client.events.EventDumper;
import freenet.client.filter.ContentFilter;
import freenet.clients.fcp.AddPeer;
import freenet.crypt.RandomSource;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.node.AnnouncementCallback;
import freenet.node.DarknetPeerNode;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.OpennetManager;
import freenet.node.PeerNode;
import freenet.node.PeerTooOldException;
import freenet.node.RequestClient;
import freenet.node.TextModeClientInterfaceServer;
import freenet.node.Version;
import freenet.support.HexUtil;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.SizeUtil;
import freenet.support.api.Bucket;
import freenet.support.io.ArrayBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class TextModeClientInterface
implements Runnable {
    final RandomSource r;
    final Node n;
    final NodeClientCore core;
    final HighLevelSimpleClient client;
    final File downloadsDir;
    final InputStream in;
    final Writer w;
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static volatile boolean logMINOR;

    public TextModeClientInterface(TextModeClientInterfaceServer server, InputStream in, OutputStream out) {
        this.n = server.n;
        this.core = server.n.getClientCore();
        this.r = server.r;
        this.client = this.core.makeClient((short)1, true, false);
        this.downloadsDir = server.downloadsDir;
        this.in = in;
        this.w = new OutputStreamWriter(out, ENCODING);
        this.client.addEventHook(new EventDumper(new BufferedWriter(new OutputStreamWriter(out, ENCODING)), false));
    }

    public TextModeClientInterface(Node n, NodeClientCore core, HighLevelSimpleClient c, File downloadDir, InputStream in, OutputStream out) {
        this.n = n;
        this.r = n.getRandom();
        this.core = core;
        this.client = c;
        this.downloadsDir = downloadDir;
        this.in = in;
        this.w = new OutputStreamWriter(out, ENCODING);
        this.client.addEventHook(new EventDumper(new BufferedWriter(new OutputStreamWriter(out, ENCODING)), false));
    }

    @Override
    public void run() {
        try {
            this.realRun();
        }
        catch (IOException e) {
            if (logMINOR) {
                Logger.minor(this, "Caught " + e, (Throwable)e);
            }
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
        }
    }

    public void realRun() throws IOException {
        this.printHeader(this.w);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.in, ENCODING));
        while (true) {
            try {
                do {
                    this.w.write("TMCI> ");
                    this.w.flush();
                } while (!this.processLine(reader));
                reader.close();
                return;
            }
            catch (SocketException e) {
                Logger.error(this, "Socket error: " + e, (Throwable)e);
                return;
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                System.out.println("Caught: " + t);
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                try {
                    this.w.write(sw.toString());
                }
                catch (IOException e) {
                    Logger.error(this, "Socket error: " + e, (Throwable)e);
                    return;
                }
            }
        }
    }

    private void printHeader(Writer sw) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("Trivial Text Mode Client Interface\r\n");
        sb.append("---------------------------------------\r\n");
        sb.append("Freenet 0.7.5 Build #").append(Version.buildNumber()).append(" r" + Version.cvsRevision() + "\r\n");
        sb.append("Enter one of the following commands:\r\n");
        sb.append("GET:<Freenet key> - Fetch a key\r\n");
        sb.append("DUMP:<Freenet key> - Dump metadata for a key\r\n");
        sb.append("PUT:\\r\\n<text, until a . on a line by itself> - Insert the document and return the key.\r\n");
        sb.append("PUT:<text> - Put a single line of text to a CHK and return the key.\r\n");
        sb.append("GETCHK:\\r\\n<text, until a . on a line by itself> - Get the key that would be returned if the document was inserted.\r\n");
        sb.append("GETCHK:<text> - Get the key that would be returned if the line was inserted.\r\n");
        sb.append("PUTFILE:<filename>[#<mimetype>] - Put a file from disk.\r\n");
        sb.append("GETFILE:<filename> - Fetch a key and put it in a file. If the key includes a filename we will use it but we will not overwrite local files.\r\n");
        sb.append("GETCHKFILE:<filename> - Get the key that would be returned if we inserted the file.\r\n");
        sb.append("PUTDIR:<path>[#<defaultfile>] - Put the entire directory from disk.\r\n");
        sb.append("GETCHKDIR:<path>[#<defaultfile>] - Get the key that would be returned if we'd put the entire directory from disk.\r\n");
        sb.append("MAKESSK - Create an SSK keypair.\r\n");
        sb.append("PUTSSK:<insert uri>;<url to redirect to> - Insert an SSK redirect to a file already inserted.\r\n");
        sb.append("PUTSSKDIR:<insert uri>#<path>[#<defaultfile>] - Insert an entire directory to an SSK.\r\n");
        sb.append("PLUGLOAD: - Load plugin. (use \"PLUGLOAD:?\" for more info)\r\n");
        sb.append("PLUGLIST - List all loaded plugins.\r\n");
        sb.append("PLUGKILL:<pluginID> - Unload the plugin with the given ID (see PLUGLIST).\r\n");
        sb.append("CONNECT:<filename|URL> - see ADDPEER:<filename|URL> below\r\n");
        sb.append("CONNECT:\\r\\n<noderef> - see ADDPEER:\\r\\n<noderef> below\r\n");
        sb.append("DISCONNECT:<ip:port|name> - see REMOVEPEER:<ip:port|name|identity> below\r\n");
        sb.append("ADDPEER:<filename|URL> - add a peer from its ref in a file/url.\r\n");
        sb.append("ADDPEER:\\r\\n<noderef including an End on a line by itself> - add a peer by entering a noderef directly.\r\n");
        sb.append("DISABLEPEER:<ip:port|name|identity> - disable a peer by providing its ip+port, name, or identity\r\n");
        sb.append("ENABLEPEER:<ip:port|name|identity> - enable a peer by providing its ip+port, name, or identity\r\n");
        sb.append("SETPEERLISTENONLY:<ip:port|name|identity> - set ListenOnly on a peer by providing its ip+port, name, or identity\r\n");
        sb.append("UNSETPEERLISTENONLY:<ip:port|name|identity> - unset ListenOnly on a peer by providing its ip+port, name, or identity\r\n");
        sb.append("HAVEPEER:<ip:port|name|identity> - report true/false on having a peer by providing its ip+port, name, or identity\r\n");
        sb.append("REMOVEPEER:<ip:port|name|identity> - remove a peer by providing its ip+port, name, or identity\r\n");
        sb.append("PEER:<ip:port|name|identity> - report the noderef of a peer (without metadata) by providing its ip+port, name, or identity\r\n");
        sb.append("PEERWMD:<ip:port|name|identity> - report the noderef of a peer (with metadata) by providing its ip+port, name, or identity\r\n");
        sb.append("PEERS - report tab delimited list of peers with name, ip+port, identity, location, status and idle time in seconds\r\n");
        sb.append("NAME:<new node name> - change the node's name.\r\n");
        sb.append("UPDATE ask the node to self-update if possible. \r\n");
        sb.append("FILTER: \\r\\n<text, until a . on a line by itself> - output the content as it returns from the content filter\r\n");
        sb.append("STATUS - display some status information on the node including its reference and connections.\r\n");
        sb.append("MEMSTAT - display some memory usage related informations.\r\n");
        sb.append("SHUTDOWN - exit the program\r\n");
        sb.append("ANNOUNCE[:<location>] - announce to the specified location\r\n");
        if (this.n.isUsingWrapper()) {
            sb.append("RESTART - restart the program\r\n");
        }
        if (this.core != null && this.core.getDirectTMCI() != this) {
            sb.append("QUIT - close the socket\r\n");
        }
        if (Node.isTestnetEnabled()) {
            sb.append("WARNING: TESTNET MODE ENABLED. YOU HAVE NO ANONYMITY.\r\n");
        }
        sw.write(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean processLine(BufferedReader reader) throws IOException {
        StringBuilder outsb;
        block182: {
            String uline;
            boolean getCHKOnly;
            String line;
            block185: {
                block184: {
                    outsb = new StringBuilder();
                    try {
                        line = reader.readLine();
                    }
                    catch (IOException e) {
                        outsb.append("Bye... (").append(e).append(')');
                        System.err.println("Bye... (" + e + ')');
                        return true;
                    }
                    getCHKOnly = false;
                    if (line == null) {
                        return true;
                    }
                    uline = line.toUpperCase();
                    if (logMINOR) {
                        Logger.minor(this, "Command: " + line);
                    }
                    if (uline.startsWith("GET:")) {
                        FreenetURI uri3;
                        String key = line.substring("GET:".length()).trim();
                        Logger.normal(this, "Key: " + key);
                        try {
                            uri3 = new FreenetURI(key);
                            Logger.normal(this, "Key: " + uri3);
                        }
                        catch (MalformedURLException e2) {
                            outsb.append("Malformed URI: ").append(key).append(" : ").append(e2);
                            outsb.append("\r\n");
                            this.w.write(outsb.toString());
                            this.w.flush();
                            return false;
                        }
                        try {
                            FetchResult result = this.client.fetch(uri3);
                            ClientMetadata cm = result.getMetadata();
                            outsb.append("Content MIME type: ").append(cm.getMIMEType());
                            Bucket data = result.asBucket();
                            if (data.size() > 32768L) {
                                System.err.println("Data is more than 32K: " + data.size());
                                outsb.append("Data is more than 32K: ").append(data.size());
                                outsb.append("\r\n");
                                this.w.write(outsb.toString());
                                this.w.flush();
                                return false;
                            }
                            byte[] dataBytes = BucketTools.toByteArray(data);
                            boolean evil = false;
                            for (byte b : dataBytes) {
                                if (b == 10 || b == 13 || b >= 32) continue;
                                evil = true;
                                break;
                            }
                            if (evil) {
                                System.err.println("Data may contain escape codes which could cause the terminal to run arbitrary commands! Save it to a file if you must with GETFILE:");
                                outsb.append("Data may contain escape codes which could cause the terminal to run arbitrary commands! Save it to a file if you must with GETFILE:");
                                outsb.append("\r\n");
                                this.w.write(outsb.toString());
                                this.w.flush();
                                return false;
                            }
                            outsb.append("Data:\r\n");
                            outsb.append(new String(dataBytes, ENCODING));
                        }
                        catch (FetchException e) {
                            outsb.append("Error: ").append(e.getMessage()).append("\r\n");
                            if (e.getMode() == FetchException.FetchExceptionMode.SPLITFILE_ERROR && e.errorCodes != null) {
                                outsb.append(e.errorCodes.toVerboseString());
                            }
                            if (e.newURI != null) {
                                outsb.append("Permanent redirect: ").append(e.newURI).append("\r\n");
                            }
                            break block182;
                        }
                    }
                    if (uline.startsWith("DUMP:")) {
                        FreenetURI uri4;
                        String key = line.substring("DUMP:".length()).trim();
                        Logger.normal(this, "Key: " + key);
                        try {
                            uri4 = new FreenetURI(key);
                            Logger.normal(this, "Key: " + uri4);
                        }
                        catch (MalformedURLException e2) {
                            outsb.append("Malformed URI: ").append(key).append(" : ").append(e2);
                            outsb.append("\r\n");
                            this.w.write(outsb.toString());
                            this.w.flush();
                            return false;
                        }
                        try {
                            FetchContext context = this.client.getFetchContext();
                            FetchWaiter fw = new FetchWaiter((RequestClient)((Object)this.client));
                            ClientGetter get = new ClientGetter(fw, uri4, context, 1, null, null, null);
                            get.setMetaSnoop(new DumperSnoopMetadata());
                            get.start(this.n.getClientCore().getClientContext());
                            FetchResult result = fw.waitForCompletion();
                            ClientMetadata cm = result.getMetadata();
                            outsb.append("Content MIME type: ").append(cm.getMIMEType());
                            Bucket data = result.asBucket();
                            if (data.size() > 32768L) {
                                System.err.println("Data is more than 32K: " + data.size());
                                outsb.append("Data is more than 32K: ").append(data.size());
                                outsb.append("\r\n");
                                this.w.write(outsb.toString());
                                this.w.flush();
                                return false;
                            }
                            byte[] dataBytes = BucketTools.toByteArray(data);
                            boolean evil = false;
                            for (byte b : dataBytes) {
                                if (b == 10 || b == 13 || b >= 32) continue;
                                evil = true;
                                break;
                            }
                            if (evil) {
                                System.err.println("Data may contain escape codes which could cause the terminal to run arbitrary commands! Save it to a file if you must with GETFILE:");
                                outsb.append("Data may contain escape codes which could cause the terminal to run arbitrary commands! Save it to a file if you must with GETFILE:");
                                outsb.append("\r\n");
                                this.w.write(outsb.toString());
                                this.w.flush();
                                return false;
                            }
                            outsb.append("Data:\r\n");
                            outsb.append(new String(dataBytes, ENCODING));
                        }
                        catch (FetchException e) {
                            outsb.append("Error: ").append(e.getMessage()).append("\r\n");
                            if (e.getMode() == FetchException.FetchExceptionMode.SPLITFILE_ERROR && e.errorCodes != null) {
                                outsb.append(e.errorCodes.toVerboseString());
                            }
                            if (e.newURI != null) {
                                outsb.append("Permanent redirect: ").append(e.newURI).append("\r\n");
                            }
                            break block182;
                        }
                    }
                    if (uline.startsWith("GETFILE:")) {
                        FreenetURI uri5;
                        String key = line.substring("GETFILE:".length()).trim();
                        Logger.normal(this, "Key: " + key);
                        try {
                            uri5 = new FreenetURI(key);
                        }
                        catch (MalformedURLException e2) {
                            outsb.append("Malformed URI: ").append(key).append(" : ").append(e2);
                            outsb.append("\r\n");
                            this.w.write(outsb.toString());
                            this.w.flush();
                            return false;
                        }
                        try {
                            File f;
                            long startTime = System.currentTimeMillis();
                            FetchResult result = this.client.fetch(uri5);
                            ClientMetadata cm = result.getMetadata();
                            outsb.append("Content MIME type: ").append(cm.getMIMEType());
                            Bucket data = result.asBucket();
                            String fnam = uri5.getDocName();
                            fnam = this.sanitize(fnam);
                            if (fnam.isEmpty()) {
                                fnam = "freenet-download-" + HexUtil.bytesToHex(BucketTools.hash(data), 0, 10);
                                String ext = DefaultMIMETypes.getExtension(cm.getMIMEType());
                                if (ext != null && !ext.isEmpty()) {
                                    fnam = fnam + '.' + ext;
                                }
                            }
                            if ((f = new File(this.downloadsDir, fnam)).exists()) {
                                outsb.append("File exists already: ").append(fnam);
                                fnam = "freenet-" + System.currentTimeMillis() + '-' + fnam;
                            }
                            FileOutputStream fos = null;
                            try {
                                fos = new FileOutputStream(f);
                                BucketTools.copyTo(data, fos, Long.MAX_VALUE);
                                fos.close();
                                outsb.append("Written to ").append(fnam);
                            }
                            catch (IOException e) {
                                outsb.append("Could not write file: caught ").append(e);
                                e.printStackTrace();
                            }
                            finally {
                                if (fos != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (IOException e) {}
                                }
                            }
                            long endTime = System.currentTimeMillis();
                            long sz = data.size();
                            double rate = 1000.0 * (double)sz / (double)(endTime - startTime);
                            outsb.append("Download rate: ").append(rate).append(" bytes / second");
                        }
                        catch (FetchException e) {
                            outsb.append("Error: ").append(e.getMessage());
                            if (e.getMode() == FetchException.FetchExceptionMode.SPLITFILE_ERROR && e.errorCodes != null) {
                                outsb.append(e.errorCodes.toVerboseString());
                            }
                            if (e.newURI != null) {
                                outsb.append("Permanent redirect: ").append(e.newURI).append("\r\n");
                            }
                            break block182;
                        }
                    }
                    if (uline.startsWith("UPDATE")) {
                        outsb.append("starting the update process");
                        this.n.getTicker().queueTimedJob(new Runnable(){

                            @Override
                            public void run() {
                                TextModeClientInterface.this.n.getNodeUpdater().arm();
                            }
                        }, 0L);
                        outsb.append("\r\n");
                        this.w.write(outsb.toString());
                        this.w.flush();
                        return false;
                    }
                    if (!uline.startsWith("FILTER:")) break block185;
                    line = line.substring("FILTER:".length()).trim();
                    outsb.append("Here is the result:\r\n");
                    String content = this.readLines(reader, false);
                    ArrayBucket input = new ArrayBucket(content.getBytes(StandardCharsets.UTF_8));
                    ArrayBucket output = new ArrayBucket();
                    InputStream inputStream = null;
                    OutputStream outputStream = null;
                    InputStream bis = null;
                    try {
                        inputStream = input.getInputStream();
                        outputStream = output.getOutputStream();
                        ContentFilter.filter(inputStream, outputStream, "text/html", new URI("http://127.0.0.1:8888/"), null, null, null, null, this.core.getLinkFilterExceptionProvider());
                        inputStream.close();
                        inputStream = null;
                        outputStream.close();
                        outputStream = null;
                        bis = output.getInputStream();
                        while (bis.available() > 0) {
                            outsb.append((char)bis.read());
                        }
                        Closer.close(inputStream);
                    }
                    catch (IOException e) {
                        outsb.append("Bucket error?: " + e.getMessage());
                        Logger.error(this, "Bucket error?: " + e, (Throwable)e);
                        break block184;
                    }
                    catch (URISyntaxException e2) {
                        outsb.append("Internal error: " + e2.getMessage());
                        Logger.error(this, "Internal error: " + e2, (Throwable)e2);
                        break block184;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        Closer.close(inputStream);
                        Closer.close(outputStream);
                        Closer.close(bis);
                        input.free();
                        output.free();
                    }
                    Closer.close(outputStream);
                    Closer.close(bis);
                    input.free();
                    output.free();
                }
                outsb.append("\r\n");
                break block182;
            }
            if (uline.startsWith("BLOW")) {
                this.n.getNodeUpdater().blow("caught an  IOException : (Incompetent Operator) :p", true);
                outsb.append("\r\n");
                this.w.write(outsb.toString());
                this.w.flush();
                return false;
            }
            if (uline.startsWith("SHUTDOWN")) {
                StringBuilder sb = new StringBuilder();
                sb.append("Shutting node down.\r\n");
                this.w.write(sb.toString());
                this.w.flush();
                this.n.exit("Shutdown from console");
            } else if (uline.startsWith("RESTART")) {
                StringBuilder sb = new StringBuilder();
                sb.append("Restarting the node.\r\n");
                this.w.write(sb.toString());
                this.w.flush();
                this.n.getNodeStarter().restart();
            } else {
                if (uline.startsWith("QUIT") && this.core.getDirectTMCI() == this) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("QUIT command not available in console mode.\r\n");
                    this.w.write(sb.toString());
                    this.w.flush();
                    return false;
                }
                if (uline.startsWith("QUIT")) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Closing connection.\r\n");
                    this.w.write(sb.toString());
                    this.w.flush();
                    return true;
                }
                if (uline.startsWith("MEMSTAT")) {
                    Runtime rt = Runtime.getRuntime();
                    float freeMemory = rt.freeMemory();
                    float totalMemory = rt.totalMemory();
                    float maxMemory = rt.maxMemory();
                    long usedJavaMem = (long)(totalMemory - freeMemory);
                    long allocatedJavaMem222222 = (long)totalMemory;
                    long maxJavaMem = (long)maxMemory;
                    int availableCpus = rt.availableProcessors();
                    NumberFormat thousendPoint = NumberFormat.getInstance();
                    ThreadGroup tg = Thread.currentThread().getThreadGroup();
                    while (tg.getParent() != null) {
                        tg = tg.getParent();
                    }
                    int threadCount = tg.activeCount();
                    StringBuilder sb = new StringBuilder();
                    sb.append("Used Java memory:\u00a0" + SizeUtil.formatSize(usedJavaMem, true) + "\r\n");
                    sb.append("Allocated Java memory:\u00a0" + SizeUtil.formatSize(allocatedJavaMem222222, true) + "\r\n");
                    sb.append("Maximum Java memory:\u00a0" + SizeUtil.formatSize(maxJavaMem, true) + "\r\n");
                    sb.append("Running threads:\u00a0" + thousendPoint.format(threadCount) + "\r\n");
                    sb.append("Available CPUs:\u00a0" + availableCpus + "\r\n");
                    sb.append("Java Version:\u00a0" + System.getProperty("java.version") + "\r\n");
                    sb.append("JVM Vendor:\u00a0" + System.getProperty("java.vendor") + "\r\n");
                    sb.append("JVM Version:\u00a0" + System.getProperty("java.version") + "\r\n");
                    sb.append("OS Name:\u00a0" + System.getProperty("os.name") + "\r\n");
                    sb.append("OS Version:\u00a0" + System.getProperty("os.version") + "\r\n");
                    sb.append("OS Architecture:\u00a0" + System.getProperty("os.arch") + "\r\n");
                    this.w.write(sb.toString());
                    this.w.flush();
                    return false;
                }
                if (uline.startsWith("HELP")) {
                    this.printHeader(this.w);
                    outsb.append("\r\n");
                    this.w.write(outsb.toString());
                    this.w.flush();
                    return false;
                }
                if (uline.startsWith("PUT:") || (getCHKOnly = uline.startsWith("GETCHK:"))) {
                    FreenetURI uri22;
                    line = getCHKOnly ? line.substring("GETCHK:".length()).trim() : line.substring("PUT:".length()).trim();
                    String content = !line.isEmpty() ? line : this.readLines(reader, false);
                    byte[] data = content.getBytes(ENCODING);
                    InsertBlock block = new InsertBlock(new ArrayBucket(data), null, FreenetURI.EMPTY_CHK_URI);
                    try {
                        uri22 = this.client.insert(block, getCHKOnly, null);
                    }
                    catch (InsertException e) {
                        InsertException.InsertExceptionMode mode222222;
                        outsb.append("Error: ").append(e.getMessage());
                        if (e.uri != null) {
                            outsb.append("URI would have been: ").append(e.uri);
                        }
                        if ((mode222222 = e.getMode()) == InsertException.InsertExceptionMode.FATAL_ERRORS_IN_BLOCKS || mode222222 == InsertException.InsertExceptionMode.TOO_MANY_RETRIES_IN_BLOCKS) {
                            outsb.append("Splitfile-specific error:\n").append(e.errorCodes.toVerboseString());
                        }
                        outsb.append("\r\n");
                        this.w.write(outsb.toString());
                        this.w.flush();
                        return false;
                    }
                    outsb.append("URI: ").append(uri22);
                } else if (uline.startsWith("PUTDIR:") || uline.startsWith("PUTSSKDIR") || (getCHKOnly = uline.startsWith("GETCHKDIR:"))) {
                    FreenetURI uri;
                    boolean ssk = false;
                    if (uline.startsWith("PUTDIR:")) {
                        line = line.substring("PUTDIR:".length());
                    } else if (uline.startsWith("PUTSSKDIR:")) {
                        line = line.substring("PUTSSKDIR:".length());
                        ssk = true;
                    } else if (uline.startsWith("GETCHKDIR:")) {
                        line = line.substring("GETCHKDIR:".length());
                    } else {
                        System.err.println("Impossible");
                        outsb.append("Impossible");
                    }
                    line = line.trim();
                    if (line.isEmpty()) {
                        this.printHeader(this.w);
                        outsb.append("\r\n");
                        this.w.write(outsb.toString());
                        this.w.flush();
                        return false;
                    }
                    String defaultFile = null;
                    FreenetURI insertURI = FreenetURI.EMPTY_CHK_URI;
                    if (line.matches("^.*#.*$")) {
                        String[] split = line.split("#");
                        if (ssk) {
                            insertURI = new FreenetURI(split[0]);
                            line = split[1];
                            if (split.length > 2) {
                                defaultFile = split[2];
                            }
                        } else {
                            defaultFile = split[1];
                            line = split[0];
                        }
                    }
                    HashMap<String, Object> bucketsByName = this.makeBucketsByName(line);
                    if (defaultFile == null) {
                        String[] defaultFiles;
                        for (String file : defaultFiles = new String[]{"index.html", "index.htm", "default.html", "default.htm"}) {
                            if (!bucketsByName.containsKey(file)) continue;
                            defaultFile = file;
                            break;
                        }
                    }
                    try {
                        uri = this.client.insertManifest(insertURI, bucketsByName, defaultFile);
                        uri = uri.addMetaStrings(new String[]{""});
                        outsb.append("=======================================================");
                        outsb.append("URI: ").append(uri);
                        outsb.append("=======================================================");
                    }
                    catch (InsertException e) {
                        outsb.append("Finished insert but: ").append(e.getMessage());
                        if (e.uri != null) {
                            uri = e.uri;
                            uri = uri.addMetaStrings(new String[]{""});
                            outsb.append("URI would have been: ").append(uri);
                        }
                        if (e.errorCodes != null) {
                            outsb.append("Splitfile errors breakdown:");
                            outsb.append(e.errorCodes.toVerboseString());
                        }
                        Logger.error(this, "Caught " + e, (Throwable)e);
                    }
                } else if (uline.startsWith("PUTFILE:") || (getCHKOnly = uline.startsWith("GETCHKFILE:"))) {
                    line = getCHKOnly ? line.substring("GETCHKFILE:".length()).trim() : line.substring("PUTFILE:".length()).trim();
                    String mimeType = DefaultMIMETypes.guessMIMEType(line, false);
                    if (line.indexOf(35) > -1) {
                        String[] splittedLine = line.split("#");
                        line = splittedLine[0];
                        mimeType = splittedLine[1];
                    }
                    File f = new File(line);
                    outsb.append("Attempting to read file ").append(line);
                    long startTime = System.currentTimeMillis();
                    try {
                        if (!f.exists() || !f.canRead()) {
                            throw new FileNotFoundException();
                        }
                        outsb.append(" using MIME type: ").append(mimeType).append("\r\n");
                        if (mimeType.equals("application/octet-stream")) {
                            mimeType = "";
                        }
                        FileBucket fb = new FileBucket(f, true, false, false, false);
                        InsertBlock block = new InsertBlock(fb, new ClientMetadata(mimeType), FreenetURI.EMPTY_CHK_URI);
                        startTime = System.currentTimeMillis();
                        FreenetURI uri6 = this.client.insert(block, getCHKOnly, f.getName());
                        outsb.append("URI: ").append(uri6).append("\r\n");
                        long endTime = System.currentTimeMillis();
                        long sz = f.length();
                        double rate = 1000.0 * (double)sz / (double)(endTime - startTime);
                        outsb.append("Upload rate: ").append(rate).append(" bytes / second\r\n");
                    }
                    catch (FileNotFoundException e1) {
                        outsb.append("File not found");
                    }
                    catch (InsertException e) {
                        outsb.append("Finished insert but: ").append(e.getMessage());
                        if (e.uri != null) {
                            outsb.append("URI would have been: ").append(e.uri);
                            long endTime = System.currentTimeMillis();
                            long sz = f.length();
                            double rate = 1000.0 * (double)sz / (double)(endTime - startTime);
                            outsb.append("Upload rate: ").append(rate).append(" bytes / second");
                        }
                        if (e.errorCodes != null) {
                            outsb.append("Splitfile errors breakdown:");
                            outsb.append(e.errorCodes.toVerboseString());
                        }
                    }
                    catch (Throwable t) {
                        outsb.append("Insert threw: ").append(t);
                        t.printStackTrace();
                    }
                } else if (uline.startsWith("MAKESSK")) {
                    InsertableClientSSK key = InsertableClientSSK.createRandom(this.r, "");
                    outsb.append("Insert URI: ").append(key.getInsertURI().toString(false, false)).append("\r\n");
                    outsb.append("Request URI: ").append(key.getURI().toString(false, false)).append("\r\n");
                    FreenetURI insertURI2 = key.getInsertURI().setDocName("testsite");
                    String fixedInsertURI = insertURI2.toString(false, false);
                    outsb.append("Note that you MUST add a filename to the end of the above URLs e.g.:\r\n").append(fixedInsertURI).append("\r\n");
                    outsb.append("Normally you will then do PUTSSKDIR:<insert URI>#<directory to upload>, for example:\r\nPUTSSKDIR:").append(fixedInsertURI).append("#directoryToUpload/\r\n");
                    outsb.append("This will then produce a manifest site containing all the files, the default document can be accessed at\r\n").append(key.getURI().toString(false, false)).append("testsite/");
                } else {
                    if (uline.startsWith("PUTSSK:")) {
                        String cmd = line.substring("PUTSSK:".length());
                        if ((cmd = cmd.trim()).indexOf(59) <= 0) {
                            outsb.append("No target URI provided.");
                            outsb.append("PUTSSK:<insert uri>;<url to redirect to>");
                            outsb.append("\r\n");
                            this.w.write(outsb.toString());
                            this.w.flush();
                            return false;
                        }
                        String[] split = cmd.split(";");
                        String insertURI3 = split[0];
                        String targetURI = split[1];
                        outsb.append("Insert URI: ").append(insertURI3);
                        outsb.append("Target URI: ").append(targetURI);
                        FreenetURI insert = new FreenetURI(insertURI3);
                        FreenetURI target = new FreenetURI(targetURI);
                        try {
                            FreenetURI result = this.client.insertRedirect(insert, target);
                            outsb.append("Successfully inserted to fetch URI: ").append(result);
                        }
                        catch (InsertException e) {
                            outsb.append("Finished insert but: ").append(e.getMessage());
                            Logger.normal(this, "Error: " + e, (Throwable)e);
                            if (e.uri != null) {
                                outsb.append("URI would have been: ").append(e.uri);
                            }
                            break block182;
                        }
                    }
                    if (uline.startsWith("STATUS")) {
                        outsb.append("DARKNET:\n");
                        SimpleFieldSet fs = this.n.exportDarknetPublicFieldSet();
                        outsb.append(fs.toString());
                        if (this.n.isOpennetEnabled()) {
                            outsb.append("OPENNET:\n");
                            fs = this.n.exportOpennetPublicFieldSet();
                            outsb.append(fs.toString());
                        }
                        outsb.append(this.n.getStatus());
                        if (Version.buildNumber() < Version.getHighestSeenBuild()) {
                            outsb.append("The latest version is : ").append(Version.getHighestSeenBuild());
                        }
                    } else if (uline.startsWith("ADDPEER:") || uline.startsWith("CONNECT:")) {
                        String key = null;
                        key = uline.startsWith("CONNECT:") ? line.substring("CONNECT:".length()).trim() : line.substring("ADDPEER:".length()).trim();
                        String content = null;
                        if (!key.isEmpty()) {
                            outsb.append("Trying to add peer to node by noderef in ").append(key).append("\r\n");
                            File f = new File(key);
                            if (f.isFile()) {
                                outsb.append("Given string seems to be a file, loading...\r\n");
                                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), ENCODING));
                                content = this.readLines(in, true);
                                in.close();
                            } else {
                                outsb.append("Given string seems to be an URL, loading...\r\n");
                                URL url = new URL(key);
                                content = AddPeer.getReferenceFromURL(url).toString();
                            }
                        } else {
                            content = this.readLines(reader, true);
                        }
                        if (content == null) {
                            return false;
                        }
                        if (content.isEmpty()) {
                            return false;
                        }
                        this.addPeer(content);
                    } else if (uline.startsWith("NAME:")) {
                        outsb.append("Node name currently: ").append(this.n.getMyName());
                        String key = line.substring("NAME:".length()).trim();
                        outsb.append("New name: ").append(key);
                        try {
                            this.n.setName(key);
                            if (logMINOR) {
                                Logger.minor(this, "Setting node.name to " + key);
                            }
                        }
                        catch (Exception e) {
                            Logger.error(this, "Error setting node's name", (Throwable)e);
                        }
                        this.core.storeConfig();
                    } else if (uline.startsWith("DISABLEPEER:")) {
                        String nodeIdentifier = line.substring("DISABLEPEER:".length()).trim();
                        if (!this.havePeer(nodeIdentifier)) {
                            this.w.write("no peer for " + nodeIdentifier + "\r\n");
                            this.w.flush();
                            return false;
                        }
                        if (this.disablePeer(nodeIdentifier)) {
                            outsb.append("disable succeeded for ").append(nodeIdentifier);
                        } else {
                            outsb.append("disable failed for ").append(nodeIdentifier);
                        }
                        outsb.append("\r\n");
                    } else if (uline.startsWith("ENABLEPEER:")) {
                        String nodeIdentifier = line.substring("ENABLEPEER:".length()).trim();
                        if (!this.havePeer(nodeIdentifier)) {
                            this.w.write("no peer for " + nodeIdentifier + "\r\n");
                            this.w.flush();
                            return false;
                        }
                        if (this.enablePeer(nodeIdentifier)) {
                            outsb.append("enable succeeded for ").append(nodeIdentifier);
                        } else {
                            outsb.append("enable failed for ").append(nodeIdentifier);
                        }
                        outsb.append("\r\n");
                    } else if (uline.startsWith("SETPEERLISTENONLY:")) {
                        String nodeIdentifier = line.substring("SETPEERLISTENONLY:".length()).trim();
                        if (!this.havePeer(nodeIdentifier)) {
                            this.w.write("no peer for " + nodeIdentifier + "\r\n");
                            this.w.flush();
                            return false;
                        }
                        PeerNode pn = this.n.getPeerNode(nodeIdentifier);
                        if (pn == null) {
                            this.w.write("n.getPeerNode() failed to get peer details for " + nodeIdentifier + "\r\n\r\n");
                            this.w.flush();
                            return false;
                        }
                        if (!(pn instanceof DarknetPeerNode)) {
                            this.w.write("Error: " + nodeIdentifier + " identifies a non-darknet peer and this command is only available for darknet peers\r\n\r\n");
                            this.w.flush();
                            return false;
                        }
                        DarknetPeerNode dpn = (DarknetPeerNode)pn;
                        dpn.setListenOnly(true);
                        outsb.append("set ListenOnly suceeded for ").append(nodeIdentifier).append("\r\n");
                    } else if (uline.startsWith("UNSETPEERLISTENONLY:")) {
                        String nodeIdentifier = line.substring("UNSETPEERLISTENONLY:".length()).trim();
                        if (!this.havePeer(nodeIdentifier)) {
                            this.w.write("no peer for " + nodeIdentifier + "\r\n");
                            this.w.flush();
                            return false;
                        }
                        PeerNode pn = this.n.getPeerNode(nodeIdentifier);
                        if (pn == null) {
                            this.w.write("n.getPeerNode() failed to get peer details for " + nodeIdentifier + "\r\n\r\n");
                            this.w.flush();
                            return false;
                        }
                        if (!(pn instanceof DarknetPeerNode)) {
                            this.w.write("Error: " + nodeIdentifier + " identifies a non-darknet peer and this command is only available for darknet peers\r\n\r\n");
                            this.w.flush();
                            return false;
                        }
                        DarknetPeerNode dpn = (DarknetPeerNode)pn;
                        dpn.setListenOnly(false);
                        outsb.append("unset ListenOnly suceeded for ").append(nodeIdentifier).append("\r\n");
                    } else if (uline.startsWith("HAVEPEER:")) {
                        String nodeIdentifier = line.substring("HAVEPEER:".length()).trim();
                        if (this.havePeer(nodeIdentifier)) {
                            outsb.append("true for ").append(nodeIdentifier);
                        } else {
                            outsb.append("false for ").append(nodeIdentifier);
                        }
                        outsb.append("\r\n");
                    } else if (uline.startsWith("REMOVEPEER:") || uline.startsWith("DISCONNECT:")) {
                        String nodeIdentifier = null;
                        nodeIdentifier = uline.startsWith("DISCONNECT:") ? line.substring("DISCONNECT:".length()) : line.substring("REMOVEPEER:".length());
                        if (this.removePeer(nodeIdentifier)) {
                            outsb.append("peer removed for ").append(nodeIdentifier);
                        } else {
                            outsb.append("peer removal failed for ").append(nodeIdentifier);
                        }
                        outsb.append("\r\n");
                    } else if (uline.startsWith("PEER:")) {
                        String nodeIdentifier = line.substring("PEER:".length()).trim();
                        if (!this.havePeer(nodeIdentifier)) {
                            this.w.write("no peer for " + nodeIdentifier + "\r\n");
                            this.w.flush();
                            return false;
                        }
                        PeerNode pn = this.n.getPeerNode(nodeIdentifier);
                        if (pn == null) {
                            this.w.write("n.getPeerNode() failed to get peer details for " + nodeIdentifier + "\r\n\r\n");
                            this.w.flush();
                            return false;
                        }
                        SimpleFieldSet fs = pn.exportFieldSet();
                        outsb.append(fs.toString());
                    } else if (uline.startsWith("PEERWMD:")) {
                        String nodeIdentifier = line.substring("PEERWMD:".length()).trim();
                        if (!this.havePeer(nodeIdentifier)) {
                            this.w.write("no peer for " + nodeIdentifier + "\r\n");
                            this.w.flush();
                            return false;
                        }
                        PeerNode pn = this.n.getPeerNode(nodeIdentifier);
                        if (pn == null) {
                            this.w.write("n.getPeerNode() failed to get peer details for " + nodeIdentifier + "\r\n\r\n");
                            this.w.flush();
                            return false;
                        }
                        SimpleFieldSet fs = pn.exportFieldSet();
                        SimpleFieldSet meta = pn.exportMetadataFieldSet(System.currentTimeMillis());
                        if (!meta.isEmpty()) {
                            fs.put("metadata", meta);
                        }
                        outsb.append(fs.toString());
                    } else if (uline.startsWith("PEERS")) {
                        outsb.append(this.n.getTMCIPeerList());
                        outsb.append("PEERS done.\r\n");
                    } else if (uline.startsWith("PLUGLOAD")) {
                        if (uline.startsWith("PLUGLOAD:O:")) {
                            String name = line.substring("PLUGLOAD:O:".length()).trim();
                            this.n.getPluginManager().startPluginOfficial(name, true);
                        } else if (uline.startsWith("PLUGLOAD:F:")) {
                            String name = line.substring("PLUGLOAD:F:".length()).trim();
                            this.n.getPluginManager().startPluginFile(name, true);
                        } else if (uline.startsWith("PLUGLOAD:U:")) {
                            String name = line.substring("PLUGLOAD:U:".length()).trim();
                            this.n.getPluginManager().startPluginURL(name, true);
                        } else if (uline.startsWith("PLUGLOAD:K:")) {
                            String name = line.substring("PLUGLOAD:K:".length()).trim();
                            this.n.getPluginManager().startPluginFreenet(name, true);
                        } else {
                            outsb.append("  PLUGLOAD:O: pluginName         - Load official plugin from freenetproject.org\r\n");
                            outsb.append("  PLUGLOAD:F: file://<filename>  - Load plugin from file\r\n");
                            outsb.append("  PLUGLOAD:U: http://...         - Load plugin from online file\r\n");
                            outsb.append("  PLUGLOAD:K: freenet key        - Load plugin from freenet uri\r\n");
                        }
                    } else if (uline.startsWith("PLUGLIST")) {
                        outsb.append(this.n.getPluginManager().dumpPlugins());
                    } else if (uline.startsWith("PLUGKILL:")) {
                        this.n.getPluginManager().killPlugin(line.substring("PLUGKILL:".length()).trim(), TimeUnit.MINUTES.toMillis(1L), false);
                    } else if (uline.startsWith("ANNOUNCE")) {
                        OpennetManager om = this.n.getOpennet();
                        if (om == null) {
                            outsb.append("OPENNET DISABLED, cannot announce.");
                            return false;
                        }
                        final double target = (uline = uline.substring("ANNOUNCE".length())).charAt(0) == ':' ? Double.parseDouble(uline.substring(1)) : this.n.getRandom().nextDouble();
                        om.announce(target, new AnnouncementCallback(){

                            private void write(String msg) {
                                try {
                                    TextModeClientInterface.this.w.write("ANNOUNCE:" + target + ":" + msg + "\r\n");
                                    TextModeClientInterface.this.w.flush();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }

                            @Override
                            public void addedNode(PeerNode pn) {
                                this.write("Added node " + pn.shortToString());
                            }

                            @Override
                            public void bogusNoderef(String reason) {
                                this.write("Bogus noderef: " + reason);
                            }

                            @Override
                            public void completed() {
                                this.write("Completed announcement.");
                            }

                            @Override
                            public void nodeFailed(PeerNode pn, String reason) {
                                this.write("Node failed: " + pn + " " + reason);
                            }

                            @Override
                            public void noMoreNodes() {
                                this.write("Route Not Found");
                            }

                            @Override
                            public void nodeNotWanted() {
                                this.write("Hop doesn't want me.");
                            }

                            @Override
                            public void nodeNotAdded() {
                                this.write("Node not added as we don't want it for some reason.");
                            }

                            @Override
                            public void acceptedSomewhere() {
                                this.write("Announcement accepted by some node.");
                            }

                            @Override
                            public void relayedNoderef() {
                                this.write("Announcement returned a noderef that we relayed downstream. THIS SHOULD NOT HAPPEN!");
                            }
                        });
                    } else if (!uline.isEmpty()) {
                        this.printHeader(this.w);
                    }
                }
            }
        }
        outsb.append("\r\n");
        this.w.write(outsb.toString());
        this.w.flush();
        return false;
    }

    private HashMap<String, Object> makeBucketsByName(String directory) {
        if (!directory.endsWith("/")) {
            directory = directory + '/';
        }
        File thisdir = new File(directory);
        System.out.println("Listing dir: " + thisdir);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        File[] filelist = thisdir.listFiles();
        if (filelist == null) {
            throw new IllegalArgumentException("No such directory");
        }
        for (int i = 0; i < filelist.length; ++i) {
            if (!filelist[i].canRead() || !filelist[i].exists()) continue;
            if (filelist[i].isFile()) {
                File f = filelist[i];
                FileBucket bucket = new FileBucket(f, true, false, false, false);
                ret.put(f.getName(), bucket);
                continue;
            }
            if (!filelist[i].isDirectory()) continue;
            HashMap<String, Object> subdir = this.makeBucketsByName(directory + filelist[i].getName());
            ret.put(filelist[i].getName(), subdir);
        }
        return ret;
    }

    private String readLines(BufferedReader reader, boolean isFieldSet) {
        StringBuilder sb = new StringBuilder(1000);
        boolean breakflag = false;
        do {
            String line;
            try {
                line = reader.readLine();
                if (line == null) {
                    throw new EOFException();
                }
            }
            catch (IOException e1) {
                System.err.println("Bye... (" + e1 + ')');
                return null;
            }
            if (!isFieldSet && line.equals(".")) break;
            if (isFieldSet) {
                if ((line = line.trim()).equals("End")) {
                    breakflag = true;
                } else if (line.endsWith("End") && Character.isWhitespace(line.charAt(line.length() - ("End".length() + 1)))) {
                    line = "End";
                    breakflag = true;
                } else {
                    int idx = line.indexOf(61);
                    if (idx < 0) {
                        System.err.println("No = and no End in line: " + line);
                        return "";
                    }
                    if (idx > 0) {
                        String after = idx == line.length() - 1 ? "" : line.substring(idx + 1);
                        String before = line.substring(0, idx);
                        before = before.trim();
                        int x = 0;
                        for (int j = before.length() - 1; j >= 0; --j) {
                            char c = before.charAt(j);
                            if (c == '.' || Character.isLetterOrDigit(c)) continue;
                            x = j + 1;
                            break;
                        }
                        before = before.substring(x);
                        line = before + '=' + after;
                    } else {
                        System.err.println("Invalid empty field name");
                        breakflag = true;
                    }
                }
            }
            sb.append(line).append("\r\n");
        } while (!breakflag);
        return sb.toString();
    }

    private void addPeer(String content) {
        DarknetPeerNode pn;
        SimpleFieldSet fs;
        System.out.println("Connecting to:\r\n" + content);
        try {
            fs = new SimpleFieldSet(content, false, true, false);
        }
        catch (IOException e) {
            System.err.println("Did not parse: " + e);
            e.printStackTrace();
            return;
        }
        try {
            pn = this.n.createNewDarknetNode(fs, DarknetPeerNode.FRIEND_TRUST.NORMAL, DarknetPeerNode.FRIEND_VISIBILITY.NO);
        }
        catch (FSParseException e1) {
            System.err.println("Did not parse: " + e1);
            Logger.error(this, "Did not parse: " + e1, (Throwable)e1);
            return;
        }
        catch (PeerParseException e1) {
            System.err.println("Did not parse: " + e1);
            Logger.error(this, "Did not parse: " + e1, (Throwable)e1);
            return;
        }
        catch (ReferenceSignatureVerificationException e1) {
            System.err.println("Did not parse: " + e1);
            Logger.error(this, "Did not parse: " + e1, (Throwable)e1);
            return;
        }
        catch (PeerTooOldException e1) {
            System.err.println("Did not parse: " + e1);
            Logger.error(this, "Did not parse: " + e1, (Throwable)e1);
            return;
        }
        if (this.n.getPeers().addPeer(pn)) {
            System.out.println("Added peer: " + pn);
        }
        this.n.getPeers().writePeersDarknetUrgent();
    }

    private boolean disablePeer(String nodeIdentifier) {
        for (DarknetPeerNode pn : this.n.getPeers().getDarknetPeers()) {
            Peer peer = pn.getPeer();
            String nodeIpAndPort = "";
            if (peer != null) {
                nodeIpAndPort = peer.toString();
            }
            String name = pn.myName;
            String identity = pn.getIdentityString();
            if (!identity.equals(nodeIdentifier) && !nodeIpAndPort.equals(nodeIdentifier) && !name.equals(nodeIdentifier)) continue;
            pn.disablePeer();
            return true;
        }
        return false;
    }

    private boolean enablePeer(String nodeIdentifier) {
        for (DarknetPeerNode pn : this.n.getPeers().getDarknetPeers()) {
            Peer peer = pn.getPeer();
            String nodeIpAndPort = "";
            if (peer != null) {
                nodeIpAndPort = peer.toString();
            }
            String name = pn.myName;
            String identity = pn.getIdentityString();
            if (!identity.equals(nodeIdentifier) && !nodeIpAndPort.equals(nodeIdentifier) && !name.equals(nodeIdentifier)) continue;
            pn.enablePeer();
            return true;
        }
        return false;
    }

    private boolean havePeer(String nodeIdentifier) {
        for (DarknetPeerNode pn : this.n.getPeers().getDarknetPeers()) {
            Peer peer = pn.getPeer();
            String nodeIpAndPort = "";
            if (peer != null) {
                nodeIpAndPort = peer.toString();
            }
            String name = pn.myName;
            String identity = pn.getIdentityString();
            if (!identity.equals(nodeIdentifier) && !nodeIpAndPort.equals(nodeIdentifier) && !name.equals(nodeIdentifier)) continue;
            return true;
        }
        return false;
    }

    private boolean removePeer(String nodeIdentifier) {
        System.out.println("Removing peer from node for: " + nodeIdentifier);
        for (DarknetPeerNode pn : this.n.getPeers().getDarknetPeers()) {
            Peer peer = pn.getPeer();
            String nodeIpAndPort = "";
            if (peer != null) {
                nodeIpAndPort = peer.toString();
            }
            String name = pn.myName;
            String identity = pn.getIdentityString();
            if (!identity.equals(nodeIdentifier) && !nodeIpAndPort.equals(nodeIdentifier) && !name.equals(nodeIdentifier)) continue;
            this.n.removePeerConnection(pn);
            return true;
        }
        System.out.println("No node in peers list for: " + nodeIdentifier);
        return false;
    }

    private String sanitize(String fnam) {
        if (fnam == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(fnam.length());
        for (int i = 0; i < fnam.length(); ++i) {
            char c = fnam.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '-' && c != '.') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

