/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import freenet.support.Logger;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public final class Fallocate {
    private static final boolean IS_LINUX = Platform.isLinux();
    private static final boolean IS_WINDOWS = Platform.isWindows();
    private static final boolean IS_POSIX = !Platform.isWindows() && !Platform.isMac() && !Platform.isOpenBSD();
    private static final boolean IS_ANDROID = Platform.isAndroid();
    private static final int FALLOC_FL_KEEP_SIZE = 1;
    private final int fd;
    private int mode;
    private long offset;
    private final long final_filesize;
    private final FileChannel channel;

    private Fallocate(FileChannel channel, int fd, long final_filesize) {
        this.fd = fd;
        this.final_filesize = final_filesize;
        this.channel = channel;
    }

    public static Fallocate forChannel(FileChannel channel, long final_filesize) {
        return new Fallocate(channel, Fallocate.getDescriptor(channel), final_filesize);
    }

    public static Fallocate forChannel(FileChannel channel, FileDescriptor fd, long final_filesize) {
        return new Fallocate(channel, Fallocate.getDescriptor(fd), final_filesize);
    }

    public Fallocate fromOffset(long offset) {
        if (offset < 0L || offset > this.final_filesize) {
            throw new IllegalArgumentException();
        }
        this.offset = offset;
        return this;
    }

    @Deprecated
    public Fallocate keepSize() {
        if (!IS_LINUX) {
            throw new UnsupportedOperationException("fallocate keep size is not supported on this file system");
        }
        this.mode |= 1;
        return this;
    }

    public void execute() throws IOException {
        int errno = 0;
        boolean isUnsupported = false;
        if (this.fd > 2) {
            if (IS_LINUX) {
                int result = FallocateHolder.fallocate(this.fd, this.mode, this.offset, this.final_filesize - this.offset);
                errno = result == 0 ? 0 : Native.getLastError();
            } else if (IS_POSIX) {
                errno = FallocateHolderPOSIX.posix_fallocate(this.fd, this.offset, this.final_filesize - this.offset);
            } else {
                isUnsupported = true;
            }
        } else {
            isUnsupported = true;
        }
        if (isUnsupported || errno != 0) {
            if (errno != 0) {
                Logger.normal(this, "fallocate() failed; using legacy method; errno=" + errno);
            }
            Fallocate.legacyFill(this.channel, this.final_filesize, this.offset);
        }
    }

    private static int getDescriptor(FileChannel channel) {
        try {
            Field field = channel.getClass().getDeclaredField("fd");
            field.setAccessible(true);
            return Fallocate.getDescriptor((FileDescriptor)field.get(channel));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int getDescriptor(FileDescriptor descriptor) {
        try {
            Field field = descriptor.getClass().getDeclaredField(IS_ANDROID ? "descriptor" : "fd");
            field.setAccessible(true);
            return (Integer)field.get(descriptor);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static void legacyFill(FileChannel fc, long newLength, long offset) throws IOException {
        if (IS_WINDOWS) {
            fc.write(ByteBuffer.allocate(1), newLength - 1L);
        } else {
            byte[] b = new byte[0x400000];
            ByteBuffer bb = ByteBuffer.wrap(b);
            while (offset < newLength && newLength - offset >= (long)b.length) {
                bb.rewind();
                offset += (long)fc.write(bb, offset);
            }
            while (offset < newLength) {
                offset += (long)fc.write(ByteBuffer.wrap(new byte[Math.toIntExact(newLength - offset)]), offset);
            }
        }
    }

    private static class FallocateHolderPOSIX {
        private FallocateHolderPOSIX() {
        }

        private static native int posix_fallocate(int var0, long var1, long var3);

        static {
            Native.register(FallocateHolderPOSIX.class, (String)Platform.C_LIBRARY_NAME);
        }
    }

    private static class FallocateHolder {
        private FallocateHolder() {
        }

        private static native int fallocate(int var0, int var1, long var2, long var4);

        static {
            Native.register(FallocateHolder.class, (String)Platform.C_LIBRARY_NAME);
        }
    }
}

