/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.crypt.MasterSecret;
import freenet.crypt.PCFBMode;
import freenet.crypt.RandomSource;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import freenet.support.math.MersenneTwister;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class PaddedEphemerallyEncryptedBucket
implements Bucket,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Bucket bucket;
    private final int minPaddedSize;
    private final byte[] key;
    private final byte[] iv;
    private transient byte[] randomSeed;
    private long dataLength;
    private boolean readOnly;
    private transient int lastOutputStream;
    private static volatile boolean logMINOR;
    public static final int MIN_PADDED_SIZE = 1024;
    public static final int MAGIC = 1724325833;
    static final int VERSION = 1;

    public PaddedEphemerallyEncryptedBucket(Bucket bucket, int minSize, RandomSource strongPRNG, Random weakPRNG) {
        this.bucket = bucket;
        if (bucket.size() != 0L) {
            throw new IllegalArgumentException("Bucket must be empty");
        }
        byte[] tempKey = new byte[32];
        this.randomSeed = new byte[32];
        weakPRNG.nextBytes(this.randomSeed);
        strongPRNG.nextBytes(tempKey);
        this.key = tempKey;
        this.iv = new byte[32];
        strongPRNG.nextBytes(this.iv);
        this.minPaddedSize = minSize;
        this.readOnly = false;
        this.lastOutputStream = 0;
        this.dataLength = 0L;
    }

    public PaddedEphemerallyEncryptedBucket(PaddedEphemerallyEncryptedBucket orig, Bucket newBucket) {
        this.dataLength = orig.dataLength;
        this.key = (byte[])orig.key.clone();
        this.randomSeed = null;
        this.setReadOnly();
        this.bucket = newBucket;
        this.minPaddedSize = orig.minPaddedSize;
        this.iv = (byte[])(orig.iv != null ? Arrays.copyOf(orig.iv, 32) : null);
    }

    protected PaddedEphemerallyEncryptedBucket() {
        this.bucket = null;
        this.minPaddedSize = 0;
        this.key = null;
        this.iv = null;
        this.randomSeed = null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(this.getOutputStreamUnbuffered());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStreamUnbuffered() throws IOException {
        if (this.readOnly) {
            throw new IOException("Read only");
        }
        OutputStream os = this.bucket.getOutputStreamUnbuffered();
        PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = this;
        synchronized (paddedEphemerallyEncryptedBucket) {
            this.dataLength = 0L;
        }
        return new PaddedEphemerallyEncryptedOutputStream(os, ++this.lastOutputStream);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(this.getInputStreamUnbuffered());
    }

    @Override
    public InputStream getInputStreamUnbuffered() throws IOException {
        return new PaddedEphemerallyEncryptedInputStream(this.bucket.getInputStreamUnbuffered());
    }

    public synchronized long paddedLength() {
        return PaddedEphemerallyEncryptedBucket.paddedLength(this.dataLength, this.minPaddedSize);
    }

    public static long paddedLength(long dataLength, long minPaddedSize) {
        long size = dataLength;
        if (size < minPaddedSize) {
            size = minPaddedSize;
        }
        if (size == minPaddedSize) {
            return size;
        }
        long min = minPaddedSize;
        long max = minPaddedSize << 1;
        while (true) {
            if (max < 0L) {
                throw new Error("Impossible size: " + size + " - min=" + min + ", max=" + max);
            }
            if (size < min) {
                throw new IllegalStateException("???");
            }
            if (size >= min && size <= max) {
                if (logMINOR) {
                    Logger.minor(PaddedEphemerallyEncryptedBucket.class, "Padded: " + max + " was: " + dataLength);
                }
                return max;
            }
            min = max;
            max <<= 1;
        }
    }

    private synchronized Rijndael getRijndael() {
        Rijndael aes;
        try {
            aes = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        aes.initialize(this.key);
        return aes;
    }

    public PCFBMode getPCFB() {
        Rijndael aes = this.getRijndael();
        if (this.iv != null) {
            return PCFBMode.create(aes, this.iv);
        }
        return PCFBMode.create(aes);
    }

    @Override
    public String getName() {
        return "Encrypted:" + this.bucket.getName();
    }

    public String toString() {
        return super.toString() + ':' + this.bucket;
    }

    @Override
    public synchronized long size() {
        return this.dataLength;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly() {
        this.readOnly = true;
    }

    public Bucket getUnderlying() {
        return this.bucket;
    }

    @Override
    public void free() {
        this.bucket.free();
    }

    public byte[] getKey() {
        return this.key;
    }

    @Override
    public Bucket createShadow() {
        Bucket newUnderlying = this.bucket.createShadow();
        if (newUnderlying == null) {
            return null;
        }
        return new PaddedEphemerallyEncryptedBucket(this, newUnderlying);
    }

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
        this.randomSeed = new byte[32];
        context.fastWeakRandom.nextBytes(this.randomSeed);
        this.bucket.onResume(context);
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(1724325833);
        dos.writeInt(1);
        dos.writeInt(this.minPaddedSize);
        dos.write(this.key);
        if (this.iv != null) {
            dos.writeBoolean(true);
            dos.write(this.iv);
        } else {
            dos.writeBoolean(false);
        }
        dos.writeLong(this.dataLength);
        dos.writeBoolean(this.readOnly);
        this.bucket.storeTo(dos);
    }

    protected PaddedEphemerallyEncryptedBucket(DataInputStream dis, FilenameGenerator fg, PersistentFileTracker persistentFileTracker, MasterSecret masterKey) throws StorageFormatException, IOException, ResumeFailedException {
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version");
        }
        this.minPaddedSize = dis.readInt();
        this.key = new byte[32];
        dis.readFully(this.key);
        if (dis.readBoolean()) {
            this.iv = new byte[32];
            dis.readFully(this.iv);
        } else {
            this.iv = null;
        }
        this.dataLength = dis.readLong();
        this.readOnly = dis.readBoolean();
        this.bucket = BucketTools.restoreFrom(dis, fg, persistentFileTracker, masterKey);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    private class PaddedEphemerallyEncryptedInputStream
    extends InputStream {
        final InputStream in;
        final PCFBMode pcfb;
        long ptr;

        public PaddedEphemerallyEncryptedInputStream(InputStream in) {
            this.in = in;
            this.pcfb = PaddedEphemerallyEncryptedBucket.this.getPCFB();
            this.ptr = 0L;
        }

        @Override
        public int read() throws IOException {
            if (this.ptr >= PaddedEphemerallyEncryptedBucket.this.dataLength) {
                return -1;
            }
            int x = this.in.read();
            if (x == -1) {
                return x;
            }
            ++this.ptr;
            return this.pcfb.decipher(x);
        }

        @Override
        public final int available() {
            int x = (int)Math.min(PaddedEphemerallyEncryptedBucket.this.dataLength - this.ptr, Integer.MAX_VALUE);
            return Math.max(x, 0);
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            if (length + offset > buf.length || offset < 0 || length < 0) {
                throw new ArrayIndexOutOfBoundsException("a=" + offset + ", b=" + length + ", length " + buf.length);
            }
            int x = this.available();
            if (x <= 0) {
                return -1;
            }
            int readBytes = this.in.read(buf, offset, length = Math.min(length, x));
            if (readBytes <= 0) {
                return readBytes;
            }
            this.ptr += (long)readBytes;
            this.pcfb.blockDecipher(buf, offset, readBytes);
            return readBytes;
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        @Override
        public long skip(long bytes) throws IOException {
            long skipped;
            int x;
            byte[] buf = new byte[(int)Math.min(4096L, bytes)];
            for (skipped = 0L; skipped < bytes; skipped += (long)x) {
                x = this.read(buf, 0, (int)Math.min(bytes - skipped, (long)buf.length));
                if (x > 0) continue;
                return skipped;
            }
            return skipped;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    private class PaddedEphemerallyEncryptedOutputStream
    extends OutputStream {
        final PCFBMode pcfb;
        final OutputStream out;
        final int streamNumber;
        private boolean closed;

        public PaddedEphemerallyEncryptedOutputStream(OutputStream out, int streamNumber) {
            this.out = out;
            PaddedEphemerallyEncryptedBucket.this.dataLength = 0L;
            this.streamNumber = streamNumber;
            this.pcfb = PaddedEphemerallyEncryptedBucket.this.getPCFB();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = PaddedEphemerallyEncryptedBucket.this;
            synchronized (paddedEphemerallyEncryptedBucket) {
                if (this.closed) {
                    throw new IOException("Already closed!");
                }
                if (this.streamNumber != PaddedEphemerallyEncryptedBucket.this.lastOutputStream) {
                    throw new IllegalStateException("Writing to old stream in " + PaddedEphemerallyEncryptedBucket.this.getName());
                }
            }
            int toWrite = this.pcfb.encipher(b);
            PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket2 = PaddedEphemerallyEncryptedBucket.this;
            synchronized (paddedEphemerallyEncryptedBucket2) {
                this.out.write(toWrite);
                PaddedEphemerallyEncryptedBucket.this.dataLength++;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buf) throws IOException {
            PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = PaddedEphemerallyEncryptedBucket.this;
            synchronized (paddedEphemerallyEncryptedBucket) {
                if (this.closed) {
                    throw new IOException("Already closed!");
                }
                if (this.streamNumber != PaddedEphemerallyEncryptedBucket.this.lastOutputStream) {
                    throw new IllegalStateException("Writing to old stream in " + PaddedEphemerallyEncryptedBucket.this.getName());
                }
            }
            this.write(buf, 0, buf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buf, int offset, int length) throws IOException {
            PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = PaddedEphemerallyEncryptedBucket.this;
            synchronized (paddedEphemerallyEncryptedBucket) {
                if (this.closed) {
                    throw new IOException("Already closed!");
                }
                if (this.streamNumber != PaddedEphemerallyEncryptedBucket.this.lastOutputStream) {
                    throw new IllegalStateException("Writing to old stream in " + PaddedEphemerallyEncryptedBucket.this.getName());
                }
            }
            if (length == 0) {
                return;
            }
            byte[] enc = Arrays.copyOfRange(buf, offset, offset + length);
            this.pcfb.blockEncipher(enc, 0, enc.length);
            PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket2 = PaddedEphemerallyEncryptedBucket.this;
            synchronized (paddedEphemerallyEncryptedBucket2) {
                this.out.write(enc, 0, enc.length);
                PaddedEphemerallyEncryptedBucket.this.dataLength = PaddedEphemerallyEncryptedBucket.this.dataLength + (long)enc.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            MersenneTwister random;
            block11: {
                random = new MersenneTwister(PaddedEphemerallyEncryptedBucket.this.randomSeed);
                PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = PaddedEphemerallyEncryptedBucket.this;
                // MONITORENTER : paddedEphemerallyEncryptedBucket
                if (!this.closed) break block11;
                // MONITOREXIT : paddedEphemerallyEncryptedBucket
                this.closed = true;
                this.out.flush();
                this.out.close();
                return;
            }
            if (this.streamNumber != PaddedEphemerallyEncryptedBucket.this.lastOutputStream) {
                Logger.normal(this, "Not padding out to length because have been superceded: " + PaddedEphemerallyEncryptedBucket.this.getName());
                // MONITOREXIT : paddedEphemerallyEncryptedBucket
                this.closed = true;
                this.out.flush();
                this.out.close();
                return;
            }
            try {
                int left;
                long finalLength = PaddedEphemerallyEncryptedBucket.this.paddedLength();
                long padding = finalLength - PaddedEphemerallyEncryptedBucket.this.dataLength;
                int sz = 65536;
                if (padding < (long)sz) {
                    sz = (int)padding;
                }
                byte[] buf = new byte[sz];
                for (long writtenPadding = 0L; writtenPadding < padding; writtenPadding += (long)left) {
                    left = (int)Math.min(padding - writtenPadding, (long)buf.length);
                    ((Random)((Object)random)).nextBytes(buf);
                    this.out.write(buf, 0, left);
                }
                // MONITOREXIT : paddedEphemerallyEncryptedBucket
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.closed = true;
                this.out.flush();
                this.out.close();
            }
        }
    }
}

