/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.FailureCodeTracker;
import freenet.client.FetchException;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.RequestIdentifier;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;

public class GetFailedMessage
extends FCPMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    final FetchException.FetchExceptionMode code;
    final String extraDescription;
    final FailureCodeTracker tracker;
    final boolean isFatal;
    final String identifier;
    final boolean global;
    final long expectedDataLength;
    final String expectedMimeType;
    final boolean finalizedExpected;
    final FreenetURI redirectURI;
    private static volatile boolean logMINOR;
    static final int VERSION = 1;

    public GetFailedMessage(FetchException e, String identifier, boolean global) {
        if (logMINOR) {
            Logger.minor(this, "Creating get failed from " + e + " for " + identifier, (Throwable)e);
        }
        this.tracker = e.errorCodes;
        this.code = e.mode;
        this.extraDescription = e.extraMessage;
        this.isFatal = e.isFatal();
        this.identifier = identifier;
        this.global = global;
        this.expectedDataLength = e.expectedSize;
        this.expectedMimeType = e.getExpectedMimeType();
        this.finalizedExpected = e.finalizedSize();
        this.redirectURI = e.newURI;
    }

    public GetFailedMessage(SimpleFieldSet fs, boolean useVerboseFields) throws MalformedURLException {
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new NullPointerException();
        }
        this.code = FetchException.FetchExceptionMode.getByCode(Integer.parseInt(fs.get("Code")));
        this.isFatal = useVerboseFields ? fs.getBoolean("Fatal", false) : FetchException.isFatal(this.code);
        this.extraDescription = fs.get("ExtraDescription");
        SimpleFieldSet trackerSubset = fs.subset("Errors");
        this.tracker = trackerSubset != null ? new FailureCodeTracker(true, trackerSubset) : null;
        this.expectedMimeType = fs.get("ExpectedMimeType");
        this.finalizedExpected = fs.getBoolean("FinalizedExpected", false);
        String s = fs.get("ExpectedDataLength");
        this.expectedDataLength = s != null ? Long.parseLong(s) : -1L;
        s = fs.get("RedirectURI");
        this.redirectURI = s != null ? new FreenetURI(s) : null;
        this.global = fs.getBoolean("Global", false);
    }

    protected GetFailedMessage() {
        this.code = null;
        this.extraDescription = null;
        this.tracker = null;
        this.isFatal = false;
        this.identifier = null;
        this.global = false;
        this.expectedDataLength = 0L;
        this.expectedMimeType = null;
        this.finalizedExpected = false;
        this.redirectURI = null;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return this.getFieldSet(true);
    }

    public SimpleFieldSet getFieldSet(boolean verbose) {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.put("Code", this.code.code);
        if (verbose) {
            sfs.putSingle("CodeDescription", this.getFailedMessage());
        }
        if (this.extraDescription != null) {
            sfs.putSingle("ExtraDescription", this.extraDescription);
        }
        if (verbose) {
            sfs.put("Fatal", this.isFatal);
        }
        if (this.tracker != null) {
            sfs.tput("Errors", this.tracker.toFieldSet(verbose));
        }
        if (verbose) {
            sfs.putSingle("ShortCodeDescription", this.getShortFailedMessage());
        }
        sfs.putSingle("Identifier", this.identifier);
        sfs.put("Global", this.global);
        if (this.expectedDataLength > -1L) {
            sfs.put("ExpectedDataLength", this.expectedDataLength);
        }
        if (this.expectedMimeType != null) {
            sfs.putSingle("ExpectedMetadata.ContentType", this.expectedMimeType);
        }
        if (this.finalizedExpected) {
            sfs.putSingle("FinalizedExpected", "true");
        }
        if (this.redirectURI != null) {
            sfs.putSingle("RedirectURI", this.redirectURI.toString(false, false));
        }
        return sfs;
    }

    @Override
    public String getName() {
        return "GetFailed";
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "GetFailed goes from server to client not the other way around", this.identifier, this.global);
    }

    public String getFailedMessage() {
        return FetchException.getMessage(this.code);
    }

    public String getShortFailedMessage() {
        return FetchException.getShortMessage(this.code);
    }

    public String getLongFailedMessage() {
        if (this.extraDescription != null) {
            return this.getFailedMessage() + ": " + this.extraDescription;
        }
        return this.getFailedMessage();
    }

    public void writeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(1);
        dos.writeInt(this.code.code);
        this.writePossiblyNull(this.extraDescription, dos);
        dos.writeBoolean(this.finalizedExpected);
        this.writePossiblyNull(this.redirectURI == null ? null : this.redirectURI.toString(), dos);
    }

    public GetFailedMessage(DataInputStream dis, RequestIdentifier reqID, long expectedSize, String expectedType) throws StorageFormatException, IOException {
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version in GetFailedMessage");
        }
        int x = dis.readInt();
        try {
            this.code = FetchException.FetchExceptionMode.getByCode(x);
        }
        catch (IllegalArgumentException e) {
            throw new StorageFormatException("Bad error code");
        }
        this.isFatal = FetchException.isFatal(this.code);
        this.extraDescription = this.readPossiblyNull(dis);
        this.finalizedExpected = dis.readBoolean();
        String s = this.readPossiblyNull(dis);
        if (s != null) {
            try {
                this.redirectURI = new FreenetURI(s);
            }
            catch (MalformedURLException e) {
                throw new StorageFormatException("Bad redirect URI in GetFailedMessage: " + e);
            }
        } else {
            this.redirectURI = null;
        }
        this.global = reqID.globalQueue;
        this.identifier = reqID.identifier;
        this.tracker = null;
        this.expectedDataLength = expectedSize;
        this.expectedMimeType = expectedType;
    }

    private String readPossiblyNull(DataInputStream dis) throws IOException {
        if (dis.readBoolean()) {
            return dis.readUTF();
        }
        return null;
    }

    private void writePossiblyNull(String s, DataOutputStream dos) throws IOException {
        if (s != null) {
            dos.writeBoolean(true);
            dos.writeUTF(s);
        } else {
            dos.writeBoolean(false);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

