/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.async.ClientContext;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.clients.fcp.EndListPersistentRequestsMessage;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPConnectionOutputHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.PersistentRequestClient;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;
import freenet.support.io.NativeThread;

public class ListPersistentRequestsMessage
extends FCPMessage {
    static final String NAME = "ListPersistentRequests";
    private final String identifier;

    public ListPersistentRequestsMessage(SimpleFieldSet fs) {
        this.identifier = fs.get("Identifier");
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(final FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        PersistentRequestClient rebootClient = handler.getRebootClient();
        TransientListJob job = new TransientListJob(rebootClient, handler.getOutputHandler(), node.getClientCore().getClientContext(), this.identifier){

            @Override
            void complete(ClientContext context) {
                if (handler.getRebootClient().watchGlobal) {
                    PersistentRequestClient globalRebootClient = handler.getServer().getGlobalRebootClient();
                    TransientListJob job = new TransientListJob(globalRebootClient, this.outputHandler, context, this.listRequestIdentifier){

                        @Override
                        void complete(ClientContext context) {
                            this.finishComplete(context);
                        }
                    };
                    job.run();
                } else {
                    this.finishComplete(context);
                }
            }

            private void finishComplete(ClientContext context) {
                try {
                    context.jobRunner.queue(new PersistentJob(){

                        @Override
                        public boolean run(ClientContext context) {
                            PersistentRequestClient foreverClient = handler.getForeverClient();
                            PersistentListJob job = new PersistentListJob(foreverClient, outputHandler, context, listRequestIdentifier){

                                @Override
                                void complete(ClientContext context) {
                                    if (handler.getRebootClient().watchGlobal) {
                                        PersistentRequestClient globalForeverClient = handler.getServer().getGlobalForeverClient();
                                        PersistentListJob job = new PersistentListJob(globalForeverClient, this.outputHandler, context, this.listRequestIdentifier){

                                            @Override
                                            void complete(ClientContext context) {
                                                this.finishFinal();
                                            }
                                        };
                                        job.run(context);
                                    } else {
                                        this.finishFinal();
                                    }
                                }

                                private void finishFinal() {
                                    this.outputHandler.queue(new EndListPersistentRequestsMessage(this.listRequestIdentifier));
                                }
                            };
                            job.run(context);
                            return false;
                        }
                    }, NativeThread.HIGH_PRIORITY - 1);
                }
                catch (PersistenceDisabledException e) {
                    handler.send(new EndListPersistentRequestsMessage(this.listRequestIdentifier));
                }
            }
        };
        job.run();
    }

    public static abstract class PersistentListJob
    extends ListJob
    implements PersistentJob,
    Runnable {
        final ClientContext context;

        PersistentListJob(PersistentRequestClient client, FCPConnectionOutputHandler handler, ClientContext context, String listRequestIdentifier) {
            super(client, handler, listRequestIdentifier);
            this.context = context;
        }

        @Override
        void reschedule(ClientContext context) {
            context.ticker.queueTimedJob(this, 100L);
        }

        @Override
        public void run() {
            try {
                this.context.jobRunner.queue(this, NativeThread.HIGH_PRIORITY - 1);
            }
            catch (PersistenceDisabledException e) {
                this.outputHandler.queue(new EndListPersistentRequestsMessage(this.listRequestIdentifier));
            }
        }
    }

    public static abstract class TransientListJob
    extends ListJob
    implements Runnable {
        final ClientContext context;

        TransientListJob(PersistentRequestClient client, FCPConnectionOutputHandler handler, ClientContext context, String listRequestIdentifier) {
            super(client, handler, listRequestIdentifier);
            this.context = context;
        }

        @Override
        public void run() {
            this.run(this.context);
        }

        @Override
        void reschedule(ClientContext context) {
            context.ticker.queueTimedJob(this, 100L);
        }
    }

    public static abstract class ListJob
    implements PersistentJob {
        final PersistentRequestClient client;
        final FCPConnectionOutputHandler outputHandler;
        protected final String listRequestIdentifier;
        boolean sentRestartJobs;
        int progressCompleted = 0;
        int progressRunning = 0;

        ListJob(PersistentRequestClient client, FCPConnectionOutputHandler outputHandler, String listRequestIdentifier) {
            this.client = client;
            this.outputHandler = outputHandler;
            this.listRequestIdentifier = listRequestIdentifier;
        }

        @Override
        public boolean run(ClientContext context) {
            int p;
            while (!this.sentRestartJobs) {
                if (this.outputHandler.isQueueHalfFull()) {
                    this.reschedule(context);
                    return false;
                }
                p = this.client.queuePendingMessagesOnConnectionRestart(this.outputHandler, this.listRequestIdentifier, this.progressCompleted, 30);
                if (p <= this.progressCompleted) {
                    this.sentRestartJobs = true;
                    break;
                }
                this.progressCompleted = p;
            }
            if (this.noRunning()) {
                this.complete(context);
            }
            while (true) {
                if (this.outputHandler.isQueueHalfFull()) {
                    this.reschedule(context);
                    return false;
                }
                p = this.client.queuePendingMessagesFromRunningRequests(this.outputHandler, this.listRequestIdentifier, this.progressRunning, 30);
                if (p <= this.progressRunning) {
                    this.complete(context);
                    return false;
                }
                this.progressRunning = p;
            }
        }

        abstract void reschedule(ClientContext var1);

        abstract void complete(ClientContext var1);

        protected boolean noRunning() {
            return false;
        }
    }
}

