/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;
import freenet.crypt.CryptByteBufferType;
import freenet.crypt.KeyGenUtils;
import freenet.crypt.PCFBMode;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.UnsupportedTypeException;
import freenet.crypt.ciphers.Rijndael;
import freenet.support.Fields;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public final class CryptByteBuffer
implements Serializable {
    private static final long serialVersionUID = 6143338995971755362L;
    private final CryptByteBufferType type;
    private final SecretKey key;
    private IvParameterSpec iv;
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private BlockCipher blockCipher;
    private PCFBMode encryptPCFB;
    private PCFBMode decryptPCFB;

    public CryptByteBuffer(CryptByteBufferType type, SecretKey key, IvParameterSpec iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (iv != null && !type.hasIV()) {
            throw new UnsupportedTypeException(type, "This type does not take an IV.");
        }
        if (iv != null) {
            this.iv = iv;
        } else if (type.hasIV()) {
            this.genIV();
        }
        this.type = type;
        this.key = key;
        try {
            if (type.cipherName.equals("RIJNDAEL")) {
                this.blockCipher = new Rijndael(type.keyType.keySize, type.blockSize);
                this.blockCipher.initialize(key.getEncoded());
                if (type == CryptByteBufferType.RijndaelPCFB) {
                    this.encryptPCFB = PCFBMode.create(this.blockCipher, this.iv.getIV());
                    this.decryptPCFB = PCFBMode.create(this.blockCipher, this.iv.getIV());
                }
            } else {
                this.encryptCipher = Cipher.getInstance(type.algName);
                this.decryptCipher = Cipher.getInstance(type.algName);
                this.encryptCipher.init(1, (Key)this.key, this.iv);
                this.decryptCipher.init(2, (Key)this.key, this.iv);
            }
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        catch (NoSuchPaddingException e) {
            throw new Error(e);
        }
    }

    public CryptByteBuffer(CryptByteBufferType type, SecretKey key) throws GeneralSecurityException {
        this(type, key, (IvParameterSpec)null);
    }

    public CryptByteBuffer(CryptByteBufferType type, byte[] key) throws GeneralSecurityException {
        this(type, KeyGenUtils.getSecretKey(type.keyType, key));
    }

    public CryptByteBuffer(CryptByteBufferType type, ByteBuffer key) throws GeneralSecurityException {
        this(type, Fields.copyToArray(key));
    }

    public CryptByteBuffer(CryptByteBufferType type, SecretKey key, byte[] iv, int offset) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this(type, key, new IvParameterSpec(iv, offset, type.ivSize));
    }

    public CryptByteBuffer(CryptByteBufferType type, SecretKey key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this(type, key, iv, 0);
    }

    public CryptByteBuffer(CryptByteBufferType type, SecretKey key, ByteBuffer iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this(type, key, Fields.copyToArray(iv), 0);
    }

    public CryptByteBuffer(CryptByteBufferType type, byte[] key, byte[] iv, int offset) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this(type, KeyGenUtils.getSecretKey(type.keyType, key), iv, offset);
    }

    public CryptByteBuffer(CryptByteBufferType type, byte[] key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this(type, key, iv, 0);
    }

    public CryptByteBuffer(CryptByteBufferType type, ByteBuffer key, ByteBuffer iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this(type, Fields.copyToArray(key), Fields.copyToArray(iv), 0);
    }

    public void encrypt(byte[] input, int offset, int len, byte[] output, int outputOffset) {
        if (offset + len > input.length) {
            throw new IllegalArgumentException();
        }
        if (input == output && offset != outputOffset) {
            byte[] temp = Arrays.copyOfRange(input, offset, offset + len);
            this.encrypt(temp, 0, temp.length);
            System.arraycopy(temp, 0, output, outputOffset, len);
            return;
        }
        if (this.type == CryptByteBufferType.RijndaelPCFB) {
            System.arraycopy(input, offset, output, outputOffset, len);
            this.encryptPCFB.blockEncipher(output, outputOffset, len);
        } else if (this.type.cipherName.equals("RIJNDAEL")) {
            if (offset == 0 && len == input.length && outputOffset == 0 && len == output.length) {
                this.blockCipher.encipher(input, output);
            } else {
                byte[] result = new byte[len];
                this.blockCipher.encipher(Arrays.copyOfRange(input, offset, offset + len), result);
                System.arraycopy(result, 0, output, outputOffset, len);
            }
        } else {
            try {
                int copied = this.encryptCipher.update(input, offset, len, output, outputOffset);
                if (copied != len) {
                    throw new IllegalStateException("Not a stream cipher???");
                }
            }
            catch (ShortBufferException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void encrypt(byte[] input, int offset, int len) {
        this.encrypt(input, offset, len, input, offset);
    }

    public byte[] encryptCopy(byte[] input, int offset, int len) {
        byte[] output = Arrays.copyOfRange(input, offset, offset + len);
        this.encrypt(input, offset, len, output, 0);
        return output;
    }

    public byte[] encryptCopy(byte[] input) {
        return this.encryptCopy(input, 0, input.length);
    }

    public ByteBuffer encryptCopy(ByteBuffer input) {
        if (input.hasArray()) {
            return ByteBuffer.wrap(this.encryptCopy(input.array(), input.arrayOffset() + input.position(), input.remaining()));
        }
        return ByteBuffer.wrap(this.encryptCopy(Fields.copyToArray(input)));
    }

    public void encrypt(ByteBuffer input, ByteBuffer output) {
        block6: {
            if (input.hasArray() && output.hasArray()) {
                int moved = Math.min(input.remaining(), output.remaining());
                this.encrypt(input.array(), input.arrayOffset() + input.position(), moved, output.array(), output.arrayOffset() + output.position());
                input.position(input.position() + moved);
                output.position(output.position() + moved);
            } else {
                if (this.type != CryptByteBufferType.RijndaelPCFB && !this.type.cipherName.equals("RIJNDAEL")) {
                    try {
                        int copy = Math.min(input.remaining(), output.remaining());
                        int copied = this.encryptCipher.update(input, output);
                        if (copied != copy) {
                            throw new IllegalStateException("Not a stream cipher???");
                        }
                        break block6;
                    }
                    catch (ShortBufferException e) {
                        throw new Error("Impossible: " + e, e);
                    }
                }
                int moved = Math.min(input.remaining(), output.remaining());
                byte[] buf = new byte[moved];
                input.get(buf);
                this.encrypt(buf, 0, buf.length);
                output.put(buf);
            }
        }
    }

    public void decrypt(byte[] input, int offset, int len, byte[] output, int outputOffset) {
        if (offset + len > input.length) {
            throw new IllegalArgumentException();
        }
        if (input == output && offset != outputOffset) {
            byte[] temp = Arrays.copyOfRange(input, offset, offset + len);
            this.decrypt(temp, 0, temp.length);
            System.arraycopy(temp, 0, output, outputOffset, len);
            return;
        }
        if (this.type == CryptByteBufferType.RijndaelPCFB) {
            System.arraycopy(input, offset, output, outputOffset, len);
            this.decryptPCFB.blockDecipher(output, outputOffset, len);
        } else if (this.type.cipherName.equals("RIJNDAEL")) {
            if (offset == 0 && len == input.length && outputOffset == 0 && len == output.length) {
                this.blockCipher.decipher(input, output);
            } else {
                byte[] result = new byte[len];
                this.blockCipher.decipher(Arrays.copyOfRange(input, offset, offset + len), result);
                System.arraycopy(result, 0, output, outputOffset, len);
            }
        } else {
            try {
                int copied = this.decryptCipher.update(input, offset, len, output, outputOffset);
                if (copied != len) {
                    throw new IllegalStateException("Not a stream cipher???");
                }
            }
            catch (ShortBufferException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void decrypt(byte[] input, int offset, int len) {
        this.decrypt(input, offset, len, input, offset);
    }

    public byte[] decryptCopy(byte[] input, int offset, int len) {
        byte[] output = Arrays.copyOfRange(input, offset, offset + len);
        this.decrypt(input, offset, len, output, 0);
        return output;
    }

    public byte[] decryptCopy(byte[] input) {
        return this.decryptCopy(input, 0, input.length);
    }

    public ByteBuffer decryptCopy(ByteBuffer input) {
        if (input.hasArray()) {
            return ByteBuffer.wrap(this.decryptCopy(input.array(), input.arrayOffset() + input.position(), input.remaining()));
        }
        return ByteBuffer.wrap(this.decryptCopy(Fields.copyToArray(input)));
    }

    public void decrypt(ByteBuffer input, ByteBuffer output) {
        block6: {
            if (input.hasArray() && output.hasArray()) {
                int moved = Math.min(input.remaining(), output.remaining());
                this.decrypt(input.array(), input.arrayOffset() + input.position(), moved, output.array(), output.arrayOffset() + output.position());
                input.position(input.position() + moved);
                output.position(output.position() + moved);
            } else {
                if (this.type != CryptByteBufferType.RijndaelPCFB && !this.type.cipherName.equals("RIJNDAEL")) {
                    try {
                        int copy = Math.min(input.remaining(), output.remaining());
                        int copied = this.decryptCipher.update(input, output);
                        if (copied != copy) {
                            throw new IllegalStateException("Not a stream cipher???");
                        }
                        break block6;
                    }
                    catch (ShortBufferException e) {
                        throw new Error("Impossible: " + e, e);
                    }
                }
                int moved = Math.min(input.remaining(), output.remaining());
                byte[] buf = new byte[moved];
                input.get(buf);
                this.decrypt(buf, 0, buf.length);
                output.put(buf);
            }
        }
    }

    public void setIV(IvParameterSpec iv) throws InvalidAlgorithmParameterException {
        if (!this.type.hasIV()) {
            throw new UnsupportedTypeException(this.type);
        }
        this.iv = iv;
        try {
            this.encryptCipher.init(1, (Key)this.key, this.iv);
            this.decryptCipher.init(2, (Key)this.key, this.iv);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public IvParameterSpec genIV() {
        if (!this.type.hasIV()) {
            throw new UnsupportedTypeException(this.type);
        }
        this.iv = KeyGenUtils.genIV(this.type.ivSize);
        try {
            this.encryptCipher.init(1, (Key)this.key, this.iv);
            this.decryptCipher.init(2, (Key)this.key, this.iv);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException(e);
        }
        return this.iv;
    }

    public IvParameterSpec getIV() {
        if (!this.type.hasIV()) {
            throw new UnsupportedTypeException(this.type);
        }
        return this.iv;
    }
}

