/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import freenet.crypt.DSAPublicKey;
import freenet.crypt.Global;
import freenet.crypt.SHA256;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.keys.SSKVerifyException;
import freenet.support.Fields;
import freenet.support.HexUtil;
import freenet.support.Logger;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSASigner;

public class SSKBlock
implements KeyBlock {
    private static volatile boolean logMINOR;
    private static final int HEADER_COMPARE_TO = 71;
    final byte[] data;
    final byte[] headers;
    final int headersOffset;
    final NodeSSK nodeKey;
    final DSAPublicKey pubKey;
    final short hashIdentifier;
    final short symCipherIdentifier;
    final int hashCode;
    public static final short DATA_LENGTH = 1024;
    public static final int MAX_COMPRESSED_DATA_LENGTH = 1022;
    static final short SIG_R_LENGTH = 32;
    static final short SIG_S_LENGTH = 32;
    static final short E_H_DOCNAME_LENGTH = 32;
    public static final short TOTAL_HEADERS_LENGTH = 136;
    static final short ENCRYPTED_HEADERS_LENGTH = 36;

    public boolean equals(Object o) {
        if (!(o instanceof SSKBlock)) {
            return false;
        }
        SSKBlock block = (SSKBlock)o;
        if (!block.pubKey.equals(this.pubKey)) {
            return false;
        }
        if (!block.nodeKey.equals(this.nodeKey)) {
            return false;
        }
        if (block.headersOffset != this.headersOffset) {
            return false;
        }
        if (block.hashIdentifier != this.hashIdentifier) {
            return false;
        }
        if (block.symCipherIdentifier != this.symCipherIdentifier) {
            return false;
        }
        for (int i = 0; i < 71; ++i) {
            if (block.headers[i] == this.headers[i]) continue;
            return false;
        }
        return Arrays.equals(block.data, this.data);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public SSKBlock(byte[] data, byte[] headers, NodeSSK nodeKey, boolean dontVerify) throws SSKVerifyException {
        if (headers.length != 136) {
            throw new IllegalArgumentException("Headers.length=" + headers.length + " should be " + 136);
        }
        this.data = data;
        this.headers = headers;
        this.nodeKey = nodeKey;
        if (data.length != 1024) {
            throw new SSKVerifyException("Data length wrong: " + data.length + " should be " + 1024);
        }
        this.pubKey = nodeKey.getPubKey();
        if (this.pubKey == null) {
            throw new SSKVerifyException("PubKey was null from " + nodeKey);
        }
        this.hashIdentifier = (short)(((headers[0] & 0xFF) << 8) + (headers[1] & 0xFF));
        if (this.hashIdentifier != 1) {
            throw new SSKVerifyException("Hash not SHA-256");
        }
        int x = 2;
        this.symCipherIdentifier = (short)(((headers[x] & 0xFF) << 8) + (headers[x + 1] & 0xFF));
        byte[] ehDocname = new byte[32];
        System.arraycopy(headers, x += 2, ehDocname, 0, ehDocname.length);
        this.headersOffset = x += 32;
        if ((x += 36) + 32 + 32 > headers.length) {
            throw new SSKVerifyException("Headers too short: " + headers.length + " should be at least " + x + 32 + 32);
        }
        if (!dontVerify || logMINOR) {
            byte[] bufR = new byte[32];
            byte[] bufS = new byte[32];
            System.arraycopy(headers, x, bufR, 0, 32);
            System.arraycopy(headers, x += 32, bufS, 0, 32);
            x += 32;
            MessageDigest md = SHA256.getMessageDigest();
            md.update(data);
            byte[] dataHash = md.digest();
            md.update(headers, 0, this.headersOffset + 36);
            md.update(dataHash);
            byte[] overallHash = md.digest();
            BigInteger r = new BigInteger(1, bufR);
            BigInteger s = new BigInteger(1, bufS);
            DSASigner dsa = new DSASigner();
            dsa.init(false, (CipherParameters)new DSAPublicKeyParameters(this.pubKey.getY(), Global.getDSAgroupBigAParameters()));
            if (!dsa.verifySignature(Global.truncateHash(overallHash), r, s) && !dsa.verifySignature(overallHash, r, s)) {
                if (dontVerify) {
                    Logger.error(this, "DSA verification failed with dontVerify!!!!");
                }
                throw new SSKVerifyException("Signature verification failed for node-level SSK");
            }
        }
        if (!Arrays.equals(ehDocname, nodeKey.encryptedHashedDocname)) {
            throw new SSKVerifyException("E(H(docname)) wrong - wrong key?? \nfrom headers: " + HexUtil.bytesToHex(ehDocname) + "\nfrom key:     " + HexUtil.bytesToHex(nodeKey.encryptedHashedDocname));
        }
        this.hashCode = Fields.hashCode(data) ^ Fields.hashCode(headers) ^ nodeKey.hashCode() ^ this.pubKey.hashCode() ^ this.hashIdentifier;
    }

    @Override
    public NodeSSK getKey() {
        return this.nodeKey;
    }

    @Override
    public byte[] getRawHeaders() {
        return this.headers;
    }

    @Override
    public byte[] getRawData() {
        return this.data;
    }

    public DSAPublicKey getPubKey() {
        return this.pubKey;
    }

    @Override
    public byte[] getPubkeyBytes() {
        return this.pubKey.asBytes();
    }

    @Override
    public byte[] getFullKey() {
        return this.getKey().getFullKey();
    }

    @Override
    public byte[] getRoutingKey() {
        return this.getKey().getRoutingKey();
    }

    static {
        Logger.registerClass(SSKBlock.class);
    }
}

