/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.InsertException;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequestSchedulerGroup;
import freenet.client.async.ClientRequester;
import freenet.keys.CHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.KeyBlock;
import freenet.keys.SSKBlock;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelPutException;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableInsert;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestItemKey;
import freenet.node.SendableRequestSender;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

public class SimpleSendableInsert
extends SendableInsert {
    private static final long serialVersionUID = 1L;
    public final KeyBlock block;
    public final short prioClass;
    private boolean finished;
    public final RequestClient client;
    public final ClientRequestScheduler scheduler;
    private static volatile boolean logMINOR;

    public SimpleSendableInsert(NodeClientCore core, KeyBlock block, short prioClass) {
        super(false, false);
        this.block = block;
        this.prioClass = prioClass;
        this.client = core.getNode().getNonPersistentClientBulk();
        if (block instanceof CHKBlock) {
            this.scheduler = core.getRequestStarters().chkPutSchedulerBulk;
        } else if (block instanceof SSKBlock) {
            this.scheduler = core.getRequestStarters().sskPutSchedulerBulk;
        } else {
            throw new IllegalArgumentException("Don't know what to do with " + block);
        }
        if (!this.scheduler.isInsertScheduler()) {
            throw new IllegalStateException("Scheduler " + this.scheduler + " is not an insert scheduler!");
        }
    }

    public SimpleSendableInsert(KeyBlock block, short prioClass, RequestClient client, ClientRequestScheduler scheduler) {
        super(false, false);
        this.block = block;
        this.prioClass = prioClass;
        this.client = client;
        this.scheduler = scheduler;
    }

    @Override
    public void onSuccess(SendableRequestItem keyNum, ClientKey key, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Finished insert of " + this.block);
        }
    }

    @Override
    public void onFailure(LowLevelPutException e, SendableRequestItem keyNum, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Failed insert of " + this.block + ": " + e);
        }
    }

    @Override
    public short getPriorityClass() {
        return this.prioClass;
    }

    @Override
    public SendableRequestSender getSender(ClientContext context) {
        return new SendableRequestSender(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean send(NodeClientCore core, RequestScheduler sched, ClientContext context, ChosenBlock req) {
                try {
                    if (logMINOR) {
                        Logger.minor(this, "Starting request: " + this);
                    }
                    core.realPut(SimpleSendableInsert.this.block, req.canWriteClientCache, true, false, false, false);
                }
                catch (LowLevelPutException e) {
                    SimpleSendableInsert.this.onFailure(e, req.token, context);
                    if (logMINOR) {
                        Logger.minor(this, "Request failed: " + this + " for " + e);
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    SimpleSendableInsert.this.finished = true;
                }
                if (logMINOR) {
                    Logger.minor(this, "Request succeeded: " + this);
                }
                SimpleSendableInsert.this.onSuccess(req.token, null, context);
                sched.removeRunningInsert(SimpleSendableInsert.this, req.token.getKey());
                return true;
            }

            @Override
            public boolean sendIsBlocking() {
                return true;
            }
        };
    }

    @Override
    public RequestClient getClient() {
        return this.client;
    }

    @Override
    public ClientRequester getClientRequest() {
        return null;
    }

    @Override
    public ClientRequestSchedulerGroup getSchedulerGroup() {
        return null;
    }

    @Override
    public boolean isCancelled() {
        return this.finished;
    }

    @Override
    public boolean isEmpty() {
        return this.finished;
    }

    public void schedule() {
        this.finished = false;
        this.scheduler.registerInsert(this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(ClientContext context) {
        SimpleSendableInsert simpleSendableInsert = this;
        synchronized (simpleSendableInsert) {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }
        super.unregister(context, this.prioClass);
    }

    @Override
    public synchronized long countAllKeys(ClientContext context) {
        if (this.finished) {
            return 0L;
        }
        return 1L;
    }

    @Override
    public synchronized long countSendableKeys(ClientContext context) {
        if (this.finished) {
            return 0L;
        }
        return 1L;
    }

    @Override
    public synchronized SendableRequestItem chooseKey(KeysFetchingLocally keys, ClientContext context) {
        MySendableRequestItem mine = new MySendableRequestItem(this);
        if (keys.hasInsert(mine)) {
            return null;
        }
        if (this.finished) {
            return null;
        }
        return mine;
    }

    @Override
    public synchronized long getWakeupTime(ClientContext context, long now) {
        if (this.isEmpty()) {
            return -1L;
        }
        if (this.scheduler.fetchingKeys().hasInsert(new MySendableRequestItem(this))) {
            return Long.MAX_VALUE;
        }
        return 0L;
    }

    @Override
    public boolean isSSK() {
        return this.block instanceof SSKBlock;
    }

    @Override
    public boolean canWriteClientCache() {
        return false;
    }

    @Override
    public boolean forkOnCacheable() {
        return true;
    }

    @Override
    public void onEncode(SendableRequestItem token, ClientKey key, ClientContext context) {
    }

    @Override
    public boolean localRequestOnly() {
        return false;
    }

    @Override
    protected void innerOnResume(ClientContext context) throws InsertException {
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    private static class MySendableRequestItem
    implements SendableRequestItem,
    SendableRequestItemKey {
        final SimpleSendableInsert parent;

        public MySendableRequestItem(SimpleSendableInsert parent) {
            this.parent = parent;
        }

        @Override
        public void dump() {
        }

        @Override
        public SendableRequestItemKey getKey() {
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof MySendableRequestItem) {
                return ((MySendableRequestItem)o).parent == this.parent;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }
    }
}

