/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.probe;

public enum Type {
    BANDWIDTH(0),
    BUILD(1),
    IDENTIFIER(2),
    LINK_LENGTHS(3),
    LOCATION(4),
    STORE_SIZE(5),
    UPTIME_48H(6),
    UPTIME_7D(7),
    REJECT_STATS(8),
    OVERALL_BULK_OUTPUT_CAPACITY_USAGE(9);

    public final byte code;
    private static final int MAX_CODE;

    private Type(byte code) {
        this.code = code;
    }

    static boolean isValid(byte code) {
        return code >= 0 && code < MAX_CODE;
    }

    static Type valueOf(byte code) throws IllegalArgumentException {
        switch (code) {
            case 0: {
                return BANDWIDTH;
            }
            case 1: {
                return BUILD;
            }
            case 2: {
                return IDENTIFIER;
            }
            case 3: {
                return LINK_LENGTHS;
            }
            case 4: {
                return LOCATION;
            }
            case 5: {
                return STORE_SIZE;
            }
            case 6: {
                return UPTIME_48H;
            }
            case 7: {
                return UPTIME_7D;
            }
            case 8: {
                return REJECT_STATS;
            }
            case 9: {
                return OVERALL_BULK_OUTPUT_CAPACITY_USAGE;
            }
        }
        throw new IllegalArgumentException("There is no ProbeType with code " + code + ".");
    }

    static {
        MAX_CODE = Type.values().length;
    }
}

