/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import freenet.client.FetchException;
import freenet.crypt.SHA256;
import freenet.keys.FreenetURI;
import freenet.node.PrioRunnable;
import freenet.node.Version;
import freenet.node.updater.NodeUpdateManager;
import freenet.support.Executor;
import freenet.support.Fields;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.tanukisoftware.wrapper.WrapperManager;

public class MainJarDependenciesChecker {
    private static volatile boolean logMINOR;
    private final Deployer deployer;
    private final TreeSet<Dependency> dependencies = new TreeSet();
    private boolean broken = false;
    private int build;
    private final HashSet<Downloader> downloaders = new HashSet();
    private final Executor executor;
    static final byte[] SCRIPT_HEAD;
    static final String UPDATER_BACKUP_SUFFIX = ".update.bak.tmp";

    MainJarDependenciesChecker(Deployer deployer, Executor executor) {
        this.deployer = deployer;
        this.executor = executor;
    }

    public synchronized MainJarDependencies handle(Properties props, int build) {
        try {
            return this.innerHandle(props, build);
        }
        catch (RuntimeException e) {
            this.broken = true;
            Logger.error(this, "MainJarDependencies parsing update dependencies.properties file broke: " + e, (Throwable)e);
            throw e;
        }
        catch (Error e) {
            this.broken = true;
            Logger.error(this, "MainJarDependencies parsing update dependencies.properties file broke: " + e, (Throwable)e);
            throw e;
        }
    }

    private synchronized MainJarDependencies innerHandle(Properties props, int build) {
        this.clear(build);
        HashSet<String> processed = new HashSet<String>();
        File[] list = new File(".").listFiles(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                if (!arg0.isFile()) {
                    return false;
                }
                String name = arg0.getName().toLowerCase();
                if (!name.endsWith(".jar") && !name.endsWith(".jar.new")) {
                    return false;
                }
                return !name.equals("freenet.jar") && !name.equals("freenet.jar.new") && !name.equals("freenet-stable-latest.jar") && !name.equals("freenet-stable-latest.jar.new");
            }
        });
        block14: for (String propName : props.stringPropertyNames()) {
            byte[] expectedHash;
            DEPENDENCY_TYPE type;
            String s;
            String baseName;
            block45: {
                if (!propName.contains(".") || !processed.add(baseName = propName.split("\\.")[0])) continue;
                s = props.getProperty(baseName + ".type");
                if (s == null) {
                    Logger.error(this, "dependencies.properties broken? missing type for \"" + baseName + "\"");
                    this.broken = true;
                    continue;
                }
                try {
                    type = DEPENDENCY_TYPE.valueOf(s);
                    if (type == DEPENDENCY_TYPE.OPTIONAL_ATOMIC_MULTI_FILES_WITH_RESTART) {
                    }
                    break block45;
                }
                catch (IllegalArgumentException e) {
                    if (s.startsWith("OPTIONAL_")) {
                        if (!logMINOR) continue;
                        Logger.minor(this, "Ignoring non-essential dependency type \"" + s + "\" for \"" + baseName + "\"");
                        continue;
                    }
                    Logger.error(this, "dependencies.properties broken? unrecognised type for \"" + baseName + "\"");
                    this.broken = true;
                }
                continue;
            }
            s = props.getProperty(baseName + ".os");
            if (s != null && !MainJarDependenciesChecker.matchesCurrentOS(s)) {
                Logger.normal(this, "Ignoring " + baseName + " as not relevant to this operating system");
                continue;
            }
            s = props.getProperty(baseName + ".arch");
            if (s != null && !MainJarDependenciesChecker.matchesCurrentArch(s)) {
                Logger.normal(this, "Ignoring " + baseName + " as not relevant to this architecture");
                continue;
            }
            String version = props.getProperty(baseName + ".version");
            if (version == null) {
                Logger.error(this, "dependencies.properties broken? missing version");
                this.broken = true;
                continue;
            }
            File filename = null;
            s = props.getProperty(baseName + ".filename");
            if (s != null) {
                filename = new File(s);
            }
            if (filename == null) {
                Logger.error(this, "dependencies.properties broken? missing filename");
                this.broken = true;
                continue;
            }
            if (filename.getParentFile() != null) {
                filename.getParentFile().mkdirs();
            }
            FreenetURI maxCHK = null;
            s = props.getProperty(baseName + ".key");
            if (s == null) {
                Logger.error(this, "dependencies.properties broken? missing " + baseName + ".key");
            } else {
                try {
                    maxCHK = new FreenetURI(s);
                }
                catch (MalformedURLException e) {
                    Logger.error(this, "Unable to parse CHK for " + baseName + ": \"" + s + "\": " + e, (Throwable)e);
                    maxCHK = null;
                }
            }
            Pattern p = null;
            if (type == DEPENDENCY_TYPE.CLASSPATH) {
                String regex = props.getProperty(baseName + ".filename-regex");
                if (regex == null && type == DEPENDENCY_TYPE.CLASSPATH) {
                    Logger.error(this, "No " + baseName + ".filename-regex in dependencies.properties - we will not be able to clean up old versions of files, and may have to download the latest version unnecessarily");
                }
                try {
                    if (regex != null) {
                        p = Pattern.compile(regex);
                    }
                }
                catch (PatternSyntaxException e) {
                    Logger.error(this, "Bogus Pattern \"" + regex + "\" in dependencies.properties");
                    p = null;
                }
            }
            if ((expectedHash = MainJarDependenciesChecker.parseExpectedHash(props.getProperty(baseName + ".sha256"), baseName)) == null) {
                System.err.println("Unable to update to build " + build + ": dependencies.properties broken: No hash for " + baseName);
                this.broken = true;
                continue;
            }
            s = props.getProperty(baseName + ".size");
            long size = -1L;
            if (s != null) {
                try {
                    size = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    size = -1L;
                }
            }
            if (size < 0L) {
                System.err.println("Unable to update to build " + build + ": dependencies.properties broken: Broken length for " + baseName + " : \"" + s + "\"");
                this.broken = true;
                continue;
            }
            int order = 0;
            File currentFile = null;
            if (type == DEPENDENCY_TYPE.CLASSPATH || type == DEPENDENCY_TYPE.OPTIONAL_CLASSPATH_NO_UPDATE) {
                s = props.getProperty(baseName + ".order");
                if (s != null) {
                    try {
                        order = Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Unable to update to build " + build + ": dependencies.properties broken: Broken order for " + baseName + " : \"" + s + "\"");
                        this.broken = true;
                        continue;
                    }
                }
                currentFile = MainJarDependenciesChecker.getDependencyInUse(p);
            }
            boolean executable = false;
            s = props.getProperty(baseName + ".executable");
            if (s != null) {
                executable = Boolean.parseBoolean(s);
            }
            if (type == DEPENDENCY_TYPE.OPTIONAL_CLASSPATH_NO_UPDATE && filename.exists()) {
                if (filename.canRead() && filename.length() > 0L) {
                    System.out.println("Assuming non-updated dependency file is current: " + filename);
                    this.dependencies.add(new Dependency(currentFile, filename, p, order));
                    continue;
                }
                System.out.println("Non-updated dependency is empty?: " + filename + " - will try to fetch it");
                filename.delete();
            }
            if (MainJarDependenciesChecker.validFile(filename, expectedHash, size, executable)) {
                System.out.println("Found file required by the new Freenet version: " + filename);
                if (type != DEPENDENCY_TYPE.CLASSPATH) continue;
                this.dependencies.add(new Dependency(currentFile, filename, p, order));
                continue;
            }
            if (currentFile != null && MainJarDependenciesChecker.validFile(currentFile, expectedHash, size, executable)) {
                System.out.println("Existing version of " + currentFile + " is OK for update.");
                if (type != DEPENDENCY_TYPE.CLASSPATH) continue;
                this.dependencies.add(new Dependency(currentFile, currentFile, p, order));
                continue;
            }
            if (type == DEPENDENCY_TYPE.CLASSPATH) {
                if (p == null) {
                    if (maxCHK != null) {
                        try {
                            this.fetchDependency(maxCHK, new Dependency(currentFile, filename, p, order), expectedHash, size, true, executable);
                        }
                        catch (FetchException fe) {
                            this.broken = true;
                            Logger.error(this, "Failed to start fetch: " + fe, (Throwable)fe);
                            System.err.println("Failed to start fetch of essential component for next release: " + fe);
                        }
                        continue;
                    }
                    System.err.println("Unable to fetch " + baseName + " because no URI and no regex to match old versions.");
                    this.broken = true;
                    continue;
                }
                for (File f : list) {
                    String name = f.getName();
                    if (!p.matcher(name.toLowerCase()).matches() || !MainJarDependenciesChecker.validFile(f, expectedHash, size, executable)) continue;
                    System.out.println("Found " + name + " - meets requirement for " + baseName + " for next update.");
                    this.dependencies.add(new Dependency(currentFile, f, p, order));
                    continue block14;
                }
            }
            if (maxCHK == null) {
                System.err.println("Cannot fetch " + baseName + " for update because no CHK and no old file");
                this.broken = true;
                continue;
            }
            try {
                this.fetchDependency(maxCHK, new Dependency(currentFile, filename, p, order), expectedHash, size, type != DEPENDENCY_TYPE.OPTIONAL_PRELOAD, executable);
            }
            catch (FetchException e) {
                this.broken = true;
                Logger.error(this, "Failed to start fetch: " + e, (Throwable)e);
                System.err.println("Failed to start fetch of essential component for next release: " + e);
            }
        }
        if (this.ready()) {
            return new MainJarDependencies(new TreeSet<Dependency>((SortedSet<Dependency>)this.dependencies), build);
        }
        return null;
    }

    private static boolean matchesCurrentOS(String s) {
        String[] osList;
        FileUtil.OperatingSystem myOS = FileUtil.detectedOS;
        for (String os : osList = s.split(",")) {
            os = os.trim();
            if (myOS.toString().equalsIgnoreCase(os)) {
                return true;
            }
            if (os.equalsIgnoreCase("ALL_WINDOWS") && myOS.isWindows) {
                return true;
            }
            if (os.equalsIgnoreCase("ALL_UNIX") && myOS.isUnix) {
                return true;
            }
            if (!os.equalsIgnoreCase("ALL_MAC") || !myOS.isMac) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesCurrentArch(String s) {
        String[] archList;
        FileUtil.CPUArchitecture myCPU = FileUtil.detectedArch;
        for (String arch : archList = s.split(",")) {
            arch = arch.trim();
            if (!myCPU.toString().equalsIgnoreCase(arch)) continue;
            return true;
        }
        return false;
    }

    public boolean cleanup(Properties props, final Deployer deployer, int build) {
        HashSet<String> processed = new HashSet<String>();
        final ArrayList toDelete = new ArrayList();
        File[] listMain = new File(".").listFiles(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                if (!arg0.isFile()) {
                    return false;
                }
                String name = arg0.getName().toLowerCase();
                if (name.endsWith(".updater.tmp") || name.endsWith(".updater.fblob.tmp")) {
                    toDelete.add(arg0);
                    return false;
                }
                if (!name.endsWith(".jar")) {
                    return false;
                }
                return !name.equals("freenet.jar") && !name.equals("freenet.jar.new") && !name.equals("freenet-stable-latest.jar") && !name.equals("freenet-stable-latest.jar.new");
            }
        });
        for (File f : toDelete) {
            System.out.println("Deleting old temp file \"" + f + "\"");
            f.delete();
        }
        for (String propName : props.stringPropertyNames()) {
            String currentFileVersion;
            byte[] expectedHash;
            FreenetURI key;
            DEPENDENCY_TYPE type;
            String baseName;
            if (!propName.contains(".") || !processed.add(baseName = propName.split("\\.")[0])) continue;
            String s = props.getProperty(baseName + ".type");
            if (s == null) {
                Logger.error(MainJarDependencies.class, "dependencies.properties broken? missing type for \"" + baseName + "\"");
                continue;
            }
            try {
                type = DEPENDENCY_TYPE.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                if (s.startsWith("OPTIONAL_")) {
                    if (!logMINOR) continue;
                    Logger.minor(MainJarDependencies.class, "Ignoring non-essential dependency type \"" + s + "\" for \"" + baseName + "\"");
                    continue;
                }
                Logger.error(MainJarDependencies.class, "dependencies.properties broken? unrecognised type for \"" + baseName + "\"");
                continue;
            }
            s = props.getProperty(baseName + ".os");
            if (s != null && !MainJarDependenciesChecker.matchesCurrentOS(s)) {
                Logger.normal(MainJarDependenciesChecker.class, "Ignoring " + baseName + " as not relevant to this operating system");
                continue;
            }
            s = props.getProperty(baseName + ".arch");
            if (s != null && !MainJarDependenciesChecker.matchesCurrentArch(s)) {
                Logger.normal(this, "Ignoring " + baseName + " as not relevant to this architecture");
                continue;
            }
            String mustBeOnPathNotAScript = props.getProperty(baseName + ".mustBeOnPathNotAScript");
            if (mustBeOnPathNotAScript != null && !this.isOnPathNotAScript(mustBeOnPathNotAScript)) {
                Logger.normal(this, "Ignoring " + baseName + " because needs \"" + mustBeOnPathNotAScript + "\" on the path and not a script");
                System.out.println("Ignoring " + baseName + " because needs \"" + mustBeOnPathNotAScript + "\" on the path and not a script");
                continue;
            }
            if (type == DEPENDENCY_TYPE.OPTIONAL_ATOMIC_MULTI_FILES_WITH_RESTART) {
                this.parseAtomicMultiFilesWithRestart(props, baseName);
                continue;
            }
            String version = props.getProperty(baseName + ".version");
            if (version == null) {
                Logger.error(MainJarDependencies.class, "dependencies.properties broken? missing version");
                return false;
            }
            File filename = null;
            s = props.getProperty(baseName + ".filename");
            if (s != null) {
                filename = new File(s);
            }
            if (filename == null) {
                Logger.error(MainJarDependencies.class, "dependencies.properties broken? missing filename");
                return false;
            }
            s = props.getProperty(baseName + ".key");
            if (s == null) {
                Logger.error(MainJarDependencies.class, "dependencies.properties broken? missing " + baseName + ".key");
                return false;
            }
            try {
                key = new FreenetURI(s);
            }
            catch (MalformedURLException e) {
                Logger.error(MainJarDependencies.class, "Unable to parse CHK for " + baseName + ": \"" + s + "\": " + e, (Throwable)e);
                return false;
            }
            Pattern p = null;
            if (type == DEPENDENCY_TYPE.CLASSPATH) {
                String regex = props.getProperty(baseName + ".filename-regex");
                if (regex == null) {
                    Logger.error(MainJarDependencies.class, "No " + baseName + ".filename-regex in dependencies.properties");
                    return false;
                }
                try {
                    p = Pattern.compile(regex);
                }
                catch (PatternSyntaxException e) {
                    Logger.error(MainJarDependencies.class, "Bogus Pattern \"" + regex + "\" in dependencies.properties");
                    return false;
                }
            }
            if ((expectedHash = MainJarDependenciesChecker.parseExpectedHash(props.getProperty(baseName + ".sha256"), baseName)) == null) {
                System.err.println("Unable to update to build " + build + ": dependencies.properties broken: No hash for " + baseName);
                return false;
            }
            s = props.getProperty(baseName + ".size");
            long size = -1L;
            if (s != null) {
                try {
                    size = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    size = -1L;
                }
            }
            if (size < 0L) {
                System.err.println("Unable to update to build " + build + ": dependencies.properties broken: Broken length for " + baseName + " : \"" + s + "\"");
                return false;
            }
            s = props.getProperty(baseName + ".order");
            if (s != null) {
                try {
                    Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    System.err.println("Unable to update to build " + build + ": dependencies.properties broken: Broken order for " + baseName + " : \"" + s + "\"");
                    continue;
                }
            }
            File currentFile = null;
            if (type == DEPENDENCY_TYPE.CLASSPATH) {
                currentFile = MainJarDependenciesChecker.getDependencyInUse(p);
            }
            if (type == DEPENDENCY_TYPE.OPTIONAL_CLASSPATH_NO_UPDATE && filename.exists()) {
                if (filename.canRead() && filename.length() > 0L) {
                    Logger.normal(MainJarDependenciesChecker.class, "Assuming non-updated dependency file is current: " + filename);
                    continue;
                }
                System.out.println("Non-updated dependency is empty?: " + filename + " - will try to fetch it");
                filename.delete();
            }
            if (type != DEPENDENCY_TYPE.CLASSPATH && type != DEPENDENCY_TYPE.OPTIONAL_PRELOAD && type != DEPENDENCY_TYPE.OPTIONAL_CLASSPATH_NO_UPDATE) continue;
            boolean executable = false;
            s = props.getProperty(baseName + ".executable");
            if (s != null) {
                executable = Boolean.parseBoolean(s);
            }
            if (type == DEPENDENCY_TYPE.OPTIONAL_PRELOAD && filename.exists()) {
                currentFile = filename;
            }
            if (currentFile != null && currentFile.exists() && MainJarDependenciesChecker.validFile(currentFile, expectedHash, size, executable)) {
                if (!type.optional) {
                    System.out.println("Will serve " + currentFile + " for UOM");
                    deployer.addDependency(expectedHash, currentFile);
                }
            } else if (currentFile != null && !type.optional) {
                System.out.println("Component " + baseName + " is using a non-standard file, we cannot serve the file " + filename + " via UOM to other nodes. Hence they may not be able to download the update from us.");
            } else {
                final File file = filename;
                try {
                    System.out.println("Preloading " + filename + (type.optional ? "" : " for the next update..."));
                    deployer.fetch(key, filename, size, expectedHash, new JarFetcherCallback(){

                        @Override
                        public void onSuccess() {
                            System.out.println("Preloaded " + file + " which will be needed when we upgrade.");
                            if (!type.optional) {
                                System.out.println("Will serve " + file + " for UOM");
                                deployer.addDependency(expectedHash, file);
                            }
                        }

                        @Override
                        public void onFailure(FetchException e) {
                            Logger.error(this, "Failed to preload " + file + " from " + key + " : " + e, (Throwable)e);
                        }
                    }, type.optional ? 0 : build, false, executable);
                }
                catch (FetchException e) {
                    Logger.error(MainJarDependencies.class, "Failed to preload " + file + " from " + key + " : " + e, (Throwable)e);
                }
            }
            if (currentFile == null || (currentFileVersion = MainJarDependenciesChecker.getDependencyVersion(currentFile)) == null) continue;
            for (File f : listMain) {
                String name = f.getName().toLowerCase();
                if (!p.matcher(name).matches() || name.equalsIgnoreCase(currentFile.getName()) || MainJarDependenciesChecker.inClasspath(name)) continue;
                String fileVersion = MainJarDependenciesChecker.getDependencyVersion(f);
                if (fileVersion == null) {
                    f.delete();
                    System.out.println("Deleting old dependency file (no version): " + f);
                    continue;
                }
                if (Fields.compareVersion(fileVersion, version) > 0) continue;
                f.delete();
                System.out.println("Deleting old dependency file (outdated): " + f);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOnPathNotAScript(String toFind) {
        String[] split;
        String path = System.getenv("PATH");
        if (path == null) {
            return false;
        }
        for (String s : split = path.split(File.pathSeparator)) {
            boolean bl;
            File f = new File(s);
            if (!f.exists() || !f.isDirectory() || !(f = new File(f, toFind)).exists() || !f.canExecute()) continue;
            if (!f.canRead()) {
                Logger.error(this, "On path and can execute but not read, so can't check whether it is a script?!: " + f);
                return false;
            }
            if (f.length() < (long)SCRIPT_HEAD.length) {
                Logger.error(this, "Found " + toFind + " on path but less than " + SCRIPT_HEAD + " bytes long, so can't check whether it is a script - will the shell try the next match? We can't tell whether it is a script or not ...");
                return false;
            }
            FileInputStream fis = new FileInputStream(f);
            byte[] buf = new byte[SCRIPT_HEAD.length];
            DataInputStream dis = new DataInputStream(fis);
            try {
                dis.read(buf);
                bl = !Arrays.equals(buf, SCRIPT_HEAD);
            }
            catch (IOException e) {
                boolean bl2;
                try {
                    Logger.error(this, "Unable to read " + f + " to check whether it is a script: " + e + " - disk corruption problems???", (Throwable)e);
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    try {
                        Closer.close(fis);
                        Closer.close(dis);
                        throw throwable;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                Closer.close(fis);
                Closer.close(dis);
                return bl2;
            }
            Closer.close(fis);
            Closer.close(dis);
            return bl;
        }
        Logger.normal(this, "Could not find " + toFind + " on the path");
        return false;
    }

    private boolean parseAtomicMultiFilesWithRestart(Properties props, String name) {
        AtomicDeployer atomicDeployer = this.createRestartingAtomicDeployer(name);
        if (atomicDeployer == null) {
            return false;
        }
        boolean nothingToDo = true;
        for (String propName : props.stringPropertyNames()) {
            AtomicDependency dependency;
            File f;
            byte[] expectedHash;
            MUST_EXIST mustExist;
            FreenetURI key;
            String[] split = propName.split("\\.");
            if (split.length != 4 || !split[0].equals(name) || !split[1].equals("files") || !split[3].equals("filename")) continue;
            String fileBase = name + ".files." + split[2];
            File filename = null;
            String s = props.getProperty(fileBase + ".filename");
            if (s == null) break;
            filename = new File(s);
            s = props.getProperty(fileBase + ".key");
            if (s == null) {
                Logger.error(MainJarDependencies.class, "dependencies.properties broken? missing " + fileBase + ".key in atomic multi-files list");
                atomicDeployer.cleanup();
                return false;
            }
            try {
                key = new FreenetURI(s);
            }
            catch (MalformedURLException e) {
                Logger.error(MainJarDependencies.class, "Unable to parse CHK for multi-files replace for " + fileBase + ": \"" + s + "\": " + e, (Throwable)e);
                atomicDeployer.cleanup();
                return false;
            }
            s = props.getProperty(fileBase + ".size");
            long size = -1L;
            if (s != null) {
                try {
                    size = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    Logger.error(MainJarDependencies.class, "Unable to parse size for multi-files replace for " + fileBase + ": \"" + s + "\": " + e, (Throwable)e);
                    atomicDeployer.cleanup();
                    return false;
                }
            }
            if ((s = props.getProperty(fileBase + ".mustExist")) == null) {
                mustExist = MUST_EXIST.FALSE;
            } else {
                try {
                    mustExist = MUST_EXIST.valueOf(s.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    Logger.error(MainJarDependencies.class, "Unable to past mustExist \"" + s + "\" for " + fileBase);
                    atomicDeployer.cleanup();
                    return false;
                }
            }
            boolean mustBeOnClassPath = false;
            s = props.getProperty(fileBase + ".mustBeOnClassPath");
            if (s != null) {
                mustBeOnClassPath = Boolean.parseBoolean(s);
            }
            if ((expectedHash = MainJarDependenciesChecker.parseExpectedHash(props.getProperty(fileBase + ".sha256"), fileBase)) == null) {
                System.err.println("dependencies.properties multi-file replace broken: No hash for " + fileBase);
                atomicDeployer.cleanup();
                return false;
            }
            boolean executable = false;
            s = props.getProperty(fileBase + ".executable");
            if (s != null) {
                executable = Boolean.parseBoolean(s);
            }
            if (!filename.exists()) {
                if (mustExist != MUST_EXIST.FALSE) {
                    System.out.println("Not running multi-file replace " + name + " : File does not exist: " + filename);
                    atomicDeployer.cleanup();
                    return false;
                }
                nothingToDo = false;
                System.out.println("Multi-file replace: Must create " + filename + " for " + name);
            } else if (!MainJarDependenciesChecker.validFile(filename, expectedHash, size, executable)) {
                if (mustExist == MUST_EXIST.EXACT) {
                    System.out.println("Not running multi-file replace: Not compatible with old version of prerequisite " + filename);
                    atomicDeployer.cleanup();
                    return false;
                }
                System.out.println("Multi-file replace: Must update " + filename + " for " + name);
                nothingToDo = false;
            } else if (mustExist == MUST_EXIST.EXACT) continue;
            if (mustBeOnClassPath && (f = MainJarDependenciesChecker.getDependencyInUse(Pattern.compile(Pattern.quote(filename.getName())))) == null) {
                System.err.println("Not running multi-file replace: File must be on classpath: " + filename + " for " + name);
                atomicDeployer.cleanup();
                return false;
            }
            try {
                dependency = new AtomicDependency(filename, key, size, expectedHash, executable);
            }
            catch (IOException e) {
                System.err.println("Unable to start multi-file update for " + name + " : " + e);
                atomicDeployer.cleanup();
                return false;
            }
            atomicDeployer.add(dependency);
        }
        if (nothingToDo) {
            System.out.println("Multi-file replace: Nothing to do for " + name + ".");
            atomicDeployer.cleanup();
            return false;
        }
        atomicDeployer.start();
        return true;
    }

    private AtomicDeployer createRestartingAtomicDeployer(String name) {
        if (FileUtil.detectedOS.isUnix || FileUtil.detectedOS.isMac) {
            return new UnixRestartingAtomicDeployer(name);
        }
        if (FileUtil.detectedOS.isWindows) {
            System.out.println("Multi-file update for " + name + " not supported on Windows at present, see bug #5883");
            return null;
        }
        System.out.println("Multi-file update for " + name + " not supported on unknown non-unix non-windows OS " + (Object)((Object)FileUtil.detectedOS));
        return null;
    }

    /*
     * Exception decompiling
     */
    public static String getDependencyVersion(File currentFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File getDependencyInUse(Pattern p) {
        String[] split;
        if (p == null) {
            return null;
        }
        String classpath = System.getProperty("java.class.path");
        for (String s : split = classpath.split(File.pathSeparator)) {
            File f = new File(s);
            if (!p.matcher(f.getName().toLowerCase()).matches()) continue;
            return f;
        }
        return null;
    }

    private static boolean inClasspath(String name) {
        String[] split;
        String classpath = System.getProperty("java.class.path");
        for (String s : split = classpath.split(File.pathSeparator)) {
            File f = new File(s);
            if (!name.equalsIgnoreCase(f.getName())) continue;
            return true;
        }
        return false;
    }

    private static byte[] parseExpectedHash(String sha256, String baseName) {
        if (sha256 == null) {
            Logger.error(MainJarDependencies.class, "No SHA256 for " + baseName + " in dependencies.properties");
            return null;
        }
        try {
            return HexUtil.hexToBytes(sha256);
        }
        catch (NumberFormatException e) {
            Logger.error(MainJarDependencies.class, "Bogus expected hash: \"" + sha256 + "\" : " + e, (Throwable)e);
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            Logger.error(MainJarDependencies.class, "Bogus expected hash: \"" + sha256 + "\" : " + e, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean validFile(File filename, byte[] expectedHash, long size, boolean executable) {
        boolean bl;
        FileInputStream fis;
        block11: {
            if (filename == null) {
                return false;
            }
            if (!filename.exists()) {
                return false;
            }
            if (filename.length() != size) {
                System.out.println("File exists while updating but length is wrong (" + filename.length() + " should be " + size + ") for " + filename);
                return false;
            }
            fis = null;
            fis = new FileInputStream(filename);
            MessageDigest md = SHA256.getMessageDigest();
            SHA256.hash(fis, md);
            byte[] hash = md.digest();
            fis.close();
            fis = null;
            if (!Arrays.equals(hash, expectedHash)) break block11;
            if (executable && !filename.canExecute()) {
                filename.setExecutable(true);
            }
            boolean bl2 = true;
            Closer.close(fis);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (FileNotFoundException e) {
            Logger.error(MainJarDependencies.class, "File not found: " + filename);
            boolean bl3 = false;
            Closer.close(fis);
            return bl3;
        }
        catch (IOException e2) {
            System.err.println("Unable to read " + filename + " for updater");
            boolean bl4 = false;
            {
                catch (Throwable throwable) {
                    Closer.close(fis);
                    throw throwable;
                }
            }
            Closer.close(fis);
            return bl4;
        }
        Closer.close(fis);
        return bl;
    }

    private synchronized void clear(int build) {
        this.dependencies.clear();
        this.broken = false;
        this.build = build;
        final Downloader[] toCancel = this.downloaders.toArray(new Downloader[this.downloaders.size()]);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (Downloader d : toCancel) {
                    d.cancel();
                }
            }
        });
        this.downloaders.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy() {
        TreeSet<Dependency> f;
        MainJarDependenciesChecker mainJarDependenciesChecker = this;
        synchronized (mainJarDependenciesChecker) {
            f = new TreeSet<Dependency>((SortedSet<Dependency>)this.dependencies);
        }
        if (logMINOR) {
            Logger.minor(this, "Deploying build " + this.build + " with " + f.size() + " dependencies");
        }
        this.deployer.deploy(new MainJarDependencies(f, this.build));
    }

    private synchronized void fetchDependency(FreenetURI chk, Dependency dep, byte[] expectedHash, long expectedSize, boolean essential, boolean executable) throws FetchException {
        Downloader d = new Downloader(dep, chk, expectedHash, expectedSize, essential, executable, this.build);
        if (essential) {
            this.downloaders.add(d);
        }
    }

    private synchronized boolean ready() {
        if (this.broken) {
            return false;
        }
        return this.downloaders.isEmpty();
    }

    public synchronized boolean isBroken() {
        return this.broken;
    }

    static {
        Logger.registerClass(MainJarDependenciesChecker.class);
        SCRIPT_HEAD = "#!".getBytes(StandardCharsets.UTF_8);
    }

    private class UnixRestartingAtomicDeployer
    extends RestartingAtomicDeployer {
        static final String RESTART_SCRIPT_NAME = "tempRestartFreenet.sh";

        public UnixRestartingAtomicDeployer(String name) {
            super(name);
        }

        @Override
        protected boolean deployMultiFileUpdate() {
            File restartScript;
            if (!WrapperManager.isControlledByNativeWrapper()) {
                return false;
            }
            try {
                restartScript = this.createRestartScript();
            }
            catch (IOException e) {
                System.err.println("Unable to deploy multi-file update for " + this.name + " because cannot write script to restart the wrapper: " + e);
                Logger.error(this, "Unable to deploy multi-file update for " + this.name + " because cannot write script to restart the wrapper: " + e, (Throwable)e);
                return false;
            }
            if (restartScript == null) {
                return false;
            }
            File shell = this.findShell();
            if (shell == null) {
                return false;
            }
            if (this.innerDeployMultiFileUpdate()) {
                try {
                    if (Runtime.getRuntime().exec(new String[]{shell.toString(), restartScript.toString()}) == null) {
                        System.err.println("Unable to start restarter script " + restartScript + " with shell " + shell + " -> cannot deploy multi-file update for " + this.name);
                        return false;
                    }
                }
                catch (IOException e) {
                    System.err.println("Unable to start restarter script " + restartScript + " with shell " + shell + " -> cannot deploy multi-file update for " + this.name + " : " + e);
                    Logger.error(this, "Unable to start restarter script " + restartScript + " with shell " + shell + " -> cannot deploy multi-file update for " + this.name + " : " + e, (Throwable)e);
                    return false;
                }
                System.out.println("Shutting down Freenet for hard restart after deploying multi-file update for " + this.name + ". The script " + restartScript + " should start it back up.");
                WrapperManager.stop((int)0);
                return true;
            }
            return false;
        }

        private File findShell() {
            File f = new File("/bin/sh");
            if (f.exists() && f.canExecute()) {
                return f;
            }
            f = new File("/bin/bash");
            if (f.exists() && f.canExecute()) {
                return f;
            }
            System.err.println("Unable to find system shell");
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File createRestartScript() throws IOException {
            File file;
            File runsh = new File("run.sh");
            String runshNoNice = "run.nonice-for-update.sh";
            if (!runsh.exists() || !runsh.canExecute()) {
                System.err.println("Cannot find run.sh so cannot deploy multi-file update for " + this.name);
                return null;
            }
            if (!this.createRunShNoNice(runsh, new File(runshNoNice))) {
                return null;
            }
            if (!new File("/dev/null").exists()) {
                System.err.println("Cannot deploy multi-file update for " + this.name + " without /dev/null");
                return null;
            }
            File restartFreenet = new File(RESTART_SCRIPT_NAME);
            restartFreenet.delete();
            FileBucket fb = new FileBucket(restartFreenet, false, true, false, false);
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(fb.getOutputStream());
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, StandardCharsets.ISO_8859_1);
                osw.write("#!/bin/sh\n");
                osw.write("while kill -0 " + WrapperManager.getWrapperPID() + " > /dev/null 2>&1; do sleep 1; done\n");
                osw.write("./" + runshNoNice + " start > /dev/null 2>&1\n");
                osw.write("rm tempRestartFreenet.sh\n");
                osw.write("rm " + runshNoNice + "\n");
                osw.close();
                osw = null;
                os = null;
                file = restartFreenet;
            }
            catch (Throwable throwable) {
                Closer.close(os);
                throw throwable;
            }
            Closer.close(os);
            return file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean createRunShNoNice(File input, File output) throws IOException {
            boolean bl;
            boolean failed;
            FileOutputStream os;
            FileInputStream is;
            block11: {
                String line;
                is = null;
                os = null;
                failed = false;
                is = new FileInputStream(input);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(is), StandardCharsets.UTF_8));
                os = new FileOutputStream(output);
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), StandardCharsets.UTF_8));
                boolean writtenPrio = false;
                while ((line = br.readLine()) != null) {
                    if (!writtenPrio && line.startsWith("PRIORITY=")) {
                        writtenPrio = true;
                        line = "PRIORITY=";
                    }
                    w.write(line + "\n");
                }
                br.close();
                is = new FileInputStream(input);
                ((Writer)w).close();
                os = null;
                if (output.setExecutable(true) || output.canExecute()) break block11;
                failed = true;
                boolean bl2 = false;
                Closer.close(is);
                Closer.close(os);
                if (failed) {
                    output.delete();
                }
                return bl2;
            }
            try {
                bl = true;
            }
            catch (IOException e) {
                boolean bl3;
                try {
                    failed = true;
                    bl3 = false;
                }
                catch (Throwable throwable) {
                    Closer.close(is);
                    Closer.close(os);
                    if (failed) {
                        output.delete();
                    }
                    throw throwable;
                }
                Closer.close(is);
                Closer.close(os);
                if (failed) {
                    output.delete();
                }
                return bl3;
            }
            Closer.close(is);
            Closer.close(os);
            if (failed) {
                output.delete();
            }
            return bl;
        }
    }

    private abstract class RestartingAtomicDeployer
    extends AtomicDeployer {
        public RestartingAtomicDeployer(String name) {
            super(name);
        }
    }

    class AtomicDeployer {
        private final Set<AtomicDependency> dependencies = new HashSet<AtomicDependency>();
        private final Set<AtomicDependency> dependenciesWaiting = new HashSet<AtomicDependency>();
        private boolean failed;
        private boolean started;
        final String name;

        public AtomicDeployer(String name) {
            this.name = name;
        }

        public void cleanup() {
            for (AtomicDependency dep : this.dependencies()) {
                dep.cancel();
                dep.cleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(AtomicDependency dep, FetchException e) {
            AtomicDeployer atomicDeployer = this;
            synchronized (atomicDeployer) {
                this.failed = true;
                this.dependenciesWaiting.remove(dep);
            }
            System.err.println("Unable to deploy multi-file update " + this.name + " because fetch failed for " + dep.filename);
            this.cleanup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(AtomicDependency dep) {
            AtomicDeployer atomicDeployer = this;
            synchronized (atomicDeployer) {
                assert (this.dependencies.contains(dep));
                this.dependenciesWaiting.remove(dep);
                if (!this.dependenciesWaiting.isEmpty()) {
                    return;
                }
                if (this.failed) {
                    return;
                }
            }
            this.readyToDeploy();
        }

        private void readyToDeploy() {
            MainJarDependenciesChecker.this.deployer.multiFileReplaceReadyToDeploy(this);
        }

        public synchronized void add(AtomicDependency dependency) {
            if (this.started) {
                Logger.error(this, "Already started!");
                this.failed = true;
                return;
            }
            this.dependencies.add(dependency);
            this.dependenciesWaiting.add(dependency);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            for (AtomicDependency dep : this.dependencies()) {
                if (dep.start((AtomicDeployer)this)) continue;
                System.err.println("Unable to start fetch for " + this);
                AtomicDependency[] atomicDependencyArray = this;
                synchronized (this) {
                    this.failed = true;
                    AtomicDependency[] deps = this.dependencies();
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    for (AtomicDependency kill : deps) {
                        kill.cancel();
                    }
                    return;
                }
            }
            AtomicDependency[] atomicDependencyArray = this;
            synchronized (this) {
                this.started = true;
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return;
            }
        }

        private synchronized AtomicDependency[] dependencies() {
            return this.dependencies.toArray(new AtomicDependency[this.dependencies.size()]);
        }

        public void deployMultiFileUpdateOffThread() {
            MainJarDependenciesChecker.this.executor.execute(new PrioRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = NodeUpdateManager.deployLock();
                    synchronized (object) {
                        if (AtomicDeployer.this.deployMultiFileUpdate()) {
                            NodeUpdateManager.waitForever();
                        }
                    }
                }

                @Override
                public int getPriority() {
                    return NativeThread.MAX_PRIORITY;
                }
            });
        }

        protected boolean deployMultiFileUpdate() {
            if (!this.innerDeployMultiFileUpdate()) {
                System.err.println("Failed to deploy multi-file update " + this.name);
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean innerDeployMultiFileUpdate() {
            AtomicDependency[] deps;
            AtomicDeployer atomicDeployer = this;
            synchronized (atomicDeployer) {
                if (this.failed || !this.started) {
                    Logger.error(this, "Not deploying: failed=" + this.failed + " started=" + this.started, (Throwable)new Exception("error"));
                    return false;
                }
            }
            for (AtomicDependency dep : deps = this.dependencies()) {
                if (dep.backupOriginal()) continue;
                System.err.println("Unable to backup dependency " + dep.filename + " - aborting multi-file update deployment " + this.name);
                return false;
            }
            boolean failedDeploy = false;
            for (AtomicDependency dep : deps) {
                if (dep.deploy()) continue;
                failedDeploy = true;
                System.err.println("Unable to update file " + dep.filename + " from " + dep.tempFilename + " - aborting multi-file update deployment " + this.name);
                break;
            }
            if (failedDeploy) {
                System.err.println("Deploying multi-file update failed: " + this.name);
                System.err.println("Restoring files from backups");
                for (AtomicDependency dep : deps) {
                    if (dep.revertFromBackup()) continue;
                    System.err.println("Restoring file from backup failed. Freenet may fail to start on next restart! You should move " + dep.backupFilename + " to " + dep.filename);
                }
            }
            return !failedDeploy;
        }
    }

    private class AtomicDependency
    implements JarFetcherCallback {
        private final File tempFilename;
        private final File backupFilename;
        private final File filename;
        private final FreenetURI key;
        private final long size;
        private final byte[] expectedHash;
        private final boolean executable;
        private AtomicDeployer myDeployer;
        private JarFetcher fetcher;
        private boolean nothingToBackup;
        private boolean triedDeploy;
        private boolean succeededFetch;
        private boolean backedUp;

        public AtomicDependency(File filename, FreenetURI key, long size, byte[] expectedHash, boolean executable) throws IOException {
            File[] list;
            this.filename = filename;
            this.key = key;
            this.size = size;
            this.expectedHash = expectedHash;
            this.executable = executable;
            File parent = filename.getAbsoluteFile().getParentFile();
            if (parent == null) {
                parent = new File(".");
            }
            for (File f : list = parent.listFiles()) {
                String name = f.getName();
                if (!name.startsWith(filename.getName()) || !name.endsWith(MainJarDependenciesChecker.UPDATER_BACKUP_SUFFIX)) continue;
                f.delete();
            }
            this.tempFilename = File.createTempFile(filename.getName(), ".tmp", parent);
            this.tempFilename.deleteOnExit();
            this.backupFilename = File.createTempFile(filename.getName(), MainJarDependenciesChecker.UPDATER_BACKUP_SUFFIX, parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean start(AtomicDeployer myDeployer) {
            AtomicDependency atomicDependency = this;
            synchronized (atomicDependency) {
                if (this.myDeployer != null) {
                    return true;
                }
                this.myDeployer = myDeployer;
            }
            System.out.println("Fetching " + this.filename + " from " + this.key);
            try {
                JarFetcher fetcher = MainJarDependenciesChecker.this.deployer.fetch(this.key, this.tempFilename, this.size, this.expectedHash, this, MainJarDependenciesChecker.this.build, false, this.executable);
                AtomicDependency atomicDependency2 = this;
                synchronized (atomicDependency2) {
                    this.fetcher = fetcher;
                }
                return true;
            }
            catch (FetchException e) {
                Logger.error(this, "Unable to start fetch for " + this.filename + " from " + this.key + " size " + this.size + " expected hash " + HexUtil.bytesToHex(this.expectedHash) + " : " + e, (Throwable)e);
                System.err.println("Unable to start fetch for " + this.filename + " for multi-file replace");
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess() {
            AtomicDeployer d;
            AtomicDependency atomicDependency = this;
            synchronized (atomicDependency) {
                this.succeededFetch = true;
                d = this.myDeployer;
            }
            System.out.println("Fetched " + this.filename + " from " + this.key);
            d.onSuccess(this);
        }

        @Override
        public void onFailure(FetchException e) {
            System.out.println("Failed to fetch " + this.filename + " from " + this.key);
            this.getDeployer().onFailure(this, e);
        }

        private synchronized AtomicDeployer getDeployer() {
            return this.myDeployer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            JarFetcher f;
            AtomicDependency atomicDependency = this;
            synchronized (atomicDependency) {
                f = this.fetcher;
                this.fetcher = null;
            }
            if (f == null) {
                return;
            }
            f.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean backupOriginal() {
            System.out.println("Backing up " + this.filename + " to " + this.backupFilename);
            if (!this.filename.exists()) {
                AtomicDependency atomicDependency = this;
                synchronized (atomicDependency) {
                    this.nothingToBackup = true;
                    this.backedUp = true;
                }
                return true;
            }
            if (FileUtil.copyFile(this.filename, this.backupFilename)) {
                AtomicDependency atomicDependency = this;
                synchronized (atomicDependency) {
                    this.backedUp = true;
                }
                if (this.executable) {
                    return this.backupFilename.setExecutable(true) || this.backupFilename.canExecute();
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean deploy() {
            System.out.println("Deploying " + this.tempFilename + " to " + this.filename);
            AtomicDependency atomicDependency = this;
            synchronized (atomicDependency) {
                assert (this.succeededFetch);
                assert (this.backedUp);
                this.triedDeploy = true;
            }
            if (!this.filename.exists()) {
                if (this.tempFilename.renameTo(this.filename)) {
                    if (this.executable) {
                        return this.filename.setExecutable(true) || this.filename.canExecute();
                    }
                    return true;
                }
                return false;
            }
            if (this.tempFilename.renameTo(this.filename)) {
                if (this.executable) {
                    return this.filename.setExecutable(true) || this.filename.canExecute();
                }
                return true;
            }
            this.filename.delete();
            if (this.tempFilename.renameTo(this.filename)) {
                if (this.executable) {
                    return this.filename.setExecutable(true) || this.filename.canExecute();
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean revertFromBackup() {
            boolean nothingToBackup;
            AtomicDependency atomicDependency = this;
            synchronized (atomicDependency) {
                assert (this.succeededFetch);
                assert (this.backedUp);
                if (!this.triedDeploy) {
                    return true;
                }
            }
            System.out.println("Reverting from backup " + this.backupFilename + " to " + this.filename);
            AtomicDependency atomicDependency2 = this;
            synchronized (atomicDependency2) {
                nothingToBackup = this.nothingToBackup;
            }
            if (nothingToBackup) {
                if (!this.filename.delete() && this.filename.exists()) {
                    System.err.println("Unable to delete file while reverting multi-file deploy: " + this.filename);
                    this.tempFilename.delete();
                    return true;
                }
                this.tempFilename.delete();
                return true;
            }
            if (!this.backupFilename.renameTo(this.filename)) {
                return false;
            }
            if (this.executable) {
                if (this.filename.setExecutable(true) || this.filename.canExecute()) {
                    this.tempFilename.delete();
                    return true;
                }
                return false;
            }
            this.tempFilename.delete();
            return true;
        }

        void cleanup() {
            this.tempFilename.delete();
            this.backupFilename.delete();
        }
    }

    static enum MUST_EXIST {
        FALSE,
        TRUE,
        EXACT;

    }

    static enum DEPENDENCY_TYPE {
        CLASSPATH,
        OPTIONAL_CLASSPATH_NO_UPDATE,
        OPTIONAL_PRELOAD,
        OPTIONAL_ATOMIC_MULTI_FILES_WITH_RESTART;

        final boolean optional = this.name().startsWith("OPTIONAL_");
    }

    private class Downloader
    implements JarFetcherCallback {
        final JarFetcher fetcher;
        final Dependency dep;
        final boolean essential;
        final int forBuild;

        Downloader(Dependency dep, FreenetURI uri, byte[] expectedHash, long expectedSize, boolean essential, boolean executable, int forBuild) throws FetchException {
            this.fetcher = MainJarDependenciesChecker.this.deployer.fetch(uri, dep.newFilename, expectedSize, expectedHash, this, MainJarDependenciesChecker.this.build, essential, executable);
            this.dep = dep;
            this.essential = essential;
            this.forBuild = forBuild;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess() {
            if (!this.essential) {
                System.out.println("Downloaded " + this.dep.newFilename + " - may be used by next update");
                return;
            }
            System.out.println("Downloaded " + this.dep.newFilename + " needed for update " + this.forBuild + "...");
            boolean toDeploy = false;
            boolean forCurrentVersion = false;
            MainJarDependenciesChecker mainJarDependenciesChecker = MainJarDependenciesChecker.this;
            synchronized (mainJarDependenciesChecker) {
                MainJarDependenciesChecker.this.downloaders.remove(this);
                if (this.forBuild == MainJarDependenciesChecker.this.build) {
                    MainJarDependenciesChecker.this.dependencies.add(this.dep);
                    toDeploy = MainJarDependenciesChecker.this.ready();
                } else {
                    forCurrentVersion = this.forBuild == Version.buildNumber();
                }
            }
            if (toDeploy) {
                MainJarDependenciesChecker.this.deploy();
            } else if (forCurrentVersion) {
                MainJarDependenciesChecker.this.deployer.reannounce();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(FetchException e) {
            if (!this.essential) {
                Logger.error(this, "Failed to pre-load " + this.dep.newFilename + " : " + e, (Throwable)e);
            } else {
                System.err.println("Failed to fetch " + this.dep.newFilename + " needed for next update (" + e.getShortMessage() + "). Will try again if we find a new freenet.jar.");
                MainJarDependenciesChecker mainJarDependenciesChecker = MainJarDependenciesChecker.this;
                synchronized (mainJarDependenciesChecker) {
                    MainJarDependenciesChecker.this.downloaders.remove(this);
                    if (this.forBuild != MainJarDependenciesChecker.this.build) {
                        return;
                    }
                    MainJarDependenciesChecker.this.broken = true;
                }
            }
        }

        public void cancel() {
            this.fetcher.cancel();
        }
    }

    final class Dependency
    implements Comparable<Dependency> {
        private File oldFilename;
        private File newFilename;
        private Pattern regex;
        private int order;

        private Dependency(File oldFilename, File newFilename, Pattern regex, int order) {
            this.oldFilename = oldFilename;
            this.newFilename = newFilename;
            this.regex = regex;
            this.order = order;
        }

        public File oldFilename() {
            return this.oldFilename;
        }

        public File newFilename() {
            return this.newFilename;
        }

        public Pattern regex() {
            return this.regex;
        }

        @Override
        public int compareTo(Dependency arg0) {
            if (this == arg0) {
                return 0;
            }
            if (this.order > arg0.order) {
                return 1;
            }
            if (this.order < arg0.order) {
                return -1;
            }
            int ret = this.newFilename.getName().compareTo(arg0.newFilename.getName());
            if (ret != 0) {
                return ret;
            }
            return this.newFilename.compareTo(arg0.newFilename);
        }

        public int order() {
            return this.order;
        }
    }

    static interface JarFetcherCallback {
        public void onSuccess();

        public void onFailure(FetchException var1);
    }

    static interface JarFetcher {
        public void cancel();
    }

    static interface Deployer {
        public void deploy(MainJarDependencies var1);

        public JarFetcher fetch(FreenetURI var1, File var2, long var3, byte[] var5, JarFetcherCallback var6, int var7, boolean var8, boolean var9) throws FetchException;

        public void addDependency(byte[] var1, File var2);

        public void reannounce();

        public void multiFileReplaceReadyToDeploy(AtomicDeployer var1);
    }

    class MainJarDependencies {
        final int build;
        final Set<Dependency> dependencies;
        final boolean mustRewriteWrapperConf;

        MainJarDependencies(TreeSet<Dependency> dependencies, int build) {
            this.dependencies = Collections.unmodifiableSortedSet(dependencies);
            this.build = build;
            boolean mustRewrite = false;
            for (Dependency d : dependencies) {
                if (d.oldFilename == null || !d.oldFilename.equals(d.newFilename)) {
                    mustRewrite = true;
                    break;
                }
                if (File.pathSeparatorChar != ':' || d.oldFilename == null || !d.oldFilename.getName().equalsIgnoreCase("freenet-ext.jar.new")) continue;
                mustRewrite = true;
                break;
            }
            this.mustRewriteWrapperConf = mustRewrite;
        }
    }
}

