/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.FeedMessage;
import freenet.clients.http.wizardsteps.DATASTORE_SIZE;
import freenet.config.ConfigException;
import freenet.config.PersistentConfig;
import freenet.l10n.NodeL10n;
import freenet.node.NodeClientCore;
import freenet.node.Version;
import freenet.node.useralerts.UserAlert;
import freenet.support.HTMLNode;

public class DatastoreTooSmallAlert
implements UserAlert {
    private final NodeClientCore core;

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("DataStoreTooSmallAlert." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("DataStoreTooSmallAlert." + key, pattern, value);
    }

    public DatastoreTooSmallAlert(NodeClientCore core) {
        this.core = core;
    }

    @Override
    public boolean userCanDismiss() {
        return true;
    }

    @Override
    public String getTitle() {
        return DatastoreTooSmallAlert.l10n("title");
    }

    @Override
    public String getShortText() {
        return this.getTitle();
    }

    @Override
    public String getText() {
        PersistentConfig config = this.core.getNode().getConfig();
        long storeSize = config.get("node").getLong("storeSize");
        long clientCacheSize = config.get("node").getLong("clientCacheSize");
        long slashdotCacheSize = config.get("node").getLong("slashdotCacheSize");
        long totalSize = storeSize + clientCacheSize + slashdotCacheSize;
        totalSize = (long)((double)totalSize * 1.036);
        long currentSize = (totalSize + 0x20000000L) / 0x40000000L;
        long availableSize = DATASTORE_SIZE.maxDatastoreSize(this.core.getNode()) / 0x40000000L;
        long minSize = availableSize / 5L;
        if (minSize > 50L) {
            minSize = 50L;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(DatastoreTooSmallAlert.l10n("description", "size", Long.toString(minSize)));
        sb.append(" ");
        sb.append(DatastoreTooSmallAlert.l10n("current", "size", currentSize + " GiB"));
        sb.append(DatastoreTooSmallAlert.l10n("available", "size", availableSize + " GiB"));
        return sb.toString();
    }

    @Override
    public HTMLNode getHTMLText() {
        PersistentConfig config = this.core.getNode().getConfig();
        long storeSize = config.get("node").getLong("storeSize");
        long clientCacheSize = config.get("node").getLong("clientCacheSize");
        long slashdotCacheSize = config.get("node").getLong("slashdotCacheSize");
        long totalSize = storeSize + clientCacheSize + slashdotCacheSize;
        totalSize = (long)((double)totalSize * 1.036);
        long currentSize = (totalSize + 0x20000000L) / 0x40000000L;
        long availableSize = DATASTORE_SIZE.maxDatastoreSize(this.core.getNode()) / 0x40000000L;
        long minSize = availableSize / 5L;
        if (minSize > 50L) {
            minSize = 50L;
        }
        HTMLNode alertNode = new HTMLNode("div");
        alertNode.addChild("p", DatastoreTooSmallAlert.l10n("description", "size", Long.toString(minSize)));
        HTMLNode sizesNode = new HTMLNode("p");
        sizesNode.addChild("#", DatastoreTooSmallAlert.l10n("current", "size", currentSize + " GiB"));
        sizesNode.addChild("br");
        sizesNode.addChild("#", DatastoreTooSmallAlert.l10n("available", "size", availableSize + " GiB"));
        alertNode.addChild(sizesNode);
        alertNode.addChild("a", "href", "/wizard/?step=DATASTORE_SIZE&singlestep=true").addChild("#", DatastoreTooSmallAlert.l10n("submit"));
        return alertNode;
    }

    @Override
    public short getPriorityClass() {
        return 2;
    }

    @Override
    public boolean isValid() {
        PersistentConfig config = this.core.getNode().getConfig();
        long storeSize = config.get("node").getLong("storeSize");
        long clientCacheSize = config.get("node").getLong("clientCacheSize");
        long slashdotCacheSize = config.get("node").getLong("slashdotCacheSize");
        long totalSize = storeSize + clientCacheSize + slashdotCacheSize;
        totalSize = (long)((double)totalSize * 1.036);
        long currentSize = (totalSize + 0x20000000L) / 0x40000000L;
        long availableSize = DATASTORE_SIZE.maxDatastoreSize(this.core.getNode()) / 0x40000000L;
        long minSize = availableSize / 10L;
        if (minSize > 25L) {
            minSize = 25L;
        }
        int currentVersion = Version.buildNumber();
        int dismissedVersion = this.core.getNode().getConfig().get("node").getInt("datastoreTooSmallDismissed");
        return currentSize < minSize && currentVersion != dismissedVersion;
    }

    @Override
    public void isValid(boolean validity) {
    }

    @Override
    public String dismissButtonText() {
        return NodeL10n.getBase().getString("UserAlert.hide");
    }

    @Override
    public boolean shouldUnregisterOnDismiss() {
        return true;
    }

    @Override
    public void onDismiss() {
        String currentVersion = Integer.toString(Version.buildNumber());
        try {
            this.core.getNode().getConfig().get("node").set("datastoreTooSmallDismissed", currentVersion);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Override
    public String anchor() {
        return "datastore-too-small";
    }

    @Override
    public boolean isEventNotification() {
        return false;
    }

    @Override
    public long getUpdatedTime() {
        return System.currentTimeMillis();
    }

    @Override
    public FCPMessage getFCPMessage() {
        return new FeedMessage(this.getTitle(), this.getShortText(), this.getText(), this.getPriorityClass(), this.getUpdatedTime());
    }
}

