/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.l10n.NodeL10n;
import freenet.node.NodeClientCore;
import freenet.node.useralerts.UserAlert;
import freenet.node.useralerts.UserEvent;
import freenet.support.Base64;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import java.io.IOException;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UserAlertManager
implements Comparator<UserAlert> {
    private final Set<UserAlert> alerts;
    private final NodeClientCore core;
    private final Set<FCPConnectionHandler> subscribers;
    private final Map<UserEvent.Type, UserEvent> events;
    private final Set<UserEvent.Type> unregisteredEventTypes;
    private long lastUpdated;
    static final HTMLNode ALERTS_LINK = new HTMLNode("a", "href", "/alerts/").setReadOnly();

    public UserAlertManager(NodeClientCore core) {
        this.core = core;
        this.alerts = new HashSet<UserAlert>();
        this.subscribers = new CopyOnWriteArraySet<FCPConnectionHandler>();
        this.events = new HashMap<UserEvent.Type, UserEvent>();
        this.unregisteredEventTypes = new HashSet<UserEvent.Type>();
        this.lastUpdated = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(UserAlert alert) {
        if (alert instanceof UserEvent) {
            this.register((UserEvent)alert);
        }
        Set<UserAlert> set = this.alerts;
        synchronized (set) {
            if (!this.alerts.contains(alert)) {
                this.alerts.add(alert);
                this.lastUpdated = System.currentTimeMillis();
                this.notifySubscribers(alert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(UserEvent event) {
        Object object = this.unregisteredEventTypes;
        synchronized (object) {
            if (this.unregisteredEventTypes.contains((Object)event.getEventType())) {
                return;
            }
        }
        object = this.events;
        synchronized (object) {
            UserEvent lastEvent = this.events.get((Object)event.getEventType());
            Set<UserAlert> set = this.alerts;
            synchronized (set) {
                if (lastEvent != null) {
                    this.alerts.remove(lastEvent);
                }
                this.alerts.add(event);
            }
            this.events.put(event.getEventType(), event);
            this.lastUpdated = System.currentTimeMillis();
            this.notifySubscribers(event);
        }
    }

    private void notifySubscribers(final UserAlert alert) {
        this.core.getClientContext().getMainExecutor().execute(new Runnable(){

            @Override
            public void run() {
                for (FCPConnectionHandler subscriber : UserAlertManager.this.subscribers) {
                    subscriber.send(alert.getFCPMessage());
                }
            }
        }, "UserAlertManager callback executor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(UserAlert alert) {
        if (alert == null) {
            return;
        }
        if (alert instanceof UserEvent) {
            this.unregister(((UserEvent)alert).getEventType());
        }
        Set<UserAlert> set = this.alerts;
        synchronized (set) {
            this.alerts.remove(alert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(UserEvent.Type eventType) {
        Object object;
        if (eventType.unregisterIndefinitely()) {
            object = this.unregisteredEventTypes;
            synchronized (object) {
                this.unregisteredEventTypes.add(eventType);
            }
        }
        object = this.events;
        synchronized (object) {
            UserEvent latestEvent = this.events.remove((Object)eventType);
            if (latestEvent != null) {
                Set<UserAlert> set = this.alerts;
                synchronized (set) {
                    this.alerts.remove(latestEvent);
                }
            }
        }
    }

    public void dismissAlert(int alertHashCode) {
        UserAlert[] userAlerts;
        for (UserAlert userAlert : userAlerts = this.getAlerts()) {
            if (userAlert.hashCode() != alertHashCode || !userAlert.userCanDismiss()) continue;
            if (userAlert.shouldUnregisterOnDismiss()) {
                userAlert.onDismiss();
                this.unregister(userAlert);
                continue;
            }
            userAlert.isValid(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAlert[] getAlerts() {
        UserAlert[] a;
        Set<UserAlert> set = this.alerts;
        synchronized (set) {
            a = this.alerts.toArray(new UserAlert[this.alerts.size()]);
        }
        Arrays.sort(a, this);
        return a;
    }

    @Override
    public int compare(UserAlert a0, UserAlert a1) {
        short prio1;
        if (a0 == a1) {
            return 0;
        }
        short prio0 = a0.getPriorityClass();
        if (prio0 - (prio1 = a1.getPriorityClass()) == 0) {
            int hash1;
            int classHash1;
            boolean isEvent0 = a0.isEventNotification();
            boolean isEvent1 = a1.isEventNotification();
            if (isEvent0 && !isEvent1) {
                return 1;
            }
            if (!isEvent0 && isEvent1) {
                return -1;
            }
            int classHash0 = a0.getClass().hashCode();
            if (classHash0 > (classHash1 = a1.getClass().hashCode())) {
                return 1;
            }
            if (classHash0 < classHash1) {
                return -1;
            }
            if (a0.getUpdatedTime() < a1.getUpdatedTime()) {
                return 1;
            }
            if (a0.getUpdatedTime() > a1.getUpdatedTime()) {
                return -1;
            }
            int hash0 = a0.hashCode();
            if (hash0 > (hash1 = a1.hashCode())) {
                return 1;
            }
            if (hash1 > hash0) {
                return -1;
            }
            return 0;
        }
        if (prio0 > prio1) {
            return 1;
        }
        return -1;
    }

    public HTMLNode createAlerts() {
        return this.createAlerts(true);
    }

    public HTMLNode createAlerts(boolean showOnlyErrors) {
        HTMLNode alertsNode = new HTMLNode("div");
        int totalNumber = 0;
        for (UserAlert alert : this.getAlerts()) {
            if (showOnlyErrors && alert.getPriorityClass() > 1 || !alert.isValid()) continue;
            ++totalNumber;
            alertsNode.addChild("a", "name", alert.anchor());
            if (showOnlyErrors) {
                try {
                    alertsNode.addChild(this.renderAlert(alert));
                }
                catch (Throwable t) {
                    Logger.error(this, "FAILED TO RENDER ALERT: " + alert + " : " + t, t);
                }
                continue;
            }
            alertsNode.addChild(this.renderAlert(alert));
        }
        if (totalNumber == 0) {
            return new HTMLNode("#", "");
        }
        return alertsNode;
    }

    public HTMLNode renderAlert(UserAlert userAlert) {
        HTMLNode userAlertNode = null;
        short level = userAlert.getPriorityClass();
        userAlertNode = new HTMLNode("div", "class", "infobox infobox-" + this.getAlertLevelName(level));
        userAlertNode.addChild("div", "class", "infobox-header", userAlert.getTitle());
        HTMLNode alertContentNode = userAlertNode.addChild("div", "class", "infobox-content");
        alertContentNode.addChild(userAlert.getHTMLText());
        alertContentNode.addChild(this.renderDismissButton(userAlert, null));
        return userAlertNode;
    }

    public HTMLNode renderDismissButton(UserAlert userAlert, String redirectToAfterDisable) {
        HTMLNode result = new HTMLNode("div");
        if (userAlert.userCanDismiss()) {
            HTMLNode dismissFormNode = result.addChild("form", new String[]{"action", "method"}, new String[]{"/alerts/", "post"}).addChild("div");
            dismissFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "disable", String.valueOf(userAlert.hashCode())});
            dismissFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.core.getFormPassword()});
            dismissFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "dismiss-user-alert", userAlert.dismissButtonText()});
            if (redirectToAfterDisable != null) {
                dismissFormNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "redirectToAfterDisable", redirectToAfterDisable});
            }
        }
        return result;
    }

    private String getAlertLevelName(short level) {
        if (level <= 0) {
            return "error";
        }
        if (level <= 1) {
            return "alert";
        }
        if (level <= 2) {
            return "warning";
        }
        if (level <= 3) {
            return "minor";
        }
        Logger.error(this, "Unknown alert level: " + level, (Throwable)new Exception("debug"));
        return "error";
    }

    public HTMLNode createSummary() {
        return this.createAlerts(true);
    }

    public HTMLNode createSummary(boolean oneLine) {
        String classes;
        short highestLevel = 99;
        int numberOfCriticalError = 0;
        int numberOfError = 0;
        int numberOfWarning = 0;
        int numberOfMinor = 0;
        int totalNumber = 0;
        for (UserAlert alert : this.getAlerts()) {
            if (!alert.isValid()) continue;
            short level = alert.getPriorityClass();
            if (level < highestLevel) {
                highestLevel = level;
            }
            if (level <= 0) {
                ++numberOfCriticalError;
            } else if (level <= 1) {
                ++numberOfError;
            } else if (level <= 2) {
                ++numberOfWarning;
            } else if (level <= 3) {
                ++numberOfMinor;
            }
            ++totalNumber;
        }
        if (numberOfMinor == 0 && numberOfWarning == 0 && oneLine) {
            return null;
        }
        if (totalNumber == 0) {
            return new HTMLNode("#", "");
        }
        boolean separatorNeeded = false;
        String separator = oneLine ? ", " : " | ";
        int messageTypes = 0;
        StringBuilder alertSummaryString = new StringBuilder(1024);
        if (numberOfCriticalError != 0 && !oneLine) {
            alertSummaryString.append(this.l10n("criticalErrorCountLabel")).append(' ').append(numberOfCriticalError);
            separatorNeeded = true;
            ++messageTypes;
        }
        if (numberOfError != 0 && !oneLine) {
            if (separatorNeeded) {
                alertSummaryString.append(separator);
            }
            alertSummaryString.append(this.l10n("errorCountLabel")).append(' ').append(numberOfError);
            separatorNeeded = true;
            ++messageTypes;
        }
        if (numberOfWarning != 0) {
            if (separatorNeeded) {
                alertSummaryString.append(separator);
            }
            if (oneLine) {
                alertSummaryString.append(numberOfWarning).append(' ').append(this.l10n("warningCountLabel").replace(":", ""));
            } else {
                alertSummaryString.append(this.l10n("warningCountLabel")).append(' ').append(numberOfWarning);
            }
            separatorNeeded = true;
            ++messageTypes;
        }
        if (numberOfMinor != 0) {
            if (separatorNeeded) {
                alertSummaryString.append(separator);
            }
            if (oneLine) {
                alertSummaryString.append(numberOfMinor).append(' ').append(this.l10n("minorCountLabel").replace(":", ""));
            } else {
                alertSummaryString.append(this.l10n("minorCountLabel")).append(' ').append(numberOfMinor);
            }
            separatorNeeded = true;
            ++messageTypes;
        }
        if (messageTypes != 1 && !oneLine) {
            if (separatorNeeded) {
                alertSummaryString.append(separator);
            }
            alertSummaryString.append(this.l10n("totalLabel")).append(' ').append(totalNumber);
        }
        HTMLNode summaryBox = null;
        String string = classes = oneLine ? "alerts-line contains-" : "infobox infobox-";
        if (highestLevel <= 0 && !oneLine) {
            summaryBox = new HTMLNode("div", "class", classes + "error");
        } else if (highestLevel <= 1 && !oneLine) {
            summaryBox = new HTMLNode("div", "class", classes + "alert");
        } else if (highestLevel <= 2) {
            summaryBox = new HTMLNode("div", "class", classes + "warning");
        } else if (highestLevel <= 3) {
            summaryBox = new HTMLNode("div", "class", classes + "information");
        }
        summaryBox.addChild("div", "class", "infobox-header", this.l10n("alertsTitle"));
        HTMLNode summaryContent = summaryBox.addChild("div", "class", "infobox-content");
        if (!oneLine) {
            summaryContent.addChild("#", alertSummaryString.toString() + separator + " ");
            NodeL10n.getBase().addL10nSubstitution(summaryContent, "UserAlertManager.alertsOnAlertsPage", new String[]{"link"}, new HTMLNode[]{ALERTS_LINK});
        } else {
            summaryContent.addChild("a", "href", "/alerts/", NodeL10n.getBase().getString("StatusBar.alerts") + " " + alertSummaryString.toString());
        }
        summaryBox.addAttribute("id", "messages-summary-box");
        return summaryBox;
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("UserAlertManager." + key);
    }

    public void dumpEvents(HashSet<String> toDump) {
        for (UserAlert alert : this.getAlerts()) {
            if (!alert.isEventNotification() || !toDump.contains(alert.anchor())) continue;
            this.unregister(alert);
            alert.onDismiss();
        }
    }

    public void watch(final FCPConnectionHandler subscriber) {
        this.subscribers.add(subscriber);
        this.core.getClientContext().getMainExecutor().execute(new Runnable(){

            @Override
            public void run() {
                for (UserAlert alert : UserAlertManager.this.getAlerts()) {
                    if (!alert.isValid()) continue;
                    subscriber.send(alert.getFCPMessage());
                }
            }
        }, "UserAlertManager callback executor");
        this.subscribers.add(subscriber);
    }

    public void unwatch(FCPConnectionHandler subscriber) {
        this.subscribers.remove(subscriber);
    }

    private String formatTime(long time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String date = format.format((Object)new Date(time));
        return date.substring(0, 22) + ":" + date.substring(22);
    }

    public String getAtom(String startURI) {
        String messagesURI = startURI + "/alerts/";
        String feedURI = startURI + "/feed/";
        XmlBuilder xmlBuilder = new XmlBuilder();
        xmlBuilder.addNamespaceElement("http://www.w3.org/2005/Atom", "feed", feed -> {
            feed.addElement("title", this.l10n("feedTitle"));
            feed.addElement("link", link -> {
                link.setAttribute("rel", "self");
                link.setAttribute("href", feedURI);
            });
            feed.addElement("link", link -> link.setAttribute("href", startURI));
            feed.addElement("id", "urn:node:" + Base64.encode(this.core.getNode().getDarknetPubKeyHash()));
            feed.addElement("updated", this.formatTime(this.lastUpdated));
            feed.addElement("logo", "/favicon.ico");
            Arrays.stream(this.getAlerts()).filter(UserAlert::isValid).forEach(alert -> feed.addElement("entry", entry -> {
                entry.addElement("id", "urn:feed:" + alert.anchor());
                entry.addElement("link", link -> link.setAttribute("href", messagesURI + "#" + alert.anchor()));
                entry.addElement("updated", this.formatTime(alert.getUpdatedTime()));
                entry.addElement("title", alert.getTitle());
                entry.addElement("summary", alert.getShortText());
                entry.addElement("content", alert.getText(), content -> content.setAttribute("type", "text"));
            }));
        });
        return xmlBuilder.generate();
    }

    private static class XmlBuilder
    implements ElementBuilder {
        private final Document document;
        private final Element element;
        private static DocumentBuilder documentBuilder;
        private static final TransformerFactory transformerFactory;
        private static final Transformer transformer;

        @Override
        public void addElement(String name, Consumer<ElementBuilder> elementBuilder) {
            Element element = this.document.createElement(name);
            elementBuilder.accept(new XmlBuilder(this.document, element));
            (this.element == null ? this.document : this.element).appendChild(element);
        }

        @Override
        public void addElement(String name, String content, Consumer<ElementBuilder> elementBuilder) {
            Element element = this.document.createElement(name);
            element.setTextContent(content);
            elementBuilder.accept(new XmlBuilder(this.document, element));
            (this.element == null ? this.document : this.element).appendChild(element);
        }

        @Override
        public void addNamespaceElement(String namespace, String name, Consumer<ElementBuilder> elementBuilder) {
            Element element = this.document.createElementNS(namespace, name);
            elementBuilder.accept(new XmlBuilder(this.document, element));
            (this.element == null ? this.document : this.element).appendChild(element);
        }

        @Override
        public void setAttribute(String name, String value) {
            if (this.element != null) {
                this.element.setAttribute(name, value);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String generate() {
            DOMSource source = new DOMSource(this.document);
            try (StringWriter stringWriter = new StringWriter();){
                StreamResult result = new StreamResult(stringWriter);
                transformer.transform(source, result);
                String string = stringWriter.toString();
                return string;
            }
            catch (IOException | TransformerException e) {
                throw new RuntimeException(e);
            }
        }

        public XmlBuilder() {
            this(documentBuilder.newDocument(), null);
        }

        private XmlBuilder(Document document, Element element) {
            this.document = document;
            this.element = element;
        }

        static {
            transformerFactory = TransformerFactory.newInstance();
            try {
                documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            }
            catch (ParserConfigurationException | TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface ElementBuilder {
        public void addElement(String var1, Consumer<ElementBuilder> var2);

        public void addElement(String var1, String var2, Consumer<ElementBuilder> var3);

        public void addNamespaceElement(String var1, String var2, Consumer<ElementBuilder> var3);

        public void setAttribute(String var1, String var2);

        default public void addElement(String name, String content) {
            this.addElement(name, content, elementBuilder -> {});
        }
    }
}

