/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream
implements DataInput {
    protected ByteBuffer buf;

    public ByteBufferInputStream(byte[] array) {
        this(array, 0, array.length);
    }

    public ByteBufferInputStream(byte[] array, int offset, int length) {
        this(ByteBuffer.wrap(array, offset, length));
    }

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int length = this.read(buf, 0, 1);
        if (length > 0) {
            return Byte.toUnsignedInt(buf[0]);
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = Math.min(len, this.buf.remaining());
        this.buf.get(b, off, read);
        return read;
    }

    public int remaining() {
        return this.buf.remaining();
    }

    @Override
    public boolean readBoolean() throws IOException {
        try {
            return this.buf.get() != 0;
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.buf.get();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public char readChar() throws IOException {
        try {
            return this.buf.getChar();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            return this.buf.getDouble();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public float readFloat() throws IOException {
        try {
            return this.buf.getFloat();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        try {
            this.buf.get(b);
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        try {
            this.buf.get(b, off, len);
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.buf.getInt();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.buf.getLong();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public short readShort() throws IOException {
        try {
            return this.buf.getShort();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        try {
            return this.buf.get() & 0xFF;
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public int readUnsignedShort() throws IOException {
        try {
            return this.buf.getShort() & 0xFFFF;
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int skip = Math.min(n, this.buf.remaining());
        this.buf.position(this.buf.position() + skip);
        return skip;
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return new DataInputStream(this).readLine();
    }

    public ByteBufferInputStream slice(int size) throws IOException {
        try {
            if (this.buf.remaining() < size) {
                throw new EOFException();
            }
            ByteBuffer bf2 = this.buf.slice();
            bf2.limit(size);
            this.skip(size);
            return new ByteBufferInputStream(bf2);
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }
}

