/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.math;

import freenet.support.math.RunningAverage;
import java.util.Arrays;

public final class SimpleRunningAverage
implements RunningAverage,
Cloneable {
    private final double[] refs;
    private final double initValue;
    private double sum;
    private long totalReports;

    public SimpleRunningAverage(int length, double initValue) {
        this.refs = new double[length];
        this.initValue = initValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleRunningAverage(SimpleRunningAverage other) {
        double[] dArray = other.refs;
        synchronized (other.refs) {
            this.refs = (double[])other.refs.clone();
            this.initValue = other.initValue;
            this.sum = other.sum;
            this.totalReports = other.totalReports;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double currentValue() {
        double[] dArray = this.refs;
        synchronized (this.refs) {
            if (this.totalReports == 0L) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.initValue;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.sum / (double)Math.min((long)this.refs.length, this.totalReports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double valueIfReported(double r) {
        double[] dArray = this.refs;
        synchronized (this.refs) {
            int index = (int)(this.totalReports % (long)this.refs.length);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return (this.sum - this.refs[index] + r) / (double)Math.min((long)this.refs.length, this.totalReports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(double d) {
        double[] dArray = this.refs;
        synchronized (this.refs) {
            int index = (int)(this.totalReports % (long)this.refs.length);
            this.sum = this.sum - this.refs[index] + d;
            this.refs[index] = d;
            ++this.totalReports;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        double[] dArray = this.refs;
        synchronized (this.refs) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return super.toString() + ", total=" + this.sum + ", average=" + this.currentValue();
        }
    }

    @Override
    public void report(long d) {
        this.report((double)d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countReports() {
        double[] dArray = this.refs;
        synchronized (this.refs) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.totalReports;
        }
    }

    @Override
    public SimpleRunningAverage clone() {
        return new SimpleRunningAverage(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        double[] dArray = this.refs;
        synchronized (this.refs) {
            this.sum = 0.0;
            this.totalReports = 0L;
            Arrays.fill(this.refs, 0.0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

