/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.keys.ClientSSK;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableUSK;
import freenet.keys.USK;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.Arrays;
import java.util.Locale;

public class USKDateHint {
    private static final TemporalField WEEK_OF_YEAR = WeekFields.of(Locale.US).weekOfWeekBasedYear();
    private static final TemporalField WEEK_YEAR = WeekFields.of(Locale.US).weekBasedYear();
    private final LocalDate dateUtc;

    USKDateHint(LocalDate dateUtc) {
        this.dateUtc = dateUtc;
    }

    public static USKDateHint now() {
        return new USKDateHint(LocalDate.now(ZoneOffset.UTC));
    }

    public String get(Type type) {
        if (type == Type.WEEK) {
            return this.dateUtc.get(WEEK_YEAR) + "-WEEK-" + this.dateUtc.get(WEEK_OF_YEAR);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.dateUtc.getYear());
        if (type == Type.YEAR) {
            return sb.toString();
        }
        sb.append('-');
        sb.append(this.dateUtc.getMonthValue() - 1);
        if (type == Type.MONTH) {
            return sb.toString();
        }
        sb.append('-');
        sb.append(this.dateUtc.getDayOfMonth());
        return sb.toString();
    }

    public String getData(long edition) {
        return String.format("HINT\n%d\n%s\n", edition, this.get(Type.DAY));
    }

    public FreenetURI[] getInsertURIs(InsertableUSK key) {
        return (FreenetURI[])Arrays.stream(Type.values()).map(type -> key.getInsertableSSK(this.getDocName(key, (Type)((Object)type))).getInsertURI()).toArray(FreenetURI[]::new);
    }

    public ClientSSK[] getRequestURIs(USK key) {
        return (ClientSSK[])Arrays.stream(Type.values()).map(type -> key.getSSK(this.getDocName(key, (Type)((Object)type)))).toArray(ClientSSK[]::new);
    }

    private String getDocName(USK key, Type type) {
        return String.format("%s-DATEHINT-%s", key.siteName, this.get(type));
    }

    public static enum Type {
        YEAR,
        MONTH,
        DAY,
        WEEK;


        public boolean alwaysMorePreciseThan(Type type) {
            if (this.equals((Object)type)) {
                return false;
            }
            if (this.equals((Object)DAY)) {
                return true;
            }
            if (this.equals((Object)MONTH)) {
                return type.equals((Object)YEAR);
            }
            if (this.equals((Object)WEEK)) {
                return type.equals((Object)YEAR);
            }
            return false;
        }
    }
}

