/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.PluginRemovedMessage;
import freenet.clients.fcp.ProtocolErrorMessage;
import freenet.node.Node;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.support.SimpleFieldSet;

public class RemovePlugin
extends FCPMessage {
    static final String NAME = "RemovePlugin";
    private final String identifier;
    private final String plugname;
    private final int maxWaitTime;
    private final boolean purge;

    public RemovePlugin(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "Must contain an Identifier field", null, false);
        }
        this.plugname = fs.get("PluginName");
        if (this.plugname == null) {
            throw new MessageInvalidException(5, "Must contain a PluginName field", this.identifier, false);
        }
        this.maxWaitTime = fs.getInt("MaxWaitTime", 0);
        this.purge = fs.getBoolean("Purge", false);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(final FCPConnectionHandler handler, final Node node) throws MessageInvalidException {
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "LoadPlugin requires full access", this.identifier, false);
        }
        node.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                PluginInfoWrapper pi = node.getPluginManager().getPluginInfo(RemovePlugin.this.plugname);
                if (pi == null) {
                    handler.send(new ProtocolErrorMessage(32, false, "Plugin '" + RemovePlugin.this.plugname + "' does not exist or is not a FCP plugin", RemovePlugin.this.identifier, false));
                } else {
                    pi.stopPlugin(node.getPluginManager(), RemovePlugin.this.maxWaitTime, false);
                    if (RemovePlugin.this.purge) {
                        node.getPluginManager().removeCachedCopy(pi.getFilename());
                    }
                    handler.send(new PluginRemovedMessage(RemovePlugin.this.plugname, RemovePlugin.this.identifier));
                }
            }
        }, "Remove Plugin");
    }
}

