/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.filter.HTMLFilter;
import freenet.client.filter.LinkFilterExceptionProvider;
import freenet.clients.http.FProxyFetchInProgress;
import freenet.clients.http.FProxyToadlet;
import freenet.clients.http.IntervalPusherManager;
import freenet.clients.http.LinkEnabledCallback;
import freenet.clients.http.LinkFilterExceptedToadlet;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PermanentRedirectException;
import freenet.clients.http.StartupToadlet;
import freenet.clients.http.StaticToadlet;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContainer;
import freenet.clients.http.ToadletContextImpl;
import freenet.clients.http.bookmark.BookmarkManager;
import freenet.clients.http.updateableelements.PushDataManager;
import freenet.config.EnumerableOptionCallback;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.SubConfig;
import freenet.crypt.SSL;
import freenet.io.AllowedHosts;
import freenet.io.NetworkInterface;
import freenet.io.SSLNetworkInterface;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.PrioRunnable;
import freenet.node.SecurityLevelListener;
import freenet.node.SecurityLevels;
import freenet.node.useralerts.UserAlertManager;
import freenet.pluginmanager.FredPluginL10n;
import freenet.support.Executor;
import freenet.support.HTMLNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.api.BooleanCallback;
import freenet.support.api.BucketFactory;
import freenet.support.api.IntCallback;
import freenet.support.api.LongCallback;
import freenet.support.api.StringCallback;
import freenet.support.io.ArrayBucketFactory;
import freenet.support.io.NativeThread;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.tanukisoftware.wrapper.WrapperManager;

public final class SimpleToadletServer
implements ToadletContainer,
Runnable,
LinkFilterExceptionProvider {
    private final LinkedList<ToadletElement> toadlets;
    private final int port;
    private String bindTo;
    private String allowedHosts;
    private NetworkInterface networkInterface;
    private boolean ssl = false;
    public static final int DEFAULT_FPROXY_PORT = 8888;
    private final AllowedHosts allowedFullAccess;
    private boolean publicGatewayMode;
    private final boolean wasPublicGatewayMode;
    private PageMaker.THEME cssTheme;
    private File cssOverride;
    private boolean sendAllThemes;
    private boolean advancedModeEnabled;
    private final PageMaker pageMaker;
    private boolean fetchKeyBoxAboveBookmarks;
    private Thread myThread;
    private final Executor executor;
    private final Random random;
    private BucketFactory bf;
    private volatile NodeClientCore core;
    private boolean doRobots;
    private boolean enablePersistentConnections;
    private boolean enableInlinePrefetch;
    private boolean enableActivelinks;
    private boolean enableExtendedMethodHandling;
    private boolean enableCachingForChkAndSskKeys;
    static volatile boolean isPanicButtonToBeShown;
    static volatile boolean noConfirmPanic;
    public BookmarkManager bookmarkManager;
    private volatile boolean fProxyJavascriptEnabled;
    private volatile boolean fProxyWebPushingEnabled;
    private volatile boolean fproxyHasCompletedWizard;
    private volatile boolean disableProgressPage;
    private int maxFproxyConnections;
    private int fproxyConnections;
    private boolean finishedStartup;
    @Deprecated
    public PushDataManager pushDataManager;
    public IntervalPusherManager intervalPushManager;
    private static volatile boolean logMINOR;
    private boolean haveCalledFProxy = false;
    public StartupToadlet startupToadlet;
    private FProxyFetchInProgress.REFILTER_POLICY refilterPolicy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFproxy() {
        NodeClientCore core = this.core;
        Node node = core.getNode();
        SimpleToadletServer simpleToadletServer = this;
        synchronized (simpleToadletServer) {
            if (this.haveCalledFProxy) {
                return;
            }
            this.haveCalledFProxy = true;
        }
        this.pushDataManager = new PushDataManager(this.getTicker());
        this.intervalPushManager = new IntervalPusherManager(this.getTicker(), this.pushDataManager);
        this.bookmarkManager = new BookmarkManager(core, this.publicGatewayMode());
        try {
            FProxyToadlet.maybeCreateFProxyEtc(core, node, node.getConfig(), this);
        }
        catch (IOException e) {
            Logger.error(this, "Could not start fproxy: " + e, (Throwable)e);
            System.err.println("Could not start fproxy:");
            e.printStackTrace();
        }
    }

    public void setCore(NodeClientCore core) {
        this.core = core;
    }

    public SimpleToadletServer(SubConfig fproxyConfig, BucketFactory bucketFactory, Executor executor, Node node) throws IOException, InvalidConfigValueException {
        this.executor = executor;
        this.core = null;
        this.random = new Random();
        int configItemOrder = 0;
        fproxyConfig.register("enabled", true, configItemOrder++, true, true, "SimpleToadletServer.enabled", "SimpleToadletServer.enabledLong", new FProxyEnabledCallback());
        boolean enabled = fproxyConfig.getBoolean("enabled");
        fproxyConfig.register("ssl", false, configItemOrder++, true, true, "SimpleToadletServer.ssl", "SimpleToadletServer.sslLong", new FProxySSLCallback());
        fproxyConfig.register("port", 8888, configItemOrder++, true, true, "SimpleToadletServer.port", "SimpleToadletServer.portLong", (IntCallback)new FProxyPortCallback(), false);
        fproxyConfig.register("bindTo", "127.0.0.1,0:0:0:0:0:0:0:1", configItemOrder++, true, true, "SimpleToadletServer.bindTo", "SimpleToadletServer.bindToLong", new FProxyBindtoCallback());
        fproxyConfig.register("css", PageMaker.THEME.getDefault().code, configItemOrder++, false, false, "SimpleToadletServer.cssName", "SimpleToadletServer.cssNameLong", new FProxyCSSNameCallback());
        fproxyConfig.register("CSSOverride", "", configItemOrder++, true, false, "SimpleToadletServer.cssOverride", "SimpleToadletServer.cssOverrideLong", new FProxyCSSOverrideCallback());
        fproxyConfig.register("sendAllThemes", false, configItemOrder++, true, false, "SimpleToadletServer.sendAllThemes", "SimpleToadletServer.sendAllThemesLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return SimpleToadletServer.this.sendAllThemes;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                SimpleToadletServer.this.sendAllThemes = val;
            }
        });
        this.sendAllThemes = fproxyConfig.getBoolean("sendAllThemes");
        fproxyConfig.register("advancedModeEnabled", false, configItemOrder++, true, false, "SimpleToadletServer.advancedMode", "SimpleToadletServer.advancedModeLong", new FProxyAdvancedModeEnabledCallback(this));
        fproxyConfig.register("enableExtendedMethodHandling", false, configItemOrder++, true, false, "SimpleToadletServer.enableExtendedMethodHandling", "SimpleToadletServer.enableExtendedMethodHandlingLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return SimpleToadletServer.this.enableExtendedMethodHandling;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (this.get().equals(val)) {
                    return;
                }
                SimpleToadletServer.this.enableExtendedMethodHandling = val;
            }
        });
        fproxyConfig.register("javascriptEnabled", true, configItemOrder++, true, false, "SimpleToadletServer.enableJS", "SimpleToadletServer.enableJSLong", new FProxyJavascriptEnabledCallback(this));
        fproxyConfig.register("webPushingEnabled", false, configItemOrder++, true, false, "SimpleToadletServer.enableWP", "SimpleToadletServer.enableWPLong", new FProxyWebPushingEnabledCallback(this));
        fproxyConfig.register("hasCompletedWizard", false, configItemOrder++, true, false, "SimpleToadletServer.hasCompletedWizard", "SimpleToadletServer.hasCompletedWizardLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return SimpleToadletServer.this.fproxyHasCompletedWizard;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (this.get().equals(val)) {
                    return;
                }
                SimpleToadletServer.this.fproxyHasCompletedWizard = val;
            }
        });
        fproxyConfig.register("disableProgressPage", false, configItemOrder++, true, false, "SimpleToadletServer.disableProgressPage", "SimpleToadletServer.disableProgressPageLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return SimpleToadletServer.this.disableProgressPage;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                SimpleToadletServer.this.disableProgressPage = val;
            }
        });
        this.fproxyHasCompletedWizard = fproxyConfig.getBoolean("hasCompletedWizard");
        this.fProxyJavascriptEnabled = fproxyConfig.getBoolean("javascriptEnabled");
        this.fProxyWebPushingEnabled = fproxyConfig.getBoolean("webPushingEnabled");
        this.disableProgressPage = fproxyConfig.getBoolean("disableProgressPage");
        this.enableExtendedMethodHandling = fproxyConfig.getBoolean("enableExtendedMethodHandling");
        fproxyConfig.register("showPanicButton", false, configItemOrder++, true, true, "SimpleToadletServer.panicButton", "SimpleToadletServer.panicButtonLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return isPanicButtonToBeShown;
            }

            @Override
            public void set(Boolean value) {
                if (value == isPanicButtonToBeShown) {
                    return;
                }
                isPanicButtonToBeShown = value;
            }
        });
        fproxyConfig.register("noConfirmPanic", false, configItemOrder++, true, true, "SimpleToadletServer.noConfirmPanic", "SimpleToadletServer.noConfirmPanicLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return noConfirmPanic;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (val == noConfirmPanic) {
                    return;
                }
                noConfirmPanic = val;
            }
        });
        fproxyConfig.register("publicGatewayMode", false, configItemOrder++, true, true, "SimpleToadletServer.publicGatewayMode", "SimpleToadletServer.publicGatewayModeLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return SimpleToadletServer.this.publicGatewayMode;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (SimpleToadletServer.this.publicGatewayMode == val) {
                    return;
                }
                SimpleToadletServer.this.publicGatewayMode = val;
                throw new NodeNeedRestartException(SimpleToadletServer.l10n("publicGatewayModeNeedsRestart"));
            }
        });
        this.wasPublicGatewayMode = this.publicGatewayMode = fproxyConfig.getBoolean("publicGatewayMode");
        fproxyConfig.register("enablePersistentConnections", false, configItemOrder++, true, false, "SimpleToadletServer.enablePersistentConnections", "SimpleToadletServer.enablePersistentConnectionsLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean get() {
                SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
                synchronized (simpleToadletServer) {
                    return SimpleToadletServer.this.enablePersistentConnections;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
                synchronized (simpleToadletServer) {
                    SimpleToadletServer.this.enablePersistentConnections = val;
                }
            }
        });
        this.enablePersistentConnections = fproxyConfig.getBoolean("enablePersistentConnections");
        fproxyConfig.register("enableInlinePrefetch", false, configItemOrder++, true, false, "SimpleToadletServer.enableInlinePrefetch", "SimpleToadletServer.enableInlinePrefetchLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean get() {
                SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
                synchronized (simpleToadletServer) {
                    return SimpleToadletServer.this.enableInlinePrefetch;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
                synchronized (simpleToadletServer) {
                    SimpleToadletServer.this.enableInlinePrefetch = val;
                }
            }
        });
        this.enableInlinePrefetch = fproxyConfig.getBoolean("enableInlinePrefetch");
        fproxyConfig.register("enableActivelinks", false, configItemOrder++, false, false, "SimpleToadletServer.enableActivelinks", "SimpleToadletServer.enableActivelinksLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return SimpleToadletServer.this.enableActivelinks;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                SimpleToadletServer.this.enableActivelinks = val;
            }
        });
        this.enableActivelinks = fproxyConfig.getBoolean("enableActivelinks");
        fproxyConfig.register("passthroughMaxSize", FProxyToadlet.MAX_LENGTH_NO_PROGRESS, configItemOrder++, true, false, "SimpleToadletServer.passthroughMaxSize", "SimpleToadletServer.passthroughMaxSizeLong", (LongCallback)new FProxyPassthruMaxSizeNoProgress(), true);
        FProxyToadlet.MAX_LENGTH_NO_PROGRESS = fproxyConfig.getLong("passthroughMaxSize");
        fproxyConfig.register("passthroughMaxSizeProgress", FProxyToadlet.MAX_LENGTH_WITH_PROGRESS, configItemOrder++, true, false, "SimpleToadletServer.passthroughMaxSizeProgress", "SimpleToadletServer.passthroughMaxSizeProgressLong", (LongCallback)new FProxyPassthruMaxSizeProgress(), true);
        FProxyToadlet.MAX_LENGTH_WITH_PROGRESS = fproxyConfig.getLong("passthroughMaxSizeProgress");
        System.out.println("Set fproxy max length to " + FProxyToadlet.MAX_LENGTH_NO_PROGRESS + " and max length with progress to " + FProxyToadlet.MAX_LENGTH_WITH_PROGRESS + " = " + fproxyConfig.getLong("passthroughMaxSizeProgress"));
        fproxyConfig.register("enableCachingForChkAndSskKeys", false, configItemOrder++, true, true, "SimpleToadletServer.enableCachingForChkAndSskKeys", "SimpleToadletServer.enableCachingForChkAndSskKeysLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return SimpleToadletServer.this.enableCachingForChkAndSskKeys;
            }

            @Override
            public void set(Boolean value) throws InvalidConfigValueException, NodeNeedRestartException {
                SimpleToadletServer.this.enableCachingForChkAndSskKeys = value;
            }
        });
        this.enableCachingForChkAndSskKeys = fproxyConfig.getBoolean("enableCachingForChkAndSskKeys");
        fproxyConfig.register("allowedHosts", "127.0.0.1,0:0:0:0:0:0:0:1", configItemOrder++, true, true, "SimpleToadletServer.allowedHosts", "SimpleToadletServer.allowedHostsLong", new FProxyAllowedHostsCallback());
        fproxyConfig.register("allowedHostsFullAccess", "127.0.0.1,0:0:0:0:0:0:0:1", configItemOrder++, true, true, "SimpleToadletServer.allowedFullAccess", "SimpleToadletServer.allowedFullAccessLong", new StringCallback(){

            @Override
            public String get() {
                return SimpleToadletServer.this.allowedFullAccess.getAllowedHosts();
            }

            @Override
            public void set(String val) throws InvalidConfigValueException {
                try {
                    SimpleToadletServer.this.allowedFullAccess.setAllowedHosts(val);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidConfigValueException(e);
                }
            }
        });
        this.allowedFullAccess = new AllowedHosts(fproxyConfig.getString("allowedHostsFullAccess"));
        fproxyConfig.register("doRobots", false, configItemOrder++, true, false, "SimpleToadletServer.doRobots", "SimpleToadletServer.doRobotsLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return SimpleToadletServer.this.doRobots;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException {
                SimpleToadletServer.this.doRobots = val;
            }
        });
        this.doRobots = fproxyConfig.getBoolean("doRobots");
        fproxyConfig.register("maxFproxyConnections", 100, configItemOrder++, true, false, "SimpleToadletServer.maxFproxyConnections", "SimpleToadletServer.maxFproxyConnectionsLong", new IntCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer get() {
                SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
                synchronized (simpleToadletServer) {
                    return SimpleToadletServer.this.maxFproxyConnections;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(Integer val) {
                SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
                synchronized (simpleToadletServer) {
                    SimpleToadletServer.this.maxFproxyConnections = val;
                    SimpleToadletServer.this.notifyAll();
                }
            }
        }, false);
        this.maxFproxyConnections = fproxyConfig.getInt("maxFproxyConnections");
        fproxyConfig.register("metaRefreshSamePageInterval", 1, configItemOrder++, true, false, "SimpleToadletServer.metaRefreshSamePageInterval", "SimpleToadletServer.metaRefreshSamePageIntervalLong", new IntCallback(){

            @Override
            public Integer get() {
                return HTMLFilter.metaRefreshSamePageMinInterval;
            }

            @Override
            public void set(Integer val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (val < -1) {
                    throw new InvalidConfigValueException("-1 = disabled, 0+ = set a minimum interval");
                }
                HTMLFilter.metaRefreshSamePageMinInterval = val;
            }
        }, false);
        HTMLFilter.metaRefreshSamePageMinInterval = Math.max(-1, fproxyConfig.getInt("metaRefreshSamePageInterval"));
        fproxyConfig.register("metaRefreshRedirectInterval", 1, configItemOrder++, true, false, "SimpleToadletServer.metaRefreshRedirectInterval", "SimpleToadletServer.metaRefreshRedirectIntervalLong", new IntCallback(){

            @Override
            public Integer get() {
                return HTMLFilter.metaRefreshRedirectMinInterval;
            }

            @Override
            public void set(Integer val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (val < -1) {
                    throw new InvalidConfigValueException("-1 = disabled, 0+ = set a minimum interval");
                }
                HTMLFilter.metaRefreshRedirectMinInterval = val;
            }
        }, false);
        HTMLFilter.metaRefreshRedirectMinInterval = Math.max(-1, fproxyConfig.getInt("metaRefreshRedirectInterval"));
        fproxyConfig.register("embedM3uPlayerInFreesites", true, configItemOrder++, true, false, "SimpleToadletServer.embedM3uPlayerInFreesites", "SimpleToadletServer.embedM3uPlayerInFreesitesLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return HTMLFilter.embedM3uPlayer;
            }

            @Override
            public void set(Boolean val) {
                HTMLFilter.embedM3uPlayer = val;
            }
        });
        HTMLFilter.embedM3uPlayer = fproxyConfig.getBoolean("embedM3uPlayerInFreesites");
        fproxyConfig.register("refilterPolicy", "RE_FILTER", configItemOrder++, true, false, "SimpleToadletServer.refilterPolicy", "SimpleToadletServer.refilterPolicyLong", new ReFilterCallback());
        this.refilterPolicy = FProxyFetchInProgress.REFILTER_POLICY.valueOf(fproxyConfig.getString("refilterPolicy"));
        isPanicButtonToBeShown = fproxyConfig.getBoolean("showPanicButton");
        noConfirmPanic = fproxyConfig.getBoolean("noConfirmPanic");
        this.bf = bucketFactory;
        this.port = fproxyConfig.getInt("port");
        this.bindTo = fproxyConfig.getString("bindTo");
        String cssName = fproxyConfig.getString("css");
        if (cssName.indexOf(58) != -1 || cssName.indexOf(47) != -1) {
            throw new InvalidConfigValueException("CSS name must not contain slashes or colons!");
        }
        this.cssTheme = PageMaker.THEME.themeFromName(cssName);
        this.pageMaker = new PageMaker(this.cssTheme, node);
        if (!fproxyConfig.getOption("CSSOverride").isDefault()) {
            this.cssOverride = new File(fproxyConfig.getString("CSSOverride"));
            this.pageMaker.setOverride("/static/override/" + this.cssOverride.getName());
        } else {
            this.cssOverride = null;
            this.pageMaker.setOverride(null);
        }
        fproxyConfig.register("fetchKeyBoxAboveBookmarks", this.cssTheme.fetchKeyBoxAboveBookmarks, configItemOrder++, false, false, "SimpleToadletServer.fetchKeyBoxAboveBookmarks", "SimpleToadletServer.fetchKeyBoxAboveBookmarksLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return SimpleToadletServer.this.fetchKeyBoxAboveBookmarks;
            }

            @Override
            public void set(Boolean val) {
                if (this.get().equals(val)) {
                    return;
                }
                SimpleToadletServer.this.fetchKeyBoxAboveBookmarks = val;
            }
        });
        this.fetchKeyBoxAboveBookmarks = fproxyConfig.getBoolean("fetchKeyBoxAboveBookmarks");
        this.advancedModeEnabled = fproxyConfig.getBoolean("advancedModeEnabled");
        this.toadlets = new LinkedList();
        if (SSL.available()) {
            this.ssl = fproxyConfig.getBoolean("ssl");
        }
        this.allowedHosts = fproxyConfig.getString("allowedHosts");
        if (!enabled) {
            Logger.normal(this, "Not starting FProxy as it's disabled");
            System.out.println("Not starting FProxy as it's disabled");
        } else {
            this.maybeGetNetworkInterface();
            this.myThread = new Thread((Runnable)this, "SimpleToadletServer");
            this.myThread.setDaemon(true);
        }
        StaticToadlet statictoadlet = new StaticToadlet();
        this.register(statictoadlet, null, "/static/", false, false);
        this.startupToadlet = new StartupToadlet(statictoadlet);
        this.register(this.startupToadlet, null, "/", false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStartupToadlet() {
        SimpleToadletServer simpleToadletServer = this;
        synchronized (simpleToadletServer) {
            this.unregister(this.startupToadlet);
            this.startupToadlet = null;
        }
    }

    private void maybeGetNetworkInterface() throws IOException {
        if (this.networkInterface != null) {
            return;
        }
        this.networkInterface = this.ssl ? SSLNetworkInterface.create(this.port, this.bindTo, this.allowedHosts, this.executor, true) : NetworkInterface.create(this.port, this.bindTo, this.allowedHosts, this.executor, true);
    }

    @Override
    public boolean doRobots() {
        return this.doRobots;
    }

    @Override
    public boolean publicGatewayMode() {
        return this.wasPublicGatewayMode;
    }

    public void start() {
        if (this.myThread != null) {
            try {
                this.maybeGetNetworkInterface();
                this.myThread.start();
                Logger.normal(this, "Starting FProxy on " + this.bindTo + ':' + this.port);
                System.out.println("Starting FProxy on " + this.bindTo + ':' + this.port);
            }
            catch (IOException e) {
                Logger.error(this, "Could not bind network port for FProxy?", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishStart() {
        this.core.getNode().getSecurityLevels().addNetworkThreatLevelListener(new SecurityLevelListener<SecurityLevels.NETWORK_THREAT_LEVEL>(){

            @Override
            public void onChange(SecurityLevels.NETWORK_THREAT_LEVEL oldLevel, SecurityLevels.NETWORK_THREAT_LEVEL newLevel) {
                if (newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.LOW && newLevel != oldLevel) {
                    SimpleToadletServer.this.refilterPolicy = FProxyFetchInProgress.REFILTER_POLICY.ACCEPT_OLD;
                } else if (oldLevel == SecurityLevels.NETWORK_THREAT_LEVEL.LOW && newLevel != oldLevel) {
                    SimpleToadletServer.this.refilterPolicy = FProxyFetchInProgress.REFILTER_POLICY.RE_FILTER;
                }
            }
        });
        this.core.getNode().getSecurityLevels().addPhysicalThreatLevelListener(new SecurityLevelListener<SecurityLevels.PHYSICAL_THREAT_LEVEL>(){

            @Override
            public void onChange(SecurityLevels.PHYSICAL_THREAT_LEVEL oldLevel, SecurityLevels.PHYSICAL_THREAT_LEVEL newLevel) {
                if (newLevel != oldLevel && newLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW) {
                    isPanicButtonToBeShown = false;
                } else if (newLevel != oldLevel) {
                    isPanicButtonToBeShown = true;
                }
            }
        });
        SimpleToadletServer simpleToadletServer = this;
        synchronized (simpleToadletServer) {
            this.finishedStartup = true;
        }
    }

    @Override
    public void register(Toadlet t, String menu, String urlPrefix, boolean atFront, boolean fullOnly) {
        this.register(t, menu, urlPrefix, atFront, null, null, fullOnly, null, null);
    }

    @Override
    public void register(Toadlet t, String menu, String urlPrefix, boolean atFront, String name, String title, boolean fullOnly, LinkEnabledCallback cb) {
        this.register(t, menu, urlPrefix, atFront, name, title, fullOnly, cb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Toadlet t, String menu, String urlPrefix, boolean atFront, String name, String title, boolean fullOnly, LinkEnabledCallback cb, FredPluginL10n l10n) {
        ToadletElement te = new ToadletElement(t, urlPrefix, menu, name);
        LinkedList<ToadletElement> linkedList = this.toadlets;
        synchronized (linkedList) {
            if (atFront) {
                this.toadlets.addFirst(te);
            } else {
                this.toadlets.addLast(te);
            }
            t.container = this;
        }
        if (menu != null && name != null) {
            this.pageMaker.addNavigationLink(menu, urlPrefix, name, title, fullOnly, cb, l10n);
        }
    }

    public void registerMenu(String link, String name, String title, FredPluginL10n plugin) {
        this.pageMaker.addNavigationCategory(link, name, title, plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(Toadlet t) {
        ToadletElement e = null;
        LinkedList<ToadletElement> linkedList = this.toadlets;
        synchronized (linkedList) {
            Iterator i = this.toadlets.iterator();
            while (i.hasNext()) {
                e = (ToadletElement)i.next();
                if (e.t != t) continue;
                i.remove();
                break;
            }
        }
        if (e != null && e.t == t && e.menu != null && e.name != null) {
            this.pageMaker.removeNavigationLink(e.menu, e.name);
        }
    }

    public StartupToadlet getStartupToadlet() {
        return this.startupToadlet;
    }

    @Override
    public boolean fproxyHasCompletedWizard() {
        return this.fproxyHasCompletedWizard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Toadlet findToadlet(URI uri) throws PermanentRedirectException {
        String path = uri.getPath();
        NodeClientCore core = this.core;
        if (!(core == null || core.getNode() == null || this.fproxyHasCompletedWizard || path.startsWith("/wizard/") || path.startsWith("/wiz/") || path.startsWith("/static/") || path.startsWith("/external-link/") || path.equals("/favicon.ico"))) {
            try {
                throw new PermanentRedirectException(new URI(null, null, null, -1, "/wizard/", uri.getQuery(), null));
            }
            catch (URISyntaxException e) {
                throw new Error(e);
            }
        }
        LinkedList<ToadletElement> linkedList = this.toadlets;
        synchronized (linkedList) {
            for (ToadletElement te : this.toadlets) {
                URI newURI;
                if (path.startsWith(te.prefix)) {
                    return te.t;
                }
                if (te.prefix.isEmpty() || te.prefix.charAt(te.prefix.length() - 1) != '/' || !path.equals(te.prefix.substring(0, te.prefix.length() - 1))) continue;
                try {
                    newURI = new URI(te.prefix);
                }
                catch (URISyntaxException e) {
                    throw new Error(e);
                }
                throw new PermanentRedirectException(newURI);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean finishedStartup = false;
        while (true) {
            SimpleToadletServer simpleToadletServer = this;
            synchronized (simpleToadletServer) {
                while (this.fproxyConnections > this.maxFproxyConnections) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!finishedStartup && this.finishedStartup) {
                    finishedStartup = true;
                }
                if (this.myThread == null) {
                    return;
                }
            }
            Socket conn = this.networkInterface.accept();
            if (WrapperManager.hasShutdownHookBeenTriggered()) {
                return;
            }
            if (conn == null) continue;
            if (logMINOR) {
                Logger.minor(this, "Accepted connection");
            }
            SocketHandler sh = new SocketHandler(conn, finishedStartup);
            sh.start();
        }
    }

    @Override
    public PageMaker.THEME getTheme() {
        return this.cssTheme;
    }

    public UserAlertManager getUserAlertManager() {
        NodeClientCore core = this.core;
        if (core == null) {
            return null;
        }
        return core.getAlerts();
    }

    public void setCSSName(PageMaker.THEME theme) {
        this.cssTheme = theme;
    }

    @Override
    public synchronized boolean sendAllThemes() {
        return this.sendAllThemes;
    }

    @Override
    public synchronized boolean isAdvancedModeEnabled() {
        return this.advancedModeEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAdvancedMode(boolean enabled) {
        SimpleToadletServer simpleToadletServer = this;
        synchronized (simpleToadletServer) {
            if (this.advancedModeEnabled == enabled) {
                return;
            }
            this.advancedModeEnabled = enabled;
        }
        this.core.getNode().getConfig().store();
    }

    @Override
    public synchronized boolean isFProxyJavascriptEnabled() {
        return this.fProxyJavascriptEnabled;
    }

    public synchronized void enableFProxyJavascript(boolean b) {
        this.fProxyJavascriptEnabled = b;
    }

    @Override
    public synchronized boolean isFProxyWebPushingEnabled() {
        return this.fProxyWebPushingEnabled;
    }

    public synchronized void enableFProxyWebPushing(boolean b) {
        this.fProxyWebPushingEnabled = b;
    }

    @Override
    public String getFormPassword() {
        if (this.core == null) {
            return "";
        }
        return this.core.getFormPassword();
    }

    @Override
    public boolean isAllowedFullAccess(InetAddress remoteAddr) {
        return this.allowedFullAccess.allowed(remoteAddr);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("SimpleToadletServer." + key, pattern, value);
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("SimpleToadletServer." + key);
    }

    @Override
    public HTMLNode addFormChild(HTMLNode parentNode, String target, String id) {
        HTMLNode formNode = parentNode.addChild("div").addChild("form", new String[]{"action", "method", "enctype", "id", "accept-charset"}, new String[]{target, "post", "multipart/form-data", id, "utf-8"});
        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", this.getFormPassword()});
        return formNode;
    }

    public void setBucketFactory(BucketFactory tempBucketFactory) {
        this.bf = tempBucketFactory;
    }

    public boolean isEnabled() {
        return this.myThread != null;
    }

    public BookmarkManager getBookmarks() {
        return this.bookmarkManager;
    }

    public FreenetURI[] getBookmarkURIs() {
        if (this.bookmarkManager == null) {
            return new FreenetURI[0];
        }
        return this.bookmarkManager.getBookmarkURIs();
    }

    @Override
    public boolean enablePersistentConnections() {
        return this.enablePersistentConnections;
    }

    @Override
    public boolean enableInlinePrefetch() {
        return this.enableInlinePrefetch;
    }

    @Override
    public boolean enableExtendedMethodHandling() {
        return this.enableExtendedMethodHandling;
    }

    @Override
    public boolean enableCachingForChkAndSskKeys() {
        return this.enableCachingForChkAndSskKeys;
    }

    @Override
    public synchronized boolean allowPosts() {
        return !(this.bf instanceof ArrayBucketFactory);
    }

    @Override
    public synchronized BucketFactory getBucketFactory() {
        return this.bf;
    }

    @Override
    public boolean enableActivelinks() {
        return this.enableActivelinks;
    }

    @Override
    public boolean disableProgressPage() {
        return this.disableProgressPage;
    }

    @Override
    public PageMaker getPageMaker() {
        return this.pageMaker;
    }

    public Ticker getTicker() {
        return this.core.getNode().getTicker();
    }

    public NodeClientCore getCore() {
        return this.core;
    }

    @Override
    public FProxyFetchInProgress.REFILTER_POLICY getReFilterPolicy() {
        return this.refilterPolicy;
    }

    @Override
    public File getOverrideFile() {
        return this.cssOverride;
    }

    @Override
    public String getURL() {
        return this.getURL(null);
    }

    @Override
    public String getURL(String host) {
        StringBuffer sb = new StringBuffer();
        if (this.ssl) {
            sb.append("https");
        } else {
            sb.append("http");
        }
        sb.append("://");
        if (host == null) {
            host = "127.0.0.1";
        }
        sb.append(host);
        sb.append(":");
        sb.append(this.port);
        sb.append("/");
        return sb.toString();
    }

    @Override
    public boolean isSSL() {
        return this.ssl;
    }

    @Override
    public boolean isLinkExcepted(URI link) {
        Toadlet toadlet = null;
        try {
            toadlet = this.findToadlet(link);
        }
        catch (PermanentRedirectException permanentRedirectException) {
            // empty catch block
        }
        if (toadlet instanceof LinkFilterExceptedToadlet) {
            return ((LinkFilterExceptedToadlet)((Object)toadlet)).isLinkExcepted(link);
        }
        return false;
    }

    @Override
    public long generateUniqueID() {
        return this.random.nextLong();
    }

    public PushDataManager getPushDataManager() {
        return this.pushDataManager;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public class SocketHandler
    implements PrioRunnable {
        Socket sock;
        final boolean finishedStartup;

        public SocketHandler(Socket conn, boolean finishedStartup) {
            this.sock = conn;
            this.finishedStartup = finishedStartup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() {
            if (this.finishedStartup) {
                SimpleToadletServer.this.executor.execute(this, "HTTP socket handler@" + this.hashCode());
            } else {
                new Thread(this).start();
            }
            SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
            synchronized (simpleToadletServer) {
                SimpleToadletServer.this.fproxyConnections++;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logMINOR) {
                Logger.minor(this, "Handling connection");
            }
            try {
                ToadletContextImpl.handle(this.sock, SimpleToadletServer.this, SimpleToadletServer.this.pageMaker, SimpleToadletServer.this.getUserAlertManager(), SimpleToadletServer.this.bookmarkManager);
            }
            catch (Throwable t) {
                System.err.println("Caught in SimpleToadletServer: " + t);
                t.printStackTrace();
                Logger.error(this, "Caught in SimpleToadletServer: " + t, t);
            }
            finally {
                SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
                synchronized (simpleToadletServer) {
                    SimpleToadletServer.this.fproxyConnections--;
                    SimpleToadletServer.this.notifyAll();
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Handled connection");
            }
        }

        @Override
        public int getPriority() {
            return NativeThread.HIGH_PRIORITY - 1;
        }
    }

    private class ReFilterCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        private ReFilterCallback() {
        }

        @Override
        public String[] getPossibleValues() {
            FProxyFetchInProgress.REFILTER_POLICY[] possible = FProxyFetchInProgress.REFILTER_POLICY.values();
            String[] ret = new String[possible.length];
            for (int i = 0; i < possible.length; ++i) {
                ret[i] = possible[i].name();
            }
            return ret;
        }

        @Override
        public String get() {
            return SimpleToadletServer.this.refilterPolicy.name();
        }

        @Override
        public void set(String val) throws InvalidConfigValueException, NodeNeedRestartException {
            SimpleToadletServer.this.refilterPolicy = FProxyFetchInProgress.REFILTER_POLICY.valueOf(val);
        }
    }

    private static class FProxyWebPushingEnabledCallback
    extends BooleanCallback {
        private final SimpleToadletServer ts;

        FProxyWebPushingEnabledCallback(SimpleToadletServer ts) {
            this.ts = ts;
        }

        @Override
        public Boolean get() {
            return this.ts.isFProxyWebPushingEnabled();
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
            if (this.get().equals(val)) {
                return;
            }
            this.ts.enableFProxyWebPushing(val);
        }
    }

    private static class FProxyJavascriptEnabledCallback
    extends BooleanCallback {
        private final SimpleToadletServer ts;

        FProxyJavascriptEnabledCallback(SimpleToadletServer ts) {
            this.ts = ts;
        }

        @Override
        public Boolean get() {
            return this.ts.isFProxyJavascriptEnabled();
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            this.ts.enableFProxyJavascript(val);
        }
    }

    private static class FProxyAdvancedModeEnabledCallback
    extends BooleanCallback {
        private final SimpleToadletServer ts;

        FProxyAdvancedModeEnabledCallback(SimpleToadletServer ts) {
            this.ts = ts;
        }

        @Override
        public Boolean get() {
            return this.ts.isAdvancedModeEnabled();
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            this.ts.setAdvancedMode(val);
        }
    }

    private class FProxyEnabledCallback
    extends BooleanCallback {
        private FProxyEnabledCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean get() {
            SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
            synchronized (simpleToadletServer) {
                return SimpleToadletServer.this.myThread != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            SimpleToadletServer simpleToadletServer = SimpleToadletServer.this;
            synchronized (simpleToadletServer) {
                if (!val.booleanValue()) {
                    SimpleToadletServer.this.myThread.interrupt();
                    SimpleToadletServer.this.myThread = null;
                    SimpleToadletServer.this.notifyAll();
                    return;
                }
                SimpleToadletServer.this.myThread = new Thread((Runnable)SimpleToadletServer.this, "SimpleToadletServer");
            }
            SimpleToadletServer.this.createFproxy();
            SimpleToadletServer.this.myThread.setDaemon(true);
            SimpleToadletServer.this.myThread.start();
        }
    }

    private class FProxyCSSOverrideCallback
    extends StringCallback {
        private FProxyCSSOverrideCallback() {
        }

        @Override
        public String get() {
            return SimpleToadletServer.this.cssOverride == null ? "" : SimpleToadletServer.this.cssOverride.toString();
        }

        @Override
        public void set(String val) throws InvalidConfigValueException {
            NodeClientCore core = SimpleToadletServer.this.core;
            if (core == null) {
                return;
            }
            if (val.equals(this.get()) || val.isEmpty()) {
                SimpleToadletServer.this.cssOverride = null;
            } else {
                File tmp = new File(val.trim());
                if (!core.allowUploadFrom(tmp)) {
                    throw new InvalidConfigValueException(SimpleToadletServer.l10n("cssOverrideNotInUploads", "filename", tmp.toString()));
                }
                if (!tmp.canRead() || !tmp.isFile()) {
                    throw new InvalidConfigValueException(SimpleToadletServer.l10n("cssOverrideCantRead", "filename", tmp.toString()));
                }
                File parent = tmp.getParentFile();
                if (parent.getParentFile() == null) {
                    throw new InvalidConfigValueException(SimpleToadletServer.l10n("cssOverrideCantUseRootDir", "filename", parent.toString()));
                }
                SimpleToadletServer.this.cssOverride = tmp;
            }
            if (SimpleToadletServer.this.cssOverride == null) {
                SimpleToadletServer.this.pageMaker.setOverride(null);
            } else {
                SimpleToadletServer.this.pageMaker.setOverride("/static/override/" + SimpleToadletServer.this.cssOverride.getName());
            }
        }
    }

    private class FProxyCSSNameCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        private FProxyCSSNameCallback() {
        }

        @Override
        public String get() {
            return ((SimpleToadletServer)SimpleToadletServer.this).cssTheme.code;
        }

        @Override
        public void set(String CSSName) throws InvalidConfigValueException {
            if (CSSName.indexOf(58) != -1 || CSSName.indexOf(47) != -1) {
                throw new InvalidConfigValueException(SimpleToadletServer.l10n("illegalCSSName"));
            }
            SimpleToadletServer.this.cssTheme = PageMaker.THEME.themeFromName(CSSName);
            SimpleToadletServer.this.pageMaker.setTheme(SimpleToadletServer.this.cssTheme);
            NodeClientCore core = SimpleToadletServer.this.core;
            if (core.getNode().getPluginManager() != null) {
                core.getNode().getPluginManager().setFProxyTheme(SimpleToadletServer.this.cssTheme);
            }
            SimpleToadletServer.this.fetchKeyBoxAboveBookmarks = ((SimpleToadletServer)SimpleToadletServer.this).cssTheme.fetchKeyBoxAboveBookmarks;
        }

        @Override
        public String[] getPossibleValues() {
            return PageMaker.THEME.possibleValues;
        }
    }

    private class FProxyAllowedHostsCallback
    extends StringCallback {
        private FProxyAllowedHostsCallback() {
        }

        @Override
        public String get() {
            return SimpleToadletServer.this.networkInterface.getAllowedHosts();
        }

        @Override
        public void set(String allowedHosts) throws InvalidConfigValueException {
            if (!allowedHosts.equals(this.get())) {
                try {
                    SimpleToadletServer.this.networkInterface.setAllowedHosts(allowedHosts);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidConfigValueException(e);
                }
            }
        }
    }

    private class FProxyBindtoCallback
    extends StringCallback {
        private FProxyBindtoCallback() {
        }

        @Override
        public String get() {
            return SimpleToadletServer.this.bindTo;
        }

        @Override
        public void set(String bindTo) throws InvalidConfigValueException {
            String oldValue = this.get();
            if (!bindTo.equals(oldValue)) {
                Object[] failedAddresses = SimpleToadletServer.this.networkInterface.setBindTo(bindTo, false);
                if (failedAddresses == null) {
                    SimpleToadletServer.this.bindTo = bindTo;
                } else {
                    SimpleToadletServer.this.networkInterface.setBindTo(oldValue, false);
                    throw new InvalidConfigValueException(SimpleToadletServer.l10n("couldNotChangeBindTo", "failedInterfaces", Arrays.toString(failedAddresses)));
                }
            }
        }
    }

    private class FProxyPortCallback
    extends IntCallback {
        private FProxyPortCallback() {
        }

        @Override
        public Integer get() {
            return SimpleToadletServer.this.port;
        }

        @Override
        public void set(Integer newPort) throws NodeNeedRestartException {
            if (SimpleToadletServer.this.port != newPort) {
                throw new NodeNeedRestartException("Port cannot change on the fly");
            }
        }
    }

    private static class FProxyPassthruMaxSizeProgress
    extends LongCallback {
        private FProxyPassthruMaxSizeProgress() {
        }

        @Override
        public Long get() {
            return FProxyToadlet.MAX_LENGTH_WITH_PROGRESS;
        }

        @Override
        public void set(Long val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            FProxyToadlet.MAX_LENGTH_WITH_PROGRESS = val;
        }
    }

    private static class FProxyPassthruMaxSizeNoProgress
    extends LongCallback {
        private FProxyPassthruMaxSizeNoProgress() {
        }

        @Override
        public Long get() {
            return FProxyToadlet.MAX_LENGTH_NO_PROGRESS;
        }

        @Override
        public void set(Long val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            FProxyToadlet.MAX_LENGTH_NO_PROGRESS = val;
        }
    }

    private class FProxySSLCallback
    extends BooleanCallback {
        private FProxySSLCallback() {
        }

        @Override
        public Boolean get() {
            return SimpleToadletServer.this.ssl;
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            if (!SSL.available()) {
                throw new InvalidConfigValueException("Enable SSL support before use ssl with Fproxy");
            }
            SimpleToadletServer.this.ssl = val;
            throw new InvalidConfigValueException("Cannot change SSL on the fly, please restart freenet");
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }

    private static class ToadletElement {
        Toadlet t;
        String prefix;
        String menu;
        String name;

        public ToadletElement(Toadlet t2, String urlPrefix, String menu, String name) {
            this.t = t2;
            this.prefix = urlPrefix;
            this.menu = menu;
            this.name = name;
        }
    }
}

