/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import freenet.crypt.DSAPrivateKey;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.Global;
import freenet.crypt.SHA256;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.support.math.MersenneTwister;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Random;

public class ClientKSK
extends InsertableClientSSK {
    private static final long serialVersionUID = 1L;
    final String keyword;

    private ClientKSK(String keyword, byte[] pubKeyHash, DSAPublicKey pubKey, DSAPrivateKey privKey, byte[] keywordHash) throws MalformedURLException {
        super(keyword, pubKeyHash, pubKey, privKey, keywordHash, (byte)2);
        this.keyword = keyword;
    }

    protected ClientKSK() {
        this.keyword = null;
    }

    @Override
    public FreenetURI getURI() {
        return new FreenetURI("KSK", this.keyword);
    }

    public static InsertableClientSSK create(FreenetURI uri) {
        if (!uri.getKeyType().equals("KSK")) {
            throw new IllegalArgumentException();
        }
        return ClientKSK.create(uri.getDocName());
    }

    public static ClientKSK create(String keyword) {
        MessageDigest md256 = SHA256.getMessageDigest();
        byte[] keywordHash = md256.digest(keyword.getBytes(StandardCharsets.UTF_8));
        MersenneTwister mt = MersenneTwister.createUnsynchronized(keywordHash);
        DSAPrivateKey privKey = new DSAPrivateKey(Global.DSAgroupBigA, (Random)((Object)mt));
        DSAPublicKey pubKey = new DSAPublicKey(Global.DSAgroupBigA, privKey);
        byte[] pubKeyHash = md256.digest(pubKey.asBytes());
        try {
            return new ClientKSK(keyword, pubKeyHash, pubKey, privKey, keywordHash);
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
    }
}

