/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.HourlyStatsRecord;
import freenet.node.Node;
import freenet.support.HTMLNode;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class HourlyStats {
    private HourlyStatsRecord prevRecord;
    private HourlyStatsRecord currentRecord;
    private HourlyStatsRecord totalRecord;
    private Calendar lastHourlyTime;
    private Calendar currentTime;
    private final Node node;

    public HourlyStats(Node node) {
        this.node = node;
        this.prevRecord = null;
        this.currentRecord = new HourlyStatsRecord(node, false);
        this.totalRecord = new HourlyStatsRecord(node, false);
        this.lastHourlyTime = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.currentTime = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    public synchronized void remoteRequest(boolean ssk, boolean success, boolean local, int htl, double location) {
        Date now = new Date();
        this.currentTime.setTime(now);
        if (this.lastHourlyTime.get(11) != this.currentTime.get(11)) {
            this.lastHourlyTime.setTime(now);
            this.prevRecord = this.currentRecord;
            this.currentRecord = new HourlyStatsRecord(this.node, true);
            this.prevRecord.markFinal();
            this.prevRecord.log();
        }
        this.currentRecord.remoteRequest(ssk, success, local, htl, location);
        this.totalRecord.remoteRequest(ssk, success, local, htl, location);
    }

    public void fillRemoteRequestHTLsBox(HTMLNode html) {
        this.totalRecord.fillRemoteRequestHTLsBox(html);
    }
}

