/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.compress;

import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.compress.AbstractCompressor;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.compress.CompressionRatioException;
import freenet.support.io.CountedOutputStream;
import freenet.support.io.HeaderStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class Bzip2Compressor
extends AbstractCompressor {
    public static final byte[] BZ_HEADER = "BZ".getBytes(StandardCharsets.ISO_8859_1);

    @Override
    public Bucket compress(Bucket data, BucketFactory bf, long maxReadLength, long maxWriteLength) throws IOException, CompressionOutputSizeException {
        RandomAccessBucket output = bf.makeBucket(maxWriteLength);
        try (InputStream is = data.getInputStream();
             OutputStream os = output.getOutputStream();){
            this.compress(is, os, maxReadLength, maxWriteLength);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long compress(InputStream is, OutputStream os, long maxReadLength, long maxWriteLength, long amountOfDataToCheckCompressionRatio, int minimumCompressionPercentage) throws IOException, CompressionRatioException {
        if (maxReadLength <= 0L) {
            throw new IllegalArgumentException();
        }
        BZip2CompressorOutputStream bz2os = null;
        try {
            CountedOutputStream cos = new CountedOutputStream(os);
            bz2os = new BZip2CompressorOutputStream(HeaderStreams.dimOutput(BZ_HEADER, cos));
            long read = 0L;
            int bufferSize = 32768;
            byte[] buffer = new byte[bufferSize];
            long iterationToCheckCompressionRatio = amountOfDataToCheckCompressionRatio / (long)bufferSize;
            int i = 0;
            while (true) {
                int l;
                int x;
                int n = x = (l = (int)Math.min((long)buffer.length, maxReadLength - read)) == 0 ? -1 : is.read(buffer, 0, buffer.length);
                if (x <= -1) break;
                if (x == 0) {
                    throw new IOException("Returned zero from read()");
                }
                bz2os.write(buffer, 0, x);
                read += (long)x;
                if (cos.written() > maxWriteLength) {
                    throw new CompressionOutputSizeException();
                }
                if ((long)(++i) != iterationToCheckCompressionRatio || minimumCompressionPercentage == 0) continue;
                this.checkCompressionEffect(read, cos.written(), minimumCompressionPercentage);
            }
            bz2os.flush();
            cos.flush();
            bz2os.close();
            bz2os = null;
            if (cos.written() > maxWriteLength) {
                throw new CompressionOutputSizeException();
            }
            long l = cos.written();
            return l;
        }
        finally {
            if (bz2os != null) {
                bz2os.flush();
                bz2os.close();
            }
        }
    }

    @Override
    public long decompress(InputStream is, OutputStream os, long maxLength, long maxCheckSizeBytes) throws IOException, CompressionOutputSizeException {
        BZip2CompressorInputStream bz2is = new BZip2CompressorInputStream(HeaderStreams.augInput(BZ_HEADER, is));
        long written = 0L;
        int bufSize = 32768;
        if (maxLength > 0L && maxLength < (long)bufSize) {
            bufSize = (int)maxLength;
        }
        byte[] buffer = new byte[bufSize];
        while (true) {
            int bytesRead;
            int expectedBytesRead;
            if ((expectedBytesRead = (int)Math.min((long)buffer.length, maxLength - written)) < (bytesRead = bz2is.read(buffer, 0, buffer.length))) {
                Logger.normal(this, "expectedBytesRead=" + expectedBytesRead + ", bytesRead=" + bytesRead + ", written=" + written + ", maxLength=" + maxLength + " throwing a CompressionOutputSizeException");
                if (maxCheckSizeBytes > 0L) {
                    written += (long)bytesRead;
                    while (true) {
                        if ((bytesRead = bz2is.read(buffer, 0, expectedBytesRead = (int)Math.min((long)buffer.length, maxLength + maxCheckSizeBytes - written))) <= -1) {
                            throw new CompressionOutputSizeException(written);
                        }
                        if (bytesRead == 0) {
                            throw new IOException("Returned zero from read()");
                        }
                        written += (long)bytesRead;
                    }
                }
                throw new CompressionOutputSizeException();
            }
            if (bytesRead <= -1) {
                return written;
            }
            if (bytesRead == 0) {
                throw new IOException("Returned zero from read()");
            }
            os.write(buffer, 0, bytesRead);
            written += (long)bytesRead;
        }
    }

    @Override
    public int decompress(byte[] dbuf, int i, int j, byte[] output) throws CompressionOutputSizeException {
        ByteArrayInputStream bais = new ByteArrayInputStream(dbuf, i, j);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(output.length);
        int bytes = 0;
        try {
            this.decompress(bais, baos, (long)output.length, -1L);
            bytes = baos.size();
        }
        catch (IOException e) {
            throw new Error("Got IOException: " + e.getMessage(), e);
        }
        byte[] buf = baos.toByteArray();
        System.arraycopy(buf, 0, output, 0, bytes);
        return bytes;
    }
}

